/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile;", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata$Compatible;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMetadata", "", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "classesToDecompile", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "()Z", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "shouldDecompileBuiltInClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Companion", "kotlin.core"})
public final class BuiltInDefinitionFile
extends FileWithMetadata.Compatible {
    @NotNull
    private final VirtualFile packageDirectory;
    private final boolean isMetadata;
    private static boolean FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProtoBuf.Class> getClassesToDecompile() {
        List list;
        List list2 = super.getClassesToDecompile();
        boolean bl = false;
        boolean bl2 = false;
        List classes = list2;
        boolean bl3 = false;
        if (this.isMetadata || !FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES) {
            list = classes;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = classes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv$iv;
                boolean bl4 = false;
                if (!this.shouldDecompileBuiltInClass(NameResolverUtilKt.getClassId((NameResolver)((NameResolver)this.getNameResolver()), (int)classProto.getFqName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final boolean shouldDecompileBuiltInClass(ClassId classId) {
        StringBuilder stringBuilder = new StringBuilder().append(classId.getShortClassName().asString()).append(".");
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
        String realJvmClassFileName = stringBuilder.append(javaClassFileType.getDefaultExtension()).toString();
        return this.packageDirectory.findChild(realJvmClassFileName) == null;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    public final boolean isMetadata() {
        return this.isMetadata;
    }

    public BuiltInDefinitionFile(@NotNull ProtoBuf.PackageFragment proto, @NotNull BuiltInsBinaryVersion version, @NotNull VirtualFile packageDirectory, boolean isMetadata) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        super(proto, (BinaryVersion)version, (SerializerExtensionProtocol)BuiltInSerializerProtocol.INSTANCE);
        this.packageDirectory = packageDirectory;
        this.isMetadata = isMetadata;
    }

    static {
        Companion = new Companion(null);
        FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/builtIns/BuiltInDefinitionFile$Companion;", "", "()V", "<set-?>", "", "FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "()Z", "setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "(Z)V", "read", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "contents", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.core"})
    public static final class Companion {
        public final boolean getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES() {
            return FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
        }

        @TestOnly
        public final void setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES(boolean bl) {
            FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = bl;
        }

        @Nullable
        public final FileWithMetadata read(@NotNull byte[] contents, @NotNull VirtualFile file) {
            ProtoBuf.PackageFragment proto;
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ByteArrayInputStream stream = new ByteArrayInputStream(contents);
            BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom((InputStream)stream);
            if (!version.isCompatible()) {
                return new FileWithMetadata.Incompatible((BinaryVersion)version);
            }
            ProtoBuf.PackageFragment packageFragment = proto = ProtoBuf.PackageFragment.parseFrom((InputStream)stream, (ExtensionRegistryLite)BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
            Intrinsics.checkNotNullExpressionValue((Object)packageFragment, (String)"proto");
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
            BuiltInDefinitionFile result = new BuiltInDefinitionFile(packageFragment, version, virtualFile, Intrinsics.areEqual((Object)file.getExtension(), (Object)"kotlin_metadata"));
            ProtoBuf.Package packageProto = result.getProto().getPackage();
            if (result.getClassesToDecompile().isEmpty()) {
                ProtoBuf.Package package_ = packageProto;
                Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"packageProto");
                if (package_.getTypeAliasCount() == 0 && packageProto.getFunctionCount() == 0 && packageProto.getPropertyCount() == 0) {
                    return null;
                }
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

