/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a<\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"analyzeElementWithInline", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "deep", "", "analyzedElements", "", "analyzeInlineFunctions", "", "fullResolveContext", "analyzeInlinedFunctions", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacadeForFile", "file", "analyzeOnlyReifiedInlineFunctions", "bindingContext", "hasReifiedTypeParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin.core"})
public final class InlineAnalysisUtillKt {
    @NotNull
    public static final Pair<BindingContext, List<KtFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull KtFile file, boolean analyzeOnlyReifiedInlineFunctions, @Nullable BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)resolutionFacadeForFile, (String)"resolutionFacadeForFile");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashSet analyzedElements = new HashSet();
        BindingContext context = InlineAnalysisUtillKt.analyzeElementWithInline(resolutionFacadeForFile, (KtElement)file, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions, bindingContext);
        LinkedHashSet<KtFile> toProcess = new LinkedHashSet<KtFile>();
        toProcess.add(file);
        Iterator iterator = analyzedElements.iterator();
        while (iterator.hasNext()) {
            KtFile containingFile;
            KtElement collectedElement;
            KtElement ktElement = collectedElement = (KtElement)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"collectedElement");
            Intrinsics.checkNotNullExpressionValue((Object)ktElement.getContainingKtFile(), (String)"collectedElement.containingKtFile");
            toProcess.add(containingFile);
        }
        return new Pair((Object)context, new ArrayList(toProcess));
    }

    public static /* synthetic */ Pair analyzeInlinedFunctions$default(ResolutionFacade resolutionFacade, KtFile ktFile, boolean bl, BindingContext bindingContext, int n, Object object) {
        if ((n & 8) != 0) {
            bindingContext = null;
        }
        return InlineAnalysisUtillKt.analyzeInlinedFunctions(resolutionFacade, ktFile, bl, bindingContext);
    }

    private static final BindingContext analyzeElementWithInline(ResolutionFacade resolutionFacade, KtElement element2, int deep, Set<KtElement> analyzedElements, boolean analyzeInlineFunctions, BindingContext fullResolveContext) {
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        HashSet declarationsWithBody = new HashSet();
        ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
        CollectionsKt.addIfNotNull((Collection)innerContexts, (Object)fullResolveContext);
        element2.accept((PsiElementVisitor)new KtTreeVisitorVoid(resolutionFacade, innerContexts, analyzeInlineFunctions, project2, analyzedElements, declarationsWithBody){
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ ArrayList $innerContexts;
            final /* synthetic */ boolean $analyzeInlineFunctions;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $analyzedElements;
            final /* synthetic */ HashSet $declarationsWithBody;

            public void visitExpression(@NotNull KtExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitExpression(expression);
                BindingContext bindingContext = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)expression), null, (int)2, null);
                this.$innerContexts.add(bindingContext);
                Call call = (Call)bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression);
                if (call == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)call, (String)"bindingContext.get(Bindi\u2026LL, expression) ?: return");
                Call call2 = call;
                ResolvedCall resolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)destructuringDeclaration), null, (int)2, null);
                this.$innerContexts.add(bindingContext);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitForExpression(expression);
                BindingContext bindingContext = ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)expression), null, (int)2, null);
                this.$innerContexts.add(bindingContext);
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
                this.checkResolveCall((ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor descriptor = resolvedCall.getResultingDescriptor();
                if (descriptor instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                CallableDescriptor callableDescriptor = descriptor;
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor");
                this.isAdditionalResolveNeededForDescriptor(callableDescriptor);
                if (descriptor instanceof PropertyDescriptor) {
                    Iterator<E> iterator = ((PropertyDescriptor)descriptor).getAccessors().iterator();
                    while (iterator.hasNext()) {
                        PropertyAccessorDescriptor accessor;
                        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = (PropertyAccessorDescriptor)iterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)propertyAccessorDescriptor, (String)"accessor");
                        this.isAdditionalResolveNeededForDescriptor((CallableDescriptor)propertyAccessorDescriptor);
                    }
                }
            }

            private final void isAdditionalResolveNeededForDescriptor(CallableDescriptor descriptor) {
                if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor)) || !this.$analyzeInlineFunctions && !InlineAnalysisUtillKt.access$hasReifiedTypeParameters(descriptor)) {
                    return;
                }
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor);
                if (declaration != null && declaration instanceof KtDeclarationWithBody && !this.$analyzedElements.contains(declaration)) {
                    this.$declarationsWithBody.add(declaration);
                    return;
                }
            }
            {
                this.$resolutionFacade = $captured_local_variable$0;
                this.$innerContexts = $captured_local_variable$1;
                this.$analyzeInlineFunctions = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$analyzedElements = $captured_local_variable$4;
                this.$declarationsWithBody = $captured_local_variable$5;
            }
        });
        analyzedElements.add(element2);
        Collection collection = declarationsWithBody;
        boolean bl = false;
        if (!collection.isEmpty() && deep < 10) {
            Iterator iterator = declarationsWithBody.iterator();
            while (iterator.hasNext()) {
                KtDeclarationWithBody inlineFunction;
                KtDeclarationWithBody ktDeclarationWithBody = inlineFunction = (KtDeclarationWithBody)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktDeclarationWithBody, (String)"inlineFunction");
                KtExpression body = ktDeclarationWithBody.getBodyExpression();
                if (body == null) continue;
                innerContexts.add(InlineAnalysisUtillKt.analyzeElementWithInline$default(resolutionFacade, (KtElement)inlineFunction, deep + 1, analyzedElements, analyzeInlineFunctions, null, 32, null));
            }
            analyzedElements.addAll(declarationsWithBody);
        }
        return CompositeBindingContext.Companion.create((List)innerContexts);
    }

    static /* synthetic */ BindingContext analyzeElementWithInline$default(ResolutionFacade resolutionFacade, KtElement ktElement, int n, Set set, boolean bl, BindingContext bindingContext, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bindingContext = null;
        }
        return InlineAnalysisUtillKt.analyzeElementWithInline(resolutionFacade, ktElement, n, set, bl, bindingContext);
    }

    private static final boolean hasReifiedTypeParameters(CallableDescriptor descriptor) {
        boolean bl;
        block3: {
            List list = descriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.typeParameters");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    TypeParameterDescriptor typeParameterDescriptor = it;
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasReifiedTypeParameters(CallableDescriptor descriptor) {
        return InlineAnalysisUtillKt.hasReifiedTypeParameters(descriptor);
    }
}

