/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdksBuilder;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0000H\u0007J2\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010 \u001a\u00020\nJ\u0014\u0010!\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eJ\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "classes", "", "", "sources", "scripts", "", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$LightScriptInfo;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "customDefinitionsUsed", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "sdks", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "getSdks", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptSdksBuilder;", "add", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "other", "addCustom", "path", "scriptClassesRoots", "", "sourceSourcesRoots", "info", "addTemplateClassesRoots", "classesRoots", "build", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "toStorage", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "useCustomScriptDefinition", "Companion", "kotlin.core"})
public final class ScriptClassRootsBuilder {
    @NotNull
    private final ScriptSdksBuilder sdks;
    private boolean customDefinitionsUsed;
    @NotNull
    private final Project project;
    private final Set<String> classes;
    private final Set<String> sources;
    private final Map<String, ScriptClassRootsCache.LightScriptInfo> scripts;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ScriptSdksBuilder getSdks() {
        return this.sdks;
    }

    @NotNull
    public final ScriptClassRootsCache build() {
        return new ScriptClassRootsCache(this.scripts, this.classes, this.sources, this.customDefinitionsUsed, this.sdks.build());
    }

    public final void useCustomScriptDefinition() {
        this.customDefinitionsUsed = true;
    }

    public final void add(@NotNull VirtualFile vFile, @NotNull ScriptCompilationConfigurationWrapper configuration2) {
        boolean bl;
        LinkOption[] linkOptionArray;
        String absolutePath;
        Path path;
        Path path2;
        File file;
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.sdks.addSdk(configuration2.getJavaHome());
        Iterable $this$forEach$iv = configuration2.getDependenciesClassPath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (File)element$iv;
            boolean bl2 = false;
            Path path3 = path2 = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            path = path3;
            boolean bl3 = false;
            absolutePath = ((Object)path.toAbsolutePath()).toString();
            path = path2;
            linkOptionArray = new LinkOption[]{};
            bl = false;
            if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ScriptUtilsKt.getLogger().warn("configuration dependency classpath " + absolutePath + " does not exist");
            }
            this.classes.add(absolutePath);
        }
        $this$forEach$iv = configuration2.getDependenciesSources();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (File)element$iv;
            boolean bl4 = false;
            Path path4 = path2 = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            path = path4;
            boolean bl5 = false;
            absolutePath = ((Object)path.toAbsolutePath()).toString();
            path = path2;
            linkOptionArray = new LinkOption[]{};
            bl = false;
            if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ScriptUtilsKt.getLogger().warn("configuration dependency sources " + absolutePath + " does not exist");
            }
            this.sources.add(absolutePath);
        }
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vFile.path");
        this.scripts.put(string, new ScriptClassRootsCache.DirectScriptInfo(configuration2));
        this.useCustomScriptDefinition();
    }

    public final void addCustom(@NotNull String path, @NotNull Collection<String> scriptClassesRoots, @NotNull Collection<String> sourceSourcesRoots, @NotNull ScriptClassRootsCache.LightScriptInfo info2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(scriptClassesRoots, (String)"scriptClassesRoots");
        Intrinsics.checkNotNullParameter(sourceSourcesRoots, (String)"sourceSourcesRoots");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.classes.addAll(scriptClassesRoots);
        this.sources.addAll(sourceSourcesRoots);
        this.scripts.put(path, info2);
    }

    public final void addTemplateClassesRoots(@NotNull Collection<String> classesRoots) {
        Intrinsics.checkNotNullParameter(classesRoots, (String)"classesRoots");
        this.classes.addAll(classesRoots);
    }

    @Deprecated(message="Don't use, used only from DefaultScriptingSupport for saving to storage")
    public final void add(@NotNull ScriptClassRootsBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.classes.addAll((Collection<String>)other.classes);
        this.sources.addAll((Collection<String>)other.sources);
        this.sdks.addAll(other.sdks);
        this.scripts.putAll(other.scripts);
    }

    public final void toStorage(@NotNull ScriptClassRootsStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        storage.setClasspath(this.classes);
        storage.setSources(this.sources);
        this.sdks.toStorage(storage);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptClassRootsBuilder(@NotNull Project project, @NotNull Set<String> classes, @NotNull Set<String> sources, @NotNull Map<String, ScriptClassRootsCache.LightScriptInfo> scripts) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
        this.project = project;
        this.classes = classes;
        this.sources = sources;
        this.scripts = scripts;
        this.sdks = new ScriptSdksBuilder(this.project, null, null, 6, null);
    }

    public /* synthetic */ ScriptClassRootsBuilder(Project project, Set set, Set set2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            bl = false;
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            bl = false;
            map2 = new LinkedHashMap();
        }
        this(project, set, set2, map2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder$Companion;", "", "()V", "fromStorage", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsStorage;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final ScriptClassRootsBuilder fromStorage(@NotNull Project project, @NotNull ScriptClassRootsStorage storage) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            ScriptClassRootsBuilder scriptClassRootsBuilder = new ScriptClassRootsBuilder(project, CollectionsKt.toMutableSet((Iterable)storage.getClasspath()), CollectionsKt.toMutableSet((Iterable)storage.getSources()), null, 8, null);
            boolean bl = false;
            boolean bl2 = false;
            ScriptClassRootsBuilder it = scriptClassRootsBuilder;
            boolean bl3 = false;
            it.getSdks().fromStorage(storage);
            return scriptClassRootsBuilder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

