/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.SLRUMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.jvm.util.ClasspathExtractionException;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptTemplatesProviderAdapter;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.StandardScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.core.util.CheckCanceledLock;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000289B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001aH\u0016J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\b\u0010(\u001a\u00020\nH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020+2\u0006\u0010\"\u001a\u00020#H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020 H\u0002J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u0011J\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\n\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configurations", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "", "definitionsBySource", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "failedContributorsHashes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "scriptDefinitionsCache", "Lcom/intellij/util/containers/SLRUMap;", "", "scriptDefinitionsCacheLock", "Lorg/jetbrains/kotlin/idea/core/util/CheckCanceledLock;", "sourcesToReload", "", "dispose", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "getAllDefinitions", "getDefaultDefinition", "getSources", "isReady", "", "isScratchFile", "kotlinScriptingSettingsSafe", "Lorg/jetbrains/kotlin/idea/core/script/settings/KotlinScriptingSettings;", "loadScriptDefinitions", "reloadDefinitionsBy", "source", "reloadScriptDefinitions", "reloadScriptDefinitionsIfNeeded", "reorderScriptDefinitions", "updateDefinitions", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "safeGetDefinitions", "Companion", "UpdateDefinitionsResult", "kotlin.core"})
public final class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    private final ReentrantReadWriteLock definitionsLock;
    private final Map<ScriptDefinitionsSource, List<ScriptDefinition>> definitionsBySource;
    private volatile List<? extends ScriptDefinition> definitions;
    private final Set<ScriptDefinitionsSource> sourcesToReload;
    private final HashSet<Integer> failedContributorsHashes;
    private final CheckCanceledLock scriptDefinitionsCacheLock;
    private final SLRUMap<String, ScriptDefinition> scriptDefinitionsCache;
    private volatile CompositeScriptConfigurationManager configurations;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        ScriptDefinition scriptDefinition;
        ScriptDefinition scriptDefinition2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String string = script.getLocationId();
        if (string == null) {
            return null;
        }
        String locationId = string;
        if (this.nonScriptId(locationId)) {
            return null;
        }
        CompositeScriptConfigurationManager compositeScriptConfigurationManager = this.configurations;
        if (compositeScriptConfigurationManager != null && (compositeScriptConfigurationManager = compositeScriptConfigurationManager.tryGetScriptDefinitionFast(locationId)) != null) {
            CompositeScriptConfigurationManager compositeScriptConfigurationManager2 = compositeScriptConfigurationManager;
            boolean bl2 = false;
            boolean bl3 = false;
            CompositeScriptConfigurationManager fastPath = compositeScriptConfigurationManager2;
            boolean bl4 = false;
            return fastPath;
        }
        if (!this.isReady()) {
            return null;
        }
        CheckCanceledLock this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            bl = false;
            ScriptDefinition fastPath = (ScriptDefinition)this.scriptDefinitionsCache.get((Object)locationId);
            scriptDefinition2 = fastPath;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv).unlock();
        }
        if (scriptDefinition2 != null) {
            this_$iv = scriptDefinition2;
            $i$f$withLock$kotlin_core = false;
            bl = false;
            CheckCanceledLock cached = this_$iv;
            boolean bl5 = false;
            return cached;
        }
        if (this.isScratchFile(script)) {
            scriptDefinition = this.getDefaultDefinition();
        } else {
            scriptDefinition = super.findDefinition(script);
            if (scriptDefinition == null) {
                return null;
            }
        }
        ScriptDefinition definition = scriptDefinition;
        CheckCanceledLock this_$iv2 = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core2 = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv2).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl6 = false;
            this.scriptDefinitionsCache.put((Object)locationId, (Object)definition);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv2).unlock();
        }
        return definition;
    }

    private final boolean isScratchFile(SourceCode script) {
        VirtualFile virtualFile;
        if (script instanceof VirtualFileScriptSource) {
            virtualFile = ((VirtualFileScriptSource)script).getVirtualFile();
        } else {
            String string = script.getLocationId();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                virtualFile = VirtualFileManager.getInstance().findFileByUrl(it);
            } else {
                virtualFile = null;
            }
        }
        VirtualFile virtualFile2 = virtualFile;
        return virtualFile2 != null && ScratchFileService.getInstance().getRootType(virtualFile2) instanceof ScratchRootType;
    }

    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ScriptDefinition scriptDefinition = this.findDefinition(ScriptHostUtilKt.toScriptSource((File)new File(fileName)));
        return scriptDefinition != null ? scriptDefinition.getLegacyDefinition() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        block17: {
            UpdateDefinitionsResult updateDefinitionsResult;
            UpdateDefinitionsResult updateDefinitionsResult2;
            int n;
            int n2;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            boolean bl2 = false;
            int n3 = 0;
            n3 = 0;
            int n4 = readCount$iv;
            while (n3 < n4) {
                int it$iv = n3++;
                boolean bl3 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl4 = false;
                if (this.definitions == null) {
                    this.sourcesToReload.add(source);
                    return;
                }
                Object object = this.definitionsBySource;
                ScriptDefinitionsSource scriptDefinitionsSource = source;
                bl = false;
                Map<ScriptDefinitionsSource, List<ScriptDefinition>> map2 = object;
                boolean bl5 = false;
                if (!map2.containsKey(scriptDefinitionsSource)) {
                    object = "Unknown script definition source: " + source;
                    boolean bl6 = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n4 = 0;
                n2 = 0;
                n2 = 0;
                n = readCount$iv;
                while (n2 < n) {
                    int n5 = n2++;
                    boolean bl7 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            List<ScriptDefinition> safeGetDefinitions = this.safeGetDefinitions(source);
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv2 = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled2 = false;
            ReentrantReadWriteLock.ReadLock rl$iv2 = $this$writeWithCheckCanceled$iv2.readLock();
            int readCount$iv2 = $this$writeWithCheckCanceled$iv2.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv2.getReadHoldCount() : 0;
            n4 = 0;
            n2 = 0;
            n2 = 0;
            n = readCount$iv2;
            while (n2 < n) {
                int it$iv = n2++;
                boolean bl8 = false;
                rl$iv2.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv2 = $this$writeWithCheckCanceled$iv2.writeLock();
            while (!wl$iv2.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl9 = false;
                this.definitionsBySource.put(source, safeGetDefinitions);
                bl = false;
                this.definitions = (List)AddToStdlibKt.flattenTo((Iterable)this.definitionsBySource.values(), (Collection)new ArrayList());
                updateDefinitionsResult2 = this.updateDefinitions();
            }
            finally {
                n = 0;
                int n6 = 0;
                n6 = 0;
                int n7 = readCount$iv2;
                while (n6 < n7) {
                    int it$iv = n6++;
                    boolean bl10 = false;
                    rl$iv2.lock();
                }
                wl$iv2.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult3 = updateDefinitionsResult = updateDefinitionsResult2;
            if (updateDefinitionsResult3 == null) break block17;
            updateDefinitionsResult3.apply();
        }
    }

    @NotNull
    protected Sequence<ScriptDefinition> getCurrentDefinitions() {
        KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
        if (kotlinScriptingSettings == null) {
            return SequencesKt.emptySequence();
        }
        KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
        List<? extends ScriptDefinition> list = this.definitions;
        if (list == null) {
            ScriptDefinitionsManager scriptDefinitionsManager = this;
            boolean bl = false;
            boolean bl2 = false;
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager;
            boolean bl3 = false;
            $this$run.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list2 = $this$run.definitions;
            list = list2;
            Intrinsics.checkNotNull(list2);
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<ScriptDefinition, Boolean>(scriptingSettings){
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;

            public final boolean invoke(@NotNull ScriptDefinition it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$scriptingSettings.isScriptDefinitionEnabled(it);
            }
            {
                this.$scriptingSettings = kotlinScriptingSettings;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinitionsSource> getSources() {
        void $this$mapTo$iv$iv;
        ScriptDefinitionsSource scriptDefinitionsSource;
        Collection collection;
        void $this$mapTo$iv$iv2;
        ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)((AreaInstance)this.project)).getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"Extensions.getArea(proje\u2026emplatesProvider.EP_NAME)");
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"Extensions.getArea(proje\u2026vider.EP_NAME).extensions");
        Iterable $this$map$iv = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ScriptTemplatesProvider scriptTemplatesProvider = (ScriptTemplatesProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            scriptDefinitionsSource = ScriptDefinitionsManagerKt.asSource(new ScriptTemplatesProviderAdapter((ScriptTemplatesProvider)v2));
            collection.add(scriptDefinitionsSource);
        }
        List fromDeprecatedEP = (List)destination$iv$iv;
        ExtensionPoint extensionPoint2 = ScriptDefinitionContributor.Companion.getEP_NAME().getPoint((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint2, (String)"ScriptDefinitionContribu\u2026EP_NAME.getPoint(project)");
        Object[] objectArray2 = extensionPoint2.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"ScriptDefinitionContribu\u2026Point(project).extensions");
        Iterable $this$map$iv2 = ArraysKt.toList((Object[])objectArray2);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptDefinitionContributor bl = (ScriptDefinitionContributor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            scriptDefinitionsSource = ScriptDefinitionsManagerKt.asSource((ScriptDefinitionContributor)v5);
            collection.add(scriptDefinitionsSource);
        }
        List fromNewEp = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Iterable)fromDeprecatedEP), (Object)CollectionsKt.last((List)fromNewEp));
    }

    public final void reloadScriptDefinitionsIfNeeded() {
        Unit unit = this.definitions;
        if (unit == null) {
            this.loadScriptDefinitions();
            unit = Unit.INSTANCE;
        }
    }

    public final void reloadScriptDefinitions() {
        this.loadScriptDefinitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadScriptDefinitions() {
        ArrayList arrayList;
        UpdateDefinitionsResult updateDefinitionsResult;
        UpdateDefinitionsResult element$iv$iv2222;
        int n;
        int it$iv;
        if (this.project.isDisposed()) {
            return;
        }
        Iterable $this$associateWith$iv = this.getSources();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv2222 : $this$associateWithTo$iv$iv) {
            void it;
            ScriptDefinitionsSource scriptDefinitionsSource = (ScriptDefinitionsSource)element$iv$iv2222;
            Object t = element$iv$iv2222;
            Map map2 = result$iv;
            boolean bl = false;
            List<ScriptDefinition> list = this.safeGetDefinitions((ScriptDefinitionsSource)it);
            map2.put(t, list);
        }
        Map newDefinitionsBySource = result$iv;
        Object $this$writeWithCheckCanceled$iv = this.definitionsLock;
        boolean $i$f$writeWithCheckCanceled = false;
        ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).readLock();
        int readCount$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).getReadHoldCount() : 0;
        boolean bl = false;
        int element$iv$iv2222 = 0;
        element$iv$iv2222 = 0;
        int it = readCount$iv;
        while (element$iv$iv2222 < it) {
            it$iv = element$iv$iv2222++;
            n = 0;
            rl$iv.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv22 = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).writeLock();
        while (!wl$iv22.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl2 = false;
            this.definitionsBySource.putAll(newDefinitionsBySource);
            boolean bl3 = false;
            this.definitions = (List)AddToStdlibKt.flattenTo((Iterable)this.definitionsBySource.values(), (Collection)new ArrayList());
            element$iv$iv2222 = this.updateDefinitions();
        }
        finally {
            it = 0;
            it$iv = 0;
            it$iv = 0;
            n = readCount$iv;
            while (it$iv < n) {
                int it$iv2 = it$iv++;
                boolean bl4 = false;
                rl$iv.lock();
            }
            wl$iv22.unlock();
        }
        UpdateDefinitionsResult updateDefinitionsResult2 = updateDefinitionsResult = element$iv$iv2222;
        if (updateDefinitionsResult2 != null) {
            updateDefinitionsResult2.apply();
        }
        $this$writeWithCheckCanceled$iv = this.definitionsLock;
        $i$f$writeWithCheckCanceled = false;
        rl$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).readLock();
        readCount$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).getReadHoldCount() : 0;
        boolean wl$iv22 = false;
        int element$iv$iv2222 = 0;
        element$iv$iv2222 = 0;
        it = readCount$iv;
        while (element$iv$iv2222 < it) {
            it$iv = element$iv$iv2222++;
            n = 0;
            rl$iv.unlock();
        }
        ReentrantReadWriteLock.WriteLock wl$iv = ((ReentrantReadWriteLock)$this$writeWithCheckCanceled$iv).writeLock();
        while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            ArrayList arrayList2;
            boolean bl5 = false;
            Set<ScriptDefinitionsSource> set = this.sourcesToReload;
            boolean bl6 = false;
            boolean bl7 = false;
            Set<ScriptDefinitionsSource> it2 = set;
            boolean bl8 = false;
            Collection collection = it2;
            boolean bl9 = false;
            Set<Object> set2 = !collection.isEmpty() ? set : null;
            if (set2 != null) {
                set = set2;
                bl6 = false;
                bl7 = false;
                it2 = set;
                boolean bl10 = false;
                ArrayList copy = new ArrayList(it2);
                it2.clear();
                arrayList2 = copy;
            } else {
                arrayList2 = null;
            }
            ArrayList element$iv$iv2222 = arrayList2;
            arrayList = element$iv$iv2222;
        }
        finally {
            it = 0;
            int n2 = 0;
            n2 = 0;
            int n3 = readCount$iv;
            while (n2 < n3) {
                int it$iv3 = n2++;
                boolean bl11 = false;
                rl$iv.lock();
            }
            wl$iv.unlock();
        }
        if (arrayList != null) {
            void $this$forEach$iv;
            $this$writeWithCheckCanceled$iv = arrayList;
            ScriptDefinitionsManager scriptDefinitionsManager = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptDefinitionsSource p1 = (ScriptDefinitionsSource)element$iv;
                boolean bl12 = false;
                scriptDefinitionsManager.reloadDefinitionsBy(p1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reorderScriptDefinitions() {
        block11: {
            UpdateDefinitionsResult updateDefinitionsResult;
            UpdateDefinitionsResult updateDefinitionsResult2;
            KotlinScriptingSettings kotlinScriptingSettings = this.kotlinScriptingSettingsSafe();
            if (kotlinScriptingSettings == null) {
                return;
            }
            KotlinScriptingSettings scriptingSettings = kotlinScriptingSettings;
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = readCount$iv;
            while (n < n2) {
                int it$iv = n++;
                boolean bl2 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                UpdateDefinitionsResult updateDefinitionsResult3;
                boolean bl3 = false;
                List<? extends ScriptDefinition> list = this.definitions;
                if (list != null) {
                    List<? extends ScriptDefinition> list2 = list;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    List<? extends ScriptDefinition> list3 = list2;
                    boolean bl6 = false;
                    Iterable $this$forEach$iv = list3;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ScriptDefinition it = (ScriptDefinition)element$iv;
                        boolean bl7 = false;
                        it.setOrder(scriptingSettings.getScriptDefinitionOrder(it));
                    }
                    Iterable $this$sortedBy$iv = list3;
                    boolean $i$f$sortedBy = false;
                    boolean bl8 = false;
                    this.definitions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            T receiver = a;
                            boolean bl2 = false;
                            Comparable comparable = Integer.valueOf(((ScriptDefinition)receiver).getOrder());
                            receiver = b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Integer n = ((ScriptDefinition)receiver).getOrder();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                    updateDefinitionsResult3 = this.updateDefinitions();
                } else {
                    updateDefinitionsResult3 = null;
                }
                updateDefinitionsResult2 = updateDefinitionsResult3;
            }
            finally {
                n2 = 0;
                int n3 = 0;
                n3 = 0;
                int n4 = readCount$iv;
                while (n3 < n4) {
                    int it$iv = n3++;
                    boolean bl9 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            UpdateDefinitionsResult updateDefinitionsResult4 = updateDefinitionsResult = updateDefinitionsResult2;
            if (updateDefinitionsResult4 == null) break block11;
            updateDefinitionsResult4.apply();
        }
    }

    private final KotlinScriptingSettings kotlinScriptingSettingsSafe() {
        boolean $i$f$runReadAction = false;
        return (KotlinScriptingSettings)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            {
                this.this$0 = scriptDefinitionsManager;
            }

            public final T compute() {
                boolean bl = false;
                return (T)(!ScriptDefinitionsManager.access$getProject$p(this.this$0).isDisposed() ? KotlinScriptingSettings.Companion.getInstance(ScriptDefinitionsManager.access$getProject$p(this.this$0)) : null);
            }
        });
    }

    @NotNull
    public final List<ScriptDefinition> getAllDefinitions() {
        List<ScriptDefinition> list = this.definitions;
        if (list == null) {
            ScriptDefinitionsManager scriptDefinitionsManager = this;
            boolean bl = false;
            boolean bl2 = false;
            ScriptDefinitionsManager $this$run = scriptDefinitionsManager;
            boolean bl3 = false;
            $this$run.reloadScriptDefinitions();
            List<? extends ScriptDefinition> list2 = $this$run.definitions;
            list = list2;
            Intrinsics.checkNotNull(list2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        boolean bl;
        block12: {
            Set<ScriptDefinitionsSource> set;
            if (this.definitions == null) {
                return false;
            }
            ReentrantReadWriteLock $this$writeWithCheckCanceled$iv = this.definitionsLock;
            boolean $i$f$writeWithCheckCanceled = false;
            ReentrantReadWriteLock.ReadLock rl$iv = $this$writeWithCheckCanceled$iv.readLock();
            int readCount$iv = $this$writeWithCheckCanceled$iv.getWriteHoldCount() == 0 ? $this$writeWithCheckCanceled$iv.getReadHoldCount() : 0;
            boolean bl2 = false;
            int n = 0;
            n = 0;
            int n2 = readCount$iv;
            while (n < n2) {
                int it$iv = n++;
                boolean bl3 = false;
                rl$iv.unlock();
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $this$writeWithCheckCanceled$iv.writeLock();
            while (!wl$iv.tryLock(100L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
            try {
                boolean bl4 = false;
                set = this.definitionsBySource.keySet();
            }
            finally {
                n2 = 0;
                int n3 = 0;
                n3 = 0;
                int n4 = readCount$iv;
                while (n3 < n4) {
                    int it$iv = n3++;
                    boolean bl5 = false;
                    rl$iv.lock();
                }
                wl$iv.unlock();
            }
            Set<ScriptDefinitionsSource> keys = set;
            Iterable $this$all$iv = keys;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ScriptDefinitionsSource source = (ScriptDefinitionsSource)element$iv;
                    boolean bl6 = false;
                    ScriptDefinitionsSource scriptDefinitionsSource = source;
                    if (!(scriptDefinitionsSource instanceof ScriptDefinitionContributor)) {
                        scriptDefinitionsSource = null;
                    }
                    ScriptDefinitionContributor scriptDefinitionContributor = (ScriptDefinitionContributor)scriptDefinitionsSource;
                    if (scriptDefinitionContributor == null || scriptDefinitionContributor.isReady()) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        Object object = ScriptDefinitionContributor.Companion;
        Project project$iv = this.project;
        boolean $i$f$find = false;
        ExtensionPoint extensionPoint = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"EP_NAME.getPoint(project)");
        List list = extensionPoint.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.getPoint(project).extensionList");
        Iterable $this$filterIsInstance$iv$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof StandardScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor = (StandardScriptDefinitionContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
        if (standardScriptDefinitionContributor == null) {
            object = "StandardScriptDefinitionContributor should be registered is plugin.xml";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        StandardScriptDefinitionContributor standardScriptDefinitionContributor2 = standardScriptDefinitionContributor;
        return (ScriptDefinition)new ScriptDefinition.FromLegacy(this.getScriptingHostConfiguration(), (KotlinScriptDefinition)CollectionsKt.last(standardScriptDefinitionContributor2.getDefinitions()), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final UpdateDefinitionsResult updateDefinitions() {
        void $this$filterTo$iv$iv;
        boolean bl = this.definitionsLock.isWriteLocked();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = false;
            String $i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22 = "updateDefinitions should only be called under the write lock";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ScriptDefinitionsManager$updateDefinitions$22));
        }
        if (this.project.isDisposed()) {
            return null;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Iterable $this$filter$iv = SequencesKt.toSet((Sequence)this.getKnownFilenameExtensions());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType fileTypeByExtension;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager.getFileTypeByExtension(it), (String)"fileTypeManager.getFileTypeByExtension(it)");
            boolean notKnown = Intrinsics.areEqual((Object)fileTypeByExtension, (Object)KotlinFileType.INSTANCE) ^ true;
            if (notKnown) {
                StringBuilder stringBuilder = new StringBuilder().append("extension ").append(it).append(" file type [").append(fileTypeByExtension.getName()).append("] is not registered as ");
                KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
                ScriptUtilsKt.scriptingWarnLog(stringBuilder.append(kotlinFileType.getName()).toString());
            }
            if (!notKnown) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set newExtensions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.clearCache();
        CheckCanceledLock this_$iv = this.scriptDefinitionsCacheLock;
        boolean $i$f$withLock$kotlin_core = false;
        while (!CheckCanceledLock.access$getLock$p(this_$iv).tryLock(100L, TimeUnit.MILLISECONDS)) {
            ProgressManager.checkCanceled();
        }
        try {
            boolean bl4 = false;
            this.scriptDefinitionsCache.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            CheckCanceledLock.access$getLock$p(this_$iv).unlock();
        }
        return new UpdateDefinitionsResult(this.project, newExtensions);
    }

    private final List<ScriptDefinition> safeGetDefinitions(ScriptDefinitionsSource $this$safeGetDefinitions) {
        if (!this.failedContributorsHashes.contains($this$safeGetDefinitions.hashCode())) {
            try {
                return SequencesKt.toList((Sequence)$this$safeGetDefinitions.getDefinitions());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.failedContributorsHashes.add($this$safeGetDefinitions.hashCode());
                if (t.getCause() instanceof ClasspathExtractionException || t instanceof ClasspathExtractionException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Cannot load script definitions from ").append($this$safeGetDefinitions).append(": ");
                    Object object = t.getCause();
                    if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                        object = t.getMessage();
                    }
                    ScriptUtilsKt.scriptingWarnLog(stringBuilder.append((String)object).toString());
                }
                ScriptUtilsKt.scriptingErrorLog("[kts] cannot load script definitions using " + $this$safeGetDefinitions, t);
            }
        }
        return CollectionsKt.emptyList();
    }

    public void dispose() {
        super.dispose();
        this.clearCache();
        this.definitionsBySource.clear();
        this.definitions = null;
        this.failedContributorsHashes.clear();
        this.scriptDefinitionsCache.clear();
        this.configurations = null;
    }

    public ScriptDefinitionsManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.definitionsLock = new ReentrantReadWriteLock();
        boolean bl = false;
        this.definitionsBySource = new LinkedHashMap();
        bl = false;
        this.sourcesToReload = new LinkedHashSet();
        this.failedContributorsHashes = new HashSet();
        this.scriptDefinitionsCacheLock = new CheckCanceledLock();
        this.scriptDefinitionsCache = new SLRUMap(10, 10);
        this.configurations = ScriptConfigurationManager.Companion.compositeScriptConfigurationManager(this.project);
    }

    public static final /* synthetic */ Project access$getProject$p(ScriptDefinitionsManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$UpdateDefinitionsResult;", "", "project", "Lcom/intellij/openapi/project/Project;", "newExtensions", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getNewExtensions", "()Ljava/util/Set;", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.core"})
    private static final class UpdateDefinitionsResult {
        @NotNull
        private final Project project;
        @NotNull
        private final Set<String> newExtensions;

        public final void apply() {
            Collection collection = this.newExtensions;
            boolean bl = false;
            if (!collection.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append("extensions ").append(this.newExtensions).append(" is about to be registered as ");
                KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
                ScriptUtilsKt.scriptingWarnLog(stringBuilder.append(kotlinFileType.getName()).toString());
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ UpdateDefinitionsResult this$0;

                    public final void run() {
                        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction(new Computable(this, fileTypeManager){
                            final /* synthetic */ apply.1 this$0;
                            final /* synthetic */ FileTypeManager $fileTypeManager$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$fileTypeManager$inlined = fileTypeManager;
                            }

                            public final T compute() {
                                boolean bl = false;
                                Iterable $this$forEach$iv = this.this$0.this$0.getNewExtensions();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    this.$fileTypeManager$inlined.associateExtension((FileType)KotlinFileType.INSTANCE, it);
                                }
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.this$0 = updateDefinitionsResult;
                    }
                });
            }
            ScriptConfigurationManager.Companion.getInstance(this.project).updateScriptDefinitionReferences();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Set<String> getNewExtensions() {
            return this.newExtensions;
        }

        public UpdateDefinitionsResult(@NotNull Project project, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            this.project = project;
            this.newExtensions = newExtensions;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Set<String> component2() {
            return this.newExtensions;
        }

        @NotNull
        public final UpdateDefinitionsResult copy(@NotNull Project project, @NotNull Set<String> newExtensions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(newExtensions, (String)"newExtensions");
            return new UpdateDefinitionsResult(project, newExtensions);
        }

        public static /* synthetic */ UpdateDefinitionsResult copy$default(UpdateDefinitionsResult updateDefinitionsResult, Project project, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                project = updateDefinitionsResult.project;
            }
            if ((n & 2) != 0) {
                set = updateDefinitionsResult.newExtensions;
            }
            return updateDefinitionsResult.copy(project, set);
        }

        @NotNull
        public String toString() {
            return "UpdateDefinitionsResult(project=" + this.project + ", newExtensions=" + this.newExtensions + ")";
        }

        public int hashCode() {
            Project project = this.project;
            Set<String> set = this.newExtensions;
            return (project != null ? project.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UpdateDefinitionsResult)) break block3;
                    UpdateDefinitionsResult updateDefinitionsResult = (UpdateDefinitionsResult)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)updateDefinitionsResult.project) || !Intrinsics.areEqual(this.newExtensions, updateDefinitionsResult.newExtensions)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(ScriptDefinitionProvider.class);
            if (object == null) {
                String string = "Unable to locate service " + ScriptDefinitionProvider.class.getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager");
            }
            return (ScriptDefinitionsManager)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

