/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.core.CoreBundle;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006\u001a#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a(\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u001b*\u00020\u000f\u001a\n\u0010\u001e\u001a\u00020\u001b*\u00020\u000f\u001a\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005*\u00020\u0007H\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u001b*\u00020\u000fH\u0002\u001a\u0012\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005*\u00020\u0007H\u0002\u001a\u001c\u0010\"\u001a\u00020\u0017*\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0006H\u0002\u001a\u000e\u0010&\u001a\u0004\u0018\u00010\u0017*\u00020\u0007H\u0002\u001a\f\u0010'\u001a\u0004\u0018\u00010\u000b*\u00020\u000f\u001a\u0014\u0010(\u001a\u00020)*\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002\u001a\n\u0010,\u001a\u00020)*\u00020-\u001a\n\u0010.\u001a\u00020)*\u00020-\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"kotlinSourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "pureKotlinSourceFolders", "", "", "Lcom/intellij/openapi/module/Module;", "getPureKotlinSourceFolders", "(Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "findLongestExistingPackage", "Lcom/intellij/psi/PsiPackage;", "module", "packageName", "findOrCreateDirectoryForPackage", "Lcom/intellij/psi/PsiDirectory;", "getPackageDirectoriesInModule", "", "rootPackage", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/openapi/module/Module;)[Lcom/intellij/psi/PsiDirectory;", "getWritableModuleDirectory", "vFiles", "Lcom/intellij/util/Query;", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/psi/PsiManager;", "getFqNameByDirectory", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/PsiFile;", "getFqNameWithImplicitPrefix", "getFqNameWithImplicitPrefixOrRoot", "getNonGeneratedKotlinSourceRoots", "getNonRootFqNameOrNull", "getOrConfigureKotlinSourceRoots", "getOrCreateChildDirectory", "requestor", "", "name", "getOrCreateRootDirectory", "getPackage", "hasExplicitPackagePrefix", "", "project", "Lcom/intellij/openapi/project/Project;", "packageMatchesDirectory", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageMatchesDirectoryOrImplicit", "kotlin.core"})
public final class PackageUtilsKt {
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> kotlinSourceRootTypes;

    @Nullable
    public static final PsiPackage getPackage(@NotNull PsiDirectory $this$getPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackage, (String)"$this$getPackage");
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        Intrinsics.checkNotNull((Object)javaDirectoryService);
        return javaDirectoryService.getPackage($this$getPackage);
    }

    private static final FqName getNonRootFqNameOrNull(PsiDirectory $this$getNonRootFqNameOrNull) {
        FqName fqName;
        Object object = PackageUtilsKt.getPackage($this$getNonRootFqNameOrNull);
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            fqName = new FqName((String)p1);
        } else {
            fqName = null;
        }
        return fqName;
    }

    @NotNull
    public static final FqName getFqNameByDirectory(@NotNull PsiFile $this$getFqNameByDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameByDirectory, (String)"$this$getFqNameByDirectory");
        PsiDirectory psiDirectory = $this$getFqNameByDirectory.getParent();
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getNonRootFqNameOrNull(psiDirectory)) == null) {
            FqName fqName = FqName.ROOT;
            psiDirectory = fqName;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"FqName.ROOT");
        }
        return psiDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName getFqNameWithImplicitPrefix(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefix, (String)"$this$getFqNameWithImplicitPrefix");
        FqName fqName = PackageUtilsKt.getNonRootFqNameOrNull($this$getFqNameWithImplicitPrefix);
        if (fqName == null) {
            return null;
        }
        FqName packageFqName = fqName;
        Object object = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$getFqNameWithImplicitPrefix);
        if (object != null) {
            VirtualFile virtualFile = object;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile;
            boolean bl3 = false;
            Project project = $this$getFqNameWithImplicitPrefix.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            object = !PackageUtilsKt.hasExplicitPackagePrefix(it, project) ? virtualFile : null;
            if (object != null) {
                void $this$mapTo$iv$iv;
                virtualFile = object;
                bl = false;
                bl2 = false;
                VirtualFile sourceRoot = virtualFile;
                boolean bl4 = false;
                Project project2 = $this$getFqNameWithImplicitPrefix.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                FqName implicitPrefix = PerModulePackageCacheService.Companion.getInstance(project2).getImplicitPackagePrefix(sourceRoot);
                List list = implicitPrefix.pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"implicitPrefix.pathSegments()");
                Collection collection = list;
                List list2 = packageFqName.pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"packageFqName.pathSegments()");
                Iterable $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Name name = (Name)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl5 = false;
                    String string = it2.asString();
                    collection2.add(string);
                }
                return FqName.fromSegments((List)((List)destination$iv$iv));
            }
        }
        return packageFqName;
    }

    @NotNull
    public static final FqName getFqNameWithImplicitPrefixOrRoot(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefixOrRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefixOrRoot, (String)"$this$getFqNameWithImplicitPrefixOrRoot");
        FqName fqName = PackageUtilsKt.getFqNameWithImplicitPrefix($this$getFqNameWithImplicitPrefixOrRoot);
        if (fqName == null) {
            FqName fqName2 = FqName.ROOT;
            fqName = fqName2;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        }
        return fqName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasExplicitPackagePrefix(VirtualFile $this$hasExplicitPackagePrefix, Project project) {
        PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory($this$hasExplicitPackagePrefix, project);
        Object object = psiDirectory;
        if (psiDirectory == null) return false;
        PsiPackage psiPackage = PackageUtilsKt.getPackage(object);
        object = psiPackage;
        if (psiPackage == null) return false;
        String string = object.getQualifiedName();
        object = string;
        if (string == null) return false;
        CharSequence charSequence = (CharSequence)object;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    public static final boolean packageMatchesDirectory(@NotNull KtFile $this$packageMatchesDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$packageMatchesDirectory, (String)"$this$packageMatchesDirectory");
        return Intrinsics.areEqual((Object)$this$packageMatchesDirectory.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$this$packageMatchesDirectory));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean packageMatchesDirectoryOrImplicit(@NotNull KtFile $this$packageMatchesDirectoryOrImplicit) {
        Intrinsics.checkNotNullParameter((Object)$this$packageMatchesDirectoryOrImplicit, (String)"$this$packageMatchesDirectoryOrImplicit");
        if (Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$this$packageMatchesDirectoryOrImplicit))) return true;
        PsiDirectory psiDirectory = $this$packageMatchesDirectoryOrImplicit.getParent();
        if (!Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null))) return false;
        return true;
    }

    private static final PsiDirectory getWritableModuleDirectory(Query<VirtualFile> vFiles, Module module, PsiManager manager) {
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory;
            if (ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)module.getProject()) != module || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiPackage findLongestExistingPackage(Module module, String packageName) {
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        PsiManager manager = psiManager;
        String nameToMatch = packageName;
        while (true) {
            int lastDotIndex;
            Query vFiles;
            Intrinsics.checkNotNullExpressionValue((Object)ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(nameToMatch, false), (String)"ModulePackageIndex.getIn\u2026eName(nameToMatch, false)");
            PsiDirectory directory = PackageUtilsKt.getWritableModuleDirectory((Query<VirtualFile>)vFiles, module, manager);
            if (directory != null) {
                List<String> list = PackageUtilsKt.getPureKotlinSourceFolders(module);
                if (list != null) {
                    boolean bl;
                    block9: {
                        void $this$any$iv;
                        Iterable iterable = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                VirtualFile virtualFile = directory.getVirtualFile();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"directory.virtualFile");
                                String string = virtualFile.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directory.virtualFile.path");
                                if (!StringsKt.startsWith((String)string, (String)it, (boolean)true)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return PackageUtilsKt.getPackage(directory);
                    }
                }
            }
            if ((lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)nameToMatch, (char)'.', (int)0, (boolean)false, (int)6, null)) < 0) {
                return null;
            }
            String string = nameToMatch;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, lastDotIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
    }

    private static final List<String> getPureKotlinSourceFolders(Module $this$pureKotlinSourceFolders) {
        Object object = KotlinFacet.Companion.get($this$pureKotlinSourceFolders);
        return object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null && (object = object.getSettings()) != null ? object.getPureKotlinSourceFolders() : null;
    }

    private static final List<VirtualFile> getNonGeneratedKotlinSourceRoots(Module $this$getNonGeneratedKotlinSourceRoots) {
        ModuleRootManager rootManager;
        boolean bl = false;
        List result = new ArrayList();
        Map modulesToPureKotlinSourceFolders = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)$this$getNonGeneratedKotlinSourceRoots, PackageUtilsKt.getPureKotlinSourceFolders($this$getNonGeneratedKotlinSourceRoots))});
        ModuleRootManager moduleRootManager = rootManager = ModuleRootManager.getInstance((Module)$this$getNonGeneratedKotlinSourceRoots);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"rootManager");
        for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
            List sourceFolders;
            Intrinsics.checkNotNullExpressionValue((Object)contentEntry.getSourceFolders(kotlinSourceRootTypes), (String)"contentEntry.getSourceFo\u2026rs(kotlinSourceRootTypes)");
            Iterator iterator = sourceFolders.iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                VirtualFile it;
                block9: {
                    List modulePureKotlinSourceFolders;
                    Object object;
                    VirtualFile virtualFile;
                    SourceFolder sourceFolder;
                    SourceFolder sourceFolder2 = sourceFolder = (SourceFolder)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceFolder2, (String)"sourceFolder");
                    JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)sourceFolder2.getJpsElement().getProperties(kotlinSourceRootTypes);
                    if (javaSourceRootProperties != null) {
                        if (javaSourceRootProperties.isForGeneratedSources()) {
                            continue;
                        }
                    }
                    if (sourceFolder.getFile() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    it = virtualFile;
                    boolean bl5 = false;
                    Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)$this$getNonGeneratedKotlinSourceRoots.getProject());
                    if (moduleForFile == null) continue;
                    Map $this$getOrPut$iv = modulesToPureKotlinSourceFolders;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(moduleForFile);
                    if (value$iv == null) {
                        boolean bl6 = false;
                        List<String> answer$iv = PackageUtilsKt.getPureKotlinSourceFolders(moduleForFile);
                        $this$getOrPut$iv.put(moduleForFile, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    List list = modulePureKotlinSourceFolders = (List)object;
                    if (list == null) continue;
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String pure = (String)element$iv;
                            boolean bl7 = false;
                            VirtualFile virtualFile2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                            String string = virtualFile2.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                            if (!StringsKt.startsWith((String)string, (String)pure, (boolean)true)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                Collection collection = result;
                boolean bl8 = false;
                collection.add(it);
            }
        }
        return result;
    }

    private static final List<VirtualFile> getOrConfigureKotlinSourceRoots(Module $this$getOrConfigureKotlinSourceRoots) {
        List<VirtualFile> sourceRoots = PackageUtilsKt.getNonGeneratedKotlinSourceRoots($this$getOrConfigureKotlinSourceRoots);
        Collection collection = sourceRoots;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return sourceRoots;
        }
        boolean $i$f$runWriteAction = false;
        return (List)ApplicationManager.getApplication().runWriteAction(new Computable($this$getOrConfigureKotlinSourceRoots){
            final /* synthetic */ Module $this_getOrConfigureKotlinSourceRoots$inlined;
            {
                this.$this_getOrConfigureKotlinSourceRoots$inlined = module;
            }

            public final T compute() {
                boolean bl = false;
                VirtualFile virtualFile = PackageUtilsKt.access$getOrCreateRootDirectory(this.$this_getOrConfigureKotlinSourceRoots$inlined);
                if (virtualFile != null) {
                    Project project = this.$this_getOrConfigureKotlinSourceRoots$inlined.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    PackageUtilsKt.access$getOrCreateChildDirectory(virtualFile, project, "kotlin");
                }
                Project project = this.$this_getOrConfigureKotlinSourceRoots$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                RootUtilsKt.invalidateProjectRoots(project);
                return (T)PackageUtilsKt.access$getNonGeneratedKotlinSourceRoots(this.$this_getOrConfigureKotlinSourceRoots$inlined);
            }
        });
    }

    private static final VirtualFile getOrCreateChildDirectory(VirtualFile $this$getOrCreateChildDirectory, Object requestor, String name) {
        VirtualFile virtualFile = $this$getOrCreateChildDirectory.findChild(name);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            VirtualFile virtualFile3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
            if (!virtualFile3.isDirectory()) {
                throw (Throwable)new IOException(CoreBundle.message((String)"directory.create.wrong.parent.error", (Object[])new Object[0]));
            }
            if (!it.isValid()) {
                throw (Throwable)new IOException(CoreBundle.message((String)"invalid.directory.create.files", (Object[])new Object[0]));
            }
            return it;
        }
        VirtualFile virtualFile4 = $this$getOrCreateChildDirectory.createChildDirectory(requestor, name);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"this.createChildDirectory(requestor, name)");
        return virtualFile4;
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getOrCreateRootDirectory(Module $this$getOrCreateRootDirectory) {
        VirtualFile virtualFile;
        VirtualFile rootParent;
        Object[] objectArray = ProjectRootsUtilKt.getRootManager($this$getOrCreateRootDirectory).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootManager.contentEntries");
        ContentEntry contentEntry = (ContentEntry)ArraysKt.firstOrNull((Object[])objectArray);
        if (contentEntry == null) {
            return null;
        }
        ContentEntry contentEntry2 = contentEntry;
        VirtualFile virtualFile2 = contentEntry2.getFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            return it;
        }
        Path path = Paths.get(URI.create(contentEntry2.getUrl()));
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        VirtualFile virtualFile4 = rootParent = localFileSystem.findFileByPath(PathKt.getParentSystemIndependentPath((Path)path2));
        if (virtualFile4 != null) {
            String string;
            VirtualFile virtualFile5;
            Project project;
            block6: {
                void $this$takeLastWhile$iv;
                Project project2 = $this$getOrCreateRootDirectory.getProject();
                String string2 = $this$getOrCreateRootDirectory.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                String string3 = string2;
                project = project2;
                virtualFile5 = virtualFile4;
                boolean $i$f$takeLastWhile = false;
                int bl3 = StringsKt.getLastIndex((CharSequence)((CharSequence)$this$takeLastWhile$iv));
                boolean bl = false;
                while (bl3 >= 0) {
                    void index$iv;
                    char it = $this$takeLastWhile$iv.charAt((int)index$iv);
                    boolean bl4 = false;
                    if (!(it != '.')) {
                        void var8_16 = $this$takeLastWhile$iv;
                        void var9_17 = index$iv + true;
                        boolean bl5 = false;
                        String string4 = var8_16.substring((int)var9_17);
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        break block6;
                    }
                    --index$iv;
                }
                string = $this$takeLastWhile$iv;
            }
            void var13_19 = string;
            virtualFile = virtualFile5.createChildDirectory((Object)project, (String)var13_19);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final PsiDirectory[] getPackageDirectoriesInModule(PsiPackage rootPackage, Module module) {
        PsiDirectory[] psiDirectoryArray = rootPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"rootPackage.getDirectori\u2026cope.moduleScope(module))");
        return psiDirectoryArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, @NotNull String packageName) {
        void psiDirectory;
        List<VirtualFile> sourceRoots;
        PsiDirectory psiDirectory2;
        Object thisCollection$iv2;
        boolean $i$f$toTypedArray;
        Object $this$toTypedArray$iv;
        int n;
        int beginIndex;
        PsiPackage rootPackage;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Project project2 = project;
        PsiDirectory existingDirectoryByPackage = null;
        String restOfName = packageName;
        CharSequence charSequence = packageName;
        boolean bl = false;
        if (charSequence.length() > 0 && (rootPackage = PackageUtilsKt.findLongestExistingPackage(module, packageName)) != null) {
            String string;
            beginIndex = rootPackage.getQualifiedName().length() + 1;
            if (beginIndex < packageName.length()) {
                String string2 = packageName;
                boolean bl2 = false;
                String string3 = string2.substring(beginIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            String subPackageName = string;
            String postfixToShow = StringsKt.replace$default((String)subPackageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            CharSequence charSequence2 = subPackageName;
            boolean bl3 = false;
            if (charSequence2.length() > 0) {
                char c = File.separatorChar;
                bl3 = false;
                postfixToShow = String.valueOf(c) + postfixToShow;
            }
            Map modulesToPureKotlinSourceFolders = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)module, PackageUtilsKt.getPureKotlinSourceFolders(module))});
            PsiDirectory[] moduleDirectories = PackageUtilsKt.getPackageDirectoriesInModule(rootPackage, module);
            boolean bl4 = false;
            List result = new ArrayList();
            PsiDirectory[] $this$forEach$iv = moduleDirectories;
            boolean $i$f$forEach = false;
            PsiDirectory[] psiDirectoryArray = $this$forEach$iv;
            n = psiDirectoryArray.length;
            for (int j = 0; j < n; ++j) {
                boolean bl5;
                PsiDirectory directory;
                block20: {
                    List modulePureKotlinSourceFolders;
                    Object object;
                    PsiDirectory element$iv;
                    directory = element$iv = psiDirectoryArray[j];
                    boolean bl6 = false;
                    Module directoryModule = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)module.getProject());
                    if (directoryModule == null) continue;
                    Map $this$getOrPut$iv = modulesToPureKotlinSourceFolders;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(directoryModule);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        List<String> answer$iv = PackageUtilsKt.getPureKotlinSourceFolders(directoryModule);
                        $this$getOrPut$iv.put(directoryModule, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    List list = modulePureKotlinSourceFolders = (List)object;
                    if (list == null) continue;
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            String it = (String)element$iv2;
                            boolean bl8 = false;
                            VirtualFile virtualFile = directory.getVirtualFile();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"directory.virtualFile");
                            String string4 = virtualFile.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"directory.virtualFile.path");
                            if (!StringsKt.startsWith((String)string4, (String)it, (boolean)true)) continue;
                            bl5 = true;
                            break block20;
                        }
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                Collection collection = result;
                boolean bl9 = false;
                collection.add(directory);
            }
            $this$toTypedArray$iv = result;
            $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            PsiDirectory[] psiDirectoryArray2 = thisCollection$iv2.toArray(new PsiDirectory[0]);
            if (psiDirectoryArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PsiDirectory psiDirectory3 = DirectoryChooserUtil.selectDirectory((Project)project2, (PsiDirectory[])psiDirectoryArray2, null, (String)postfixToShow);
            if (psiDirectory3 == null) {
                return null;
            }
            existingDirectoryByPackage = psiDirectory3;
            restOfName = subPackageName;
        }
        if ((psiDirectory2 = existingDirectoryByPackage) == null) {
            beginIndex = 0;
            boolean subPackageName = false;
            boolean bl10 = false;
            sourceRoots = PackageUtilsKt.getOrConfigureKotlinSourceRoots(module);
            if (sourceRoots.isEmpty()) {
                return null;
            }
            boolean moduleDirectories = false;
            List directoryList = new ArrayList();
            $this$toTypedArray$iv = sourceRoots.iterator();
            while ($this$toTypedArray$iv.hasNext()) {
                PsiDirectory directory;
                VirtualFile sourceRoot = (VirtualFile)$this$toTypedArray$iv.next();
                if (PsiManager.getInstance((Project)project2).findDirectory(sourceRoot) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"PsiManager.getInstance(p\u2026y(sourceRoot) ?: continue");
                thisCollection$iv2 = directoryList;
                n = 0;
                thisCollection$iv2.add(directory);
            }
            Iterable $this$sortedBy$iv = directoryList;
            boolean $i$f$sortedBy = false;
            boolean thisCollection$iv2 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PsiDirectory it = (PsiDirectory)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (PsiDirectory)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            $i$f$toTypedArray = false;
            Iterator thisCollection$iv22 = $this$toTypedArray$iv;
            PsiDirectory[] psiDirectoryArray = thisCollection$iv22.toArray((PsiDirectory[])new PsiDirectory[0]);
            if (psiDirectoryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PsiDirectory[] sourceDirectories = psiDirectoryArray;
            char c = File.separatorChar;
            String string = StringsKt.replace$default((String)packageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            boolean bl11 = false;
            PsiDirectory psiDirectory4 = DirectoryChooserUtil.selectDirectory((Project)project2, (PsiDirectory[])sourceDirectories, null, (String)(String.valueOf(c) + string));
            if (psiDirectory4 == null) {
                return null;
            }
            psiDirectory2 = psiDirectory4;
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory4, (String)"DirectoryChooserUtil.sel\u2026\n        ) ?: return null");
        }
        PsiDirectory existingDirectory = psiDirectory2;
        findOrCreateDirectoryForPackage.2 $fun$getLeftPart$2 = findOrCreateDirectoryForPackage.2.INSTANCE;
        findOrCreateDirectoryForPackage.3 $fun$cutLeftPart$3 = findOrCreateDirectoryForPackage.3.INSTANCE;
        Ref.ObjectRef bl10 = new Ref.ObjectRef();
        bl10.element = existingDirectory;
        while (true) {
            sourceRoots = restOfName;
            boolean sourceDirectories = false;
            if (!(sourceRoots.length() > 0)) break;
            String name = $fun$getLeftPart$2.invoke(restOfName);
            PsiDirectory foundExistingDirectory = ((PsiDirectory)psiDirectory.element).findSubdirectory(name);
            PsiDirectory psiDirectory5 = foundExistingDirectory;
            if (psiDirectory5 == null) {
                Object object = WriteAction.compute((ThrowableComputable)new ThrowableComputable((Ref.ObjectRef)psiDirectory, name){
                    final /* synthetic */ Ref.ObjectRef $psiDirectory;
                    final /* synthetic */ String $name;

                    public final PsiDirectory compute() {
                        return ((PsiDirectory)this.$psiDirectory.element).createSubdirectory(this.$name);
                    }
                    {
                        this.$psiDirectory = objectRef;
                        this.$name = string;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.compute<PsiD\u2026reateSubdirectory(name) }");
                psiDirectory5 = (PsiDirectory)object;
            }
            psiDirectory.element = psiDirectory5;
            restOfName = $fun$cutLeftPart$3.invoke(restOfName);
        }
        return (PsiDirectory)psiDirectory.element;
    }

    static {
        Set set = SetsKt.setOf((Object[])new KotlinSourceRootType[]{(KotlinSourceRootType)SourceKotlinRootType.INSTANCE, (KotlinSourceRootType)TestSourceKotlinRootType.INSTANCE});
        Set set2 = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"JavaModuleSourceRootTypes.SOURCES");
        kotlinSourceRootTypes = SetsKt.plus((Set)set, (Iterable)set2);
    }

    public static final /* synthetic */ VirtualFile access$getOrCreateRootDirectory(Module $this$access_u24getOrCreateRootDirectory) {
        return PackageUtilsKt.getOrCreateRootDirectory($this$access_u24getOrCreateRootDirectory);
    }

    public static final /* synthetic */ VirtualFile access$getOrCreateChildDirectory(VirtualFile $this$access_u24getOrCreateChildDirectory, Object requestor, String name) {
        return PackageUtilsKt.getOrCreateChildDirectory($this$access_u24getOrCreateChildDirectory, requestor, name);
    }

    public static final /* synthetic */ List access$getNonGeneratedKotlinSourceRoots(Module $this$access_u24getNonGeneratedKotlinSourceRoots) {
        return PackageUtilsKt.getNonGeneratedKotlinSourceRoots($this$access_u24getNonGeneratedKotlinSourceRoots);
    }
}

