/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IDEKotlinAsJavaSupport;
import org.jetbrains.kotlin.idea.caches.resolve.util.DumbUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileClassProvider;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KtFileClassProviderImpl;", "Lorg/jetbrains/kotlin/psi/KtFileClassProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFileClasses", "", "Lcom/intellij/psi/PsiClass;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)[Lcom/intellij/psi/PsiClass;", "kotlin.core"})
public final class KtFileClassProviderImpl
implements KtFileClassProvider {
    @NotNull
    private final Project project;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiClass[] getFileClasses(@NotNull KtFile file) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                if (DumbUtilsKt.isInDumbMode(project)) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"PsiClass.EMPTY_ARRAY");
                    return PsiClass.EMPTY_ARRAY;
                }
                if (file.isCompiled()) break block16;
                boolean $i$f$runReadAction = false;
                if (!((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(file){
                    final /* synthetic */ KtFile $file$inlined;
                    {
                        this.$file$inlined = ktFile;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(this.$file$inlined.isScript());
                    }
                })).booleanValue()) break block17;
            }
            Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"PsiClass.EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        boolean bl = false;
        ArrayList result = new ArrayList();
        Iterable $this$filterIsInstance$iv = file.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)it);
            collection2.add(ktLightClass);
        }
        CollectionsKt.filterNotNullTo((Iterable)((List)destination$iv$iv), (Collection)result);
        IdeaModuleInfo moduleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)file);
        if (!JvmPlatformKt.isJvm((TargetPlatform)moduleInfo.getPlatform())) {
            return new PsiClass[0];
        }
        JvmFileClassInfo jvmClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file);
        FqName fileClassFqName = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)file);
        KotlinAsJavaSupport kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
        if (KtPsiFactoryKt.getAnalysisContext((KtFile)file) != null && file.hasTopLevelCallables()) {
            PsiManager psiManager = PsiManager.getInstance((Project)file.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(\n\u2026                        )");
            collection = CollectionsKt.listOf((Object)KtLightClassForFacade.Companion.createForSyntheticFile(psiManager, fileClassFqName, file));
        } else if (jvmClassInfo.getWithJvmMultifileClass()) {
            collection = kotlinAsJavaSupport.getFacadeClasses(fileClassFqName, moduleInfo.contentScope());
        } else if (file.hasTopLevelCallables()) {
            KotlinAsJavaSupport kotlinAsJavaSupport2 = kotlinAsJavaSupport;
            if (kotlinAsJavaSupport2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.caches.resolve.IDEKotlinAsJavaSupport");
            }
            collection = ((IDEKotlinAsJavaSupport)kotlinAsJavaSupport2).createLightClassForFileFacade(fileClassFqName, CollectionsKt.listOf((Object)file), moduleInfo);
        } else {
            collection = CollectionsKt.emptyList();
        }
        Collection facadeClasses = collection;
        Iterable $this$filterTo$iv = facadeClasses;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            PsiClass it = (PsiClass)element$iv;
            boolean bl3 = false;
            if (!(it instanceof KtLightClassForFacade && ((KtLightClassForFacade)it).getFiles().contains(file))) continue;
            ((Collection)result).add(element$iv);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiClassArray;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KtFileClassProviderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

