/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoUtilsKt;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionAnchorCacheService;
import org.jetbrains.kotlin.idea.project.KotlinLibraryToSourceAnalysisComponentKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.resolve.ResolutionAnchorProvider;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinIdeResolutionAnchorService;", "Lorg/jetbrains/kotlin/resolve/ResolutionAnchorProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolutionAnchor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "kotlin.core"})
public final class KotlinIdeResolutionAnchorService
implements ResolutionAnchorProvider {
    @NotNull
    private final Project project;

    @Nullable
    public ModuleDescriptor getResolutionAnchor(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!KotlinLibraryToSourceAnalysisComponentKt.getLibraryToSourceAnalysisEnabled(this.project)) {
            return null;
        }
        Map<LibraryInfo, ModuleSourceInfo> moduleToAnchor = ResolutionAnchorCacheService.Companion.getInstance(this.project).getResolutionAnchorsForLibraries();
        ModuleInfo moduleInfo = ModuleInfoUtilsKt.getModuleInfo((ModuleDescriptor)moduleDescriptor);
        if (moduleInfo == null) {
            return null;
        }
        ModuleInfo moduleInfo2 = moduleInfo;
        ModuleInfo keyModuleInfo = moduleInfo2 instanceof SourceForBinaryModuleInfo ? (ModuleInfo)((SourceForBinaryModuleInfo)moduleInfo2).getBinariesModuleInfo() : moduleInfo2;
        Map<LibraryInfo, ModuleSourceInfo> map2 = moduleToAnchor;
        boolean bl = false;
        ModuleSourceInfo moduleSourceInfo = map2.get(keyModuleInfo);
        if (moduleSourceInfo == null) {
            return null;
        }
        ModuleSourceInfo mapped = moduleSourceInfo;
        ResolutionFacade resolutionFacade = KotlinCacheService.Companion.getInstance(this.project).getResolutionFacadeByModuleInfo((ModuleInfo)mapped, mapped.getPlatform());
        return resolutionFacade != null ? resolutionFacade.getModuleDescriptor() : null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinIdeResolutionAnchorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

