/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\u0006\u0010\u0019\u001a\u00020\u0014J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\u001c\u001a\u00020\u0007J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\u000bR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\b0\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00050\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/IdeaModelInfosCache;", "", "moduleSourceInfosByModules", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "libraryInfosByLibraries", "Lcom/intellij/openapi/roots/libraries/Library;", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "sdkInfosBySdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "(Lcom/intellij/util/containers/MultiMap;Lcom/intellij/util/containers/MultiMap;Ljava/util/Map;)V", "libraryInfos", "", "kotlin.jvm.PlatformType", "moduleSourceInfos", "resultByPlatform", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "sdkInfos", "allModules", "forPlatform", "platform", "getLibraryInfosForLibrary", "", "library", "getModuleInfosForModule", "module", "getSdkInfoForSdk", "sdk", "kotlin.core"})
public final class IdeaModelInfosCache {
    private final ConcurrentHashMap<TargetPlatform, List<IdeaModuleInfo>> resultByPlatform;
    private final List<ModuleSourceInfo> moduleSourceInfos;
    private final List<LibraryInfo> libraryInfos;
    private final List<SdkInfo> sdkInfos;
    private final MultiMap<Module, ModuleSourceInfo> moduleSourceInfosByModules;
    private final MultiMap<Library, LibraryInfo> libraryInfosByLibraries;
    private final Map<Sdk, SdkInfo> sdkInfosBySdks;

    @NotNull
    public final List<IdeaModuleInfo> forPlatform(@NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        ConcurrentMap $this$getOrPut$iv = this.resultByPlatform;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(platform);
        if (object == null) {
            boolean bl = false;
            List list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ModuleInfosFromIdeaModelKt.access$mergePlatformModules(this.moduleSourceInfos, platform), (Iterable)this.libraryInfos), (Iterable)this.sdkInfos);
            boolean bl2 = false;
            boolean bl3 = false;
            List default$iv = list;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(platform, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"resultByPlatform.getOrPu\u2026nfos + sdkInfos\n        }");
        return (List)object;
    }

    @NotNull
    public final List<IdeaModuleInfo> allModules() {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.moduleSourceInfos, (Iterable)this.libraryInfos), (Iterable)this.sdkInfos);
    }

    @NotNull
    public final Collection<ModuleSourceInfo> getModuleInfosForModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection collection = this.moduleSourceInfosByModules.get((Object)module);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"moduleSourceInfosByModules[module]");
        return collection;
    }

    @NotNull
    public final Collection<LibraryInfo> getLibraryInfosForLibrary(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Collection collection = this.libraryInfosByLibraries.get((Object)library);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"libraryInfosByLibraries[library]");
        return collection;
    }

    @Nullable
    public final SdkInfo getSdkInfoForSdk(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return this.sdkInfosBySdks.get(sdk);
    }

    public IdeaModelInfosCache(@NotNull MultiMap<Module, ModuleSourceInfo> moduleSourceInfosByModules, @NotNull MultiMap<Library, LibraryInfo> libraryInfosByLibraries, @NotNull Map<Sdk, SdkInfo> sdkInfosBySdks) {
        Intrinsics.checkNotNullParameter(moduleSourceInfosByModules, (String)"moduleSourceInfosByModules");
        Intrinsics.checkNotNullParameter(libraryInfosByLibraries, (String)"libraryInfosByLibraries");
        Intrinsics.checkNotNullParameter(sdkInfosBySdks, (String)"sdkInfosBySdks");
        this.moduleSourceInfosByModules = moduleSourceInfosByModules;
        this.libraryInfosByLibraries = libraryInfosByLibraries;
        this.sdkInfosBySdks = sdkInfosBySdks;
        this.resultByPlatform = new ConcurrentHashMap();
        Collection collection = this.moduleSourceInfosByModules.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"moduleSourceInfosByModules.values()");
        this.moduleSourceInfos = CollectionsKt.toList((Iterable)collection);
        Collection collection2 = this.libraryInfosByLibraries.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"libraryInfosByLibraries.values()");
        this.libraryInfos = CollectionsKt.toList((Iterable)collection2);
        this.sdkInfos = CollectionsKt.toList((Iterable)this.sdkInfosBySdks.values());
    }
}

