/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.GetSourceModuleDependenciesKt;
import org.jetbrains.kotlin.idea.caches.project.HmppSourceModuleDependencyFilter;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.NonHmppSourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceModuleDependenciesFilter;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\f2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"orderEntryToModuleInfo", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "forProduction", "", "acceptAsDependency", "filterSourceModuleDependencies", "", "Lcom/intellij/openapi/module/Module;", "debugString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "dependencies", "getSourceModuleDependencies", "resolveDependenciesFromOrderEntries", "kotlin.core"})
public final class GetSourceModuleDependenciesKt {
    @NotNull
    public static final List<IdeaModuleInfo> getSourceModuleDependencies(@NotNull Module $this$getSourceModuleDependencies, boolean forProduction, @NotNull TargetPlatform platform) {
        StringBuilder stringBuilder;
        StringBuilder debugString;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceModuleDependencies, (String)"$this$getSourceModuleDependencies");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        StringBuilder stringBuilder2 = debugString = IdeaModuleInfosKt.getLOG().isDebugEnabled() ? new StringBuilder() : null;
        if (stringBuilder2 != null) {
            StringBuilder stringBuilder3 = stringBuilder2;
            String string = "Building idea model dependencies for module " + $this$getSourceModuleDependencies + ", platform=" + platform + ", forProduction=" + forProduction;
            boolean bl = false;
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl2 = false;
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            stringBuilder = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        Set<IdeaModuleInfo> allIdeaModuleInfoDependencies = GetSourceModuleDependenciesKt.resolveDependenciesFromOrderEntries($this$getSourceModuleDependencies, debugString, forProduction);
        Set<IdeaModuleInfo> supportedModuleInfoDependencies = GetSourceModuleDependenciesKt.filterSourceModuleDependencies($this$getSourceModuleDependencies, debugString, platform, allIdeaModuleInfoDependencies);
        StringBuilder stringBuilder7 = debugString;
        IdeaModuleInfosKt.getLOG().debug(stringBuilder7 != null ? stringBuilder7.toString() : null);
        return CollectionsKt.toList((Iterable)supportedModuleInfoDependencies);
    }

    private static final Set<IdeaModuleInfo> resolveDependenciesFromOrderEntries(Module $this$resolveDependenciesFromOrderEntries, StringBuilder debugString, boolean forProduction) {
        StringBuilder stringBuilder;
        LinkedHashSet result = new LinkedHashSet();
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)$this$resolveDependenciesFromOrderEntries).orderEntries().compileOnly().recursively().exportedOnly();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"ModuleRootManager.getIns\u2026ursively().exportedOnly()");
        OrderEnumerator dependencyEnumerator = orderEnumerator;
        if (forProduction && Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType($this$resolveDependenciesFromOrderEntries), (Object)BuildSystemType.JPS.INSTANCE)) {
            dependencyEnumerator.productionOnly();
        }
        StringBuilder stringBuilder2 = debugString;
        if (stringBuilder2 != null) {
            stringBuilder2.append("    IDEA dependencies: [");
        }
        dependencyEnumerator.forEach(new Processor($this$resolveDependenciesFromOrderEntries, debugString, forProduction, result){
            final /* synthetic */ Module $this_resolveDependenciesFromOrderEntries;
            final /* synthetic */ StringBuilder $debugString;
            final /* synthetic */ boolean $forProduction;
            final /* synthetic */ LinkedHashSet $result;

            public final boolean process(OrderEntry orderEntry) {
                block2: {
                    block1: {
                        StringBuilder stringBuilder = this.$debugString;
                        if (stringBuilder != null) {
                            StringBuilder stringBuilder2 = new StringBuilder();
                            OrderEntry orderEntry2 = orderEntry;
                            Intrinsics.checkNotNullExpressionValue((Object)orderEntry2, (String)"orderEntry");
                            stringBuilder.append(stringBuilder2.append(orderEntry2.getPresentableName()).append(' ').toString());
                        }
                        OrderEntry orderEntry3 = orderEntry;
                        Intrinsics.checkNotNullExpressionValue((Object)orderEntry3, (String)"orderEntry");
                        if (!GetSourceModuleDependenciesKt.access$acceptAsDependency(orderEntry3, this.$forProduction)) break block1;
                        Project project = this.$this_resolveDependenciesFromOrderEntries.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        this.$result.addAll(GetSourceModuleDependenciesKt.access$orderEntryToModuleInfo(project, orderEntry, this.$forProduction));
                        StringBuilder stringBuilder3 = this.$debugString;
                        if (stringBuilder3 == null) break block2;
                        stringBuilder3.append("OK; ");
                        break block2;
                    }
                    StringBuilder stringBuilder = this.$debugString;
                    if (stringBuilder == null) break block2;
                    stringBuilder.append("SKIP; ");
                }
                return true;
            }
            {
                this.$this_resolveDependenciesFromOrderEntries = module;
                this.$debugString = stringBuilder;
                this.$forProduction = bl;
                this.$result = linkedHashSet;
            }
        });
        StringBuilder stringBuilder3 = debugString;
        if (stringBuilder3 != null) {
            StringBuilder stringBuilder4 = stringBuilder3;
            String string = "]";
            boolean bl = false;
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder5;
            boolean bl2 = false;
            StringBuilder stringBuilder7 = stringBuilder6.append('\n');
            stringBuilder = stringBuilder7;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<IdeaModuleInfo> filterSourceModuleDependencies(Module $this$filterSourceModuleDependencies, StringBuilder debugString, TargetPlatform platform, Set<? extends IdeaModuleInfo> dependencies2) {
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        SourceModuleDependenciesFilter dependencyFilter = PlatformKt.isHMPPEnabled($this$filterSourceModuleDependencies) ? (SourceModuleDependenciesFilter)new HmppSourceModuleDependencyFilter(platform) : (SourceModuleDependenciesFilter)new NonHmppSourceModuleDependenciesFilter(platform);
        Iterable $this$filter$iv = dependencies2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdeaModuleInfo dependency = (IdeaModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!dependencyFilter.isSupportedDependency(dependency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set supportedDependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        StringBuilder stringBuilder2 = debugString;
        if (stringBuilder2 != null) {
            StringBuilder stringBuilder3 = stringBuilder2;
            Object object = filterSourceModuleDependencies.1.INSTANCE;
            iterable = null;
            int n = 0;
            CharSequence charSequence = ";";
            CharSequence charSequence2 = "]";
            CharSequence charSequence3 = "[";
            object = "    Corrected result (Supported dependencies): " + CollectionsKt.joinToString$default((Iterable)supportedDependencies, (CharSequence)charSequence, (CharSequence)charSequence3, (CharSequence)charSequence2, (int)n, (CharSequence)((Object)iterable), (Function1)object, (int)24, null);
            boolean bl = false;
            StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl2 = false;
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            stringBuilder = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        return supportedDependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean acceptAsDependency(OrderEntry $this$acceptAsDependency, boolean forProduction) {
        if (!($this$acceptAsDependency instanceof ExportableOrderEntry)) return true;
        if (!forProduction) return true;
        if ($this$acceptAsDependency instanceof ModuleOrderEntry) {
            if (((ModuleOrderEntry)$this$acceptAsDependency).isProductionOnTestDependency()) return true;
        }
        DependencyScope dependencyScope = ((ExportableOrderEntry)$this$acceptAsDependency).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyScope, (String)"scope");
        if (!dependencyScope.isForProductionCompile()) return false;
        return true;
    }

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean forProduction) {
        List<Object> list;
        Function1<Module, List<? extends ModuleSourceInfo>> $fun$toInfos$1 = new Function1<Module, List<? extends ModuleSourceInfo>>(forProduction){
            final /* synthetic */ boolean $forProduction;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $this$toInfos) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$toInfos, (String)"$this$toInfos");
                Iterable $this$filter$iv = IdeaModuleInfosKt.correspondingModuleInfos($this$toInfos);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.$forProduction || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$forProduction = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            Module module = orderEntry.getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orderEntry.getOwnerModule()");
            list = $fun$toInfos$1.invoke(module);
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orderEntry.module ?: return emptyList()");
            Module module2 = module;
            list = forProduction && ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency() ? CollectionsKt.listOfNotNull((Object)IdeaModuleInfosKt.testSourceInfo(module2)) : $fun$toInfos$1.invoke(module2);
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)library, (String)"orderEntry.library ?: return listOf()");
            Library library2 = library;
            list = IdeaModuleInfosKt.createLibraryInfo(project, library2);
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"orderEntry.jdk ?: return listOf()");
            Sdk sdk2 = sdk;
            list = CollectionsKt.listOfNotNull((Object)new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list;
    }

    public static final /* synthetic */ boolean access$acceptAsDependency(OrderEntry $this$access_u24acceptAsDependency, boolean forProduction) {
        return GetSourceModuleDependenciesKt.acceptAsDependency($this$access_u24acceptAsDependency, forProduction);
    }

    public static final /* synthetic */ List access$orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean forProduction) {
        return GetSourceModuleDependenciesKt.orderEntryToModuleInfo(project, orderEntry, forProduction);
    }
}

