/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.endpoints.EndpointsDocumentationProvider;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.presentation.EndpointMethodPresentation;
import com.intellij.microservices.ui.flat.EndpointsListItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u00042\u00020\u0005BC\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0006\u0010\r\u001a\u00028\u0001\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u00108\u001a\u0004\u0018\u000109J\u0012\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020&H\u0016JO\u0010<\u001a\u0004\u0018\u00010=\"\b\b\u0002\u0010\u0001*\u00020\u0002\"\b\b\u0003\u0010\u0003*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030>2\u0006\u0010\f\u001a\u0002H\u00012\u0006\u0010\r\u001a\u0002H\u00032\u0006\u0010?\u001a\u00020@H\u0002\u00a2\u0006\u0002\u0010AJ\u0010\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010?\u001a\u00020@R\u0013\u0010\r\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\f\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u001c\u0010\u0012R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010)\u001a\u0004\u0018\u00010&\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u0015\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\n\n\u0002\u0010/\u001a\u0004\b-\u0010.R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010(R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"Lcom/intellij/microservices/ui/flat/FlatEndpointItem;", "G", "", "E", "Lcom/intellij/microservices/ui/flat/EndpointsListItem;", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "provider", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "group", "endpoint", "presentation", "Lcom/intellij/navigation/ItemPresentation;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/navigation/ItemPresentation;)V", "getEndpoint", "()Ljava/lang/Object;", "Ljava/lang/Object;", "fileBgColor", "Ljava/awt/Color;", "getFileBgColor", "()Ljava/awt/Color;", "frameworkPresentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getFrameworkPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getGroup", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "isValid", "locationString", "", "getLocationString", "()Ljava/lang/String;", "method", "getMethod", "methodOrder", "", "getMethodOrder", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getModule", "()Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "presentableText", "getPresentableText", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProvider", "()Lcom/intellij/microservices/endpoints/EndpointsProvider;", "getContainingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "dataId", "getEndpointDocumentation", "Ljavax/swing/JComponent;", "Lcom/intellij/microservices/endpoints/EndpointsDocumentationProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/microservices/endpoints/EndpointsDocumentationProvider;Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)Ljavax/swing/JComponent;", "intellij.microservices.ui"})
public final class FlatEndpointItem<G, E>
extends EndpointsListItem
implements DataContext {
    @Nullable
    private final String method;
    @Nullable
    private final Integer methodOrder;
    @NotNull
    private final String presentableText;
    @NotNull
    private final String locationString;
    @Nullable
    private final Icon icon;
    private final boolean isDeprecated;
    @Nullable
    private final Color fileBgColor;
    @NotNull
    private final Project project;
    @Nullable
    private final EndpointsModuleEntity module;
    @NotNull
    private final EndpointsProvider<G, E> provider;
    @NotNull
    private final G group;
    @NotNull
    private final E endpoint;

    public final boolean isValid() {
        return this.provider.isValidEndpoint(this.group, this.endpoint);
    }

    @NotNull
    public final FrameworkPresentation getFrameworkPresentation() {
        return this.provider.getPresentation();
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final Integer getMethodOrder() {
        return this.methodOrder;
    }

    @NotNull
    public final String getPresentableText() {
        return this.presentableText;
    }

    @NotNull
    public final String getLocationString() {
        return this.locationString;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Nullable
    public final Color getFileBgColor() {
        return this.fileBgColor;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (!this.isValid()) {
            return null;
        }
        return this.provider.getEndpointData(this.group, this.endpoint, dataId);
    }

    @Nullable
    public final JComponent getEndpointDocumentation(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (this.provider instanceof EndpointsDocumentationProvider) {
            return this.getEndpointDocumentation((EndpointsDocumentationProvider)this.provider, this.group, this.endpoint, parentDisposable);
        }
        PsiElement psiElement = (PsiElement)this.getData(EndpointsProvider.DOCUMENTATION_ELEMENT);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getData(EndpointsProvide\u2026N_ELEMENT) ?: return null");
        PsiElement psiElement2 = psiElement;
        return (JComponent)DocumentationComponent.createAndFetch((Project)psiElement2.getProject(), (PsiElement)psiElement2, (Disposable)parentDisposable);
    }

    private final <G, E> JComponent getEndpointDocumentation(EndpointsDocumentationProvider<G, E> provider, G group, E endpoint, Disposable parentDisposable) {
        return provider.getEndpointDocumentation(group, endpoint, parentDisposable);
    }

    @Nullable
    public final VirtualFile getContainingFile() {
        if (!this.isValid()) {
            return null;
        }
        return (VirtualFile)this.getData(CommonDataKeys.VIRTUAL_FILE);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final EndpointsModuleEntity getModule() {
        return this.module;
    }

    @NotNull
    public final EndpointsProvider<G, E> getProvider() {
        return this.provider;
    }

    @NotNull
    public final G getGroup() {
        return this.group;
    }

    @NotNull
    public final E getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - void declaration
     */
    public FlatEndpointItem(@NotNull Project project, @Nullable EndpointsModuleEntity module, @NotNull EndpointsProvider<G, E> provider, @NotNull G group, @NotNull E endpoint, @NotNull ItemPresentation presentation) {
        Color color;
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super(null);
        this.project = project;
        this.module = module;
        this.provider = provider;
        this.group = group;
        this.endpoint = endpoint;
        ItemPresentation itemPresentation = presentation;
        if (!(itemPresentation instanceof EndpointMethodPresentation)) {
            itemPresentation = null;
        }
        EndpointMethodPresentation endpointMethodPresentation = (EndpointMethodPresentation)itemPresentation;
        this.method = endpointMethodPresentation != null ? endpointMethodPresentation.getEndpointMethod() : null;
        ItemPresentation itemPresentation2 = presentation;
        if (!(itemPresentation2 instanceof EndpointMethodPresentation)) {
            itemPresentation2 = null;
        }
        EndpointMethodPresentation endpointMethodPresentation2 = (EndpointMethodPresentation)itemPresentation2;
        this.methodOrder = endpointMethodPresentation2 != null ? Integer.valueOf(endpointMethodPresentation2.getEndpointMethodOrder()) : null;
        String string2 = presentation.getPresentableText();
        if (string2 == null) {
            string2 = this.presentableText = " ";
        }
        if ((string = presentation.getLocationString()) == null) {
            string = "";
        }
        this.locationString = string;
        this.icon = presentation.getIcon(false);
        ItemPresentation $this$castSafelyTo$iv = presentation;
        boolean $i$f$castSafelyTo = false;
        ItemPresentation itemPresentation3 = $this$castSafelyTo$iv;
        if (!(itemPresentation3 instanceof PresentationData)) {
            itemPresentation3 = null;
        }
        PresentationData presentationData = (PresentationData)itemPresentation3;
        TextAttributesKey textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
        this.isDeprecated = Intrinsics.areEqual((Object)(presentationData != null ? presentationData.getTextAttributesKey() : null), (Object)(textAttributesKey != null ? (Comparable)textAttributesKey : (Comparable)Boolean.valueOf(false)));
        FlatEndpointItem flatEndpointItem = this;
        VirtualFile virtualFile = this.getContainingFile();
        if (virtualFile != null) {
            void it;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile virtualFile3 = virtualFile2;
            FlatEndpointItem flatEndpointItem2 = flatEndpointItem;
            boolean bl3 = false;
            Color color2 = VfsPresentationUtil.getFileBackgroundColor((Project)this.project, (VirtualFile)it);
            flatEndpointItem = flatEndpointItem2;
            color = color2;
        } else {
            color = null;
        }
        flatEndpointItem.fileBgColor = color;
    }
}

