/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.ProjectTopics;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.microservices.endpoints.EndpointsViewOpener;
import com.intellij.microservices.ui.EndpointsViewSettings;
import com.intellij.microservices.ui.MicroservicesUIIcons;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.EndpointsView;
import com.intellij.microservices.ui.flat.EndpointsViewManager;
import com.intellij.microservices.ui.flat.EndpointsViewManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsViewManager;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "checkToolWindowStatus", "", "project", "Lcom/intellij/openapi/project/Project;", "refreshStructure", "", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindowState", "Lcom/intellij/microservices/ui/flat/EndpointsViewManager$ToolWindowState;", "registerToolWindow", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "runActivity", "updateToolWindowState", "state", "refreshData", "Companion", "EndpointsToolWindowFactory", "ToolWindowState", "intellij.microservices.ui"})
public final class EndpointsViewManager
implements StartupActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project) {
        Application app;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        if (EndpointsProvider.Companion.hasAnyProviders()) {
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            if (toolWindowManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
            }
            ToolWindowManagerEx toolWindowManager2 = (ToolWindowManagerEx)toolWindowManager;
            ToolWindow toolWindow = this.registerToolWindow((ToolWindowManager)toolWindowManager2);
            WindowInfoImpl windowInfo = toolWindowManager2.getLayout().getInfo("Endpoints");
            if (windowInfo == null || !windowInfo.isFromPersistentSettings()) {
                toolWindow.setShowStripeButton(false);
                EndpointsViewManager.checkToolWindowStatus$default(this, project, false, 2, null);
            }
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(this, project){
            final /* synthetic */ EndpointsViewManager this$0;
            final /* synthetic */ Project $project;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EndpointsViewManager.checkToolWindowStatus$default(this.this$0, this.$project, false, 2, null);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        });
        EndpointsProvider.EP_NAME.addChangeListener(new Runnable(this, project){
            final /* synthetic */ EndpointsViewManager this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                MessageBus messageBus = application.getMessageBus();
                Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
                MessageBus messageBus2 = messageBus;
                ((EndpointsViewListener)messageBus2.syncPublisher(EndpointsViewListener.Companion.getTOPIC())).endpointsChanged(new EndpointsViewListener.ChangeEvent(this.$project, EndpointsViewListener.ChangeType.FLUSH));
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ runActivity.2 this$0;

                    public final void run() {
                        EndpointsViewManager.access$checkToolWindowStatus(this.this$0.this$0, this.this$0.$project, true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, ModalityState.NON_MODAL, this.$project.getDisposed());
            }
            {
                this.this$0 = endpointsViewManager;
                this.$project = project;
            }
        }, (Disposable)EndpointsViewSettings.Companion.getInstance(project));
        messageBusConnection2.subscribe(EndpointsViewOpener.Companion.getTOPIC(), (Object)new EndpointsViewOpener(this, project){
            final /* synthetic */ EndpointsViewManager this$0;
            final /* synthetic */ Project $project;

            public void showEndpoints(@Nullable String filter) {
                block0: {
                    ToolWindow toolWindow = EndpointsViewManager.access$getToolWindow(this.this$0, this.$project);
                    if (toolWindow == null) break block0;
                    toolWindow.show(new Runnable(this, filter){
                        final /* synthetic */ runActivity.3 this$0;
                        final /* synthetic */ String $filter;

                        public final void run() {
                            block1: {
                                EndpointsView endpointsView = EndpointsViewManager.Companion.getActiveView(this.this$0.$project);
                                if (endpointsView == null) break block1;
                                String string = this.$filter;
                                if (string == null) {
                                    string = "";
                                }
                                endpointsView.showEndpoints(string);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$filter = string;
                        }
                    });
                }
            }

            public void showEndpoints(@Nullable String module, @Nullable String framework, @Nullable String filter) {
                block0: {
                    ToolWindow toolWindow = EndpointsViewManager.access$getToolWindow(this.this$0, this.$project);
                    if (toolWindow == null) break block0;
                    toolWindow.show(new Runnable(this, module, framework, filter){
                        final /* synthetic */ runActivity.3 this$0;
                        final /* synthetic */ String $module;
                        final /* synthetic */ String $framework;
                        final /* synthetic */ String $filter;

                        public final void run() {
                            block0: {
                                EndpointsView endpointsView = EndpointsViewManager.Companion.getActiveView(this.this$0.$project);
                                if (endpointsView == null) break block0;
                                endpointsView.showEndpoints(this.$module, this.$framework, this.$filter);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$module = string;
                            this.$framework = string2;
                            this.$filter = string3;
                        }
                    });
                }
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    private final ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.Companion.getInstance(project).getToolWindow("Endpoints");
    }

    private final void checkToolWindowStatus(Project project, boolean refreshStructure) {
        ReadAction.nonBlocking((Callable)new Callable(this, project){
            final /* synthetic */ EndpointsViewManager this$0;
            final /* synthetic */ Project $project;

            @Nullable
            public final ToolWindowState call() {
                return EndpointsViewManager.access$getToolWindowState(this.this$0, this.$project);
            }
            {
                this.this$0 = endpointsViewManager;
                this.$project = project;
            }
        }).finishOnUiThread(ModalityState.any(), new Consumer(this, project, refreshStructure){
            final /* synthetic */ EndpointsViewManager this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $refreshStructure;

            public final void accept(@Nullable ToolWindowState state) {
                if (state != null) {
                    EndpointsViewManager.access$updateToolWindowState(this.this$0, this.$project, state, this.$refreshStructure);
                }
            }
            {
                this.this$0 = endpointsViewManager;
                this.$project = project;
                this.$refreshStructure = bl;
            }
        }).coalesceBy(new Object[]{this, project}).inSmartMode(project).submit((Executor)NonUrgentExecutor.getInstance());
    }

    static /* synthetic */ void checkToolWindowStatus$default(EndpointsViewManager endpointsViewManager, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        endpointsViewManager.checkToolWindowStatus(project, bl);
    }

    private final void updateToolWindowState(Project project, ToolWindowState state, boolean refreshData) {
        block4: {
            ToolWindow toolWindow;
            block3: {
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                toolWindow = toolWindowManager.getToolWindow("Endpoints");
                if (!state.getAvailable()) break block3;
                if (toolWindow == null) {
                    toolWindow = this.registerToolWindow(toolWindowManager);
                }
                ToolWindowManager toolWindowManager2 = toolWindowManager;
                if (toolWindowManager2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
                }
                WindowInfoImpl windowInfo = ((ToolWindowManagerEx)toolWindowManager2).getLayout().getInfo("Endpoints");
                if (windowInfo == null || !windowInfo.isFromPersistentSettings()) {
                    toolWindow.setAvailable(true);
                    toolWindow.setShowStripeButton(state.getHasEndpoints());
                }
                if (!refreshData) break block4;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                MessageBus messageBus = application.getMessageBus();
                Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
                MessageBus messageBus2 = messageBus;
                ((EndpointsViewListener)messageBus2.syncPublisher(EndpointsViewListener.Companion.getTOPIC())).endpointsChanged(new EndpointsViewListener.ChangeEvent(project, EndpointsViewListener.ChangeType.ITEMS));
                break block4;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2 == null) break block4;
            toolWindow2.remove();
        }
    }

    private final ToolWindow registerToolWindow(ToolWindowManager toolWindowManager) {
        boolean bl = false;
        ToolWindowFactory toolWindowFactory = new EndpointsToolWindowFactory();
        Icon icon = MicroservicesUIIcons.ToolWindowEndpoints;
        boolean bl2 = false;
        Supplier<String> supplier = MicroservicesUiBundle.messagePointer("endpoints.tool.window.title", new Object[0]);
        return toolWindowManager.registerToolWindow(new RegisterToolWindowTask("Endpoints", null, null, false, false, bl, bl2, toolWindowFactory, icon, supplier, 94, null));
    }

    private final ToolWindowState getToolWindowState(Project project) {
        boolean bl;
        block11: {
            if (project.isDisposed()) {
                return null;
            }
            boolean bl2 = false;
            List availableProviders = new ArrayList();
            for (EndpointsProvider provider : EndpointsProvider.Companion.getAllProviders()) {
                EndpointsProvider.Status providerState = provider.getStatus(project);
                if (providerState == EndpointsProvider.Status.HAS_ENDPOINTS) {
                    return new ToolWindowState(true, true);
                }
                if (providerState != EndpointsProvider.Status.AVAILABLE) continue;
                availableProviders.add(provider);
            }
            if (availableProviders.isEmpty()) {
                return new ToolWindowState(EndpointsProvider.Companion.hasAnyProviders(), false);
            }
            EndpointsProjectModel model = EndpointsViewManagerKt.getEndpointsProjectModel();
            Collection modules = model.getModuleEntities(project);
            Iterable $this$any$iv = modules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block10: {
                        EndpointsModuleEntity module = (EndpointsModuleEntity)element$iv;
                        boolean bl4 = false;
                        EndpointsFilter filter = model.createFilter(module, false, true);
                        Iterable $this$any$iv2 = availableProviders;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                EndpointsProvider it = (EndpointsProvider)element$iv2;
                                boolean bl5 = false;
                                if (!CollectionsKt.any((Iterable)it.getEndpointGroups(project, filter))) continue;
                                bl3 = true;
                                break block10;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean hasEndpoints = bl;
        return new ToolWindowState(true, hasEndpoints);
    }

    public static final /* synthetic */ void access$checkToolWindowStatus(EndpointsViewManager $this, Project project, boolean refreshStructure) {
        $this.checkToolWindowStatus(project, refreshStructure);
    }

    public static final /* synthetic */ ToolWindow access$getToolWindow(EndpointsViewManager $this, Project project) {
        return $this.getToolWindow(project);
    }

    public static final /* synthetic */ ToolWindowState access$getToolWindowState(EndpointsViewManager $this, Project project) {
        return $this.getToolWindowState(project);
    }

    public static final /* synthetic */ void access$updateToolWindowState(EndpointsViewManager $this, Project project, ToolWindowState state, boolean refreshData) {
        $this.updateToolWindowState(project, state, refreshData);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsViewManager$ToolWindowState;", "", "available", "", "hasEndpoints", "(ZZ)V", "getAvailable", "()Z", "getHasEndpoints", "intellij.microservices.ui"})
    private static final class ToolWindowState {
        private final boolean available;
        private final boolean hasEndpoints;

        public final boolean getAvailable() {
            return this.available;
        }

        public final boolean getHasEndpoints() {
            return this.hasEndpoints;
        }

        public ToolWindowState(boolean available, boolean hasEndpoints) {
            this.available = available;
            this.hasEndpoints = hasEndpoints;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsViewManager$EndpointsToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "intellij.microservices.ui"})
    private static final class EndpointsToolWindowFactory
    implements ToolWindowFactory {
        public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            toolWindow.setToHideOnEmptyContent(true);
            toolWindow.setTitle(MicroservicesUiBundle.message("endpoints.tool.window.title", new Object[0]));
            toolWindow.setHelpId("endpoints.tool.window");
            EndpointsProjectModel model = EndpointsViewManagerKt.getEndpointsProjectModel();
            EndpointsView view = new EndpointsView(project, model, toolWindow);
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
            ContentManager contentManager2 = contentManager;
            Content content = contentManager2.getFactory().createContent(view.getComponent(), null, false);
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"contentManager.factory.c\u2026w.component, null, false)");
            Content content2 = content;
            content2.setCloseable(false);
            contentManager2.addContent(content2);
            contentManager2.setSelectedContent(content2, true);
            DumbService.getInstance((Project)project).runWhenSmart(new Runnable(view){
                final /* synthetic */ EndpointsView $view;

                public final void run() {
                    this.$view.setup();
                }
                {
                    this.$view = endpointsView;
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsViewManager$Companion;", "", "()V", "getActiveView", "Lcom/intellij/microservices/ui/flat/EndpointsView;", "project", "Lcom/intellij/openapi/project/Project;", "getAvailableTypes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/endpoints/EndpointType;", "isToolWindowAvailable", "", "intellij.microservices.ui"})
    public static final class Companion {
        public final boolean isToolWindowAvailable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            return toolWindowManager.getToolWindow("Endpoints") != null;
        }

        @Nullable
        public final EndpointsView getActiveView(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Endpoints");
            if (toolWindow == null) {
                return null;
            }
            ToolWindow toolWindow2 = toolWindow;
            if (!toolWindow2.isAvailable() || !toolWindow2.isVisible()) {
                return null;
            }
            Content content = toolWindow2.getContentManager().getContent(0);
            JComponent jComponent = content != null ? content.getComponent() : null;
            if (!(jComponent instanceof EndpointsView)) {
                jComponent = null;
            }
            return (EndpointsView)((Object)jComponent);
        }

        @NotNull
        public final Sequence<EndpointType> getAvailableTypes(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SequencesKt.distinctBy((Sequence)SequencesKt.map((Sequence)EndpointsProvider.Companion.getAvailableProviders(project), (Function1)getAvailableTypes.1.INSTANCE), (Function1)getAvailableTypes.2.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

