/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.ProjectTopics;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsChangeTracker;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsSidePanel;
import com.intellij.microservices.endpoints.EndpointsSidePanelProvider;
import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.microservices.ui.EndpointsViewSettings;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.EndpointsCursor;
import com.intellij.microservices.ui.flat.EndpointsCursorKt;
import com.intellij.microservices.ui.flat.EndpointsFilterField;
import com.intellij.microservices.ui.flat.EndpointsList;
import com.intellij.microservices.ui.flat.EndpointsListItem;
import com.intellij.microservices.ui.flat.EndpointsListRenderer;
import com.intellij.microservices.ui.flat.EndpointsSearchPopupController;
import com.intellij.microservices.ui.flat.EndpointsSearchQueryParser;
import com.intellij.microservices.ui.flat.EndpointsSearchTextField;
import com.intellij.microservices.ui.flat.EndpointsView;
import com.intellij.microservices.ui.flat.EndpointsView$WhenMappings;
import com.intellij.microservices.ui.flat.EndpointsViewManager;
import com.intellij.microservices.ui.flat.FlatEndpointItem;
import com.intellij.microservices.ui.flat.ModuleItem;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.utils.MicroservicesUsagesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 l2\u00020\u00012\u00020\u0002:\u0006lmnopqB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000f2\u0014\u00105\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003060&H\u0002J\u001e\u00107\u001a\u0002032\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090;H\u0002J>\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u00108\u001a\u0002092\b\b\u0001\u0010@\u001a\u0002092\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0&2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002090;H\u0002J\b\u0010D\u001a\u000203H\u0016J4\u0010E\u001a\u0002032\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0&2\u0006\u00108\u001a\u0002092\f\u0010C\u001a\b\u0012\u0004\u0012\u0002090;2\u0006\u0010F\u001a\u00020=H\u0002J\b\u0010G\u001a\u000203H\u0002J\b\u0010H\u001a\u000203H\u0002J\b\u0010I\u001a\u000203H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u000209H\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010K2\u0006\u0010N\u001a\u00020\u0014H\u0002J\b\u0010O\u001a\u000203H\u0002J\b\u0010P\u001a\u000203H\u0002J\b\u0010Q\u001a\u000203H\u0002J\b\u0010R\u001a\u000203H\u0002J\u0014\u0010S\u001a\u0002032\n\u0010T\u001a\u0006\u0012\u0002\b\u00030UH\u0002J\u0010\u0010V\u001a\u0002032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010W\u001a\u0002032\u0006\u0010X\u001a\u00020YH\u0002J\b\u0010Z\u001a\u000203H\u0002J\u0010\u0010[\u001a\u0002032\u0006\u00104\u001a\u00020\u000fH\u0002J\b\u0010\\\u001a\u000201H\u0002J\b\u0010]\u001a\u000203H\u0002J\b\u0010^\u001a\u000203H\u0002J\b\u0010_\u001a\u000203H\u0002J\b\u0010`\u001a\u000203H\u0002J\u0006\u0010a\u001a\u000203J\u000e\u0010b\u001a\u0002032\u0006\u0010c\u001a\u00020dJ\u0010\u0010b\u001a\u0002032\b\b\u0001\u0010e\u001a\u000209J$\u0010b\u001a\u0002032\b\u0010c\u001a\u0004\u0018\u0001092\b\u0010f\u001a\u0004\u0018\u0001092\b\u0010g\u001a\u0004\u0018\u000109J\b\u0010h\u001a\u000203H\u0002J\b\u0010i\u001a\u000203H\u0002J\b\u0010j\u001a\u000203H\u0002J\b\u0010k\u001a\u000203H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsProjectModel;Lcom/intellij/openapi/wm/ToolWindow;)V", "docSidePanel", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "docSidePanelContent", "Ljavax/swing/JComponent;", "endpointsCursor", "Lcom/intellij/microservices/ui/flat/EndpointsCursor;", "endpointsList", "Lcom/intellij/microservices/ui/flat/EndpointsList;", "endpointsModel", "Ljavax/swing/DefaultListModel;", "Lcom/intellij/microservices/ui/flat/EndpointsListItem;", "endpointsModificationCount", "", "filtersPanel", "Ljavax/swing/JPanel;", "psiChangeUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "searchPopupController", "Lcom/intellij/microservices/ui/flat/EndpointsSearchPopupController;", "searchTextField", "Lcom/intellij/microservices/ui/flat/EndpointsSearchTextField;", "searchUpdateAlarm", "Lcom/intellij/util/Alarm;", "sidePanelDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "sidePanels", "", "Lcom/intellij/microservices/endpoints/EndpointsSidePanel;", "sidePanelsActivatedState", "", "splitter", "Lcom/intellij/ui/JBSplitter;", "tabbedPaneWrapper", "Lcom/intellij/ui/tabs/impl/SingleHeightTabs;", "trackingChangesCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "updateOnShow", "", "appendToList", "", "cursor", "data", "Lcom/intellij/microservices/ui/flat/FlatEndpointItem;", "applyFilter", "attribute", "", "values", "", "createFilterActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "filterField", "Ljava/awt/Component;", "title", "items", "Lcom/intellij/microservices/ui/flat/EndpointsView$FilterItem;", "selectedItems", "dispose", "fillFilterItems", "group", "forgetData", "forgetDocumentation", "forgetSelection", "getData", "", "dataId", "getTarget", "it", "initContent", "initFilters", "initGlobalListeners", "initSidePanelTabs", "installEditOnDoubleClick", "list", "Lcom/intellij/ui/components/JBList;", "installListActions", "load", "context", "Lcom/intellij/microservices/ui/flat/EndpointsView$LoadContext;", "loadInitial", "loadNext", "performEditAction", "requestInitialLoad", "setListRenderer", "setSidePanelVisibility", "setSplitOrientation", "setup", "showEndpoints", "module", "Lcom/intellij/openapi/module/Module;", "searchedValue", "framework", "filter", "showSearchPopup", "updateContributedSidePanels", "updateItemsOnChange", "updateSidePanel", "Companion", "FilterAllAction", "FilterItem", "FilterMultiSelectAction", "FilterValueAction", "LoadContext", "intellij.microservices.ui"})
public final class EndpointsView
extends SimpleToolWindowPanel
implements Disposable {
    private final EndpointsList endpointsList;
    private final DefaultListModel<EndpointsListItem> endpointsModel;
    private final Alarm searchUpdateAlarm;
    private final MergingUpdateQueue psiChangeUpdateQueue;
    private final EndpointsSearchTextField searchTextField;
    private final EndpointsSearchPopupController searchPopupController;
    private final JBSplitter splitter;
    private final SingleHeightTabs tabbedPaneWrapper;
    private final JBPanelWithEmptyText docSidePanel;
    private JComponent docSidePanelContent;
    private final JPanel filtersPanel;
    private final JBScrollPane scrollPane;
    private final DataContext sidePanelDataContext;
    private List<? extends EndpointsSidePanel> sidePanels;
    private final Set<EndpointsSidePanel> sidePanelsActivatedState;
    private volatile EndpointsCursor endpointsCursor;
    private volatile long endpointsModificationCount;
    private volatile boolean updateOnShow;
    private final AtomicInteger trackingChangesCounter;
    private final Project project;
    private final EndpointsProjectModel model;
    private final ToolWindow toolWindow;
    private static final Logger LOG;
    @NotNull
    public static final String TOOLWINDOW_ID = "Endpoints";
    private static final int FETCH_PAGE_SIZE = 50;
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    private static final ExtensionPointName<EndpointsSidePanelProvider> SIDE_PANEL_EP_NAME;
    @NotNull
    public static final Companion Companion;

    private final void initContent() {
        AnAction anAction = ActionManager.getInstance().getAction("EndpointsActions.Title");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup titleActionsGroup = (ActionGroup)anAction;
        Object[] objectArray = titleActionsGroup.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"titleActionsGroup.getChildren(null)");
        this.toolWindow.setTitleActions(ArraysKt.toList((Object[])objectArray));
        AnAction anAction2 = ActionManager.getInstance().getAction("EndpointsActions.FilterToolbar");
        if (anAction2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EndpointsFilterToolbar", (ActionGroup)anAction2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026r\") as ActionGroup, true)");
        ActionToolbar filterToolbar = actionToolbar;
        filterToolbar.setTargetComponent((JComponent)((Object)this));
        filterToolbar.setReservePlaceAutoPopupIcon(false);
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        boolean bl2 = false;
        BorderLayoutPanel $this$apply = borderLayoutPanel;
        boolean bl3 = false;
        $this$apply.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        $this$apply.withPreferredHeight(28);
        $this$apply.addToCenter((Component)this.filtersPanel);
        $this$apply.addToRight((Component)filterToolbar.getComponent());
        BorderLayoutPanel filtersWrapper = borderLayoutPanel;
        JPanel jPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        bl2 = false;
        boolean bl4 = false;
        JPanel $this$apply2 = jPanel;
        boolean bl5 = false;
        $this$apply2.add((Component)filtersWrapper);
        $this$apply2.add((Component)((Object)this.searchTextField));
        JPanel topPanel = jPanel;
        BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel();
        bl4 = false;
        boolean bl6 = false;
        BorderLayoutPanel $this$apply3 = borderLayoutPanel2;
        boolean bl7 = false;
        $this$apply3.addToTop((Component)topPanel);
        $this$apply3.addToCenter((Component)this.scrollPane);
        BorderLayoutPanel listWrapper = borderLayoutPanel2;
        this.splitter.setFirstComponent((JComponent)listWrapper);
        this.splitter.setSecondComponent(this.tabbedPaneWrapper.getComponent());
        this.setSidePanelVisibility();
        this.docSidePanel.setLayout((LayoutManager)new BorderLayout());
        StatusText statusText = this.docSidePanel.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"docSidePanel.emptyText");
        statusText.setText(MicroservicesUiBundle.message("endpoints.tab.documentation.empty.text", new Object[0]));
        this.setContent((JComponent)this.splitter);
    }

    /*
     * WARNING - void declaration
     */
    private final void initSidePanelTabs() {
        boolean bl;
        TabInfo it22;
        boolean bl2;
        TabInfo tabInfo = this.tabbedPaneWrapper.findInfo((Component)this.docSidePanel);
        if (tabInfo != null) {
            TabInfo tabInfo2 = tabInfo;
            boolean bl3 = false;
            bl2 = false;
            it22 = tabInfo2;
            bl = false;
            this.tabbedPaneWrapper.select(it22, false);
        }
        this.forgetDocumentation();
        for (EndpointsSidePanel endpointsSidePanel : this.sidePanels) {
            if (this.tabbedPaneWrapper.findInfo((Component)endpointsSidePanel.getComponent()) != null) {
                TabInfo tabInfo2;
                boolean it22 = false;
                bl = false;
                TabInfo it3 = tabInfo2;
                boolean bl4 = false;
                this.tabbedPaneWrapper.removeTab(it3);
            }
            if (!(endpointsSidePanel instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)endpointsSidePanel));
        }
        this.tabbedPaneWrapper.removeAllTabs();
        this.sidePanels = CollectionsKt.emptyList();
        this.sidePanelsActivatedState.clear();
        if (EndpointsViewSettings.Companion.getInstance(this.project).isShowSidePanel()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$apply;
            TabInfo tabInfo3 = new TabInfo((JComponent)this.docSidePanel);
            boolean bl4 = false;
            bl2 = false;
            it22 = tabInfo3;
            Object object = this.tabbedPaneWrapper;
            boolean bl6 = false;
            $this$apply.setText(MicroservicesUiBundle.message("endpoints.tab.documentation", new Object[0]));
            Object object2 = Unit.INSTANCE;
            object.addTab(tabInfo3);
            List list = SIDE_PANEL_EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"SIDE_PANEL_EP_NAME.extensionList");
            Iterable iterable = list;
            object = this;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EndpointsSidePanel endpointsSidePanel;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl7 = false;
                EndpointsSidePanelProvider it4 = (EndpointsSidePanelProvider)element$iv$iv;
                boolean bl8 = false;
                if (it4.create(this.project) == null) continue;
                boolean bl5 = false;
                boolean bl9 = false;
                EndpointsSidePanel it$iv$iv = endpointsSidePanel;
                boolean bl11 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object.sidePanels = object2 = (List)destination$iv$iv;
            for (EndpointsSidePanel endpointsSidePanel : this.sidePanels) {
                void $this$apply2;
                iterable2 = new TabInfo(endpointsSidePanel.getComponent());
                boolean bl10 = false;
                boolean bl11 = false;
                $this$forEach$iv$iv$iv = iterable2;
                object = this.tabbedPaneWrapper;
                boolean bl14 = false;
                $this$apply2.setText(endpointsSidePanel.getTitle());
                object2 = Unit.INSTANCE;
                object.addTab((TabInfo)iterable2);
                if (!(endpointsSidePanel instanceof Disposable)) continue;
                Disposer.register((Disposable)this, (Disposable)((Disposable)endpointsSidePanel));
            }
            this.updateContributedSidePanels();
        }
    }

    private final void initFilters() {
        this.filtersPanel.add(new EndpointsFilterField(this, this.model.getModuleDisplayName()){
            final /* synthetic */ EndpointsView this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected ActionGroup createActionGroup() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = EndpointsCursorKt.getModulesOrdered(EndpointsView.access$getModel$p(this.this$0), EndpointsView.access$getProject$p(this.this$0));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EndpointsModuleEntity endpointsModuleEntity = (EndpointsModuleEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    FilterItem filterItem = new FilterItem(it.getName(), it.getName());
                    collection.add(filterItem);
                }
                List modules = (List)destination$iv$iv;
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getModules()) == null) {
                    object = SetsKt.emptySet();
                }
                Set<String> selectedModules2 = object;
                String moduleAttribute = EndpointsCursorKt.getModuleAttribute(EndpointsView.access$getModel$p(this.this$0));
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)this.this$0.new FilterAllAction(moduleAttribute));
                group.add((AnAction)this.this$0.new FilterMultiSelectAction(moduleAttribute, EndpointsView.access$getModel$p(this.this$0).getSelectModulesTitle(), this, modules, (Collection<String>)selectedModules2));
                group.add((AnAction)this.this$0.new FilterValueAction(moduleAttribute, MicroservicesUiBundle.message("endpoints.filters.module.external", new Object[0]), "#external"));
                group.add((AnAction)new Separator());
                EndpointsView.access$fillFilterItems(this.this$0, modules, moduleAttribute, selectedModules2, group);
                return (ActionGroup)group;
            }

            @NotNull
            public String getCurrentText() {
                Set<String> modules;
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getModules()) == null) {
                    object = modules = SetsKt.emptySet();
                }
                if (modules.isEmpty()) {
                    return MicroservicesUiBundle.message("endpoints.filters.all", new Object[0]);
                }
                return com.intellij.microservices.ui.flat.EndpointsView$Companion.access$displayableFilterText(EndpointsView.Companion, modules);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
        this.filtersPanel.add(new EndpointsFilterField(this, MicroservicesUiBundle.message("endpoints.filters.type", new Object[0])){
            final /* synthetic */ EndpointsView this$0;

            @NotNull
            protected ActionGroup createActionGroup() {
                Sequence<EndpointType> $this$sortedBy$iv = EndpointsViewManager.Companion.getAvailableTypes(EndpointsView.access$getProject$p(this.this$0));
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                List types2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        EndpointType it = (EndpointType)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getQueryTag());
                        it = (EndpointType)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getQueryTag();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }), (Function1)initFilters.createActionGroup.types.2.INSTANCE));
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getTypes()) == null) {
                    object = SetsKt.emptySet();
                }
                Set<String> selectedTypes = object;
                return (ActionGroup)EndpointsView.access$createFilterActions(this.this$0, this, "type:", MicroservicesUiBundle.message("endpoints.filters.type.title", new Object[0]), types2, selectedTypes);
            }

            @NotNull
            public String getCurrentText() {
                Set<String> types2;
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getTypes()) == null) {
                    object = types2 = SetsKt.emptySet();
                }
                if (types2.isEmpty()) {
                    return MicroservicesUiBundle.message("endpoints.filters.all", new Object[0]);
                }
                return com.intellij.microservices.ui.flat.EndpointsView$Companion.access$displayableFilterText(EndpointsView.Companion, types2);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
        this.filtersPanel.add(new EndpointsFilterField(this, MicroservicesUiBundle.message("endpoints.filters.framework", new Object[0])){
            final /* synthetic */ EndpointsView this$0;

            @NotNull
            protected ActionGroup createActionGroup() {
                Sequence $this$sortedBy$iv = SequencesKt.map((Sequence)EndpointsProvider.Companion.getAvailableProviders(EndpointsView.access$getProject$p(this.this$0)), (Function1)initFilters.createActionGroup.providers.1.INSTANCE);
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                List providers2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        FilterItem it = (FilterItem)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getTitle());
                        it = (FilterItem)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getTitle();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }));
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getFrameworks()) == null) {
                    object = SetsKt.emptySet();
                }
                Set<String> selectedFrameworks = object;
                return (ActionGroup)EndpointsView.access$createFilterActions(this.this$0, this, "framework:", MicroservicesUiBundle.message("endpoints.filters.framework.title", new Object[0]), providers2, selectedFrameworks);
            }

            @NotNull
            public String getCurrentText() {
                Set<String> frameworks;
                Object object = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (object == null || (object = ((EndpointsCursor)object).getQueryParser()) == null || (object = ((EndpointsSearchQueryParser)object).getFrameworks()) == null) {
                    object = frameworks = SetsKt.emptySet();
                }
                if (frameworks.isEmpty()) {
                    return MicroservicesUiBundle.message("endpoints.filters.all", new Object[0]);
                }
                return com.intellij.microservices.ui.flat.EndpointsView$Companion.access$displayableFilterText(EndpointsView.Companion, frameworks);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
    }

    private final void updateSidePanel() {
        this.forgetDocumentation();
        List list = this.endpointsList.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"endpointsList.selectedValuesList");
        EndpointsListItem item = (EndpointsListItem)CollectionsKt.firstOrNull((List)list);
        if (item instanceof FlatEndpointItem) {
            JComponent details = ((FlatEndpointItem)item).getEndpointDocumentation(this);
            if (details != null) {
                this.docSidePanel.add((Component)details, (Object)"Center");
                this.docSidePanelContent = details;
            }
        } else if (item instanceof ModuleItem) {
            SimpleColoredComponent details = new SimpleColoredComponent();
            Object object = ((ModuleItem)item).getModule();
            if (object == null || (object = object.getIcon()) == null) {
                object = AllIcons.Nodes.Module;
            }
            details.setIcon((Icon)object);
            Object object2 = ((ModuleItem)item).getModule();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = MicroservicesUiBundle.message("endpoints.filters.module.external", new Object[0]);
            }
            details.append((String)object2);
            BorderLayoutPanel wrapper = new BorderLayoutPanel();
            wrapper.addToLeft((Component)details);
            wrapper.setBorder(JBUI.Borders.empty((int)7));
            this.docSidePanel.add((Component)wrapper, (Object)"North");
            this.docSidePanelContent = (JComponent)wrapper;
        }
        this.docSidePanel.revalidate();
        this.docSidePanel.repaint();
        this.updateContributedSidePanels();
    }

    private final void updateContributedSidePanels() {
        this.sidePanelsActivatedState.clear();
        TabInfo tabInfo = this.tabbedPaneWrapper.getSelectedInfo();
        JComponent selectedSidePanelComponent = tabInfo != null ? tabInfo.getComponent() : null;
        for (EndpointsSidePanel endpointsSidePanel : this.sidePanels) {
            TabInfo info;
            boolean isActive = Intrinsics.areEqual((Object)selectedSidePanelComponent, (Object)endpointsSidePanel.getComponent());
            endpointsSidePanel.update(this.sidePanelDataContext, isActive);
            if (isActive) {
                this.sidePanelsActivatedState.add(endpointsSidePanel);
            }
            if (isActive || (info = this.tabbedPaneWrapper.findInfo((Component)endpointsSidePanel.getComponent())) == null) continue;
            boolean shouldBeEnabled = endpointsSidePanel.isAvailable(this.sidePanelDataContext);
            if (info.isEnabled() == shouldBeEnabled) continue;
            info.setEnabled(shouldBeEnabled);
        }
        this.tabbedPaneWrapper.revalidateAndRepaint();
    }

    public final void setup() {
        this.setSplitOrientation();
        this.initGlobalListeners();
        this.loadInitial();
    }

    private final void installListActions(EndpointsList endpointsList) {
        Object[] customActions;
        AnAction findUsagesAction;
        AnAction editAction2 = new AnAction(this, ActionsBundle.messagePointer((String)"action.EditSource.text", (Object[])new Object[0]), AllIcons.Actions.Edit){
            final /* synthetic */ EndpointsView this$0;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EndpointsView.access$performEditAction(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        editAction2.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)endpointsList));
        boolean bl = false;
        List actions = new ArrayList();
        AnAction editSourceAction = ActionManager.getInstance().getAction("EditSource");
        if (editSourceAction != null) {
            actions.add(editSourceAction);
        }
        if ((findUsagesAction = ActionManager.getInstance().getAction("FindUsages")) != null) {
            actions.add(findUsagesAction);
        }
        Object[] objectArray = customActions = Companion.getCustomContextMenuActions$intellij_microservices_ui();
        boolean bl2 = false;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        if (!(objectArray2.length == 0)) {
            Separator separator = Separator.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"Separator.getInstance()");
            actions.add(separator);
            CollectionsKt.addAll((Collection)actions, (Object[])customActions);
        }
        ActionGroup contextActionGroup = (ActionGroup)new DefaultActionGroup(actions);
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)endpointsList)), (ActionGroup)contextActionGroup, (String)"popup@EndpointsContextMenu");
    }

    private final void initGlobalListeners() {
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(this){
            final /* synthetic */ EndpointsView this$0;

            public final void modificationCountChanged() {
                EndpointsCursor cursor = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                if (cursor != null) {
                    long newModificationCount = cursor.getModificationCount();
                    if (EndpointsView.access$getEndpointsModificationCount$p(this.this$0) == newModificationCount || EndpointsView.access$getTrackingChangesCounter$p(this.this$0).get() != 0) {
                        EndpointsView.access$getLOG$cp().debug("No related PSI changes, will not reload endpoints");
                        return;
                    }
                }
                EndpointsView.access$getPsiChangeUpdateQueue$p(this.this$0).queue(Update.create((Object)((Object)this.this$0), (Runnable)new Runnable(this){
                    final /* synthetic */ initGlobalListeners.1 this$0;

                    public final void run() {
                        EndpointsView.access$requestInitialLoad(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = endpointsView;
            }
        });
        messageBusConnection2.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ EndpointsView this$0;

            public void exitDumbMode() {
                EndpointsView.access$requestInitialLoad(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        });
        messageBusConnection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(this){
            final /* synthetic */ EndpointsView this$0;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EndpointsView.access$requestInitialLoad(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        });
        messageBusConnection2.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(this){
            final /* synthetic */ EndpointsView this$0;

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                EndpointsView.access$requestInitialLoad(this.this$0);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                EndpointsView.access$requestInitialLoad(this.this$0);
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                EndpointsView.access$forgetData(this.this$0);
                EndpointsView.access$requestInitialLoad(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        });
        messageBusConnection2.subscribe(EndpointsViewListener.Companion.getTOPIC(), (Object)new EndpointsViewListener(this){
            final /* synthetic */ EndpointsView this$0;

            public void endpointsChanged(@NotNull EndpointsViewListener.ChangeEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (EndpointsView$WhenMappings.$EnumSwitchMapping$0[e.getType().ordinal()]) {
                    case 1: {
                        EndpointsView.access$forgetData(this.this$0);
                        break;
                    }
                    case 2: {
                        EndpointsView.access$setListRenderer(this.this$0);
                        EndpointsView.access$setSidePanelVisibility(this.this$0);
                        EndpointsView.access$initSidePanelTabs(this.this$0);
                        EndpointsView.access$requestInitialLoad(this.this$0);
                        break;
                    }
                    default: {
                        EndpointsView.access$requestInitialLoad(this.this$0);
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        messageBusConnection2.subscribe(EndpointsChangeTracker.Companion.getTOPIC(), (Object)new EndpointsChangeTracker(this){
            final /* synthetic */ EndpointsView this$0;

            public void setTrackingChanges(boolean enabled) {
                block1: {
                    int state;
                    int n = state = enabled ? EndpointsView.access$getTrackingChangesCounter$p(this.this$0).decrementAndGet() : EndpointsView.access$getTrackingChangesCounter$p(this.this$0).incrementAndGet();
                    if (!enabled || state != 0) break block1;
                    EndpointsCursor endpointsCursor = EndpointsView.access$getEndpointsCursor$p(this.this$0);
                    if (endpointsCursor != null) {
                        EndpointsCursor endpointsCursor2 = endpointsCursor;
                        boolean bl = false;
                        boolean bl2 = false;
                        EndpointsCursor it = endpointsCursor2;
                        boolean bl3 = false;
                        EndpointsView.access$setEndpointsModificationCount$p(this.this$0, it.getModificationCount());
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        messageBusConnection2.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ EndpointsView this$0;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                EndpointsView.access$setSplitOrientation(this.this$0);
                EndpointsView.access$setListRenderer(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        });
        SIDE_PANEL_EP_NAME.addChangeListener(new Runnable(this){
            final /* synthetic */ EndpointsView this$0;

            public final void run() {
                EndpointsView.access$initSidePanelTabs(this.this$0);
            }
            {
                this.this$0 = endpointsView;
            }
        }, (Disposable)this);
    }

    private final void forgetData() {
        this.psiChangeUpdateQueue.cancelAllUpdates();
        this.endpointsModel.removeAllElements();
        this.endpointsCursor = null;
        this.forgetDocumentation();
        this.updateContributedSidePanels();
    }

    private final void forgetSelection() {
        this.endpointsList.getSelectionModel().clearSelection();
    }

    private final void forgetDocumentation() {
        JComponent $this$castSafelyTo$iv = this.docSidePanelContent;
        boolean $i$f$castSafelyTo = false;
        JComponent jComponent = $this$castSafelyTo$iv;
        if (!(jComponent instanceof Disposable)) {
            jComponent = null;
        }
        Disposable disposable = (Disposable)jComponent;
        if (disposable != null) {
            Disposable disposable2 = disposable;
            boolean bl = false;
            boolean bl2 = false;
            Disposable it = disposable2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it);
        }
        this.docSidePanel.removeAll();
        this.docSidePanelContent = null;
    }

    private final void setSidePanelVisibility() {
        this.tabbedPaneWrapper.setVisible(EndpointsViewSettings.Companion.getInstance(this.project).isShowSidePanel());
    }

    private final void setListRenderer() {
        this.endpointsList.setCellRenderer(new EndpointsListRenderer(this.project, EndpointsViewSettings.Companion.getInstance(this.project).isCompactMode()));
    }

    private final void setSplitOrientation() {
        ToolWindowAnchor toolWindowAnchor = this.toolWindow.getAnchor();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"toolWindow.anchor");
        this.splitter.setOrientation(!toolWindowAnchor.isHorizontal());
    }

    private final void requestInitialLoad() {
        if (this.toolWindow.isDisposed() || DumbService.isDumb((Project)this.project)) {
            return;
        }
        if (!this.toolWindow.isVisible()) {
            if (!this.updateOnShow) {
                this.toolWindow.getReady((Object)this).doWhenDone(new Runnable(this){
                    final /* synthetic */ EndpointsView this$0;

                    public final void run() {
                        EndpointsView.access$setUpdateOnShow$p(this.this$0, false);
                        EndpointsView.access$updateItemsOnChange(this.this$0);
                    }
                    {
                        this.this$0 = endpointsView;
                    }
                });
                this.updateOnShow = true;
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ EndpointsView this$0;

            public final void run() {
                EndpointsView.access$loadInitial(this.this$0);
            }
            {
                this.this$0 = endpointsView;
            }
        }, ModalityState.NON_MODAL, this.project.getDisposed());
    }

    private final void updateItemsOnChange() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ EndpointsView this$0;

            public final void run() {
                EndpointsView.access$requestInitialLoad(this.this$0);
            }
            {
                this.this$0 = endpointsView;
            }
        }, ModalityState.NON_MODAL, this.project.getDisposed());
    }

    public void dispose() {
        this.searchUpdateAlarm.cancelAllRequests();
    }

    private final void appendToList(EndpointsCursor cursor, List<? extends FlatEndpointItem<?, ?>> data) {
        this.endpointsModificationCount = cursor.getModificationCount();
        for (FlatEndpointItem<?, ?> item : data) {
            if (cursor.getShowModules()) {
                int listSize = this.endpointsModel.size();
                if (listSize > 0) {
                    FlatEndpointItem previousItem;
                    EndpointsListItem endpointsListItem = this.endpointsModel.getElementAt(listSize - 1);
                    if (!(endpointsListItem instanceof FlatEndpointItem)) {
                        endpointsListItem = null;
                    }
                    FlatEndpointItem flatEndpointItem = previousItem = (FlatEndpointItem)endpointsListItem;
                    if (Intrinsics.areEqual((Object)(flatEndpointItem != null ? flatEndpointItem.getModule() : null), (Object)item.getModule()) ^ true) {
                        this.endpointsModel.addElement(new ModuleItem(item.getModule()));
                    }
                } else if (this.endpointsModel.size() == 0) {
                    this.endpointsModel.addElement(new ModuleItem(item.getModule()));
                }
            }
            this.endpointsModel.addElement(item);
        }
    }

    private final void loadInitial() {
        if (this.toolWindow.isDisposed() || DumbService.isDumb((Project)this.project)) {
            return;
        }
        EndpointsSearchQueryParser queryParser = new EndpointsSearchQueryParser(EndpointsCursorKt.getModuleAttribute(this.model));
        String string = this.searchTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"searchTextField.text");
        queryParser.parse(string);
        EndpointsViewSettings settings = EndpointsViewSettings.Companion.getInstance(this.project);
        EndpointsCursor cursor = new EndpointsCursor(this.project, this.model, queryParser, settings.isShowModules(), settings.isShowFromLibraries(), settings.isShowFromTests());
        ArrayList<String> filters = new ArrayList<String>(3);
        Collection collection = queryParser.getFrameworks();
        int n = 0;
        if (!collection.isEmpty()) {
            filters.add("framework");
        }
        collection = queryParser.getModules();
        n = 0;
        if (!collection.isEmpty()) {
            filters.add("module");
        }
        collection = queryParser.getTypes();
        n = 0;
        if (!collection.isEmpty()) {
            filters.add("type");
        }
        collection = filters;
        n = 0;
        if (!collection.isEmpty()) {
            MicroservicesUsagesKt.getENDPOINTS_FILTERED_EVENT().log(this.project, filters);
        }
        this.endpointsCursor = cursor;
        this.endpointsModificationCount = 0L;
        for (Component filter : this.filtersPanel.getComponents()) {
            filter.revalidate();
        }
        this.filtersPanel.repaint();
        this.load(new LoadContext(cursor, 0));
    }

    private final void loadNext(EndpointsCursor cursor) {
        if (!this.endpointsList.isBusyLoading() && cursor.hasMoreItems()) {
            LOG.debug("Load more endpoints");
            this.load(new LoadContext(cursor, this.endpointsModel.getSize()));
        }
    }

    private final void load(LoadContext context) {
        this.endpointsList.setPaintBusy(true);
        int[] oldSelectedIndices = this.endpointsList.getSelectedIndices();
        ReadAction.nonBlocking((Callable)new Callable(context){
            final /* synthetic */ LoadContext $context;

            public final List<FlatEndpointItem<?, ?>> call() {
                return this.$context.getCursor().fetch(50, this.$context.getOffset());
            }
            {
                this.$context = loadContext;
            }
        }).finishOnUiThread(ModalityState.any(), new Consumer(this, context, oldSelectedIndices){
            final /* synthetic */ EndpointsView this$0;
            final /* synthetic */ LoadContext $context;
            final /* synthetic */ int[] $oldSelectedIndices;

            /*
             * WARNING - void declaration
             */
            public final void accept(List<? extends FlatEndpointItem<?, ?>> listItems) {
                EndpointsView.access$getEndpointsList$p(this.this$0).setPaintBusy(false);
                JScrollBar jScrollBar = EndpointsView.access$getScrollPane$p(this.this$0).getVerticalScrollBar();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
                int oldScrollValue = jScrollBar.getValue();
                if (this.$context.getOffset() == 0) {
                    JScrollBar jScrollBar2 = EndpointsView.access$getScrollPane$p(this.this$0).getVerticalScrollBar();
                    Intrinsics.checkNotNullExpressionValue((Object)jScrollBar2, (String)"scrollPane.verticalScrollBar");
                    jScrollBar2.setValue(0);
                    EndpointsView.access$getEndpointsModel$p(this.this$0).setSize(0);
                }
                EndpointsCursor endpointsCursor = this.$context.getCursor();
                List<FlatEndpointItem<?, ?>> list = listItems;
                Intrinsics.checkNotNullExpressionValue(list, (String)"listItems");
                EndpointsView.access$appendToList(this.this$0, endpointsCursor, list);
                if (this.$context.getOffset() == 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.$oldSelectedIndices, (String)"oldSelectedIndices");
                    int[] nArray = this.$oldSelectedIndices;
                    boolean bl = false;
                    int[] nArray2 = nArray;
                    boolean bl2 = false;
                    if (!(nArray2.length == 0)) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        EndpointsList endpointsList = EndpointsView.access$getEndpointsList$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)this.$oldSelectedIndices, (String)"oldSelectedIndices");
                        nArray = this.$oldSelectedIndices;
                        EndpointsList endpointsList2 = endpointsList;
                        boolean $i$f$filter = false;
                        nArray2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        void var8_10 = $this$filterTo$iv$iv;
                        int n = ((void)var8_10).length;
                        for (int i = 0; i < n; ++i) {
                            void element$iv$iv;
                            void it = element$iv$iv = var8_10[i];
                            boolean bl3 = false;
                            if (!(it < EndpointsView.access$getEndpointsModel$p(this.this$0).size())) continue;
                            destination$iv$iv.add((int)element$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv;
                        endpointsList2.setSelectedIndices(CollectionsKt.toIntArray((Collection)list2));
                    }
                    JScrollBar jScrollBar3 = EndpointsView.access$getScrollPane$p(this.this$0).getVerticalScrollBar();
                    Intrinsics.checkNotNullExpressionValue((Object)jScrollBar3, (String)"scrollPane.verticalScrollBar");
                    JScrollBar jScrollBar4 = EndpointsView.access$getScrollPane$p(this.this$0).getVerticalScrollBar();
                    Intrinsics.checkNotNullExpressionValue((Object)jScrollBar4, (String)"scrollPane.verticalScrollBar");
                    jScrollBar3.setValue(RangesKt.coerceAtMost((int)oldScrollValue, (int)jScrollBar4.getMaximum()));
                }
                if (this.$context.getOffset() == 0 && listItems.size() == 50) {
                    EndpointsView.access$loadNext(this.this$0, this.$context.getCursor());
                }
            }
            {
                this.this$0 = endpointsView;
                this.$context = loadContext;
                this.$oldSelectedIndices = nArray;
            }
        }).coalesceBy(new Object[]{this}).expireWith((Disposable)this).inSmartMode(this.project).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final boolean performEditAction() {
        Navigatable data = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext((Component)((Object)this.endpointsList)));
        if (data != null && data.canNavigate()) {
            data.navigate(true);
            return true;
        }
        EndpointsListItem selectedItem = (EndpointsListItem)this.endpointsList.getSelectedValue();
        if (selectedItem instanceof ModuleItem) {
            String string = EndpointsCursorKt.getModuleAttribute(this.model);
            Object object = ((ModuleItem)selectedItem).getModule();
            if (object == null || (object = object.getName()) == null) {
                object = "#external";
            }
            this.applyFilter(string, CollectionsKt.listOf((Object)object));
            this.searchTextField.requestFocus();
            return true;
        }
        return false;
    }

    private final void installEditOnDoubleClick(JBList<?> list) {
        new DoubleClickListener(this){
            final /* synthetic */ EndpointsView this$0;

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return EndpointsView.access$performEditAction(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        }.installOn((Component)list);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterator iterator;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isReadAccessAllowed()) return null;
        if (DumbService.isDumb((Project)this.project)) {
            return null;
        }
        if (SearchTextField.KEY.is(dataId)) {
            return this.searchTextField;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project;
        }
        if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            List list = this.endpointsList.getSelectedValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"endpointsList.selectedValuesList");
            EndpointsListItem endpointsListItem = (EndpointsListItem)CollectionsKt.firstOrNull((List)list);
            EndpointsListItem endpointsListItem2 = endpointsListItem;
            if (endpointsListItem == null) return null;
            EndpointsListItem endpointsListItem3 = endpointsListItem2;
            boolean bl = false;
            boolean bl2 = false;
            EndpointsListItem it2 = endpointsListItem3;
            boolean bl3 = false;
            if (!(it2 instanceof FlatEndpointItem) || !((FlatEndpointItem)it2).isValid()) {
                if (!(it2 instanceof ModuleItem)) return null;
            }
            boolean bl4 = true;
            if (!bl4) return null;
            EndpointsListItem endpointsListItem4 = endpointsListItem3;
            endpointsListItem2 = endpointsListItem4;
            if (endpointsListItem4 == null) return null;
            endpointsListItem3 = endpointsListItem2;
            bl = false;
            bl2 = false;
            it2 = endpointsListItem3;
            boolean bl5 = false;
            Object object = this.getTarget(it2);
            return object;
        }
        if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            List list = this.endpointsList.getSelectedValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"endpointsList.selectedValuesList");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv.iterator();
        } else {
            void $this$filterTo$iv$iv2;
            Iterable $this$filterIsInstanceTo$iv$iv;
            if (!PlatformDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) return null;
            List list = this.endpointsList.getSelectedValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"endpointsList.selectedValuesList");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable destination$iv$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FlatEndpointItem)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (true) {
                Object element$iv$iv;
                if (!iterator2.hasNext()) {
                    List selectedItems = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
                    if (!selectedItems.isEmpty()) return CollectionsKt.listOf((Object)new DataProvider(selectedItems){
                        final /* synthetic */ List $selectedItems;

                        @Nullable
                        public final Object getData(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return com.intellij.microservices.ui.flat.EndpointsView$Companion.access$getSlowData(EndpointsView.Companion, it, this.$selectedItems);
                        }
                        {
                            this.$selectedItems = list;
                        }
                    });
                    return CollectionsKt.emptyList();
                }
                element$iv$iv = iterator2.next();
                FlatEndpointItem it3 = (FlatEndpointItem)element$iv$iv;
                boolean bl = false;
                if (!it3.isValid()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
        }
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (EndpointsListItem)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FlatEndpointItem && ((FlatEndpointItem)it).isValid() || it instanceof ModuleItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            EndpointsListItem it4 = (EndpointsListItem)element$iv$iv;
            boolean bl6 = false;
            EndpointsListItem endpointsListItem = it4;
            Intrinsics.checkNotNullExpressionValue((Object)endpointsListItem, (String)"it");
            if (this.getTarget(endpointsListItem) == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            Object it$iv$iv = object;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ArrayUtil.toObjectArray((Collection)((List)destination$iv$iv));
    }

    private final Object getTarget(EndpointsListItem it) {
        EndpointsListItem endpointsListItem = it;
        return endpointsListItem instanceof FlatEndpointItem ? it : (endpointsListItem instanceof ModuleItem ? ((ModuleItem)it).getModule() : null);
    }

    private final void showSearchPopup() {
        if (StringUtil.isEmptyOrSpaces((String)this.searchTextField.getText())) {
            this.searchPopupController.showAttributesPopup(null, 0);
        } else {
            this.searchPopupController.handleShowPopup();
        }
    }

    private final void applyFilter(String attribute, Collection<String> values) {
        EndpointsSearchQueryParser queryParser;
        this.forgetSelection();
        EndpointsCursor endpointsCursor = this.endpointsCursor;
        EndpointsSearchQueryParser endpointsSearchQueryParser = queryParser = endpointsCursor != null ? endpointsCursor.getQueryParser() : null;
        if (queryParser == null) {
            this.searchTextField.setText(attribute + ' ' + EndpointsView.Companion.composeFilterValue(values));
        } else {
            Collection<String> frameworks = (Collection<String>)queryParser.getFrameworks();
            Collection<String> modules = (Collection<String>)queryParser.getModules();
            Collection<String> types2 = (Collection<String>)queryParser.getTypes();
            String string = attribute;
            if (Intrinsics.areEqual((Object)string, (Object)EndpointsCursorKt.getModuleAttribute(this.model))) {
                modules = values;
            } else if (Intrinsics.areEqual((Object)string, (Object)"framework:")) {
                frameworks = values;
            } else if (Intrinsics.areEqual((Object)string, (Object)"type:")) {
                types2 = values;
            }
            StringBuilder queryBuilder = new StringBuilder();
            Object object = modules;
            boolean bl = false;
            if (!object.isEmpty()) {
                queryBuilder.append(EndpointsCursorKt.getModuleAttribute(this.model)).append(" ").append(EndpointsView.Companion.composeFilterValue(modules)).append(" ");
            }
            object = types2;
            bl = false;
            if (!object.isEmpty()) {
                queryBuilder.append("type:").append(" ").append(EndpointsView.Companion.composeFilterValue(types2)).append(" ");
            }
            object = frameworks;
            bl = false;
            if (!object.isEmpty()) {
                queryBuilder.append("framework:").append(" ").append(EndpointsView.Companion.composeFilterValue(frameworks)).append(" ");
            }
            for (String word : queryParser.getWords()) {
                queryBuilder.append(word).append(" ");
            }
            String string2 = queryBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"queryBuilder.toString()");
            object = string2;
            boolean bl2 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            this.searchTextField.setText(((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString());
            this.searchTextField.addCurrentTextToHistory();
        }
        this.loadInitial();
    }

    private final DefaultActionGroup createFilterActions(Component filterField, String attribute, @Nls String title, List<FilterItem> items, Collection<String> selectedItems) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FilterAllAction(attribute));
        group.add((AnAction)new FilterMultiSelectAction(attribute, title, filterField, items, selectedItems));
        group.add((AnAction)new Separator());
        this.fillFilterItems(items, attribute, selectedItems, group);
        return group;
    }

    private final void fillFilterItems(List<FilterItem> items, String attribute, Collection<String> selectedItems, DefaultActionGroup group) {
        for (FilterItem item : items) {
            FilterValueAction action = new FilterValueAction(attribute, item.getTitle(), item.getValue());
            if (selectedItems.contains(item.getValue())) {
                Presentation presentation = action.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation");
                presentation.setIcon(AllIcons.Actions.Checked);
            }
            group.add((AnAction)action);
        }
    }

    public final void showEndpoints(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.searchTextField.setText("");
        this.endpointsCursor = null;
        this.applyFilter(EndpointsCursorKt.getModuleAttribute(this.model), CollectionsKt.listOf((Object)module.getName()));
        this.searchTextField.requestFocus();
    }

    public final void showEndpoints(@Nullable String module, @Nullable String framework, @Nullable String filter) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        CharSequence charSequence = module;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            StringsKt.append((StringBuilder)$this$buildString, (String[])new String[]{EndpointsCursorKt.getModuleAttribute(this.model), " ", module, " "});
        }
        charSequence = framework;
        bl6 = false;
        bl7 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            StringsKt.append((StringBuilder)$this$buildString, (String[])new String[]{"framework:", " ", framework, " "});
        }
        charSequence = filter;
        bl6 = false;
        bl7 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$buildString.append(filter);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String searchedValue = string;
        this.showEndpoints(searchedValue);
    }

    public final void showEndpoints(@NlsSafe @NotNull String searchedValue) {
        Intrinsics.checkNotNullParameter((Object)searchedValue, (String)"searchedValue");
        this.searchTextField.setText(searchedValue);
        this.loadInitial();
        this.searchTextField.requestFocus();
    }

    public EndpointsView(@NotNull Project project, @NotNull EndpointsProjectModel model, @NotNull ToolWindow toolWindow) {
        ShortcutSet findShortcuts;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(false, true);
        this.project = project;
        this.model = model;
        this.toolWindow = toolWindow;
        this.endpointsList = new EndpointsList();
        this.endpointsModel = new DefaultListModel();
        this.searchUpdateAlarm = new Alarm();
        this.psiChangeUpdateQueue = new MergingUpdateQueue("EndpointsRefresh", 500, true, (JComponent)((Object)this), (Disposable)this);
        this.searchTextField = new EndpointsSearchTextField(this){
            final /* synthetic */ EndpointsView this$0;

            protected boolean toClearTextOnEscape() {
                searchTextField.1 textField = this;
                new AnAction(this, textField){
                    final /* synthetic */ searchTextField.1 this$0;
                    final /* synthetic */ searchTextField.1 $textField;

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (EndpointsView.access$getSearchPopupController$p(this.this$0.this$0).isPopupShow()) {
                            EndpointsView.access$getSearchPopupController$p(this.this$0.this$0).hidePopup();
                        } else {
                            this.$textField.setText("");
                            EndpointsView.access$loadInitial(this.this$0.this$0);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$textField = $captured_local_variable$1;
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
                return false;
            }

            protected boolean preprocessEventForTextField(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int keyCode = event.getKeyCode();
                int id = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    if (id == 401 && !EndpointsView.access$getSearchPopupController$p(this.this$0).handleEnter(event)) {
                        EndpointsView.access$getSearchPopupController$p(this.this$0).hidePopup();
                        EndpointsView.access$forgetSelection(this.this$0);
                        this.addCurrentTextToHistory();
                        EndpointsView.access$loadInitial(this.this$0);
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id == 401 && EndpointsView.access$getSearchPopupController$p(this.this$0).handleUpDown(event)) {
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            protected void historyItemChosen(@Nullable String item) {
                EndpointsView.access$loadInitial(this.this$0);
            }

            protected void onFieldCleared() {
                EndpointsView.access$loadInitial(this.this$0);
            }

            protected void showCompletionPopup() {
                if (!EndpointsView.access$getSearchPopupController$p(this.this$0).isPopupShow()) {
                    EndpointsView.access$showSearchPopup(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
                this.setHistoryPropertyName("EndpointsSearchHistory");
                this.setHistorySize(10);
            }
        };
        this.searchPopupController = new EndpointsSearchPopupController(this.project, this.model, this.searchTextField, (JList)((Object)this.endpointsList));
        this.splitter = (JBSplitter)new OnePixelSplitter(0.5f);
        this.tabbedPaneWrapper = new SingleHeightTabs(this.project, (Disposable)this);
        this.docSidePanel = new JBPanelWithEmptyText();
        this.filtersPanel = new JPanel((LayoutManager)new HorizontalLayout(10));
        this.scrollPane = new JBScrollPane((Component)((Object)this.endpointsList));
        this.sidePanelDataContext = new DataContext(this){
            final /* synthetic */ EndpointsView this$0;

            @Nullable
            public final Object getData(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getData(it);
            }
            {
                this.this$0 = endpointsView;
            }
        };
        this.sidePanels = CollectionsKt.emptyList();
        this.sidePanelsActivatedState = new HashSet();
        this.trackingChangesCounter = new AtomicInteger(0);
        this.endpointsList.setModel(this.endpointsModel);
        this.setListRenderer();
        this.installListActions(this.endpointsList);
        this.installEditOnDoubleClick(this.endpointsList);
        ScrollingUtil.installActions((JList)((JList)((Object)this.endpointsList)), null, (boolean)false);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            private int previousScrollValue;

            @Override
            public void adjustmentValueChanged(@NotNull AdjustmentEvent e) {
                block3: {
                    double scrollPercent;
                    int rowsFromEnd;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JScrollBar jScrollBar = scrollPane.getVerticalScrollBar();
                    Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
                    int scrollMax = jScrollBar.getMaximum();
                    if (scrollMax <= 0 || endpointsList.isBusyLoading() || e.getValueIsAdjusting()) break block3;
                    int oldValue = this.previousScrollValue;
                    this.previousScrollValue = e.getValue();
                    if (oldValue > e.getValue()) {
                        return;
                    }
                    int totalRows = endpointsModel.getSize();
                    if (totalRows > 0 && (rowsFromEnd = MathKt.roundToInt((double)((double)totalRows * (1.0 - (scrollPercent = (double)e.getValue() / (double)scrollMax))))) < 25) {
                        LOG.debug("Rows remaining " + rowsFromEnd + ", will load next batch");
                        EndpointsCursor endpointsCursor = endpointsCursor;
                        if (endpointsCursor != null) {
                            EndpointsCursor endpointsCursor2 = endpointsCursor;
                            boolean bl = false;
                            boolean bl2 = false;
                            EndpointsCursor it = endpointsCursor2;
                            boolean bl3 = false;
                            this.loadNext(it);
                        }
                    }
                }
            }
        });
        this.endpointsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent event) {
                ListSelectionEvent listSelectionEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)listSelectionEvent, (String)"event");
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                this.updateSidePanel();
            }
        });
        this.initSidePanelTabs();
        this.tabbedPaneWrapper.addListener(new TabsListener(){

            public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
                if (newSelection != null) {
                    Object v0;
                    block4: {
                        Iterable iterable = sidePanels;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            EndpointsSidePanel it = (EndpointsSidePanel)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getComponent(), (Object)newSelection.getComponent())) continue;
                            v0 = t;
                            break block4;
                        }
                        v0 = null;
                    }
                    EndpointsSidePanel endpointsSidePanel = v0;
                    if (endpointsSidePanel == null) {
                        return;
                    }
                    EndpointsSidePanel newSidePanel = endpointsSidePanel;
                    if (!sidePanelsActivatedState.contains(newSidePanel)) {
                        sidePanelsActivatedState.add(newSidePanel);
                        newSidePanel.update(sidePanelDataContext, true);
                    }
                }
            }
        });
        JBTextField jBTextField = this.searchTextField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchTextField.textEditor");
        jBTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            /*
             * WARNING - void declaration
             */
            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!searchTextField.isSkipDocumentEvents()) {
                    void modalityState$iv;
                    void $this$addRequest$iv;
                    searchUpdateAlarm.cancelAllRequests();
                    Alarm alarm = searchUpdateAlarm;
                    ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)searchTextField)));
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.stateForComponent(searchTextField)");
                    ModalityState modalityState2 = modalityState;
                    int delayMs$iv = 250;
                    boolean $i$f$addRequest = false;
                    $this$addRequest$iv.addRequest(new Runnable(this){
                        final /* synthetic */ 4 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            if (!StringUtil.isEmptyOrSpaces((String)EndpointsView.access$getSearchTextField$p(this.this$0.this).getText())) {
                                EndpointsView.access$getSearchPopupController$p(this.this$0.this).handleShowPopup();
                            }
                        }
                    }, delayMs$iv, (ModalityState)modalityState$iv);
                }
            }
        });
        EndpointsSearchTextField endpointsSearchTextField = this.searchTextField;
        boolean bl = false;
        boolean bl2 = false;
        EndpointsSearchTextField $this$apply = endpointsSearchTextField;
        boolean bl3 = false;
        $this$apply.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        JBTextField jBTextField2 = $this$apply.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField2, (String)"textEditor");
        jBTextField2.setBorder(JBUI.Borders.empty((int)1));
        JBTextField jBTextField3 = $this$apply.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField3, (String)"textEditor");
        jBTextField3.setOpaque(true);
        $this$apply.getTextEditor().putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUIScale.scale((int)2));
        $this$apply.getTextEditor().putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUIScale.scale((int)-1));
        this.initFilters();
        this.initContent();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ComponentsListFocusTraversalPolicy(){

            @NotNull
            protected List<Component> getOrderedComponents() {
                Object object = tabbedPaneWrapper.getSelectedInfo();
                if (object == null || (object = object.getComponent()) == null) {
                    object = (JComponent)tabbedPaneWrapper;
                }
                Object sidePanel = object;
                SpreadBuilder spreadBuilder = new SpreadBuilder(4);
                spreadBuilder.add((Object)((Component)searchTextField.getTextEditor()));
                spreadBuilder.add((Object)((Component)((Object)endpointsList)));
                spreadBuilder.add((Object)((Component)sidePanel));
                Component[] componentArray = filtersPanel.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"filtersPanel.components");
                spreadBuilder.addSpread((Object)componentArray);
                return CollectionsKt.listOf((Object[])((Component[])spreadBuilder.toArray((Object[])new Component[spreadBuilder.size()])));
            }
        });
        AnAction anAction = ActionManager.getInstance().getAction("Find");
        Object object = findShortcuts = anAction != null ? anAction.getShortcutSet() : null;
        if (findShortcuts != null) {
            new SearchTextField.FindAction().registerCustomShortcutSet(findShortcuts, (JComponent)((Object)this), (Disposable)this);
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EndpointsView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.microservices.endpointsSidePanelProvider");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026pointsSidePanelProvider\")");
        SIDE_PANEL_EP_NAME = extensionPointName;
    }

    public static final /* synthetic */ EndpointsProjectModel access$getModel$p(EndpointsView $this) {
        return $this.model;
    }

    public static final /* synthetic */ Project access$getProject$p(EndpointsView $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setEndpointsCursor$p(EndpointsView $this, EndpointsCursor endpointsCursor) {
        $this.endpointsCursor = endpointsCursor;
    }

    public static final /* synthetic */ void access$fillFilterItems(EndpointsView $this, List items, String attribute, Collection selectedItems, DefaultActionGroup group) {
        $this.fillFilterItems(items, attribute, selectedItems, group);
    }

    public static final /* synthetic */ DefaultActionGroup access$createFilterActions(EndpointsView $this, Component filterField, String attribute, String title, List items, Collection selectedItems) {
        return $this.createFilterActions(filterField, attribute, title, items, selectedItems);
    }

    public static final /* synthetic */ boolean access$performEditAction(EndpointsView $this) {
        return $this.performEditAction();
    }

    public static final /* synthetic */ long access$getEndpointsModificationCount$p(EndpointsView $this) {
        return $this.endpointsModificationCount;
    }

    public static final /* synthetic */ void access$setEndpointsModificationCount$p(EndpointsView $this, long l) {
        $this.endpointsModificationCount = l;
    }

    public static final /* synthetic */ AtomicInteger access$getTrackingChangesCounter$p(EndpointsView $this) {
        return $this.trackingChangesCounter;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getPsiChangeUpdateQueue$p(EndpointsView $this) {
        return $this.psiChangeUpdateQueue;
    }

    public static final /* synthetic */ void access$requestInitialLoad(EndpointsView $this) {
        $this.requestInitialLoad();
    }

    public static final /* synthetic */ void access$forgetData(EndpointsView $this) {
        $this.forgetData();
    }

    public static final /* synthetic */ void access$setListRenderer(EndpointsView $this) {
        $this.setListRenderer();
    }

    public static final /* synthetic */ void access$setSidePanelVisibility(EndpointsView $this) {
        $this.setSidePanelVisibility();
    }

    public static final /* synthetic */ void access$initSidePanelTabs(EndpointsView $this) {
        $this.initSidePanelTabs();
    }

    public static final /* synthetic */ void access$setSplitOrientation(EndpointsView $this) {
        $this.setSplitOrientation();
    }

    public static final /* synthetic */ boolean access$getUpdateOnShow$p(EndpointsView $this) {
        return $this.updateOnShow;
    }

    public static final /* synthetic */ void access$setUpdateOnShow$p(EndpointsView $this, boolean bl) {
        $this.updateOnShow = bl;
    }

    public static final /* synthetic */ void access$updateItemsOnChange(EndpointsView $this) {
        $this.updateItemsOnChange();
    }

    public static final /* synthetic */ void access$loadInitial(EndpointsView $this) {
        $this.loadInitial();
    }

    public static final /* synthetic */ void access$appendToList(EndpointsView $this, EndpointsCursor cursor, List data) {
        $this.appendToList(cursor, data);
    }

    public static final /* synthetic */ EndpointsSearchPopupController access$getSearchPopupController$p(EndpointsView $this) {
        return $this.searchPopupController;
    }

    public static final /* synthetic */ void access$forgetSelection(EndpointsView $this) {
        $this.forgetSelection();
    }

    public static final /* synthetic */ void access$showSearchPopup(EndpointsView $this) {
        $this.showSearchPopup();
    }

    public static final /* synthetic */ void access$setSidePanels$p(EndpointsView $this, List list) {
        $this.sidePanels = list;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$LoadContext;", "", "cursor", "Lcom/intellij/microservices/ui/flat/EndpointsCursor;", "offset", "", "(Lcom/intellij/microservices/ui/flat/EndpointsCursor;I)V", "getCursor", "()Lcom/intellij/microservices/ui/flat/EndpointsCursor;", "getOffset", "()I", "intellij.microservices.ui"})
    private static final class LoadContext {
        @NotNull
        private final EndpointsCursor cursor;
        private final int offset;

        @NotNull
        public final EndpointsCursor getCursor() {
            return this.cursor;
        }

        public final int getOffset() {
            return this.offset;
        }

        public LoadContext(@NotNull EndpointsCursor cursor, int offset) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            this.cursor = cursor;
            this.offset = offset;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$FilterAllAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "attribute", "", "(Lcom/intellij/microservices/ui/flat/EndpointsView;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.microservices.ui"})
    private final class FilterAllAction
    extends AnAction {
        private final String attribute;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EndpointsView.this.applyFilter(this.attribute, CollectionsKt.emptyList());
        }

        public FilterAllAction(String attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            super(MicroservicesUiBundle.message("endpoints.filters.all", new Object[0]));
            this.attribute = attribute;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$FilterValueAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "attribute", "", "title", "value", "(Lcom/intellij/microservices/ui/flat/EndpointsView;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.microservices.ui"})
    private final class FilterValueAction
    extends AnAction {
        private final String attribute;
        private final String title;
        private final String value;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EndpointsView.this.applyFilter(this.attribute, CollectionsKt.listOf((Object)this.value));
        }

        public FilterValueAction(@Nls @NotNull String attribute, @NotNull String title, String value) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(title);
            this.attribute = attribute;
            this.title = title;
            this.value = value;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$FilterMultiSelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "attribute", "", "title", "owner", "Ljava/awt/Component;", "items", "", "Lcom/intellij/microservices/ui/flat/EndpointsView$FilterItem;", "selectedValues", "", "(Lcom/intellij/microservices/ui/flat/EndpointsView;Ljava/lang/String;Ljava/lang/String;Ljava/awt/Component;Ljava/util/List;Ljava/util/Collection;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.microservices.ui"})
    private final class FilterMultiSelectAction
    extends AnAction {
        private final String attribute;
        private final String title;
        private final Component owner;
        private final List<FilterItem> items;
        private final Collection<String> selectedValues;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CheckBoxList checkboxList = new CheckBoxList();
            checkboxList.setItems(this.items, (Function)actionPerformed.1.INSTANCE);
            for (FilterItem filterItem : this.items) {
                if (!this.selectedValues.contains(filterItem.getValue())) continue;
                checkboxList.setItemSelected((Object)filterItem, true);
            }
            Collection collection = this.items;
            boolean bl = false;
            if (!collection.isEmpty()) {
                checkboxList.addSelectionInterval(0, 0);
            }
            checkboxList.setCheckBoxListListener(new CheckBoxListListener(this, checkboxList){
                final /* synthetic */ FilterMultiSelectAction this$0;
                final /* synthetic */ CheckBoxList $checkboxList;

                public final void checkBoxSelectionChanged(int $noName_0, boolean $noName_1) {
                    boolean bl = false;
                    Set selected = new LinkedHashSet<E>();
                    for (FilterItem item : FilterMultiSelectAction.access$getItems$p(this.this$0)) {
                        if (!this.$checkboxList.isItemSelected((Object)item)) continue;
                        selected.add(item.getValue());
                    }
                    EndpointsView.access$applyFilter(this.this$0.EndpointsView.this, FilterMultiSelectAction.access$getAttribute$p(this.this$0), selected);
                }
                {
                    this.this$0 = filterMultiSelectAction;
                    this.$checkboxList = checkBoxList;
                }
            });
            JBScrollPane jBScrollPane = new JBScrollPane((Component)checkboxList);
            jBScrollPane.setBorder((Border)JBUI.Borders.empty());
            Dimension dimension = checkboxList.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"checkboxList.preferredSize");
            jBScrollPane.setPreferredSize(Companion.computeNotBiggerDimension(dimension, this.owner.getLocationOnScreen()));
            JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jBScrollPane, (JComponent)checkboxList).setTitle(this.title).setRequestFocus(true).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"JBPopupFactory.getInstan\u2026e)\n        .createPopup()");
            JBPopup popup = jBPopup;
            popup.setMinimumSize((Dimension)new JBDimension(250, 0));
            popup.showUnderneathOf(this.owner);
        }

        public FilterMultiSelectAction(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String attribute, @NotNull String title, @NotNull Component owner, @NotNull List<FilterItem> items, Collection<String> selectedValues) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
            super(MicroservicesUiBundle.message("endpoints.filters.select", new Object[0]));
            this.attribute = attribute;
            this.title = title;
            this.owner = owner;
            this.items = items;
            this.selectedValues = selectedValues;
        }

        public static final /* synthetic */ List access$getItems$p(FilterMultiSelectAction $this) {
            return $this.items;
        }

        public static final /* synthetic */ String access$getAttribute$p(FilterMultiSelectAction $this) {
            return $this.attribute;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\"\b\u0016\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$FilterItem;", "", "titleMsg", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "value", "(Ljava/util/function/Supplier;Ljava/lang/String;)V", "title", "(Ljava/lang/String;Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "getValue", "intellij.microservices.ui"})
    private static final class FilterItem {
        @NotNull
        private final String title;
        @NotNull
        private final String value;

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public FilterItem(@Nls @NotNull String title, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.title = title;
            this.value = value;
        }

        public FilterItem(@NotNull Supplier<String> titleMsg, @NotNull String value) {
            Intrinsics.checkNotNullParameter(titleMsg, (String)"titleMsg");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = titleMsg.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"titleMsg.get()");
            this(string, value);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0003J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J(\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\f2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$0\u000fH\u0002J\u0015\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsView$Companion;", "", "()V", "FETCH_PAGE_SIZE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_FILTER_VALUE_LENGTH", "SIDE_PANEL_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/microservices/endpoints/EndpointsSidePanelProvider;", "TOOLWINDOW_ID", "", "composeFilterValue", "values", "", "computeNotBiggerDimension", "Ljava/awt/Dimension;", "ofContent", "locationOnScreen", "Ljava/awt/Point;", "displayableFilterText", "getCustomContextMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCustomContextMenuActions$intellij_microservices_ui", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "getSelectedView", "Lcom/intellij/microservices/ui/flat/EndpointsView;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionContextComponent", "Ljava/awt/Component;", "getSlowData", "dataId", "selectedItems", "Lcom/intellij/microservices/ui/flat/FlatEndpointItem;", "isViewOnScreen", "", "isViewOnScreen$intellij_microservices_ui", "intellij.microservices.ui"})
    public static final class Companion {
        private final EndpointsView getSelectedView(Component actionContextComponent) {
            Component contextComponent;
            for (contextComponent = actionContextComponent; contextComponent != null && !(contextComponent instanceof EndpointsView); contextComponent = (Component)contextComponent.getParent()) {
            }
            return (EndpointsView)((Object)contextComponent);
        }

        private final EndpointsView getSelectedView(AnActionEvent e) {
            return this.getSelectedView((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
        }

        public final boolean isViewOnScreen$intellij_microservices_ui(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.getSelectedView(e) != null;
        }

        @NotNull
        public final AnAction[] getCustomContextMenuActions$intellij_microservices_ui() {
            AnAction anAction = ActionManager.getInstance().getAction("EndpointsActions.ContextMenu");
            boolean bl = false;
            boolean bl2 = false;
            AnAction it = anAction;
            boolean bl3 = false;
            AnAction anAction2 = it;
            if (anAction2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            }
            AnAction[] anActionArray = ((ActionGroup)anAction2).getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"ActionManager.getInstanc\u2026       .getChildren(null)");
            return anActionArray;
        }

        @NlsSafe
        private final String displayableFilterText(Collection<String> values) {
            String text = values.size() == 1 ? (String)CollectionsKt.first((Iterable)values) : CollectionsKt.joinToString$default((Iterable)values, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            String string = StringUtil.shortenTextWithEllipsis((String)text, (int)30, (int)0, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026ER_VALUE_LENGTH, 0, true)");
            return string;
        }

        private final String composeFilterValue(Collection<String> values) {
            return CollectionsKt.joinToString$default((Iterable)values, (CharSequence)",", null, null, (int)0, null, (Function1)composeFilterValue.1.INSTANCE, (int)30, null);
        }

        private final Dimension computeNotBiggerDimension(Dimension ofContent, Point locationOnScreen) {
            int resultHeight;
            Dimension maxSize = new Dimension(Integer.MAX_VALUE, 600);
            int n = resultHeight = ofContent.height > maxSize.height ? maxSize.height : ofContent.height;
            if (locationOnScreen != null) {
                Rectangle r = ScreenUtil.getScreenRectangle((Point)locationOnScreen);
                resultHeight = RangesKt.coerceAtMost((int)resultHeight, (int)(r.height - r.height / 4));
            }
            int resultWidth = RangesKt.coerceAtMost((int)ofContent.width, (int)maxSize.width);
            if (ofContent.height > maxSize.height) {
                JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane()");
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"ScrollPaneFactory.create\u2026lPane().verticalScrollBar");
                resultWidth += (int)jScrollBar.getPreferredSize().getWidth();
            }
            return new Dimension(resultWidth, resultHeight);
        }

        /*
         * WARNING - void declaration
         */
        private final Object getSlowData(String dataId, Collection<? extends FlatEndpointItem<?, ?>> selectedItems) {
            if (EndpointsProvider.URL_TARGET_INFO.is(dataId)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = selectedItems;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (FlatEndpointItem)element$iv$iv;
                    boolean bl = false;
                    if (!((FlatEndpointItem)it).isValid()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Iterable iterable2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    FlatEndpointItem it2 = (FlatEndpointItem)element$iv$iv;
                    boolean bl2 = false;
                    Object object = it2.getData(dataId);
                    if (!(object instanceof Iterable)) {
                        object = null;
                    }
                    if ((Iterable)object == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Iterable it$iv$iv = iterable2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List urlTargets = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (urlTargets.isEmpty()) {
                    return null;
                }
                return CollectionsKt.flatten((Iterable)urlTargets);
            }
            FlatEndpointItem selectedItem = (FlatEndpointItem)CollectionsKt.firstOrNull((Iterable)selectedItems);
            if (selectedItem != null) {
                if (UsageView.USAGE_TARGETS_KEY.is(dataId)) {
                    UrlTargetInfo targetInfo;
                    Iterable iterableData;
                    Object object = selectedItem.getData(EndpointsProvider.URL_TARGET_INFO);
                    if (!(object instanceof Iterable)) {
                        object = null;
                    }
                    Iterable iterable = iterableData = (Iterable)object;
                    Object object2 = iterable != null ? CollectionsKt.firstOrNull((Iterable)iterable) : null;
                    if (!(object2 instanceof UrlTargetInfo)) {
                        object2 = null;
                    }
                    if ((targetInfo = (UrlTargetInfo)object2) != null) {
                        PsiElement2UsageTargetAdapter[] psiElement2UsageTargetAdapterArray;
                        NavigatablePsiElement searchableElement;
                        NavigatablePsiElement navigatablePsiElement = searchableElement = UrlPathReference.Companion.createSearchableElement(selectedItem.getProject(), targetInfo);
                        if (navigatablePsiElement != null) {
                            NavigatablePsiElement navigatablePsiElement2 = navigatablePsiElement;
                            boolean bl = false;
                            boolean bl6 = false;
                            NavigatablePsiElement it = navigatablePsiElement2;
                            boolean bl7 = false;
                            PsiElement2UsageTargetAdapter[] psiElement2UsageTargetAdapterArray2 = new PsiElement2UsageTargetAdapter[1];
                            psiElement2UsageTargetAdapterArray = psiElement2UsageTargetAdapterArray2;
                            psiElement2UsageTargetAdapterArray2[0] = new PsiElement2UsageTargetAdapter((PsiElement)searchableElement, false);
                        } else {
                            psiElement2UsageTargetAdapterArray = null;
                        }
                        return psiElement2UsageTargetAdapterArray;
                    }
                }
                return selectedItem.getData(dataId);
            }
            return null;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$displayableFilterText(Companion $this, Collection values) {
            return $this.displayableFilterText(values);
        }

        public static final /* synthetic */ Object access$getSlowData(Companion $this, String dataId, Collection selectedItems) {
            return $this.getSlowData(dataId, selectedItems);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

