/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.ui.flat.EndpointsCompletionPopupType;
import com.intellij.microservices.ui.flat.EndpointsCursorKt;
import com.intellij.microservices.ui.flat.EndpointsSearchPopup;
import com.intellij.microservices.ui.flat.EndpointsSearchPopupCallback;
import com.intellij.microservices.ui.flat.EndpointsSearchPopupController;
import com.intellij.microservices.ui.flat.EndpointsSearchQueryParser;
import com.intellij.microservices.ui.flat.EndpointsSearchTextField;
import com.intellij.microservices.ui.flat.EndpointsViewManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBTextField;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00170 2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010#\u001a\u00020\u0017H\u0002J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&J\"\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00172\b\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010*\u001a\u00020\u0015J\b\u0010+\u001a\u00020\u0015H\u0002J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&J\u0006\u0010-\u001a\u00020\u0015J \u0010.\u001a\u00020\u00102\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00170 2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010/\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fJ0\u00101\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00170 2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsSearchPopupController;", "", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "searchTextField", "Lcom/intellij/microservices/ui/flat/EndpointsSearchTextField;", "endpointsList", "Ljavax/swing/JList;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsProjectModel;Lcom/intellij/microservices/ui/flat/EndpointsSearchTextField;Ljavax/swing/JList;)V", "caretPosition", "", "getCaretPosition", "()I", "isPopupShow", "", "()Z", "searchPopup", "Lcom/intellij/microservices/ui/flat/EndpointsSearchPopup;", "appendSearchText", "", "originalValue", "", "prefix", "createAndShow", "async", "callback", "Lcom/intellij/microservices/ui/flat/EndpointsSearchPopupCallback;", "createPopup", "type", "Lcom/intellij/microservices/ui/flat/EndpointsCompletionPopupType;", "Lcom/intellij/ui/CollectionListModel;", "getCompletionValues", "", "attribute", "handleEnter", "event", "Ljava/awt/event/KeyEvent;", "handleShowAttributeValuesPopup", "name", "valuePrefix", "handleShowPopup", "handleShowPopupForQuery", "handleUpDown", "hidePopup", "noPrefixSearchValues", "showAttributesPopup", "namePrefix", "updatePopupOrCreate", "intellij.microservices.ui"})
public final class EndpointsSearchPopupController {
    private EndpointsSearchPopup searchPopup;
    private final Project project;
    private final EndpointsProjectModel model;
    private final EndpointsSearchTextField searchTextField;
    private final JList<?> endpointsList;

    public final void handleShowPopup() {
        String query = this.searchTextField.getText();
        int length = query.length();
        int position = this.getCaretPosition();
        if (position < length && query.charAt(position) != ' ' && query.charAt(position) != ',') {
            this.handleShowPopupForQuery();
            return;
        }
        String string = query;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query");
        EndpointsSearchQueryParser.QueryCompletionPosition completionPosition = EndpointsSearchQueryParser.Companion.parseAttributeInQuery(string, position);
        if (completionPosition.getAttributeValue() == null) {
            this.showAttributesPopup(completionPosition.getAttributeName(), completionPosition.getStartPosition());
        } else {
            this.handleShowAttributeValuesPopup(completionPosition.getAttributeName(), completionPosition.getAttributeValue(), completionPosition.getStartPosition());
        }
    }

    private final int getCaretPosition() {
        JBTextField jBTextField = this.searchTextField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchTextField.textEditor");
        return jBTextField.getCaretPosition();
    }

    public final void showAttributesPopup(@Nullable String namePrefix, int caretPosition) {
        boolean async;
        CollectionListModel model = new CollectionListModel(CollectionsKt.listOf((Object[])new String[]{EndpointsCursorKt.getModuleAttribute(this.model), "type:", "framework:"}));
        if (this.noPrefixSearchValues((CollectionListModel<String>)model, namePrefix)) {
            return;
        }
        boolean bl = async = this.searchPopup != null;
        if (this.updatePopupOrCreate(EndpointsCompletionPopupType.ATTRIBUTE_NAME, (CollectionListModel<String>)model, namePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(async, new EndpointsSearchPopupCallback(this, namePrefix, namePrefix){
            final /* synthetic */ EndpointsSearchPopupController this$0;
            final /* synthetic */ String $namePrefix;

            public void consume(@Nullable String value) {
                if (value == null) {
                    return;
                }
                EndpointsSearchPopupController.access$appendSearchText(this.this$0, value, this.getPrefix());
                JBTextField jBTextField = EndpointsSearchPopupController.access$getSearchTextField$p(this.this$0).getTextEditor();
                Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchTextField.textEditor");
                EndpointsSearchPopupController.access$handleShowAttributeValuesPopup(this.this$0, value, null, jBTextField.getCaretPosition());
            }
            {
                this.this$0 = this$0;
                this.$namePrefix = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    private final void handleShowAttributeValuesPopup(String name, String valuePrefix, int caretPosition) {
        List<String> values = this.getCompletionValues(name);
        if (values.isEmpty()) {
            this.handleShowPopupForQuery();
            return;
        }
        CollectionListModel model = new CollectionListModel(values);
        if (this.noPrefixSearchValues((CollectionListModel<String>)model, valuePrefix)) {
            return;
        }
        if (this.updatePopupOrCreate(EndpointsCompletionPopupType.ATTRIBUTE_VALUE, (CollectionListModel<String>)model, valuePrefix, caretPosition)) {
            return;
        }
        this.createAndShow(true, new EndpointsSearchPopupCallback(this, valuePrefix, valuePrefix){
            final /* synthetic */ EndpointsSearchPopupController this$0;
            final /* synthetic */ String $valuePrefix;

            public void consume(@Nullable String value) {
                if (value == null) {
                    return;
                }
                EndpointsSearchPopupController.access$appendSearchText(this.this$0, EndpointsSearchQueryParser.Companion.wrapAttribute(value), this.getPrefix());
                EndpointsSearchPopupController.access$handleShowPopupForQuery(this.this$0);
            }
            {
                this.this$0 = this$0;
                this.$valuePrefix = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    private final boolean updatePopupOrCreate(EndpointsCompletionPopupType type, CollectionListModel<String> model, String prefix, int caretPosition) {
        EndpointsSearchPopup currentPopup = this.searchPopup;
        if (currentPopup != null && currentPopup.getCompletionPlace() == type && currentPopup.isValid()) {
            EndpointsSearchPopupCallback callback;
            currentPopup.getModel().replaceAll(model.getItems());
            if (model.getSize() > 0) {
                JList<String> jList = currentPopup.getList();
                if (jList != null) {
                    jList.setSelectedIndex(0);
                }
            }
            if ((callback = currentPopup.getCallback()) != null) {
                callback.setPrefix(prefix);
            }
            currentPopup.setCaretPosition(caretPosition);
            currentPopup.update();
            return true;
        }
        this.createPopup(type, model, caretPosition);
        return false;
    }

    private final void createPopup(EndpointsCompletionPopupType type, CollectionListModel<String> model, int caretPosition) {
        this.hidePopup();
        this.searchPopup = new EndpointsSearchPopup(this.searchTextField, new JBPopupListener(this){
            final /* synthetic */ EndpointsSearchPopupController this$0;

            public void onClosed(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EndpointsSearchPopupController.access$setSearchPopup$p(this.this$0, null);
            }
            {
                this.this$0 = this$0;
            }
        }, type, model, caretPosition);
    }

    private final void createAndShow(boolean async, EndpointsSearchPopupCallback callback) {
        block0: {
            EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
            if (endpointsSearchPopup == null) break block0;
            endpointsSearchPopup.createAndShow(callback, async);
        }
    }

    private final boolean noPrefixSearchValues(CollectionListModel<String> model, String prefix) {
        if (StringUtil.isEmptyOrSpaces((String)prefix)) {
            return false;
        }
        int index = 0;
        while (index < model.getSize()) {
            String attribute = (String)model.getElementAt(index);
            if (Intrinsics.areEqual((Object)attribute, (Object)prefix)) {
                this.hidePopup();
                return true;
            }
            String string = prefix;
            Intrinsics.checkNotNull((Object)string);
            if (StringUtil.startsWithIgnoreCase((String)attribute, (String)string)) {
                ++index;
                continue;
            }
            model.remove(index);
        }
        if (model.isEmpty()) {
            this.handleShowPopupForQuery();
            return true;
        }
        return false;
    }

    private final List<String> getCompletionValues(String attribute) {
        if (DumbService.isDumb((Project)this.project)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)EndpointsCursorKt.getModuleAttribute(this.model), (Object)attribute)) {
            List<EndpointsModuleEntity> modules = EndpointsCursorKt.getModulesOrdered(this.model, this.project);
            ArrayList<String> moduleNames = new ArrayList<String>(modules.size() + 1);
            moduleNames.add("#external");
            for (EndpointsModuleEntity module : modules) {
                moduleNames.add(module.getName());
            }
            return moduleNames;
        }
        if (Intrinsics.areEqual((Object)"framework:", (Object)attribute)) {
            return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)EndpointsProvider.Companion.getAvailableProviders(this.project), (Function1)getCompletionValues.1.INSTANCE)));
        }
        if (Intrinsics.areEqual((Object)"type:", (Object)attribute)) {
            return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map(EndpointsViewManager.Companion.getAvailableTypes(this.project), (Function1)getCompletionValues.2.INSTANCE)));
        }
        return CollectionsKt.emptyList();
    }

    private final void handleShowPopupForQuery() {
        this.hidePopup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPopupShow() {
        if (this.searchPopup == null) return false;
        EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
        Intrinsics.checkNotNull((Object)endpointsSearchPopup);
        if (!endpointsSearchPopup.isValid()) return false;
        return true;
    }

    public final void hidePopup() {
        EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
        if (endpointsSearchPopup != null) {
            endpointsSearchPopup.hide();
        }
        this.searchPopup = null;
    }

    private final void appendSearchText(String originalValue, String prefix) {
        int n;
        int n2;
        String string;
        String value = originalValue;
        if (Intrinsics.areEqual((Object)EndpointsCursorKt.getModuleAttribute(this.model), (Object)value) || Intrinsics.areEqual((Object)"type:", (Object)value) || Intrinsics.areEqual((Object)"framework:", (Object)value)) {
            value = value + " ";
        }
        String text = this.searchTextField.getText();
        String suffix = "";
        int position = this.getCaretPosition();
        if (this.searchPopup != null) {
            EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
            Intrinsics.checkNotNull((Object)endpointsSearchPopup);
            endpointsSearchPopup.setSkipCaretEvent(true);
        }
        if (position < text.length()) {
            String string2 = text;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
            string = string2;
            n2 = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            suffix = string4;
            string = text;
            n2 = 0;
            n = 0;
            String string5 = string.substring(n2, position);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            text = string5;
        }
        if (prefix == null) {
            this.searchTextField.setTextIgnoreEvents(text + value + suffix);
        } else if (StringUtil.startsWithIgnoreCase((String)value, (String)prefix) || StringUtil.startsWithIgnoreCase((String)value, (String)("\"" + prefix))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string6 = text;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"text");
            string = string6;
            n2 = 0;
            n = text.length() - prefix.length();
            boolean bl = false;
            String string7 = string;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.searchTextField.setTextIgnoreEvents(stringBuilder.append(string8).append(value).append(suffix).toString());
        } else {
            this.searchTextField.setTextIgnoreEvents(text + value + suffix);
        }
        JBTextField jBTextField = this.searchTextField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"searchTextField.textEditor");
        jBTextField.setCaretPosition(this.searchTextField.getText().length() - suffix.length());
    }

    public final boolean handleEnter(@NotNull KeyEvent event) {
        JList<String> popupList;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
        JList<String> jList = popupList = endpointsSearchPopup != null ? endpointsSearchPopup.getList() : null;
        if (popupList != null && popupList.getSelectedIndex() != -1) {
            popupList.dispatchEvent(event);
            return true;
        }
        return false;
    }

    public final boolean handleUpDown(@NotNull KeyEvent event) {
        JList<String> popupList;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EndpointsSearchPopup endpointsSearchPopup = this.searchPopup;
        JList<String> jList = popupList = endpointsSearchPopup != null ? endpointsSearchPopup.getList() : null;
        if (popupList != null) {
            if (event.getKeyCode() == 40 && popupList.getSelectedIndex() == -1) {
                popupList.setSelectedIndex(0);
            } else {
                popupList.dispatchEvent(event);
            }
            return true;
        }
        this.endpointsList.dispatchEvent(event);
        return true;
    }

    public EndpointsSearchPopupController(@NotNull Project project, @NotNull EndpointsProjectModel model, @NotNull EndpointsSearchTextField searchTextField2, @NotNull JList<?> endpointsList) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)((Object)searchTextField2), (String)"searchTextField");
        Intrinsics.checkNotNullParameter(endpointsList, (String)"endpointsList");
        this.project = project;
        this.model = model;
        this.searchTextField = searchTextField2;
        this.endpointsList = endpointsList;
    }

    public static final /* synthetic */ void access$appendSearchText(EndpointsSearchPopupController $this, String originalValue, String prefix) {
        $this.appendSearchText(originalValue, prefix);
    }

    public static final /* synthetic */ void access$handleShowAttributeValuesPopup(EndpointsSearchPopupController $this, String name, String valuePrefix, int caretPosition) {
        $this.handleShowAttributeValuesPopup(name, valuePrefix, caretPosition);
    }

    public static final /* synthetic */ EndpointsSearchTextField access$getSearchTextField$p(EndpointsSearchPopupController $this) {
        return $this.searchTextField;
    }

    public static final /* synthetic */ void access$handleShowPopupForQuery(EndpointsSearchPopupController $this) {
        $this.handleShowPopupForQuery();
    }

    public static final /* synthetic */ EndpointsSearchPopup access$getSearchPopup$p(EndpointsSearchPopupController $this) {
        return $this.searchPopup;
    }

    public static final /* synthetic */ void access$setSearchPopup$p(EndpointsSearchPopupController $this, EndpointsSearchPopup endpointsSearchPopup) {
        $this.searchPopup = endpointsSearchPopup;
    }
}

