/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.EndpointsListItem;
import com.intellij.microservices.ui.flat.FlatEndpointItem;
import com.intellij.microservices.ui.flat.LoadingMoreItem;
import com.intellij.microservices.ui.flat.ModuleItem;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J8\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsListRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/microservices/ui/flat/EndpointsListItem;", "project", "Lcom/intellij/openapi/project/Project;", "isCompact", "", "(Lcom/intellij/openapi/project/Project;Z)V", "frameworkLabel", "Lcom/intellij/ui/components/JBLabel;", "itemRootPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "loadingRootPanel", "Ljavax/swing/JPanel;", "locationLabel", "moduleLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "moduleRootPanel", "presentableTextLabel", "typeLabel", "applyDeprecatedStyle", "Lcom/intellij/ui/SimpleTextAttributes;", "textAttributes", "deprecated", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "cellHasFocus", "intellij.microservices.ui"})
public final class EndpointsListRenderer
implements ListCellRenderer<EndpointsListItem> {
    private final BorderLayoutPanel itemRootPanel;
    private final SimpleColoredComponent presentableTextLabel;
    private final JBLabel locationLabel;
    private final JBLabel typeLabel;
    private final JBLabel frameworkLabel;
    private final JPanel moduleRootPanel;
    private final SimpleColoredComponent moduleLabel;
    private final JPanel loadingRootPanel;
    private final Project project;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends EndpointsListItem> list, @NotNull EndpointsListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        EndpointsListItem endpointsListItem;
        block8: {
            block10: {
                Color color;
                BorderLayoutPanel borderLayoutPanel;
                block12: {
                    Color rowColor;
                    block11: {
                        block9: {
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            endpointsListItem = value;
                            if (!(endpointsListItem instanceof FlatEndpointItem)) break block8;
                            this.presentableTextLabel.clear();
                            this.presentableTextLabel.setIcon(((FlatEndpointItem)value).getIcon());
                            String string = ((FlatEndpointItem)value).getPresentableText();
                            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
                            this.presentableTextLabel.append(string, this.applyDeprecatedStyle(simpleTextAttributes, ((FlatEndpointItem)value).isDeprecated()), true);
                            String method = ((FlatEndpointItem)value).getMethod();
                            if (method != null) {
                                String string2 = ' ' + method;
                                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
                                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES");
                                this.presentableTextLabel.append(string2, this.applyDeprecatedStyle(simpleTextAttributes2, ((FlatEndpointItem)value).isDeprecated()));
                            }
                            this.locationLabel.setText(((FlatEndpointItem)value).getLocationString());
                            this.typeLabel.setText((String)((FlatEndpointItem)value).getProvider().getEndpointType().getLocalizedMessage().get());
                            this.frameworkLabel.setText(((FlatEndpointItem)value).getFrameworkPresentation().getTitle());
                            if (!isSelected) break block9;
                            this.itemRootPanel.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list, true, true));
                            break block10;
                        }
                        Color bgColor = ((FlatEndpointItem)value).getFileBgColor();
                        rowColor = ListUiUtil.WithTallRow.INSTANCE.alternativeBackground(false, cellHasFocus);
                        borderLayoutPanel = this.itemRootPanel;
                        color = bgColor;
                        if (color == null) break block11;
                        Color color2 = color;
                        boolean bl = false;
                        boolean bl2 = false;
                        Color color3 = color2;
                        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
                        boolean bl3 = false;
                        Color color4 = ColorUtil.mix((Color)bgColor, (Color)rowColor, (double)0.5);
                        borderLayoutPanel = borderLayoutPanel2;
                        color = color4;
                        if (color != null) break block12;
                    }
                    color = rowColor;
                }
                borderLayoutPanel.setBackground(color);
            }
            this.presentableTextLabel.setBackground(this.itemRootPanel.getBackground());
            return (Component)this.itemRootPanel;
        }
        if (endpointsListItem instanceof ModuleItem) {
            this.moduleLabel.clear();
            Object object = ((ModuleItem)value).getModule();
            if (object == null || (object = object.getIcon()) == null) {
                object = AllIcons.Nodes.Module;
            }
            this.moduleLabel.setIcon((Icon)object);
            Object object2 = ((ModuleItem)value).getModule();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = MicroservicesUiBundle.message("endpoints.filters.module.external", new Object[0]);
            }
            this.moduleLabel.append((String)object2);
            this.moduleRootPanel.setBackground(isSelected ? ListUiUtil.WithTallRow.INSTANCE.background(list, true, true) : JBColor.PanelBackground);
            this.moduleLabel.setBackground(this.moduleRootPanel.getBackground());
            return this.moduleRootPanel;
        }
        if (endpointsListItem instanceof LoadingMoreItem) {
            return this.loadingRootPanel;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final SimpleTextAttributes applyDeprecatedStyle(SimpleTextAttributes textAttributes, boolean deprecated) {
        return deprecated ? new SimpleTextAttributes(textAttributes.getStyle() | 4, textAttributes.getFgColor()) : textAttributes;
    }

    static /* synthetic */ SimpleTextAttributes applyDeprecatedStyle$default(EndpointsListRenderer endpointsListRenderer, SimpleTextAttributes simpleTextAttributes, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
            simpleTextAttributes = simpleTextAttributes2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return endpointsListRenderer.applyDeprecatedStyle(simpleTextAttributes, bl);
    }

    public EndpointsListRenderer(@NotNull Project project, boolean isCompact) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.itemRootPanel = new BorderLayoutPanel();
        this.presentableTextLabel = new SimpleColoredComponent();
        this.locationLabel = new JBLabel();
        this.typeLabel = new JBLabel();
        this.frameworkLabel = new JBLabel();
        this.moduleRootPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.moduleLabel = new SimpleColoredComponent();
        this.loadingRootPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.itemRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.presentableTextLabel.setTransparentIconBackground(true);
        this.itemRootPanel.addToCenter((Component)this.presentableTextLabel);
        this.itemRootPanel.addToRight((Component)this.locationLabel);
        if (!isCompact) {
            NonOpaquePanel bottomPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
            bottomPanel.add((Component)this.typeLabel);
            bottomPanel.add((Component)this.frameworkLabel);
            this.itemRootPanel.addToBottom((Component)bottomPanel);
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAYED_ATTRIBUTES");
        Color grayedFgColor = simpleTextAttributes.getFgColor();
        this.typeLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        this.typeLabel.setForeground(grayedFgColor);
        this.locationLabel.setForeground(grayedFgColor);
        this.frameworkLabel.setForeground(grayedFgColor);
        this.frameworkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.moduleLabel.setTransparentIconBackground(true);
        this.moduleRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.moduleRootPanel.add((Component)this.moduleLabel);
        JBLabel loadingMoreLabel = new JBLabel(MicroservicesUiBundle.message("endpoints.loading.text", new Object[0]));
        loadingMoreLabel.setForeground(grayedFgColor);
        loadingMoreLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        this.loadingRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.loadingRootPanel.setBackground(ListUiUtil.WithTallRow.INSTANCE.alternativeBackground(false, false));
        this.loadingRootPanel.add((Component)loadingMoreLabel);
    }
}

