/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b \u0018\u00002\u00020\u0001:\u0002%&B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH$J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0003H'J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsFilterField;", "Ljavax/swing/JPanel;", "message", "", "(Ljava/lang/String;)V", "nameLabel", "Ljavax/swing/JLabel;", "popupState", "Lcom/intellij/ui/popup/PopupState;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "valueLabel", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "createFocusedBorder", "Ljavax/swing/border/Border;", "createPopupMenu", "Lcom/intellij/openapi/ui/popup/ListPopup;", "createUnfocusedBorder", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getCurrentText", "getDefaultNameForeground", "Ljava/awt/Color;", "getDefaultSelectorForeground", "indicateFocusing", "", "indicateHovering", "initUi", "setDefaultForeground", "setOnHoverForeground", "showPopupMenu", "showPopupMenuFromKeyboard", "showPopupMenuOnClick", "wrapBorder", "outerBorder", "AccessiblePopupComponent", "FilledRoundedBorder", "intellij.microservices.ui"})
public abstract class EndpointsFilterField
extends JPanel {
    private final PopupState<JBPopup> popupState;
    private final JLabel nameLabel;
    private final JLabel valueLabel;

    private final void initUi() {
        this.setFocusable(true);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(this.wrapBorder(this.createUnfocusedBorder()));
        this.add(this.nameLabel);
        this.add(this.valueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.nameLabel.setForeground(this.getDefaultNameForeground());
        this.valueLabel.setForeground(this.getDefaultSelectorForeground());
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
    }

    @NotNull
    protected abstract ActionGroup createActionGroup();

    @Nls
    @Nullable
    public abstract String getCurrentText();

    private final void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setBorder(EndpointsFilterField.access$wrapBorder(this.this$0, EndpointsFilterField.access$createFocusedBorder(this.this$0)));
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setBorder(EndpointsFilterField.access$wrapBorder(this.this$0, this.this$0.createUnfocusedBorder()));
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    EndpointsFilterField.access$showPopupMenu(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void showPopupMenuOnClick() {
        new ClickListener(this){
            final /* synthetic */ EndpointsFilterField this$0;

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EndpointsFilterField.access$showPopupMenu(this.this$0);
                return true;
            }
            {
                this.this$0 = this$0;
            }
        }.installOn((Component)this);
    }

    private final void indicateHovering() {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EndpointsFilterField.access$setOnHoverForeground(this.this$0);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                EndpointsFilterField.access$setDefaultForeground(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void showPopupMenu() {
        if (this.popupState.isRecentlyHidden()) {
            return;
        }
        ListPopup popup = this.createPopupMenu();
        this.popupState.prepareToShow((Object)popup);
        AutoPopupSupportingListener.installOn((JBPopup)((JBPopup)popup));
        popup.showUnderneathOf((Component)this);
    }

    private final void setDefaultForeground() {
        this.nameLabel.setForeground(this.getDefaultNameForeground());
        this.valueLabel.setForeground(this.getDefaultSelectorForeground());
    }

    private final Color getDefaultNameForeground() {
        Color color;
        if (StartupUiUtil.isUnderDarcula()) {
            Color color2 = UIUtil.getLabelForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getLabelForeground()");
        } else {
            Color color3 = UIUtil.getInactiveTextColor();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"UIUtil.getInactiveTextColor()");
        }
        return color;
    }

    private final Color getDefaultSelectorForeground() {
        Color color;
        if (StartupUiUtil.isUnderDarcula()) {
            Color color2 = UIUtil.getLabelForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getLabelForeground()");
        } else {
            Color color3 = UIUtil.getInactiveTextColor().darker().darker();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"UIUtil.getInactiveTextColor().darker().darker()");
        }
        return color;
    }

    private final void setOnHoverForeground() {
        this.nameLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.valueLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private final Border createFocusedBorder() {
        Color color = UIUtil.getFocusedBorderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"UIUtil.getFocusedBorderColor()");
        return new FilledRoundedBorder(color, 10, 2);
    }

    @NotNull
    protected Border createUnfocusedBorder() {
        Border border = JBUI.Borders.empty((int)2);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"JBUI.Borders.empty(2)");
        return border;
    }

    private final Border wrapBorder(Border outerBorder) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outerBorder, JBUI.Borders.empty((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)compoundBorder, (String)"BorderFactory.createComp\u2026r, JBUI.Borders.empty(2))");
        return compoundBorder;
    }

    private final ListPopup createPopupMenu() {
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026onAid.SPEEDSEARCH, false)");
        return listPopup;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleContext accessibleContext = super.getAccessibleContext();
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"super.getAccessibleContext()");
            this.accessibleContext = (AccessibleContext)((Object)new AccessiblePopupComponent(accessibleContext));
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    public EndpointsFilterField(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PopupState popupState = PopupState.forPopup();
        Intrinsics.checkNotNullExpressionValue((Object)popupState, (String)"PopupState.forPopup()");
        this.popupState = popupState;
        this.nameLabel = new JLabel(message + ": ");
        this.valueLabel = new JLabel(this){
            final /* synthetic */ EndpointsFilterField this$0;

            @Nullable
            public String getText() {
                return this.this$0.getCurrentText();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.initUi();
    }

    public static final /* synthetic */ Border access$wrapBorder(EndpointsFilterField $this, Border outerBorder) {
        return $this.wrapBorder(outerBorder);
    }

    public static final /* synthetic */ Border access$createFocusedBorder(EndpointsFilterField $this) {
        return $this.createFocusedBorder();
    }

    public static final /* synthetic */ void access$showPopupMenu(EndpointsFilterField $this) {
        $this.showPopupMenu();
    }

    public static final /* synthetic */ void access$setOnHoverForeground(EndpointsFilterField $this) {
        $this.setOnHoverForeground();
    }

    public static final /* synthetic */ void access$setDefaultForeground(EndpointsFilterField $this) {
        $this.setDefaultForeground();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsFilterField$AccessiblePopupComponent;", "Lcom/intellij/util/ui/accessibility/AccessibleContextDelegate;", "context", "Ljavax/accessibility/AccessibleContext;", "(Lcom/intellij/microservices/ui/flat/EndpointsFilterField;Ljavax/accessibility/AccessibleContext;)V", "getAccessibleName", "", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getDelegateParent", "Ljava/awt/Container;", "intellij.microservices.ui"})
    private final class AccessiblePopupComponent
    extends AccessibleContextDelegate {
        @Nullable
        protected Container getDelegateParent() {
            return null;
        }

        @NotNull
        public String getAccessibleName() {
            Object[] objectArray = new Object[2];
            String string = EndpointsFilterField.this.nameLabel.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameLabel.text");
            objectArray[0] = string;
            String string2 = EndpointsFilterField.this.valueLabel.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"valueLabel.text");
            objectArray[1] = string2;
            return MicroservicesUiBundle.message("endpoints.accessibility.filter.label", objectArray);
        }

        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.POPUP_MENU;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"AccessibleRole.POPUP_MENU");
            return accessibleRole;
        }

        public AccessiblePopupComponent(AccessibleContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsFilterField$FilledRoundedBorder;", "Ljavax/swing/border/Border;", "myColor", "Ljava/awt/Color;", "myArcSize", "", "myThickness", "(Ljava/awt/Color;II)V", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "intellij.microservices.ui"})
    private static final class FilledRoundedBorder
    implements Border {
        private final Color myColor;
        private final int myArcSize;
        private final int myThickness;

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.myColor);
            int thickness = JBUI.scale((int)this.myThickness);
            int arcSize = JBUI.scale((int)this.myArcSize);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, arcSize, arcSize));
            int innerArc = RangesKt.coerceAtLeast((int)(arcSize - thickness), (int)0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + thickness, y + thickness, width - 2 * thickness, height - 2 * thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config.restore();
        }

        @Override
        @NotNull
        public Insets getBorderInsets(@NotNull Component c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            JBInsets jBInsets = JBUI.insets((int)this.myThickness);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"JBUI.insets(myThickness)");
            return (Insets)jBInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        public FilledRoundedBorder(@NotNull Color myColor, int myArcSize, int myThickness) {
            Intrinsics.checkNotNullParameter((Object)myColor, (String)"myColor");
            this.myColor = myColor;
            this.myArcSize = myArcSize;
            this.myThickness = myThickness;
        }
    }
}

