/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/microservices/ui/flat/DefaultEndpointsProjectModel;", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "()V", "groupByModuleTitleFull", "", "getGroupByModuleTitleFull", "()Ljava/lang/String;", "groupByModuleTitleShort", "getGroupByModuleTitleShort", "moduleDisplayName", "getModuleDisplayName", "moduleQueryTag", "getModuleQueryTag", "selectModulesTitle", "getSelectModulesTitle", "createFilter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "entity", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "fromLibraries", "", "fromTests", "getModuleEntities", "", "project", "Lcom/intellij/openapi/project/Project;", "isTestModule", "DefaultEndpointsModule", "intellij.microservices.ui"})
public final class DefaultEndpointsProjectModel
implements EndpointsProjectModel {
    @NotNull
    public String getModuleQueryTag() {
        return "module";
    }

    @NotNull
    public String getModuleDisplayName() {
        return MicroservicesUiBundle.message("endpoints.filters.module", new Object[0]);
    }

    @NotNull
    public String getSelectModulesTitle() {
        return MicroservicesUiBundle.message("endpoints.filters.module.title", new Object[0]);
    }

    @NotNull
    public String getGroupByModuleTitleShort() {
        return MicroservicesUiBundle.message("endpoints.show.modules", new Object[0]);
    }

    @NotNull
    public String getGroupByModuleTitleFull() {
        return MicroservicesUiBundle.message("endpoints.show.modules.full", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<EndpointsModuleEntity> getModuleEntities(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$map$iv = moduleArray;
        boolean $i$f$map = false;
        Module[] moduleArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            DefaultEndpointsModule defaultEndpointsModule = new DefaultEndpointsModule((Module)v2);
            collection.add(defaultEndpointsModule);
        }
        return (List)destination$iv$iv;
    }

    public boolean isTestModule(@NotNull EndpointsModuleEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return StringsKt.endsWith$default((String)entity.getName(), (String)".test", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)entity.getName(), (String)".native-test", (boolean)false, (int)2, null);
    }

    @NotNull
    public EndpointsFilter createFilter(@NotNull EndpointsModuleEntity entity, boolean fromLibraries, boolean fromTests) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Module module = ((DefaultEndpointsModule)entity).getModule();
        return (EndpointsFilter)new ModuleEndpointsFilter(module, fromLibraries, fromTests);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/ui/flat/DefaultEndpointsProjectModel$DefaultEndpointsModule;", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getModule", "()Lcom/intellij/openapi/module/Module;", "name", "", "getName", "()Ljava/lang/String;", "intellij.microservices.ui"})
    private static final class DefaultEndpointsModule
    implements EndpointsModuleEntity {
        @NotNull
        private final Module module;

        @NotNull
        public String getName() {
            String string = this.module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.Module;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Nodes.Module");
            return icon;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        public DefaultEndpointsModule(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
        }
    }
}

