/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQSeedElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0012B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J&\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/ui/diagrams/serialization/MsDiagramElementJsonConverter;", "Lcom/google/gson/JsonSerializer;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;", "Lcom/google/gson/JsonDeserializer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "Companion", "intellij.microservices.ui"})
public final class MsDiagramElementJsonConverter
implements JsonSerializer<MsDiagramElement>,
JsonDeserializer<MsDiagramElement> {
    private final Project project;
    private static final String TYPE_TAG_PROPERTY = "typeTag";
    private static final String MODULE_NAME_PROPERTY = "moduleName";
    private static final String AUTHORITY_PROPERTY = "urlAuthority";
    private static final String MQ_DESTINATION_PROPERTY = "mqDestination";
    private static final String MQ_DESTINATIONS_PROPERTY = "mqDestinations";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public JsonElement serialize(@Nullable MsDiagramElement src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        Intrinsics.checkNotNull((Object)src);
        JsonObject jsonObject = new JsonObject();
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$apply = jsonObject;
        boolean bl3 = false;
        $this$apply.addProperty(TYPE_TAG_PROPERTY, src.getClass().getName());
        MsDiagramElement msDiagramElement = src;
        if (msDiagramElement instanceof MsDiagramMQSeedElement) {
            JsonSerializationContext jsonSerializationContext = context;
            Intrinsics.checkNotNull((Object)jsonSerializationContext);
            $this$apply.add(MQ_DESTINATIONS_PROPERTY, jsonSerializationContext.serialize(((MsDiagramMQSeedElement)src).getDestinationsToDisplay()));
        } else if (!(msDiagramElement instanceof MsDiagramWholeProjectSeed)) {
            if (msDiagramElement instanceof MsDiagramMQDestination) {
                JsonSerializationContext jsonSerializationContext = context;
                Intrinsics.checkNotNull((Object)jsonSerializationContext);
                $this$apply.add(MQ_DESTINATION_PROPERTY, jsonSerializationContext.serialize((Object)((MsDiagramMQDestination)src).getDestination(), (Type)((Object)MQDestination.class)));
            } else if (msDiagramElement instanceof MsDiagramWebservice) {
                $this$apply.addProperty(MODULE_NAME_PROPERTY, src.getName());
            } else if (msDiagramElement instanceof MsDiagramExternalEndpoint) {
                $this$apply.addProperty(AUTHORITY_PROPERTY, ((MsDiagramExternalEndpoint)src).getAuthority());
            }
        }
        return (JsonElement)jsonObject;
    }

    @Nullable
    public MsDiagramElement deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        MsDiagramElement msDiagramElement;
        JsonElement jsonElement = json;
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonObject obj = jsonElement.getAsJsonObject();
        JsonElement jsonElement2 = obj.get(TYPE_TAG_PROPERTY);
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"obj.get(TYPE_TAG_PROPERTY)");
        String string = jsonElement2.getAsString();
        if (Intrinsics.areEqual((Object)string, (Object)MsDiagramMQSeedElement.class.getName())) {
            JsonDeserializationContext jsonDeserializationContext = context;
            Intrinsics.checkNotNull((Object)jsonDeserializationContext);
            JsonElement jsonElement3 = obj.get(MQ_DESTINATIONS_PROPERTY);
            TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)ArrayList.class)), (Type[])new Type[]{(Type)((Object)MQDestination.class)});
            Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"TypeToken.getParameteriz\u2026QDestination::class.java)");
            Object object = jsonDeserializationContext.deserialize(jsonElement3, typeToken.getType());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context!!.deserialize(\n \u2026nation::class.java).type)");
            msDiagramElement = new MsDiagramMQSeedElement(this.project, null, (Collection)object);
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramWholeProjectSeed.class.getName())) {
            msDiagramElement = new MsDiagramWholeProjectSeed(this.project);
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramMQDestination.class.getName())) {
            JsonDeserializationContext jsonDeserializationContext = context;
            Intrinsics.checkNotNull((Object)jsonDeserializationContext);
            Object object = jsonDeserializationContext.deserialize(obj.get(MQ_DESTINATION_PROPERTY), (Type)((Object)MQDestination.class));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context!!.deserialize(ob\u2026QDestination::class.java)");
            msDiagramElement = new MsDiagramMQDestination(this.project, (MQDestination)object, CollectionsKt.emptyList());
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramWebservice.class.getName())) {
            MsDiagramWebservice msDiagramWebservice;
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
            JsonElement jsonElement4 = obj.get(MODULE_NAME_PROPERTY);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"obj.get(MODULE_NAME_PROPERTY)");
            Module module = moduleManager.findModuleByName(jsonElement4.getAsString());
            if (module != null) {
                Module module2 = module;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module2;
                boolean bl3 = false;
                Module module3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
                msDiagramWebservice = new MsDiagramWebservice(module3);
            } else {
                msDiagramWebservice = null;
            }
            msDiagramElement = msDiagramWebservice;
        } else if (Intrinsics.areEqual((Object)string, (Object)MsDiagramExternalEndpoint.class.getName())) {
            JsonElement jsonElement5 = obj.get(AUTHORITY_PROPERTY);
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"obj.get(AUTHORITY_PROPERTY)");
            String string2 = jsonElement5.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"obj.get(AUTHORITY_PROPERTY).asString");
            msDiagramElement = new MsDiagramExternalEndpoint(this.project, string2, null);
        } else {
            msDiagramElement = null;
        }
        return msDiagramElement;
    }

    public MsDiagramElementJsonConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/ui/diagrams/serialization/MsDiagramElementJsonConverter$Companion;", "", "()V", "AUTHORITY_PROPERTY", "", "MODULE_NAME_PROPERTY", "MQ_DESTINATIONS_PROPERTY", "MQ_DESTINATION_PROPERTY", "TYPE_TAG_PROPERTY", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

