/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQResolverManager;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.UnknownMQProviderType;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQSeedElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestToMQueue;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToMQSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "()V", "search", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "searchForRequestsFormingAnEdge", "", "edge", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "Companion", "intellij.microservices.ui"})
public final class RequestsToMQSearcher
implements RequestsSearcher {
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> search(@NotNull MsDiagramSeed seed, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$mapValuesTo$iv$iv;
        MsDiagramEndpoint msDiagramEndpoint;
        Module module;
        Object object;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv;
        Object answer$iv$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Module $this$groupBy$iv;
        void project;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramSeed msDiagramSeed = seed;
        if (msDiagramSeed instanceof MsDiagramMQSeedElement) {
            pair = new Pair((Object)((MsDiagramMQSeedElement)seed).getProject(), (Object)((MQDestination)CollectionsKt.first((Iterable)((MsDiagramMQSeedElement)seed).getDestinationsToDisplay())).getType());
        } else if (msDiagramSeed instanceof MsDiagramWholeProjectSeed) {
            pair = new Pair((Object)((MsDiagramWholeProjectSeed)seed).getProject(), (Object)UnknownMQProviderType.INSTANCE);
        } else {
            String string = "Unknown seed " + seed;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Pair pair2 = pair;
        Project project2 = (Project)pair2.component1();
        MQType mqTypeToSearch = (MQType)pair2.component2();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(MicroservicesUiBundle.message("microservices.diagrams.webservices.searching.mq.requests", new Object[0]));
        }
        boolean $i$f$runReadAction = false;
        Module moduleToMQUsages2 = RequestsSearcher.Companion.resolveAllAndGroupByModules((Sequence)ApplicationManager.getApplication().runReadAction(new Computable((Project)project, mqTypeToSearch){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ MQType $mqTypeToSearch$inlined;
            {
                this.$project$inlined = project;
                this.$mqTypeToSearch$inlined = mQType;
            }

            public final T compute() {
                boolean bl = false;
                return (T)MQResolverManager.Companion.getInstance(this.$project$inlined).getAllVariants(this.$mqTypeToSearch$inlined);
            }
        }), indicator, search.moduleToMQUsages.2.INSTANCE);
        Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)moduleToMQUsages2.values()));
        boolean $i$f$groupBy = false;
        void var10_15 = $this$groupBy$iv;
        Module destination$iv$iv = (Module)new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MQTargetInfo it = (MQTargetInfo)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getDestination();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void destination;
            void $dstr$destination$usages;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = value$iv$iv$iv;
            module = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            void var23_45 = $dstr$destination$usages;
            boolean bl4 = false;
            MQDestination mQDestination = (MQDestination)var23_45.getKey();
            var23_45 = $dstr$destination$usages;
            bl4 = false;
            List usages = (List)var23_45.getValue();
            msDiagramEndpoint = new MsDiagramMQDestination((Project)project, (MQDestination)destination, usages);
            module.put(object, msDiagramEndpoint);
        }
        Module destinationToMQElement = destination$iv$iv;
        Module $this$mapValues$iv2 = moduleToMQUsages2;
        boolean $i$f$mapValues2 = false;
        destination$iv$iv = $this$mapValues$iv2;
        Module destination$iv$iv2 = (Module)new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Map.Entry $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        Iterator iterator = $this$associateByTo$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void $dstr$module$_u24__u24;
            void it$iv$iv;
            Object element$iv$iv$iv = iterator.next();
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Module module2 = destination$iv$iv2;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            object = k;
            module = module2;
            boolean bl5 = false;
            void var24_50 = $dstr$module$_u24__u24;
            boolean bl6 = false;
            Module module3 = (Module)var24_50.getKey();
            msDiagramEndpoint = new MsDiagramWebservice(module3);
            module.put(object, msDiagramEndpoint);
        }
        Module moduleToWebservice = destination$iv$iv2;
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf(moduleToWebservice.values());
        destination$iv$iv2 = moduleToMQUsages2;
        $i$f$mapValuesTo2 = false;
        Iterator iterator2 = destination$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void module4;
            Map.Entry entry;
            $this$associateByTo$iv$iv$iv2 = entry = iterator2.next();
            $i$f$associateByTo2 = false;
            destination$iv$iv2 = (Module)$this$associateByTo$iv$iv$iv2.getKey();
            $this$associateByTo$iv$iv$iv2 = entry;
            $i$f$associateByTo2 = false;
            List usages = $this$associateByTo$iv$iv$iv2.getValue();
            Object v = moduleToWebservice.get(module4);
            Intrinsics.checkNotNull(v);
            MsDiagramWebservice webservice = (MsDiagramWebservice)v;
            if (!searchParams.getFromTests() && webservice.getContainsTestsOnly()) continue;
            for (MQTargetInfo usage : usages) {
                Object v2 = destinationToMQElement.get(usage.getDestination());
                Intrinsics.checkNotNull(v2);
                MsDiagramMQDestination target = (MsDiagramMQDestination)v2;
                requestsGraph.addEdge((Object)webservice, (Object)target, (Object)new RequestToMQueue(webservice, target, usage));
            }
        }
        return (Network)requestsGraph;
    }

    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source instanceof MsDiagramWebservice && target instanceof MsDiagramMQDestination && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        return edge.getRequests();
    }

    static {
        Companion = new Companion(null);
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])new MsDiagramRelationship[]{MsDiagramRelationshipsKt.ADMINISTRATION_RELATIONSHIP, MsDiagramRelationshipsKt.RECEIVE_RELATIONSHIP, MsDiagramRelationshipsKt.SEND_RELATIONSHIP, MsDiagramRelationshipsKt.SEND_AND_RECEIVE_RELATIONSHIP, MsDiagramRelationshipsKt.STREAM_FORWARD_RELATIONSHIP, MsDiagramRelationshipsKt.UNKNOWN_RELATIONSHIP});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher$Companion;", "", "()V", "SUPPORTED_RELATIONSHIPS", "", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

