/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestToExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToExternalEndpointsSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.TaperingScope;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005JJ\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00140\u0013H\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JV\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0003H\u0016J\r\u0010$\u001a\u00070\u0004\u00a2\u0006\u0002\b%H\u0016J(\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006+"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "internalAuthorities", "", "", "(Ljava/util/Set;)V", "isToExternalService", "", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "(Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;)Z", "createRequestsGraph", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "clientModules", "", "Lcom/intellij/openapi/module/Module;", "serverModules", "moduleToRequests", "", "", "findRawUrlsInCode", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/url/references/UrlPathReference;", "modulesToSearchIn", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "findRequestsToEndpointUrls", "moduleToEndpoints", "Lcom/intellij/microservices/url/UrlTargetInfo;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getEndpointTypesToSearch", "Lcom/intellij/microservices/endpoints/EndpointType;", "getIndicatorText", "Lorg/jetbrains/annotations/Nls;", "searchForRequestsFormingAnEdge", "edge", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "Companion", "RequestToUrl", "intellij.microservices.ui"})
public final class RequestsToExternalEndpointsSearcher
extends RequestsToEndpointUrlsSearcher {
    private final Set<String> internalAuthorities;
    private static final Set<EndpointType> CLIENT_ENDPOINT_TYPES;
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;
    private static final List<String> URL_FOOTPRINTS;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getIndicatorText() {
        return MicroservicesUiBundle.message("microservices.diagrams.webservices.searching.external.http.requests", new Object[0]);
    }

    @Override
    @NotNull
    public Set<EndpointType> getEndpointTypesToSearch() {
        return CLIENT_ENDPOINT_TYPES;
    }

    private final boolean isToExternalService(RequestToUrl $this$isToExternalService) {
        boolean bl;
        block8: {
            RequestToUrl requestToUrl = $this$isToExternalService;
            if (requestToUrl instanceof RequestToUrl.WithKnownTargetInfo) {
                Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((RequestToUrl.WithKnownTargetInfo)$this$isToExternalService).getInfo().getAuthorities()), (Function1)isToExternalService.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!this.internalAuthorities.contains(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            } else if (requestToUrl instanceof RequestToUrl.WithKnownPathReference) {
                Iterable $this$any$iv = ((RequestToUrl.WithKnownPathReference)$this$isToExternalService).getRef().getContext().getAuthorities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!(!this.internalAuthorities.contains(it))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> clientModules, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> moduleToEndpoints, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$forEach$iv;
        Module key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(clientModules, (String)"clientModules");
        Intrinsics.checkNotNullParameter(moduleToEndpoints, (String)"moduleToEndpoints");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        boolean bl = false;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map $this$apply = map;
        boolean bl4 = false;
        Sequence $this$mapValuesTo$iv = moduleToEndpoints;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $dstr$_u24__u24$targetInfos;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = $this$apply;
            boolean bl5 = false;
            Object k = it$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl6 = false;
            void var26_36 = $dstr$_u24__u24$targetInfos;
            boolean bl7 = false;
            List targetInfos = (List)var26_36.getValue();
            List list = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)targetInfos), (Function1)findRequestsToEndpointUrls.moduleToUrls.1.1.1.INSTANCE), (Function1)((Function1)new Function1<RequestToUrl.WithKnownTargetInfo, Boolean>(this, (Map)moduleToEndpoints, clientModules, project, searchParams){
                final /* synthetic */ RequestsToExternalEndpointsSearcher this$0;
                final /* synthetic */ Map $moduleToEndpoints$inlined;
                final /* synthetic */ List $clientModules$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ RequestsSearcher.SearchParams $searchParams$inlined;
                {
                    this.this$0 = requestsToExternalEndpointsSearcher;
                    this.$moduleToEndpoints$inlined = map;
                    this.$clientModules$inlined = list;
                    this.$project$inlined = project;
                    this.$searchParams$inlined = searchParams;
                    super(1);
                }

                public final boolean invoke(@NotNull RequestToUrl.WithKnownTargetInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return RequestsToExternalEndpointsSearcher.access$isToExternalService$p(this.this$0, it);
                }
            })));
            map3.put(k2, list);
        }
        $this$mapValuesTo$iv = SequencesKt.filter((Sequence)SequencesKt.map(this.findRawUrlsInCode((Iterable<? extends Module>)clientModules, project, searchParams), (Function1)findRequestsToEndpointUrls.moduleToUrls.1.2.INSTANCE), (Function1)((Function1)new Function1<RequestToUrl.WithKnownPathReference, Boolean>(this, moduleToEndpoints, clientModules, project, searchParams){
            final /* synthetic */ RequestsToExternalEndpointsSearcher this$0;
            final /* synthetic */ Map $moduleToEndpoints$inlined;
            final /* synthetic */ List $clientModules$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ RequestsSearcher.SearchParams $searchParams$inlined;
            {
                this.this$0 = requestsToExternalEndpointsSearcher;
                this.$moduleToEndpoints$inlined = map;
                this.$clientModules$inlined = list;
                this.$project$inlined = project;
                this.$searchParams$inlined = searchParams;
                super(1);
            }

            public final boolean invoke(@NotNull RequestToUrl.WithKnownPathReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RequestsToExternalEndpointsSearcher.access$isToExternalService$p(this.this$0, it) && !StringUtil.isEmpty((String)it.getAuthority());
            }
        }));
        boolean $i$f$groupBy = false;
        $this$associateByTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RequestToUrl.WithKnownPathReference it = (RequestToUrl.WithKnownPathReference)element$iv$iv;
            boolean bl8 = false;
            boolean $i$f$runReadAction = false;
            key$iv$iv = (Module)ApplicationManager.getApplication().runReadAction(new Computable(it){
                final /* synthetic */ RequestToUrl.WithKnownPathReference $it$inlined;
                {
                    this.$it$inlined = withKnownPathReference;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)ModuleUtil.findModuleForPsiElement((PsiElement)this.$it$inlined.getRef().getElement());
                }
            });
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl9 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        void var14_14 = $this$forEach$iv;
        boolean bl10 = false;
        Iterator iterator = var14_14.entrySet().iterator();
        while (iterator.hasNext()) {
            void module;
            Map.Entry element$iv;
            Map.Entry $dstr$module$urls = element$iv = iterator.next();
            boolean bl11 = false;
            Map.Entry entry = $dstr$module$urls;
            boolean bl12 = false;
            key$iv$iv = (Module)entry.getKey();
            entry = $dstr$module$urls;
            bl12 = false;
            List urls = (List)entry.getValue();
            void v1 = module;
            if (v1 == null) continue;
            entry = v1;
            bl12 = false;
            boolean bl13 = false;
            Map.Entry it = entry;
            boolean bl14 = false;
            $this$apply.compute(it, new BiFunction(urls, $this$apply){
                final /* synthetic */ List $urls$inlined;
                final /* synthetic */ Map $this_apply$inlined;
                {
                    this.$urls$inlined = list;
                    this.$this_apply$inlined = map;
                }

                @Nullable
                public final List<RequestToUrl> apply(@NotNull Module $noName_0, @Nullable List<RequestToUrl> acc) {
                    List list;
                    block3: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                            list = acc;
                            if (list == null) break block2;
                            List list2 = list;
                            boolean bl = false;
                            boolean bl2 = false;
                            List $this$apply = list2;
                            boolean bl3 = false;
                            $this$apply.addAll(this.$urls$inlined);
                            list = list2;
                            if (list != null) break block3;
                        }
                        list = CollectionsKt.toMutableList((Collection)this.$urls$inlined);
                    }
                    return list;
                }
            });
        }
        Map moduleToUrls2 = map;
        return this.createRequestsGraph((Iterable<? extends Module>)clientModules, moduleToEndpoints.keySet(), moduleToUrls2);
    }

    /*
     * WARNING - void declaration
     */
    private final Network<MsDiagramEndpoint, MsDiagramRequest> createRequestsGraph(Iterable<? extends Module> clientModules, Iterable<? extends Module> serverModules, Map<Module, ? extends List<? extends RequestToUrl>> moduleToRequests) {
        void $this$mapTo$iv$iv222;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        MsDiagramWebservice msDiagramWebservice;
        Object object;
        void $this$associateByTo$iv$iv;
        List allModules = CollectionsKt.plus(clientModules, serverModules);
        Iterable $this$associateBy$iv = allModules;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Module it;
            Module module = (Module)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            msDiagramWebservice = it;
            it = (Module)element$iv$iv;
            boolean bl2 = false;
            MsDiagramWebservice msDiagramWebservice2 = new MsDiagramWebservice(it);
            object.put(msDiagramWebservice, msDiagramWebservice2);
        }
        Map moduleToWebservice = destination$iv$iv;
        $i$f$associateBy = false;
        Map authorityToEndpoint = new LinkedHashMap();
        Iterable capacity$iv22 = allModules;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            Module it = (Module)element$iv$iv;
            boolean bl3 = false;
            List<? extends RequestToUrl> list = moduleToRequests.get(it);
            if (list != null) {
                Collection collection = list;
                boolean bl4 = false;
                bl = !collection.isEmpty();
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            Module it = (Module)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            msDiagramWebservice = (MsDiagramWebservice)MapsKt.getValue((Map)moduleToWebservice, (Object)it);
            object.add(msDiagramWebservice);
        }
        Object object2 = (List)destination$iv$iv2;
        boolean bl = false;
        boolean $this$mapTo$iv$iv222 = false;
        List it22 = object2;
        boolean bl52 = false;
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf(it22);
        Module $this$mapTo$iv$iv222 = moduleToRequests;
        boolean it22 = false;
        Iterator<Map.Entry<Module, ? extends List<? extends RequestToUrl>>> iterator = $this$mapTo$iv$iv222.entrySet().iterator();
        while (iterator.hasNext()) {
            void sourceModule;
            Object bl52 = object2 = iterator.next();
            boolean element$iv$iv = false;
            $this$mapTo$iv$iv222 = (Module)bl52.getKey();
            bl52 = object2;
            element$iv$iv = false;
            List urls = (List)bl52.getValue();
            Object v = moduleToWebservice.get(sourceModule);
            Intrinsics.checkNotNull(v);
            MsDiagramWebservice source = (MsDiagramWebservice)v;
            for (RequestToUrl requestToUrl : urls) {
                RequestToExternalEndpoint requestToExternalEndpoint;
                Object object3;
                String authority;
                if (requestToUrl.getAuthority() == null) {
                    continue;
                }
                Map $this$getOrPut$iv = authorityToEndpoint;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(authority);
                if (value$iv == null) {
                    boolean bl6 = false;
                    Project project = sourceModule.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"sourceModule.project");
                    RequestToUrl requestToUrl2 = requestToUrl;
                    if (!(requestToUrl2 instanceof RequestToUrl.WithKnownTargetInfo)) {
                        requestToUrl2 = null;
                    }
                    RequestToUrl.WithKnownTargetInfo withKnownTargetInfo = (RequestToUrl.WithKnownTargetInfo)requestToUrl2;
                    MsDiagramExternalEndpoint answer$iv = new MsDiagramExternalEndpoint(project, authority, (UrlTargetInfo)(withKnownTargetInfo != null ? withKnownTargetInfo.getInfo() : null));
                    $this$getOrPut$iv.put(authority, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                MsDiagramExternalEndpoint externalEndpoint = (MsDiagramExternalEndpoint)object3;
                RequestToUrl requestToUrl3 = requestToUrl;
                if (requestToUrl3 instanceof RequestToUrl.WithKnownTargetInfo) {
                    requestToExternalEndpoint = new RequestToExternalEndpoint(source, externalEndpoint, ((RequestToUrl.WithKnownTargetInfo)requestToUrl).getInfo(), null);
                } else if (requestToUrl3 instanceof RequestToUrl.WithKnownPathReference) {
                    requestToExternalEndpoint = new RequestToExternalEndpoint(source, externalEndpoint, null, ((RequestToUrl.WithKnownPathReference)requestToUrl).getRef());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                RequestToExternalEndpoint request = requestToExternalEndpoint;
                requestsGraph.addEdge((Object)source, (Object)externalEndpoint, (Object)request);
            }
        }
        return (Network)requestsGraph;
    }

    private final Sequence<UrlPathReference> findRawUrlsInCode(Iterable<? extends Module> modulesToSearchIn, Project project, RequestsSearcher.SearchParams searchParams) {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)URL_FOOTPRINTS), (Function1)((Function1)new Function1<String, Collection<? extends TextOccurrence>>(project, modulesToSearchIn){
            final /* synthetic */ Project $project;
            final /* synthetic */ Iterable $modulesToSearchIn;

            @NotNull
            public final Collection<? extends TextOccurrence> invoke(@NotNull String urlFootprint) {
                Intrinsics.checkNotNullParameter((Object)urlFootprint, (String)"urlFootprint");
                return SearchService.getInstance().searchWord(this.$project, urlFootprint).caseSensitive(false).inContexts(SearchContext.IN_STRINGS, new SearchContext[0]).inScope((SearchScope)new TaperingScope(this.$project, CollectionsKt.toSet((Iterable)this.$modulesToSearchIn))).includeInjections().buildLeafOccurrenceQuery().findAll();
            }
            {
                this.$project = project;
                this.$modulesToSearchIn = iterable;
                super(1);
            }
        })), (Function1)((Function1)new Function1<TextOccurrence, UrlPathReference>(this, searchParams){
            final /* synthetic */ RequestsToExternalEndpointsSearcher this$0;
            final /* synthetic */ RequestsSearcher.SearchParams $searchParams;

            @Nullable
            public final UrlPathReference invoke(TextOccurrence occurrence) {
                boolean $i$f$runReadAction = false;
                return (UrlPathReference)ApplicationManager.getApplication().runReadAction(new Computable(this, occurrence){
                    final /* synthetic */ findRawUrlsInCode.2 this$0;
                    final /* synthetic */ TextOccurrence $occurrence$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$occurrence$inlined = textOccurrence;
                    }

                    public final T compute() {
                        PsiReference psiReference;
                        PsiReference psiReference2;
                        block4: {
                            boolean bl = false;
                            TextOccurrence textOccurrence = this.$occurrence$inlined;
                            Intrinsics.checkNotNullExpressionValue((Object)textOccurrence, (String)"occurrence");
                            PsiReference[] psiReferenceArray = (PsiReference[])PsiTreeUtil.getNonStrictParentOfType((PsiElement)textOccurrence.getElement(), (Class[])new Class[]{PsiLanguageInjectionHost.class});
                            if (psiReferenceArray != null && (psiReferenceArray = psiReferenceArray.getReferences()) != null) {
                                PsiReference[] $this$firstOrNull$iv = psiReferenceArray;
                                boolean $i$f$firstOrNull = false;
                                PsiReference[] psiReferenceArray2 = $this$firstOrNull$iv;
                                int n = psiReferenceArray2.length;
                                for (int i = 0; i < n; ++i) {
                                    PsiReference element$iv;
                                    PsiReference it = element$iv = psiReferenceArray2[i];
                                    boolean bl2 = false;
                                    RequestsToExternalEndpointsSearcher requestsToExternalEndpointsSearcher = this.this$0.this$0;
                                    PsiReference psiReference3 = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)psiReference3, (String)"it");
                                    if (!requestsToExternalEndpointsSearcher.isAppropriateReference(psiReference3, this.this$0.$searchParams)) continue;
                                    psiReference2 = element$iv;
                                    break block4;
                                }
                                psiReference2 = null;
                            } else {
                                psiReference2 = psiReference = null;
                            }
                        }
                        if (!(psiReference2 instanceof UrlPathReference)) {
                            psiReference = null;
                        }
                        return (T)((UrlPathReference)psiReference);
                    }
                });
            }
            {
                this.this$0 = requestsToExternalEndpointsSearcher;
                this.$searchParams = searchParams;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Sequence $this$forEach$iv;
        boolean $i$f$forEach;
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source instanceof MsDiagramWebservice && target instanceof MsDiagramExternalEndpoint && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWebservice)source).getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"source.module.project");
        Project project2 = project;
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list;
        boolean bl4 = false;
        List<UrlTargetInfo> list2 = this.findModulesEndpointUrls(CollectionsKt.listOf((Object)((MsDiagramWebservice)source).getModule()), this.getEndpointTypesToSearch(), project2, searchParams).get(((MsDiagramWebservice)source).getModule());
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl5;
                block11: {
                    UrlTargetInfo info = (UrlTargetInfo)element$iv$iv;
                    boolean bl6 = false;
                    Iterable $this$any$iv = info.getAuthorities();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Authority it = (Authority)element$iv;
                            boolean bl7 = false;
                            Authority authority = it;
                            if (!(authority instanceof Authority.Exact)) {
                                authority = null;
                            }
                            Authority.Exact exact = (Authority.Exact)authority;
                            if (!Intrinsics.areEqual((Object)(exact != null ? exact.getText() : null), (Object)((MsDiagramExternalEndpoint)target).getAuthority())) continue;
                            bl5 = true;
                            break block11;
                        }
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UrlTargetInfo info = (UrlTargetInfo)element$iv;
                boolean bl8 = false;
                $this$apply.add(new RequestToExternalEndpoint((MsDiagramWebservice)source, (MsDiagramExternalEndpoint)target, info, null));
            }
        }
        $this$forEach$iv = SequencesKt.filter(this.findRawUrlsInCode(CollectionsKt.listOf((Object)((MsDiagramWebservice)source).getModule()), project2, searchParams), (Function1)((Function1)new Function1<UrlPathReference, Boolean>(this, source, project2, searchParams, target){
            final /* synthetic */ RequestsToExternalEndpointsSearcher this$0;
            final /* synthetic */ MsDiagramEndpoint $source$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ RequestsSearcher.SearchParams $searchParams$inlined;
            final /* synthetic */ MsDiagramEndpoint $target$inlined;
            {
                this.this$0 = requestsToExternalEndpointsSearcher;
                this.$source$inlined = msDiagramEndpoint;
                this.$project$inlined = project;
                this.$searchParams$inlined = searchParams;
                this.$target$inlined = msDiagramEndpoint2;
                super(1);
            }

            public final boolean invoke(@NotNull UrlPathReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getContext().getAuthorities().contains(((MsDiagramExternalEndpoint)this.$target$inlined).getAuthority());
            }
        }));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UrlPathReference urlRef = (UrlPathReference)element$iv;
            boolean bl9 = false;
            $this$apply.add(new RequestToExternalEndpoint((MsDiagramWebservice)source, (MsDiagramExternalEndpoint)target, ((MsDiagramExternalEndpoint)target).getTargetInfo(), urlRef));
        }
        return list;
    }

    public RequestsToExternalEndpointsSearcher(@NotNull Set<String> internalAuthorities) {
        Intrinsics.checkNotNullParameter(internalAuthorities, (String)"internalAuthorities");
        this.internalAuthorities = internalAuthorities;
    }

    static {
        Companion = new Companion(null);
        CLIENT_ENDPOINT_TYPES = SetsKt.setOf((Object[])new EndpointType[]{EndpointTypes.HTTP_CLIENT_TYPE, EndpointTypes.WEBSOCKET_CLIENT_TYPE});
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])new MsDiagramRelationship[]{MsDiagramRelationshipsKt.BASE_HTTP_REQUEST_RELATIONSHIP, MsDiagramRelationshipsKt.WEBSOCKET_REQUEST_RELATIONSHIP});
        URL_FOOTPRINTS = CollectionsKt.listOf((Object[])new String[]{"http", "ws", "://"});
    }

    public static final /* synthetic */ boolean access$isToExternalService$p(RequestsToExternalEndpointsSearcher $this, RequestToUrl $this$access_u24isToExternalService_u24p) {
        return $this.isToExternalService($this$access_u24isToExternalService_u24p);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "", "()V", "authority", "", "getAuthority", "()Ljava/lang/String;", "WithKnownPathReference", "WithKnownTargetInfo", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownTargetInfo;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownPathReference;", "intellij.microservices.ui"})
    private static abstract class RequestToUrl {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getAuthority() {
            String string;
            RequestToUrl requestToUrl = this;
            if (requestToUrl instanceof WithKnownTargetInfo) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ((WithKnownTargetInfo)this).getInfo().getAuthorities();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof Authority.Exact)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Authority.Exact exact = (Authority.Exact)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                string = exact != null ? exact.getText() : null;
            } else if (requestToUrl instanceof WithKnownPathReference) {
                string = (String)CollectionsKt.singleOrNull((List)((WithKnownPathReference)this).getRef().getContext().getAuthorities());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private RequestToUrl() {
        }

        public /* synthetic */ RequestToUrl(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownTargetInfo;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "info", "Lcom/intellij/microservices/url/UrlTargetInfo;", "(Lcom/intellij/microservices/url/UrlTargetInfo;)V", "getInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices.ui"})
        public static final class WithKnownTargetInfo
        extends RequestToUrl {
            @NotNull
            private final UrlTargetInfo info;

            @NotNull
            public final UrlTargetInfo getInfo() {
                return this.info;
            }

            public WithKnownTargetInfo(@NotNull UrlTargetInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super(null);
                this.info = info;
            }

            @NotNull
            public final UrlTargetInfo component1() {
                return this.info;
            }

            @NotNull
            public final WithKnownTargetInfo copy(@NotNull UrlTargetInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return new WithKnownTargetInfo(info);
            }

            public static /* synthetic */ WithKnownTargetInfo copy$default(WithKnownTargetInfo withKnownTargetInfo, UrlTargetInfo urlTargetInfo, int n, Object object) {
                if ((n & 1) != 0) {
                    urlTargetInfo = withKnownTargetInfo.info;
                }
                return withKnownTargetInfo.copy(urlTargetInfo);
            }

            @NotNull
            public String toString() {
                return "WithKnownTargetInfo(info=" + this.info + ")";
            }

            public int hashCode() {
                UrlTargetInfo urlTargetInfo = this.info;
                return urlTargetInfo != null ? urlTargetInfo.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WithKnownTargetInfo)) break block3;
                        WithKnownTargetInfo withKnownTargetInfo = (WithKnownTargetInfo)object;
                        if (!Intrinsics.areEqual((Object)this.info, (Object)withKnownTargetInfo.info)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl$WithKnownPathReference;", "Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$RequestToUrl;", "ref", "Lcom/intellij/microservices/url/references/UrlPathReference;", "(Lcom/intellij/microservices/url/references/UrlPathReference;)V", "getRef", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices.ui"})
        public static final class WithKnownPathReference
        extends RequestToUrl {
            @NotNull
            private final UrlPathReference ref;

            @NotNull
            public final UrlPathReference getRef() {
                return this.ref;
            }

            public WithKnownPathReference(@NotNull UrlPathReference ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                super(null);
                this.ref = ref;
            }

            @NotNull
            public final UrlPathReference component1() {
                return this.ref;
            }

            @NotNull
            public final WithKnownPathReference copy(@NotNull UrlPathReference ref) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                return new WithKnownPathReference(ref);
            }

            public static /* synthetic */ WithKnownPathReference copy$default(WithKnownPathReference withKnownPathReference, UrlPathReference urlPathReference, int n, Object object) {
                if ((n & 1) != 0) {
                    urlPathReference = withKnownPathReference.ref;
                }
                return withKnownPathReference.copy(urlPathReference);
            }

            @NotNull
            public String toString() {
                return "WithKnownPathReference(ref=" + this.ref + ")";
            }

            public int hashCode() {
                UrlPathReference urlPathReference = this.ref;
                return urlPathReference != null ? urlPathReference.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WithKnownPathReference)) break block3;
                        WithKnownPathReference withKnownPathReference = (WithKnownPathReference)object;
                        if (!Intrinsics.areEqual((Object)this.ref, (Object)withKnownPathReference.ref)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToExternalEndpointsSearcher$Companion;", "", "()V", "CLIENT_ENDPOINT_TYPES", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "SUPPORTED_RELATIONSHIPS", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "URL_FOOTPRINTS", "", "", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

