/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$;
import com.intellij.microservices.ui.diagrams.utils.CollectionUtilsKt;
import com.intellij.microservices.ui.diagrams.utils.ModulesUtilsKt;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014JV\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H&J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH&J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J.\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\\\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070'0&\"\b\b\u0000\u0010(*\u00020)\"\b\b\u0001\u0010**\u00020)*\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H*0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001fH\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToEndpointUrlsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "()V", "findModulesEndpointUrls", "", "Lcom/intellij/openapi/module/Module;", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "modulesToSearch", "", "endpointTypesToSearch", "", "Lcom/intellij/microservices/endpoints/EndpointType;", "project", "Lcom/intellij/openapi/project/Project;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "findRequestsToEndpointUrls", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "clientModules", "moduleToEndpoints", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getEndpointTypesToSearch", "getIndicatorText", "", "Lorg/jetbrains/annotations/Nls;", "getModulesToSearch", "isAppropriateReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "search", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "getAllEndpointsUrlsByModules", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "G", "", "E", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "modules", "fromLibraries", "fromTests", "intellij.microservices.ui"})
public abstract class RequestsToEndpointUrlsSearcher
implements RequestsSearcher {
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> search(@NotNull MsDiagramSeed seed, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        if (!(seed instanceof MsDiagramWholeProjectSeed)) {
            MutableNetwork mutableNetwork = NetworkBuilder.directed().build();
            Intrinsics.checkNotNullExpressionValue((Object)mutableNetwork, (String)"NetworkBuilder.directed().build()");
            return (Network)mutableNetwork;
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(this.getIndicatorText());
        }
        Project project = ((MsDiagramWholeProjectSeed)seed).getProject();
        List<Module> modules = this.getModulesToSearch(project, searchParams);
        Map<Module, List<UrlTargetInfo>> moduleToEndpoints = this.findModulesEndpointUrls((Iterable<? extends Module>)modules, this.getEndpointTypesToSearch(), project, searchParams);
        return this.findRequestsToEndpointUrls(modules, moduleToEndpoints, project, searchParams, indicator);
    }

    @NotNull
    public abstract String getIndicatorText();

    @NotNull
    public abstract Set<EndpointType> getEndpointTypesToSearch();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Module> getModulesToSearch(@NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] allModules = moduleManager.getModules();
        boolean bl = searchParams.getFromTests();
        if (bl) {
            Intrinsics.checkNotNullExpressionValue((Object)allModules, (String)"allModules");
            list = ArraysKt.toList((Object[])allModules);
        } else {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)allModules, (String)"allModules");
            Object[] $this$filter$iv = allModules;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var10_10 = $this$filterTo$iv$iv;
            int n = ((void)var10_10).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var10_10[i];
                boolean bl2 = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                if (!(!ModulesUtilsKt.getContainsTestsOnly((Module)v2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<Module, List<UrlTargetInfo>> findModulesEndpointUrls(@NotNull Iterable<? extends Module> modulesToSearch, @NotNull Set<EndpointType> endpointTypesToSearch, @NotNull Project project, @NotNull RequestsSearcher.SearchParams searchParams) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(modulesToSearch, (String)"modulesToSearch");
        Intrinsics.checkNotNullParameter(endpointTypesToSearch, (String)"endpointTypesToSearch");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        boolean $i$f$runReadAction22 = false;
        Sequence $i$f$runReadAction22 = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)CollectionUtilsKt.chunkedUnderReadAction((Sequence)ApplicationManager.getApplication().runReadAction(new Computable(this, project, endpointTypesToSearch, modulesToSearch, searchParams){
            final /* synthetic */ RequestsToEndpointUrlsSearcher this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Set $endpointTypesToSearch$inlined;
            final /* synthetic */ Iterable $modulesToSearch$inlined;
            final /* synthetic */ RequestsSearcher.SearchParams $searchParams$inlined;
            {
                this.this$0 = requestsToEndpointUrlsSearcher;
                this.$project$inlined = project;
                this.$endpointTypesToSearch$inlined = set;
                this.$modulesToSearch$inlined = iterable;
                this.$searchParams$inlined = searchParams;
            }

            public final T compute() {
                boolean bl = false;
                return (T)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)EndpointsProvider.Companion.getAvailableProviders(this.$project$inlined), (Function1)((Function1)new Function1<EndpointsProvider<?, ?>, Boolean>(this){
                    final /* synthetic */ findModulesEndpointUrls$$inlined$runReadAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final boolean invoke(@NotNull EndpointsProvider<?, ?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.this$0.$endpointTypesToSearch$inlined.contains(it.getEndpointType());
                    }
                })), (Function1)((Function1)new Function1<EndpointsProvider<?, ?>, Sequence<? extends Pair<? extends Module, ? extends UrlTargetInfo>>>(this){
                    final /* synthetic */ findModulesEndpointUrls$$inlined$runReadAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    @NotNull
                    public final Sequence<Pair<Module, UrlTargetInfo>> invoke(@NotNull EndpointsProvider<?, ?> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return RequestsToEndpointUrlsSearcher.access$getAllEndpointsUrlsByModules(this.this$0.this$0, it, this.this$0.$modulesToSearch$inlined, this.this$0.$searchParams$inlined.getFromLibraries(), this.this$0.$searchParams$inlined.getFromTests());
                    }
                }));
            }
        }), 50, findModulesEndpointUrls.2.INSTANCE)));
        boolean $i$f$groupBy = false;
        void var7_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = false;
            Module key$iv$iv = (Module)it2.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-RequestsToEndpointUrlsSearcher$findModulesEndpointUrls$52 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            UrlTargetInfo urlTargetInfo = (UrlTargetInfo)it.getSecond();
            list.add(urlTargetInfo);
        }
        return destination$iv$iv;
    }

    private final <G, E> Sequence<Pair<Module, UrlTargetInfo>> getAllEndpointsUrlsByModules(EndpointsProvider<G, E> $this$getAllEndpointsUrlsByModules, Iterable<? extends Module> modules, boolean fromLibraries, boolean fromTests) {
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence(modules), (Function1)((Function1)new Function1<Module, List<? extends Pair<? extends Module, ? extends UrlTargetInfo>>>($this$getAllEndpointsUrlsByModules, fromLibraries, fromTests){
            final /* synthetic */ EndpointsProvider $this_getAllEndpointsUrlsByModules;
            final /* synthetic */ boolean $fromLibraries;
            final /* synthetic */ boolean $fromTests;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<Module, UrlTargetInfo>> invoke(@NotNull Module module) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                Iterable $this$flatMap$iv = this.$this_getAllEndpointsUrlsByModules.getEndpointGroups(project, (EndpointsFilter)new ModuleEndpointsFilter(module, this.$fromLibraries, this.$fromTests));
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                Iterator<T> iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void $this$flatMapTo$iv$iv2;
                    T element$iv$iv;
                    T group = element$iv$iv = iterator.next();
                    boolean bl = false;
                    Iterable $this$flatMap$iv2 = this.$this_getAllEndpointsUrlsByModules.getEndpoints(group);
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo2 = false;
                    Iterator<T> iterator2 = $this$flatMapTo$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        void $this$mapTo$iv$iv;
                        Iterable iterable3;
                        T element$iv$iv2;
                        T endpoint = element$iv$iv2 = iterator2.next();
                        boolean bl2 = false;
                        String string = EndpointsProvider.URL_TARGET_INFO.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EndpointsProvider.URL_TARGET_INFO.name");
                        Object object = this.$this_getAllEndpointsUrlsByModules.getEndpointData(group, endpoint, string);
                        if (!(object instanceof Iterable)) {
                            object = null;
                        }
                        if ((iterable3 = (Iterable)object) == null) {
                            iterable3 = CollectionsKt.emptyList();
                        }
                        Iterable $this$map$iv = iterable3;
                        boolean $i$f$map = false;
                        Iterable iterable4 = $this$map$iv;
                        Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            UrlTargetInfo urlTargetInfo = (UrlTargetInfo)item$iv$iv;
                            Collection collection = destination$iv$iv3;
                            boolean bl3 = false;
                            Pair pair = new Pair((Object)module, (Object)it);
                            collection.add(pair);
                        }
                        Iterable list$iv$iv = (List)destination$iv$iv3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$this_getAllEndpointsUrlsByModules = endpointsProvider;
                this.$fromLibraries = bl;
                this.$fromTests = bl2;
                super(1);
            }
        }));
    }

    @NotNull
    public abstract Network<MsDiagramEndpoint, MsDiagramRequest> findRequestsToEndpointUrls(@NotNull List<? extends Module> var1, @NotNull Map<Module, ? extends List<? extends UrlTargetInfo>> var2, @NotNull Project var3, @NotNull RequestsSearcher.SearchParams var4, @Nullable ProgressIndicator var5);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isAppropriateReference(@NotNull PsiReference reference, @NotNull RequestsSearcher.SearchParams searchParams) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        if (!(reference instanceof UrlPathReference)) return false;
        if (((UrlPathReference)reference).getContext().isDeclaration()) return false;
        if (searchParams.getFromTests()) return true;
        PsiElement psiElement = ((UrlPathReference)reference).getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reference.element");
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"reference.element.containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        PsiElement psiElement2 = ((UrlPathReference)reference).getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"reference.element");
        if (TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)psiElement2.getProject())) return false;
        return true;
    }

    public static final /* synthetic */ Sequence access$getAllEndpointsUrlsByModules(RequestsToEndpointUrlsSearcher $this, EndpointsProvider $this$access_u24getAllEndpointsUrlsByModules, Iterable modules, boolean fromLibraries, boolean fromTests) {
        return $this.getAllEndpointsUrlsByModules($this$access_u24getAllEndpointsUrlsByModules, modules, fromLibraries, fromTests);
    }
}

