/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.intellij.microservices.mq.MQAccessType;
import com.intellij.microservices.mq.MQAccessTypes;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/RequestToMQueue;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "source", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "target", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestination;", "info", "Lcom/intellij/microservices/mq/MQTargetInfo;", "(Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestination;Lcom/intellij/microservices/mq/MQTargetInfo;)V", "getInfo", "()Lcom/intellij/microservices/mq/MQTargetInfo;", "getSource", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "getTarget", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestination;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "resolveToSourcePsiElement", "Lcom/intellij/psi/PsiElement;", "toRelationship", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "toString", "", "intellij.microservices.ui"})
public final class RequestToMQueue
extends MsDiagramRequest {
    @NotNull
    private final MsDiagramWebservice source;
    @NotNull
    private final MsDiagramMQDestination target;
    @NotNull
    private final MQTargetInfo info;

    @Override
    @Nullable
    public PsiElement resolveToSourcePsiElement() {
        return this.info.resolveToPsiElement();
    }

    @Override
    @NotNull
    public MsDiagramRelationship toRelationship() {
        MsDiagramRelationship msDiagramRelationship;
        MQAccessType mQAccessType = this.info.getAccessType();
        if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.ADMINISTRATION_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.ADMINISTRATION_RELATIONSHIP;
        } else if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.RECEIVE_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.RECEIVE_RELATIONSHIP;
        } else if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.SEND_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.SEND_RELATIONSHIP;
        } else if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.SEND_AND_RECEIVE_RELATIONSHIP;
        } else if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.STREAM_FORWARDING_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.STREAM_FORWARD_RELATIONSHIP;
        } else if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.UNKNOWN_TYPE)) {
            msDiagramRelationship = MsDiagramRelationshipsKt.UNKNOWN_RELATIONSHIP;
        } else {
            String string = "Unknown Access Type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return msDiagramRelationship;
    }

    @Override
    @NotNull
    public MsDiagramWebservice getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public MsDiagramMQDestination getTarget() {
        return this.target;
    }

    @NotNull
    public final MQTargetInfo getInfo() {
        return this.info;
    }

    public RequestToMQueue(@NotNull MsDiagramWebservice source, @NotNull MsDiagramMQDestination target, @NotNull MQTargetInfo info) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(null);
        this.source = source;
        this.target = target;
        this.info = info;
    }

    @NotNull
    public final MsDiagramWebservice component1() {
        return this.getSource();
    }

    @NotNull
    public final MsDiagramMQDestination component2() {
        return this.getTarget();
    }

    @NotNull
    public final MQTargetInfo component3() {
        return this.info;
    }

    @NotNull
    public final RequestToMQueue copy(@NotNull MsDiagramWebservice source, @NotNull MsDiagramMQDestination target, @NotNull MQTargetInfo info) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new RequestToMQueue(source, target, info);
    }

    public static /* synthetic */ RequestToMQueue copy$default(RequestToMQueue requestToMQueue, MsDiagramWebservice msDiagramWebservice, MsDiagramMQDestination msDiagramMQDestination, MQTargetInfo mQTargetInfo, int n, Object object) {
        if ((n & 1) != 0) {
            msDiagramWebservice = requestToMQueue.getSource();
        }
        if ((n & 2) != 0) {
            msDiagramMQDestination = requestToMQueue.getTarget();
        }
        if ((n & 4) != 0) {
            mQTargetInfo = requestToMQueue.info;
        }
        return requestToMQueue.copy(msDiagramWebservice, msDiagramMQDestination, mQTargetInfo);
    }

    @NotNull
    public String toString() {
        return "RequestToMQueue(source=" + this.getSource() + ", target=" + this.getTarget() + ", info=" + this.info + ")";
    }

    public int hashCode() {
        MsDiagramWebservice msDiagramWebservice = this.getSource();
        MsDiagramMQDestination msDiagramMQDestination = this.getTarget();
        MQTargetInfo mQTargetInfo = this.info;
        return ((msDiagramWebservice != null ? ((Object)msDiagramWebservice).hashCode() : 0) * 31 + (msDiagramMQDestination != null ? ((Object)msDiagramMQDestination).hashCode() : 0)) * 31 + (mQTargetInfo != null ? mQTargetInfo.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RequestToMQueue)) break block3;
                RequestToMQueue requestToMQueue = (RequestToMQueue)object;
                if (!Intrinsics.areEqual((Object)this.getSource(), (Object)requestToMQueue.getSource()) || !Intrinsics.areEqual((Object)this.getTarget(), (Object)requestToMQueue.getTarget()) || !Intrinsics.areEqual((Object)this.info, (Object)requestToMQueue.info)) break block3;
            }
            return true;
        }
        return false;
    }
}

