/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.mq.MQAccessType;
import com.intellij.microservices.mq.MQAccessTypes;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestination;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "project", "Lcom/intellij/openapi/project/Project;", "destination", "Lcom/intellij/microservices/mq/MQDestination;", "usages", "", "Lcom/intellij/microservices/mq/MQTargetInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/mq/MQDestination;Ljava/util/List;)V", "getDestination", "()Lcom/intellij/microservices/mq/MQDestination;", "htmlDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "getHtmlDescription", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "getName", "getProject", "()Lcom/intellij/openapi/project/Project;", "getUsages", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.microservices.ui"})
public final class MsDiagramMQDestination
extends MsDiagramEndpoint {
    @NotNull
    private final Project project;
    @NotNull
    private final MQDestination destination;
    @NotNull
    private final List<MQTargetInfo> usages;

    @Override
    @NotNull
    public String getName() {
        return this.destination.getName();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.destination.getType().getIcon();
        if (icon == null) {
            Icon icon2 = AllIcons.Webreferences.MessageQueue;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Webreferences.MessageQueue");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getHtmlDescription() {
        int administration = 0;
        int receive = 0;
        int send = 0;
        int sendAndReceive = 0;
        int streamForward = 0;
        int unknown = 0;
        for (MQTargetInfo usage : this.usages) {
            MQAccessType mQAccessType = usage.getAccessType();
            if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.ADMINISTRATION_TYPE)) {
                ++administration;
                continue;
            }
            if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.RECEIVE_TYPE)) {
                ++receive;
                continue;
            }
            if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.SEND_TYPE)) {
                ++send;
                continue;
            }
            if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE)) {
                ++sendAndReceive;
                continue;
            }
            if (Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.STREAM_FORWARDING_TYPE)) {
                ++streamForward;
                continue;
            }
            if (!Intrinsics.areEqual((Object)mQAccessType, (Object)MQAccessTypes.UNKNOWN_TYPE)) continue;
            ++unknown;
        }
        return MicroservicesUiBundle.message("microservices.diagrams.webservices.node.queue.tooltip", receive, send, sendAndReceive, streamForward, administration, unknown);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final MQDestination getDestination() {
        return this.destination;
    }

    @NotNull
    public final List<MQTargetInfo> getUsages() {
        return this.usages;
    }

    public MsDiagramMQDestination(@NotNull Project project, @NotNull MQDestination destination, @NotNull List<? extends MQTargetInfo> usages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        super(null);
        this.project = project;
        this.destination = destination;
        this.usages = usages;
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @NotNull
    public final MQDestination component2() {
        return this.destination;
    }

    @NotNull
    public final List<MQTargetInfo> component3() {
        return this.usages;
    }

    @NotNull
    public final MsDiagramMQDestination copy(@NotNull Project project, @NotNull MQDestination destination, @NotNull List<? extends MQTargetInfo> usages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        return new MsDiagramMQDestination(project, destination, usages);
    }

    public static /* synthetic */ MsDiagramMQDestination copy$default(MsDiagramMQDestination msDiagramMQDestination, Project project, MQDestination mQDestination, List list, int n, Object object) {
        if ((n & 1) != 0) {
            project = msDiagramMQDestination.getProject();
        }
        if ((n & 2) != 0) {
            mQDestination = msDiagramMQDestination.destination;
        }
        if ((n & 4) != 0) {
            list = msDiagramMQDestination.usages;
        }
        return msDiagramMQDestination.copy(project, mQDestination, list);
    }

    @NotNull
    public String toString() {
        return "MsDiagramMQDestination(project=" + this.getProject() + ", destination=" + this.destination + ", usages=" + this.usages + ")";
    }

    public int hashCode() {
        Project project = this.getProject();
        MQDestination mQDestination = this.destination;
        List<MQTargetInfo> list = this.usages;
        return ((project != null ? project.hashCode() : 0) * 31 + (mQDestination != null ? mQDestination.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MsDiagramMQDestination)) break block3;
                MsDiagramMQDestination msDiagramMQDestination = (MsDiagramMQDestination)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)msDiagramMQDestination.getProject()) || !Intrinsics.areEqual((Object)this.destination, (Object)msDiagramMQDestination.destination) || !Intrinsics.areEqual(this.usages, msDiagramMQDestination.usages)) break block3;
            }
            return true;
        }
        return false;
    }
}

