/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.google.common.graph.MutableNetwork;
import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.NamedMQType;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramCategoryManager;
import com.intellij.microservices.ui.diagrams.MsDiagramNotificationsKt;
import com.intellij.microservices.ui.diagrams.MsDiagramProvider;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.model.MQVendor;
import com.intellij.microservices.ui.diagrams.model.MsDiagramDataModel;
import com.intellij.microservices.ui.diagrams.model.MsDiagramElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestinationsGroup;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQSeedElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestToWebservice;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToExternalEndpointsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToInternalEndpointsSearcher;
import com.intellij.microservices.ui.diagrams.model.searchers.RequestsToMQSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramNode;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002`aB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010 2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000bH\u0002J\b\u0010(\u001a\u00020\"H\u0002J \u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\"H\u0016J\"\u0010/\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0015H\u0002J\u0016\u00101\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020302H\u0016J\u0018\u00104\u001a\u0004\u0018\u0001052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016J\b\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020:2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020 H\u0016J\u0016\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020 02H\u0016J\b\u0010=\u001a\u00020\u0007H\u0016J\u0012\u0010>\u001a\u00020?2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010@\u001a\u00020\"2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010A\u001a\u00020\"H\u0016J\f\u0010B\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u001a\u0010C\u001a\u00020\"2\u0010\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0EH\u0002J\u0016\u0010F\u001a\u00020\"2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000203H\u0016J\u0016\u0010H\u001a\u00020\"2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016J!\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0$2\u0006\u0010G\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020\"H\u0002J2\u0010N\u001a\b\u0012\u0004\u0012\u0002HO0$\"\u0004\b\u0000\u0010O2\b\b\u0001\u0010P\u001a\u00020:2\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002HO0RH\u0002J!\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0$2\u0006\u0010;\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bTJ:\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0$2$\u0010V\u001a \u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0Z0WH\u0002J\u0010\u0010[\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u001dH\u0002J\u0010\u0010]\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u001dH\u0002J\b\u0010^\u001a\u00020\"H\u0002J\b\u0010_\u001a\u00020\"H\u0002R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel;", "Lcom/intellij/diagram/DiagramDataModel;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;", "Lcom/intellij/diagram/DiagramDataModel$AsyncDataLoader;", "myProject", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/microservices/ui/diagrams/MsDiagramProvider;", "element", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/ui/diagrams/MsDiagramProvider;Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;)V", "currentViewSettings", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "getCurrentViewSettings", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "myDelayedRefreshScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myEdges", "", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "myLastStartedProgress", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "myMQDestinationsGroups", "", "Lcom/intellij/microservices/ui/diagrams/model/MQVendor;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramMQDestinationsGroup;", "myMQDestinationsNodes", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramNode;", "myModelData", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelData;", "myWebservicesNodes", "addElement", "Lcom/intellij/diagram/DiagramNode;", "adjustNodesAndEdgesAccordingToCommonCategories", "", "buildModelAsync", "Lorg/jetbrains/concurrency/Promise;", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "viewSettings", "clearAllNodesAndEdges", "createDiagramEdge", "source", "target", "relationship", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "dispose", "doBuildModel", "indicator", "getEdges", "", "Lcom/intellij/diagram/DiagramEdge;", "getGroup", "Lcom/intellij/openapi/graph/builder/NodesGroup;", "n", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getNodeName", "", "node", "getNodes", "getProvider", "hasElement", "", "rebuild", "refreshDataModel", "refreshDataModelAsync", "removeAllExceptPathsFromRootToNodes", "targets", "", "removeEdge", "edge", "removeNode", "scheduleEdgeRequestsSearch", "", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "scheduleEdgeRequestsSearch$intellij_microservices_ui", "scheduleModelComputation", "scheduleMutexTask", "R", "title", "callable", "Lkotlin/Function1;", "scheduleNodeRequestsSearch", "scheduleNodeRequestsSearch$intellij_microservices_ui", "scheduleRequestsSearch", "finder", "Lkotlin/Function3;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "", "setNodesAndEdgesFrom", "modelData", "showNotificationIfNoDataFound", "updateNodesAndEdges", "updatePresentation", "MyModelData", "MyModelSettings", "intellij.microservices.ui"})
public final class MsDiagramDataModel
extends DiagramDataModel<MsDiagramElement>
implements DiagramDataModel.AsyncDataLoader {
    private final AtomicReference<ProgressIndicator> myLastStartedProgress;
    private final AtomicBoolean myDelayedRefreshScheduled;
    private final AtomicReference<MyModelData> myModelData;
    private final Set<MsDiagramNode> myMQDestinationsNodes;
    private final Map<MQVendor, MsDiagramMQDestinationsGroup> myMQDestinationsGroups;
    private final Set<MsDiagramNode> myWebservicesNodes;
    private final Set<MsDiagramEdge> myEdges;

    @NotNull
    public MsDiagramProvider getProvider() {
        DiagramProvider diagramProvider = super.getProvider();
        if (diagramProvider == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.microservices.ui.diagrams.MsDiagramProvider");
        }
        return (MsDiagramProvider)diagramProvider;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        Intrinsics.checkNotNullExpressionValue((Object)simpleModificationTracker, (String)"myModificationTracker");
        return (ModificationTracker)simpleModificationTracker;
    }

    private final void updatePresentation() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!project.isDisposed()) {
            this.getBuilder().update(true, true);
        }
    }

    @NotNull
    public Collection<? extends DiagramNode<MsDiagramElement>> getNodes() {
        boolean bl = false;
        Set set = new LinkedHashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        Set $this$apply = set;
        boolean bl4 = false;
        $this$apply.addAll((Collection)this.myMQDestinationsNodes);
        $this$apply.addAll((Collection)this.myWebservicesNodes);
        return set;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<MsDiagramElement> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String string = node.getTooltip();
        if (string == null) {
            String string2 = CommonBundle.getErrorTitle();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CommonBundle.getErrorTitle()");
        }
        return string;
    }

    public void removeNode(@NotNull DiagramNode<MsDiagramElement> node) {
        block4: {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Collection collection = this.myMQDestinationsNodes;
            boolean bl = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection2).remove(node);
            collection = this.myWebservicesNodes;
            bl = false;
            Collection collection3 = collection;
            if (collection3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection3).remove(node);
            MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> mutableNetwork = this.myModelData.get();
            if (mutableNetwork == null || (mutableNetwork = mutableNetwork.getRequestsGraph()) == null) break block4;
            Object object = node.getIdentifyingElement();
            if (!(object instanceof MsDiagramEndpoint)) {
                object = null;
            }
            MsDiagramEndpoint msDiagramEndpoint = (MsDiagramEndpoint)object;
            if (msDiagramEndpoint == null) {
                return;
            }
            mutableNetwork.removeNode((Object)msDiagramEndpoint);
        }
    }

    public void removeEdge(@NotNull DiagramEdge<MsDiagramElement> edge) {
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        MyModelData myModelData = this.myModelData.get();
        if (myModelData != null) {
            MyModelData myModelData2 = myModelData;
            boolean bl = false;
            boolean bl2 = false;
            MyModelData data = myModelData2;
            boolean bl3 = false;
            for (MsDiagramRequest it : ((MsDiagramEdge)edge).getRequests()) {
                data.getRequestsGraph().removeEdge((Object)it);
            }
        }
    }

    @NotNull
    public Collection<? extends DiagramEdge<MsDiagramElement>> getEdges() {
        return this.myEdges;
    }

    private final MsDiagramEdge createDiagramEdge(MsDiagramNode source, MsDiagramNode target, MsDiagramRelationship relationship) {
        DiagramBuilder diagramBuilder = this.getBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)diagramBuilder, (String)"builder");
        return new MsDiagramEdge(source, target, relationship, diagramBuilder);
    }

    private final void clearAllNodesAndEdges() {
        this.myMQDestinationsNodes.clear();
        this.myMQDestinationsGroups.clear();
        this.myWebservicesNodes.clear();
        this.myEdges.clear();
    }

    private final void updateNodesAndEdges() {
        this.clearAllNodesAndEdges();
        MyModelData myModelData = this.myModelData.get();
        Intrinsics.checkNotNull((Object)myModelData);
        this.setNodesAndEdgesFrom(myModelData);
        this.adjustNodesAndEdgesAccordingToCommonCategories();
    }

    /*
     * WARNING - void declaration
     */
    private final void setNodesAndEdgesFrom(MyModelData modelData) {
        MsDiagramEdge msDiagramEdge;
        Map map;
        MsDiagramEndpoint $this$associateByTo$iv$iv;
        MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph = modelData.getRequestsGraph();
        Set set = requestsGraph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"requestsGraph.nodes()");
        Iterable $this$associateBy$iv = set;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Object object = $this$associateByTo$iv$iv.iterator();
        while (object.hasNext()) {
            MsDiagramEndpoint it;
            Object element$iv$iv = object.next();
            MsDiagramEndpoint msDiagramEndpoint = (MsDiagramEndpoint)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            msDiagramEdge = it;
            it = (MsDiagramEndpoint)element$iv$iv;
            boolean bl2 = false;
            MsDiagramEndpoint msDiagramEndpoint2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)msDiagramEndpoint2, (String)"it");
            MsDiagramNode msDiagramNode = new MsDiagramNode(msDiagramEndpoint2, this.getProvider());
            map.put(msDiagramEdge, msDiagramNode);
        }
        Map elementToNode = destination$iv$iv;
        for (MsDiagramEndpoint source : requestsGraph.nodes()) {
            Object v = elementToNode.get(source);
            Intrinsics.checkNotNull(v);
            MsDiagramNode sourceNode = (MsDiagramNode)((Object)v);
            $this$associateByTo$iv$iv = source;
            if ($this$associateByTo$iv$iv instanceof MsDiagramWebservice || $this$associateByTo$iv$iv instanceof MsDiagramExternalEndpoint) {
                this.myWebservicesNodes.add(sourceNode);
            } else if ($this$associateByTo$iv$iv instanceof MsDiagramMQDestination) {
                this.myMQDestinationsNodes.add(sourceNode);
            }
            for (MsDiagramEndpoint target : requestsGraph.successors((Object)source)) {
                void destination$iv$iv$iv;
                void $this$aggregateTo$iv$iv$iv;
                void $this$fold$iv;
                Grouping $this$groupingBy$iv;
                Object v2 = elementToNode.get(target);
                Intrinsics.checkNotNull(v2);
                MsDiagramNode targetNode = (MsDiagramNode)((Object)v2);
                Set set2 = requestsGraph.edgesConnecting((Object)source, (Object)target);
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"requestsGraph.edgesConnecting(source, target)");
                object = set2;
                boolean $i$f$groupingBy = false;
                $this$groupingBy$iv = (Grouping)new Grouping<MsDiagramRequest, MsDiagramRelationship>((Iterable)$this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<MsDiagramRequest> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        MsDiagramRequest it = (MsDiagramRequest)element;
                        boolean bl = false;
                        return it.toRelationship();
                    }
                };
                boolean $i$f$fold = false;
                void $this$aggregate$iv$iv = $this$fold$iv;
                boolean $i$f$aggregate = false;
                void var14_28 = $this$aggregate$iv$iv;
                boolean bl = false;
                Map map2 = new LinkedHashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator = $this$aggregateTo$iv$iv$iv.sourceIterator();
                boolean bl3 = false;
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    void request;
                    void edge;
                    MsDiagramEdge msDiagramEdge2;
                    void e$iv;
                    void first$iv;
                    void key$iv;
                    Object e$iv$iv$iv = iterator2.next();
                    Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                    Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                    boolean bl4 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                    Object e = e$iv$iv$iv;
                    Object v3 = accumulator$iv$iv$iv;
                    Object object2 = key$iv$iv$iv;
                    Object object3 = key$iv$iv$iv;
                    void var26_42 = destination$iv$iv$iv;
                    boolean bl5 = false;
                    Map map3 = key$iv;
                    if (first$iv != false) {
                        void relationship;
                        MsDiagramRequest msDiagramRequest = (MsDiagramRequest)e$iv;
                        MsDiagramRelationship msDiagramRelationship = (MsDiagramRelationship)key$iv;
                        map = map3;
                        boolean bl6 = false;
                        msDiagramEdge = this.createDiagramEdge(sourceNode, targetNode, (MsDiagramRelationship)relationship);
                        map3 = map;
                        msDiagramEdge2 = msDiagramEdge;
                    } else {
                        void acc$iv;
                        msDiagramEdge2 = acc$iv;
                    }
                    MsDiagramRequest bl6 = (MsDiagramRequest)e$iv;
                    MsDiagramEdge $noName_1 = msDiagramEdge2;
                    MsDiagramRelationship $noName_0 = (MsDiagramRelationship)((Object)map3);
                    boolean bl7 = false;
                    void var32_49 = edge;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    void it = var32_49;
                    boolean bl10 = false;
                    List<MsDiagramRequest> list = it.getRequests();
                    void v8 = request;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"request");
                    list.add((MsDiagramRequest)v8);
                    void var37_54 = var32_49;
                    var26_42.put(object3, var37_54);
                }
                object = destination$iv$iv$iv;
                boolean bl11 = false;
                boolean bl12 = false;
                Object it = object;
                boolean bl13 = false;
                this.myEdges.addAll(it.values());
            }
        }
    }

    private final void showNotificationIfNoDataFound(MyModelData modelData) {
        if (modelData.getRequestsGraph().nodes().isEmpty()) {
            Notification noDataFoundNotification = MsDiagramNotificationsKt.getGeneralGroup().createNotification(MicroservicesUiBundle.message("microservices.diagrams.webservices.presentable.name.sentence", new Object[0]), MicroservicesUiBundle.message("microservices.diagrams.webservices.no.data.found.notification", new Object[0]), NotificationType.WARNING);
            noDataFoundNotification.addAction((AnAction)new NotificationAction(this, MicroservicesUiBundle.message("microservices.diagrams.webservices.no.data.found.notification.submit.feedback.action", new Object[0])){
                final /* synthetic */ MsDiagramDataModel this$0;

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    SendFeedbackAction.submit((Project)this.this$0.getProject());
                    notification.expire();
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }
            });
            Notifications.Bus.notify((Notification)noDataFoundNotification, (Project)this.getProject());
        }
    }

    private final void adjustNodesAndEdgesAccordingToCommonCategories() {
        ArrayList nodes;
        if (this.getNodeContentManager().isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT) && (nodes = DiagramUtils.getSelectedNodes((DiagramBuilder)this.getBuilder())).size() > 0) {
            ArrayList arrayList = nodes;
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"nodes");
            this.removeAllExceptPathsFromRootToNodes(arrayList);
        }
        if (DiagramUtils.isSelectionMode((DiagramBuilder)this.getBuilder())) {
            DiagramUtils.removeNonSelectedDependencies((DiagramDataModel)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllExceptPathsFromRootToNodes(Collection<? extends DiagramNode<?>> targets) {
        void $this$flatMapTo$iv;
        Iterable iterable = this.myMQDestinationsNodes;
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            MsDiagramNode it = (MsDiagramNode)((Object)element$iv);
            boolean bl2 = false;
            Iterable list$iv = DiagramUtils.getPathsFromRoot((DiagramNode)((DiagramNode)it), targets, (DiagramDataView)((DiagramDataView)this), (DiagramUtils.PathDirection)DiagramUtils.PathDirection.BOTH);
            CollectionsKt.addAll((Collection)collection, (Iterable)list$iv);
        }
        Set pathEdges = (Set)collection;
        Set set = DiagramUtils.collectNodes((Set)pathEdges);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"DiagramUtils.collectNodes(pathEdges)");
        Set pathNodes = set;
        Collection $this$toTypedArray$iv22 = this.myWebservicesNodes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv22;
        MsDiagramNode[] msDiagramNodeArray = thisCollection$iv.toArray(new MsDiagramNode[0]);
        if (msDiagramNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        MsDiagramNode[] msDiagramNodeArray2 = msDiagramNodeArray;
        int $this$toTypedArray$iv22 = msDiagramNodeArray2.length;
        for (int i = 0; i < $this$toTypedArray$iv22; ++i) {
            MsDiagramNode msDiagramNode = msDiagramNodeArray2[i];
            if (pathNodes.contains((Object)msDiagramNode)) continue;
            this.myWebservicesNodes.remove((Object)msDiagramNode);
        }
        Collection $this$toTypedArray$iv = this.myEdges;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        MsDiagramEdge[] msDiagramEdgeArray = thisCollection$iv.toArray(new MsDiagramEdge[0]);
        if (msDiagramEdgeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (MsDiagramEdge msDiagramEdge : msDiagramEdgeArray) {
            if (pathEdges.contains((Object)msDiagramEdge)) continue;
            this.myEdges.remove((Object)msDiagramEdge);
        }
    }

    @Nullable
    public NodesGroup getGroup(@NotNull DiagramNode<MsDiagramElement> n) {
        NodesGroup nodesGroup;
        Intrinsics.checkNotNullParameter(n, (String)"n");
        Object object = n.getIdentifyingElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"n.identifyingElement");
        MsDiagramElement element = (MsDiagramElement)object;
        if (element instanceof MsDiagramMQDestination) {
            MsDiagramMQDestinationsGroup msDiagramMQDestinationsGroup;
            Object object2;
            MQType mqType = ((MsDiagramMQDestination)element).getDestination().getType();
            MQType mQType = mqType;
            if (!(mQType instanceof NamedMQType)) {
                mQType = null;
            }
            if ((object2 = (NamedMQType)mQType) == null || (object2 = object2.getName()) == null) {
                object2 = MicroservicesUiBundle.message("microservices.diagrams.mq.unknown.message.queue", new Object[0]);
            }
            MQVendor vendor = new MQVendor((String)object2, mqType.getIcon());
            Map<MQVendor, MsDiagramMQDestinationsGroup> $this$getOrPut$iv = this.myMQDestinationsGroups;
            boolean $i$f$getOrPut = false;
            MsDiagramMQDestinationsGroup value$iv = $this$getOrPut$iv.get(vendor);
            if (value$iv == null) {
                boolean bl = false;
                DiagramBuilder diagramBuilder = this.getBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)diagramBuilder, (String)"builder");
                MsDiagramMQDestinationsGroup answer$iv = new MsDiagramMQDestinationsGroup(vendor, diagramBuilder);
                $this$getOrPut$iv.put(vendor, answer$iv);
                msDiagramMQDestinationsGroup = answer$iv;
            } else {
                msDiagramMQDestinationsGroup = value$iv;
            }
            nodesGroup = (NodesGroup)msDiagramMQDestinationsGroup;
        } else if (element instanceof MsDiagramWebservice || element instanceof MsDiagramExternalEndpoint || element instanceof MsDiagramWholeProjectSeed || element instanceof MsDiagramMQSeedElement) {
            nodesGroup = super.getGroup(n);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nodesGroup;
    }

    public void dispose() {
    }

    @Nullable
    public DiagramNode<MsDiagramElement> addElement(@Nullable MsDiagramElement element) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasElement(@Nullable MsDiagramElement element) {
        MsDiagramNode it;
        boolean bl;
        Iterable $this$any$iv = this.myWebservicesNodes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (MsDiagramNode)((Object)element$iv);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getIdentifyingElement(), (Object)element)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = this.myMQDestinationsNodes;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (MsDiagramNode)((Object)element$iv);
            boolean bl3 = false;
        } while (!Intrinsics.areEqual((Object)it.getIdentifyingElement(), (Object)element));
        return true;
    }

    public void refreshDataModel() {
        this.rebuild((MsDiagramElement)this.getOriginalElement());
    }

    @NotNull
    public Promise<?> refreshDataModelAsync() {
        Promise promise;
        MsDiagramElement element = (MsDiagramElement)this.getOriginalElement();
        if (element instanceof MsDiagramWholeProjectSeed || element instanceof MsDiagramMQSeedElement) {
            Promise promise2 = this.buildModelAsync((MsDiagramSeed)((Object)element), this.getCurrentViewSettings()).onSuccess(new Consumer(this){
                final /* synthetic */ MsDiagramDataModel this$0;

                public final void accept(MyModelData it) {
                    MsDiagramDataModel.access$getMyModelData$p(this.this$0).set(it);
                    MyModelData myModelData = it;
                    Intrinsics.checkNotNullExpressionValue((Object)myModelData, (String)"it");
                    MsDiagramDataModel.access$showNotificationIfNoDataFound(this.this$0, myModelData);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ refreshDataModelAsync.1 this$0;

                        public final void run() {
                            MsDiagramDataModel.access$updateNodesAndEdges(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = msDiagramDataModel;
                }
            });
            promise = promise2;
            Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"buildModelAsync(element \u2026sAndEdges() }\n          }");
        } else {
            promise = Promises.resolvedPromise(null);
        }
        return promise;
    }

    public void rebuild(@Nullable MsDiagramElement element) {
        if (!(element instanceof MsDiagramElement)) {
            return;
        }
        MyModelData myModelData = this.myModelData.get();
        if (Intrinsics.areEqual((Object)(myModelData != null ? myModelData.getViewSettings() : null), (Object)this.getCurrentViewSettings()) ^ true) {
            this.scheduleModelComputation();
        } else {
            this.updateNodesAndEdges();
        }
    }

    private final MyModelSettings getCurrentViewSettings() {
        return new MyModelSettings(this.getNodeContentManager().isCategoryEnabled(MsDiagramCategoryManager.Companion.getFROM_TESTS()), this.getNodeContentManager().isCategoryEnabled(MsDiagramCategoryManager.Companion.getFROM_LIBRARIES()));
    }

    private final void scheduleModelComputation() {
        if (this.myDelayedRefreshScheduled.compareAndSet(false, true)) {
            this.refreshDataModelAsync().onSuccess(new Consumer(this){
                final /* synthetic */ MsDiagramDataModel this$0;

                public final void accept(Object it) {
                    DumbService.getInstance((Project)this.this$0.getProject()).smartInvokeLater(new Runnable(this){
                        final /* synthetic */ scheduleModelComputation.1 this$0;

                        public final void run() {
                            MsDiagramDataModel.access$updatePresentation(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = msDiagramDataModel;
                }
            }).onError((Consumer)scheduleModelComputation.2.INSTANCE).onProcessed(new Consumer(this){
                final /* synthetic */ MsDiagramDataModel this$0;

                public final void accept(Object it) {
                    MsDiagramDataModel.access$getMyDelayedRefreshScheduled$p(this.this$0).set(false);
                }
                {
                    this.this$0 = msDiagramDataModel;
                }
            });
        }
    }

    private final Promise<MyModelData> buildModelAsync(MsDiagramSeed seed, MyModelSettings viewSettings) {
        return this.scheduleMutexTask(MicroservicesUiBundle.message("microservices.diagrams.webservices.async.building.background.task.name", new Object[0]), (Function1)new Function1<ProgressIndicator, MyModelData>(this, seed, viewSettings){
            final /* synthetic */ MsDiagramDataModel this$0;
            final /* synthetic */ MsDiagramSeed $seed;
            final /* synthetic */ MyModelSettings $viewSettings;

            @NotNull
            public final MyModelData invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return MsDiagramDataModel.access$doBuildModel(this.this$0, this.$seed, this.$viewSettings, indicator);
            }
            {
                this.this$0 = msDiagramDataModel;
                this.$seed = msDiagramSeed;
                this.$viewSettings = myModelSettings;
                super(1);
            }
        });
    }

    private final <R> Promise<R> scheduleMutexTask(@Nls String title, Function1<? super ProgressIndicator, ? extends R> callable) {
        AsyncPromise result = new AsyncPromise();
        Task.Backgroundable task2 = new Task.Backgroundable(this, result, callable, title, this.getProject(), title, true, Task.Backgroundable.ALWAYS_BACKGROUND){
            final /* synthetic */ MsDiagramDataModel this$0;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ Function1 $callable;
            final /* synthetic */ String $title;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!MsDiagramDataModel.access$getMyLastStartedProgress$p(this.this$0).compareAndSet(null, indicator)) {
                    return;
                }
                try {
                    this.$result.setResult(this.$callable.invoke((Object)indicator));
                }
                catch (ProcessCanceledException ce) {
                    this.$result.setError((Throwable)ce);
                }
                catch (Exception e) {
                    this.$result.setError((Throwable)e);
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MsDiagramDataModel.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error((Throwable)e);
                }
                finally {
                    MsDiagramDataModel.access$getMyLastStartedProgress$p(this.this$0).compareAndSet(indicator, null);
                }
            }
            {
                this.this$0 = this$0;
                this.$result = $captured_local_variable$1;
                this.$callable = $captured_local_variable$2;
                this.$title = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        task2.queue();
        return (Promise)result;
    }

    /*
     * WARNING - void declaration
     */
    private final MyModelData doBuildModel(MsDiagramSeed seed, MyModelSettings viewSettings, ProgressIndicator indicator) {
        void destination$iv;
        void $this$flatMapTo$iv;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        RequestsSearcher.SearchParams searchParams = new RequestsSearcher.SearchParams(viewSettings.getDoSearchFromTests(), viewSettings.getDoSearchFromLibraries());
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf();
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToMQSearcher().search(seed, searchParams, indicator));
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToInternalEndpointsSearcher().search(seed, searchParams, indicator));
        Set set = requestsGraph.edges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"requestsGraph.edges()");
        Iterable iterable = set;
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Object object;
            MsDiagramRequest it = (MsDiagramRequest)element$iv;
            boolean bl2 = false;
            MsDiagramRequest msDiagramRequest = it;
            if (!(msDiagramRequest instanceof RequestToWebservice)) {
                msDiagramRequest = null;
            }
            if ((object = (RequestToWebservice)msDiagramRequest) == null || (object = ((RequestToWebservice)object).getPathReference()) == null || (object = object.getContext()) == null || (object = object.getAuthorities()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set internalAuthorities = (Set)destination$iv;
        GraphUtilsKt.plusAssign(requestsGraph, new RequestsToExternalEndpointsSearcher(internalAuthorities).search(seed, searchParams, indicator));
        return new MyModelData(viewSettings, requestsGraph);
    }

    private final Promise<List<MsDiagramRequest>> scheduleRequestsSearch(Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>> finder) {
        return this.scheduleMutexTask(MicroservicesUiBundle.message("microservices.diagrams.webservices.async.building.background.task.name", new Object[0]), (Function1)new Function1<ProgressIndicator, List<? extends MsDiagramRequest>>(this, finder){
            final /* synthetic */ MsDiagramDataModel this$0;
            final /* synthetic */ Function3 $finder;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MsDiagramRequest> invoke(@NotNull ProgressIndicator indicator) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                MyModelSettings viewSettings = MsDiagramDataModel.access$getCurrentViewSettings$p(this.this$0);
                RequestsSearcher.SearchParams searchParams = new RequestsSearcher.SearchParams(viewSettings.getDoSearchFromTests(), viewSettings.getDoSearchFromLibraries());
                Iterable iterable = CollectionsKt.listOf((Object[])new RequestsSearcher[]{new RequestsToMQSearcher(), new RequestsToInternalEndpointsSearcher(), new RequestsToExternalEndpointsSearcher(SetsKt.emptySet())});
                boolean $i$f$flatMap = false;
                void var6_6 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    RequestsSearcher it = (RequestsSearcher)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = (Iterable)this.$finder.invoke((Object)it, (Object)searchParams, (Object)indicator);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = msDiagramDataModel;
                this.$finder = function3;
                super(1);
            }
        });
    }

    @NotNull
    public final Promise<List<MsDiagramRequest>> scheduleEdgeRequestsSearch$intellij_microservices_ui(@NotNull MsDiagramEdge edge) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        return this.scheduleRequestsSearch((Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>>)((Function3)new Function3<RequestsSearcher, RequestsSearcher.SearchParams, ProgressIndicator, Iterable<? extends MsDiagramRequest>>(edge){
            final /* synthetic */ MsDiagramEdge $edge;

            @NotNull
            public final Iterable<MsDiagramRequest> invoke(@NotNull RequestsSearcher searcher, @NotNull RequestsSearcher.SearchParams searchParams, @NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
                Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return searcher.searchForRequestsFormingAnEdge(this.$edge, searchParams, indicator);
            }
            {
                this.$edge = msDiagramEdge;
                super(3);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<List<MsDiagramRequest>> scheduleNodeRequestsSearch$intellij_microservices_ui(@NotNull MsDiagramNode node) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Iterable $this$filter$iv = this.myEdges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MsDiagramEdge it = (MsDiagramEdge)((Object)element$iv$iv);
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((Object)it.getSource()), (Object)((Object)node)) || Intrinsics.areEqual((Object)((Object)it.getTarget()), (Object)((Object)node)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List edges = (List)destination$iv$iv;
        return this.scheduleRequestsSearch((Function3<? super RequestsSearcher, ? super RequestsSearcher.SearchParams, ? super ProgressIndicator, ? extends Iterable<? extends MsDiagramRequest>>)((Function3)new Function3<RequestsSearcher, RequestsSearcher.SearchParams, ProgressIndicator, Iterable<? extends MsDiagramRequest>>(edges){
            final /* synthetic */ List $edges;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<MsDiagramRequest> invoke(@NotNull RequestsSearcher searcher, @NotNull RequestsSearcher.SearchParams searchParams, @NotNull ProgressIndicator indicator) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
                Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$flatMap$iv = this.$edges;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    MsDiagramEdge edge = (MsDiagramEdge)((Object)element$iv$iv);
                    boolean bl = false;
                    Iterable<MsDiagramRequest> list$iv$iv = searcher.searchForRequestsFormingAnEdge(edge, searchParams, indicator);
                    CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$edges = list;
                super(3);
            }
        }));
    }

    public MsDiagramDataModel(@NotNull Project myProject, @NotNull MsDiagramProvider provider, @Nullable MsDiagramElement element) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        super(myProject, (DiagramProvider)provider);
        this.myLastStartedProgress = new AtomicReference();
        this.myDelayedRefreshScheduled = new AtomicBoolean();
        this.myModelData = new AtomicReference();
        boolean bl = false;
        this.myMQDestinationsNodes = new LinkedHashSet();
        bl = false;
        this.myMQDestinationsGroups = new LinkedHashMap();
        bl = false;
        this.myWebservicesNodes = new LinkedHashSet();
        bl = false;
        this.myEdges = new LinkedHashSet();
        this.setOriginalElement(element);
    }

    public static final /* synthetic */ AtomicReference access$getMyModelData$p(MsDiagramDataModel $this) {
        return $this.myModelData;
    }

    public static final /* synthetic */ void access$showNotificationIfNoDataFound(MsDiagramDataModel $this, MyModelData modelData) {
        $this.showNotificationIfNoDataFound(modelData);
    }

    public static final /* synthetic */ void access$updateNodesAndEdges(MsDiagramDataModel $this) {
        $this.updateNodesAndEdges();
    }

    public static final /* synthetic */ void access$updatePresentation(MsDiagramDataModel $this) {
        $this.updatePresentation();
    }

    public static final /* synthetic */ AtomicBoolean access$getMyDelayedRefreshScheduled$p(MsDiagramDataModel $this) {
        return $this.myDelayedRefreshScheduled;
    }

    public static final /* synthetic */ MyModelData access$doBuildModel(MsDiagramDataModel $this, MsDiagramSeed seed, MyModelSettings viewSettings, ProgressIndicator indicator) {
        return $this.doBuildModel(seed, viewSettings, indicator);
    }

    public static final /* synthetic */ AtomicReference access$getMyLastStartedProgress$p(MsDiagramDataModel $this) {
        return $this.myLastStartedProgress;
    }

    public static final /* synthetic */ MyModelSettings access$getCurrentViewSettings$p(MsDiagramDataModel $this) {
        return $this.getCurrentViewSettings();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "", "doSearchFromTests", "", "doSearchFromLibraries", "(ZZ)V", "getDoSearchFromLibraries", "()Z", "getDoSearchFromTests", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.microservices.ui"})
    private static final class MyModelSettings {
        private final boolean doSearchFromTests;
        private final boolean doSearchFromLibraries;

        public final boolean getDoSearchFromTests() {
            return this.doSearchFromTests;
        }

        public final boolean getDoSearchFromLibraries() {
            return this.doSearchFromLibraries;
        }

        public MyModelSettings(boolean doSearchFromTests, boolean doSearchFromLibraries) {
            this.doSearchFromTests = doSearchFromTests;
            this.doSearchFromLibraries = doSearchFromLibraries;
        }

        public final boolean component1() {
            return this.doSearchFromTests;
        }

        public final boolean component2() {
            return this.doSearchFromLibraries;
        }

        @NotNull
        public final MyModelSettings copy(boolean doSearchFromTests, boolean doSearchFromLibraries) {
            return new MyModelSettings(doSearchFromTests, doSearchFromLibraries);
        }

        public static /* synthetic */ MyModelSettings copy$default(MyModelSettings myModelSettings, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = myModelSettings.doSearchFromTests;
            }
            if ((n & 2) != 0) {
                bl2 = myModelSettings.doSearchFromLibraries;
            }
            return myModelSettings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "MyModelSettings(doSearchFromTests=" + this.doSearchFromTests + ", doSearchFromLibraries=" + this.doSearchFromLibraries + ")";
        }

        public int hashCode() {
            int n = this.doSearchFromTests ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.doSearchFromLibraries ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MyModelSettings)) break block3;
                    MyModelSettings myModelSettings = (MyModelSettings)object;
                    if (this.doSearchFromTests != myModelSettings.doSearchFromTests || this.doSearchFromLibraries != myModelSettings.doSearchFromLibraries) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelData;", "", "viewSettings", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "requestsGraph", "Lcom/google/common/graph/MutableNetwork;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "(Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;Lcom/google/common/graph/MutableNetwork;)V", "getRequestsGraph", "()Lcom/google/common/graph/MutableNetwork;", "getViewSettings", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramDataModel$MyModelSettings;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.microservices.ui"})
    private static final class MyModelData {
        @NotNull
        private final MyModelSettings viewSettings;
        @NotNull
        private final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph;

        @NotNull
        public final MyModelSettings getViewSettings() {
            return this.viewSettings;
        }

        @NotNull
        public final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> getRequestsGraph() {
            return this.requestsGraph;
        }

        public MyModelData(@NotNull MyModelSettings viewSettings, @NotNull MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph) {
            Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
            Intrinsics.checkNotNullParameter(requestsGraph, (String)"requestsGraph");
            this.viewSettings = viewSettings;
            this.requestsGraph = requestsGraph;
        }

        @NotNull
        public final MyModelSettings component1() {
            return this.viewSettings;
        }

        @NotNull
        public final MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> component2() {
            return this.requestsGraph;
        }

        @NotNull
        public final MyModelData copy(@NotNull MyModelSettings viewSettings, @NotNull MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> requestsGraph) {
            Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
            Intrinsics.checkNotNullParameter(requestsGraph, (String)"requestsGraph");
            return new MyModelData(viewSettings, requestsGraph);
        }

        public static /* synthetic */ MyModelData copy$default(MyModelData myModelData, MyModelSettings myModelSettings, MutableNetwork mutableNetwork, int n, Object object) {
            if ((n & 1) != 0) {
                myModelSettings = myModelData.viewSettings;
            }
            if ((n & 2) != 0) {
                mutableNetwork = myModelData.requestsGraph;
            }
            return myModelData.copy(myModelSettings, mutableNetwork);
        }

        @NotNull
        public String toString() {
            return "MyModelData(viewSettings=" + this.viewSettings + ", requestsGraph=" + this.requestsGraph + ")";
        }

        public int hashCode() {
            MyModelSettings myModelSettings = this.viewSettings;
            MutableNetwork<MsDiagramEndpoint, MsDiagramRequest> mutableNetwork = this.requestsGraph;
            return (myModelSettings != null ? ((Object)myModelSettings).hashCode() : 0) * 31 + (mutableNetwork != null ? mutableNetwork.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MyModelData)) break block3;
                    MyModelData myModelData = (MyModelData)object;
                    if (!Intrinsics.areEqual((Object)this.viewSettings, (Object)myModelData.viewSettings) || !Intrinsics.areEqual(this.requestsGraph, myModelData.requestsGraph)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

