/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    private static final Logger LOG = Logger.getInstance((String)IOUtil.class.getName());

    public static File createDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull OutputStream outputStream) throws IOException {
        InputStream asStream = null;
        try {
            asStream = clazz.getResourceAsStream(resourceName);
            if (asStream != null) {
                IOUtil.copyStreamContent(asStream, outputStream);
            }
        }
        finally {
            IOUtil.close(asStream);
            IOUtil.close(outputStream);
        }
    }

    public static void close(@Nullable Closeable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copyStreamContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    @NotNull
    public static String makeRelative(@NotNull File base, @NotNull File path) {
        if (base.equals(path)) {
            return ".";
        }
        String sFind = path.getPath();
        String sBasePath = base.getPath();
        if (!path.getPath().startsWith(sBasePath + File.separatorChar)) {
            String next = IOUtil.makeRelative(base.getParentFile(), path);
            if (".".equals(next)) {
                return "..";
            }
            return "../" + next;
        }
        return sFind.substring(sBasePath.length() + 1);
    }
}

