/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.w3validators.css;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.w3validators.W3ValidatorsBundle;
import org.jetbrains.w3validators.css.W3CssExternalAnnotator;

public class W3CssValidatorInspection
extends CssApiBaseInspection {
    @NonNls
    public static final String SHORT_NAME = "W3CssValidation";
    public String myCssVersion = "css3svg";
    public boolean myIgnoreVendorSpecificProperties = false;
    @NonNls
    private static final BidirectionalMap<String, String> myVersionToProfile = new BidirectionalMap();

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        JPanel versionPanel = new JPanel(new BorderLayout());
        versionPanel.add((Component)new JLabel(W3ValidatorsBundle.message("css.version.panel.title", new Object[0])), "West");
        Object[] strings = ArrayUtilRt.toStringArray((Collection)myVersionToProfile.keySet());
        ContainerUtil.sort((Comparable[])strings);
        ComboBox comboBox = new ComboBox(strings);
        List list = myVersionToProfile.getKeysByValue((Object)this.myCssVersion);
        if (list != null && list.size() == 1) {
            comboBox.setSelectedItem(list.get(0));
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                String version;
                String temp;
                Object item;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((item = e.getItem()) instanceof String && !W3CssValidatorInspection.this.myCssVersion.equals(temp = (String)myVersionToProfile.get((Object)(version = (String)item)))) {
                    W3CssValidatorInspection.this.myCssVersion = temp;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/w3validators/css/W3CssValidatorInspection$1", "itemStateChanged"));
            }
        });
        versionPanel.add((Component)comboBox, "Center");
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.add((Component)versionPanel);
        panel.addCheckbox(W3ValidatorsBundle.message("ignore.vendor.specific.properties", new Object[0]), "myIgnoreVendorSpecificProperties");
        return panel;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            W3CssValidatorInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            W3CssValidatorInspection.$$$reportNull$$$0(1);
        }
        if (isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        W3CssExternalAnnotator annotator = new W3CssExternalAnnotator();
        W3CssExternalAnnotator.MyVisitor info = annotator.collectInformation(file);
        if (info != null) {
            W3CssExternalAnnotator.MyVisitor annotationResult = annotator.doAnnotate(info);
            return W3CssExternalAnnotator.applyToToProblemDescriptors(file, annotationResult, manager, isOnTheFly).toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static {
        myVersionToProfile.put((Object)"CSS Level 1", (Object)"css1");
        myVersionToProfile.put((Object)"CSS Level 2", (Object)"css2");
        myVersionToProfile.put((Object)"CSS Level 2.1", (Object)"css21");
        myVersionToProfile.put((Object)"CSS Level 3", (Object)"css3");
        myVersionToProfile.put((Object)"CSS Level 3 + SVG", (Object)"css3svg");
        myVersionToProfile.put((Object)"SVG", (Object)"svg");
        myVersionToProfile.put((Object)"SVG Basic", (Object)"svgbasic");
        myVersionToProfile.put((Object)"SVG tiny", (Object)"svgtiny");
        myVersionToProfile.put((Object)"Mobile", (Object)"mobile");
        myVersionToProfile.put((Object)"ATSC TV", (Object)"atsc-tv");
        myVersionToProfile.put((Object)"TV", (Object)"tv");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/w3validators/css/W3CssValidatorInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

