/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config.properties;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;

public abstract class IndexAccessTextProcessor {
    private final String myText;
    private final MetaConfigKey myConfigKey;

    public IndexAccessTextProcessor(String text, MetaConfigKey configKey) {
        this.myText = text;
        this.myConfigKey = configKey;
    }

    protected abstract void onMissingClosingBracket(int var1);

    protected abstract void onMissingIndexValue(int var1);

    protected abstract void onBracket(int var1);

    protected abstract void onIndexValue(TextRange var1);

    protected abstract void onIndexValueNotInteger(TextRange var1);

    public void process() {
        int parseOffset = 0;
        int startIdx;
        while ((startIdx = StringUtil.indexOf((CharSequence)this.myText, (char)'[', (int)parseOffset)) != -1) {
            int endIdx;
            parseOffset = endIdx = StringUtil.indexOf((CharSequence)this.myText, (char)']', (int)startIdx);
            if (endIdx == -1) {
                this.onMissingClosingBracket(startIdx);
                parseOffset = startIdx + 1;
                continue;
            }
            if (startIdx + 1 == endIdx) {
                this.onMissingIndexValue(startIdx);
                continue;
            }
            this.onBracket(startIdx);
            boolean isPlainMapKey = this.myConfigKey.isAccessType(MetaConfigKey.AccessType.MAP);
            if (!isPlainMapKey) {
                TextRange indexValueRange = TextRange.create((int)(startIdx + 1), (int)endIdx);
                String indexValueText = indexValueRange.substring(this.myText);
                try {
                    Integer.decode(indexValueText);
                    this.onIndexValue(indexValueRange);
                }
                catch (NumberFormatException e) {
                    this.onIndexValueNotInteger(indexValueRange);
                }
            }
            this.onBracket(endIdx);
        }
        return;
    }
}

