/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.microservices.config.properties.ConfigKeyPathReferenceSet;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigKeyPathEnumReference
extends ConfigKeyPathReferenceSet.Reference
implements EmptyResolveMessageProvider {
    ConfigKeyPathEnumReference(PsiElement element, TextRange textRange, ConfigKeyPathReferenceSet referenceSet, int index) {
        super(element, textRange, referenceSet, index);
    }

    @Override
    @NotNull
    public ConfigKeyPathReference.PathType getPathType() {
        ConfigKeyPathReference.PathType pathType = ConfigKeyPathReference.PathType.ENUM;
        if (pathType == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(0);
        }
        return pathType;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            return null;
        }
        String enumText = this.getValue();
        return (PsiElement)ContainerUtil.find((Object[])keyClass.getFields(), field -> field instanceof PsiEnumConstant && enumText.equalsIgnoreCase(field.getName()) || enumText.equalsIgnoreCase(ConfigKeyPathEnumReference.getSanitizedName(field)));
    }

    public Object @NotNull [] getVariants() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                ConfigKeyPathEnumReference.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] enumConstants = (PsiField[])ContainerUtil.findAllAsArray((Object[])keyClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
        Object[] objectArray = ContainerUtil.map2Array((Object[])enumConstants, LookupElement.class, field -> {
            String sanitizedFieldName = ConfigKeyPathEnumReference.getSanitizedName(field);
            LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)sanitizedFieldName).withIcon(field.getIcon(1)).withPresentableText(sanitizedFieldName);
            return TailTypeDecorator.withTail((LookupElement)builder, (TailType)(this.isEnumMapKey() ? TailType.createSimpleTailType((char)this.getKeyValueDelimiter()) : TailType.DOT));
        });
        if (objectArray == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    private static String getSanitizedName(PsiField psiField) {
        String psiFieldName = psiField.getName();
        String string = StringUtil.toLowerCase((String)psiFieldName).replace('_', '-');
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiClass keyClass = this.getKeyClass();
        String location = keyClass == null ? "" : MicroservicesConfigBundle.message("config.unresolved.key.in.class", keyClass.getQualifiedName());
        String string = MicroservicesConfigBundle.message("config.unresolved.enum.key", this.getValue(), location);
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiClass getKeyClass() {
        return this.isFirst() ? this.getInitialKeyClass() : this.getPrevious().getKeyClass();
    }

    @Override
    @Nullable
    protected PsiClass getValueClass() {
        return this.isFirst() ? this.getInitialValueClass() : this.getPrevious().getValueClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/microservices/config/properties/ConfigKeyPathEnumReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

