/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config.hints;

import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticValuesHintReferenceProvider
extends HintReferenceProviderBase {
    private final boolean myAllowOtherValues;
    private final boolean myCaseInsensitive;
    private final TextAttributesKey myTextAttributesKey;
    private final String[] values;

    public StaticValuesHintReferenceProvider(boolean allowOtherValues, boolean caseInsensitive, TextAttributesKey textAttributesKey, String ... values) {
        this.myAllowOtherValues = allowOtherValues;
        this.myCaseInsensitive = caseInsensitive;
        this.myTextAttributesKey = textAttributesKey;
        Arrays.sort(values);
        this.values = values;
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        return new HintReferenceBase(element, textRange){

            @Override
            public TextAttributesKey getTextAttributesKey() {
                return StaticValuesHintReferenceProvider.this.myTextAttributesKey;
            }

            @Override
            @Nullable
            protected PsiElement doResolve() {
                if (StaticValuesHintReferenceProvider.this.myAllowOtherValues) {
                    return this.myElement;
                }
                String value = StaticValuesHintReferenceProvider.this.myCaseInsensitive ? StringUtil.toUpperCase((String)this.getValue()) : this.getValue();
                return Arrays.binarySearch(StaticValuesHintReferenceProvider.this.values, value.trim()) > -1 ? this.myElement : null;
            }

            public Object @NotNull [] getVariants() {
                if (StaticValuesHintReferenceProvider.this.values == null) {
                    1.$$$reportNull$$$0(0);
                }
                return StaticValuesHintReferenceProvider.this.values;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                if (StaticValuesHintReferenceProvider.this.values.length > 5) {
                    String string = super.getUnresolvedMessagePattern();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = MicroservicesConfigBundle.partialMessage("config.unresolved.static.value", 1, StringUtil.join((String[])StaticValuesHintReferenceProvider.this.values, (String)"|"));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/microservices/config/hints/StaticValuesHintReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }
}

