/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaConfigKeyReference<T extends PsiElement>
extends PsiReferenceBase.Poly<T> {
    private static final Condition<MetaConfigKey> NOT_DEPRECATED_CONDITION = key -> key.getDeprecation() == MetaConfigKey.Deprecation.NOT_DEPRECATED;
    private final MetaConfigKeyManager myConfigKeyManager;
    private final NotNullLazyValue<List<? extends MetaConfigKey>> myKeys;
    public static final Key<MetaConfigKey> META_CONFIG_KEY = Key.create((String)"metaConfigKey");

    protected MetaConfigKeyReference(@NotNull MetaConfigKeyManager configKeyManager, T element, String keyText) {
        if (configKeyManager == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(0);
        }
        super(element);
        this.myConfigKeyManager = configKeyManager;
        this.myKeys = NotNullLazyValue.atomicLazy(() -> {
            List keys = this.getAllKeys(keyText);
            if (keys.size() == 1) {
                return keys;
            }
            List notDeprecatedKeys = ContainerUtil.filter(keys, NOT_DEPRECATED_CONDITION);
            return notDeprecatedKeys.isEmpty() ? keys : notDeprecatedKeys;
        });
    }

    @NotNull
    protected MetaConfigKeyManager getConfigKeyManager() {
        MetaConfigKeyManager metaConfigKeyManager = this.myConfigKeyManager;
        if (metaConfigKeyManager == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(1);
        }
        return metaConfigKeyManager;
    }

    @NotNull
    protected List<? extends MetaConfigKey> getAllKeys(String keyText) {
        List<? extends MetaConfigKey> list = this.myConfigKeyManager.findAllApplicationMetaConfigKeys(this.getElement(), keyText);
        if (list == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(2);
        }
        return list;
    }

    public FakePsiElement createNavigationElement() {
        return new MyNavigationFakeElement(this);
    }

    @NotNull
    public abstract String getReferenceDisplayText();

    @Nullable
    public MetaConfigKey getResolvedKey() {
        return (MetaConfigKey)ContainerUtil.getFirstItem((List)((List)this.myKeys.getValue()));
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)ContainerUtil.map((Collection)((Collection)this.myKeys.getValue()), MetaConfigKey::getDeclaration));
        if (resolveResultArray == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(4);
        }
        return this.getElement();
    }

    @Nullable
    public static MetaConfigKey getResolvedMetaConfigKey(@NotNull PsiElement keyElement) {
        if (keyElement == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(5);
        }
        for (PsiReference reference : keyElement.getReferences()) {
            if (!(reference instanceof MetaConfigKeyReference)) continue;
            return ((MetaConfigKeyReference)reference).getResolvedKey();
        }
        return null;
    }

    public static boolean findAndStoreMetaConfigKeyIfMatches(@NotNull PsiElement keyElement, @NotNull ProcessingContext context, @NotNull Condition<? super MetaConfigKey> condition) {
        MetaConfigKey configKey;
        if (keyElement == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(6);
        }
        if (context == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(7);
        }
        if (condition == null) {
            MetaConfigKeyReference.$$$reportNull$$$0(8);
        }
        if ((configKey = (MetaConfigKey)RecursionManager.doPreventingRecursion((Object)keyElement, (boolean)true, () -> MetaConfigKeyReference.getResolvedMetaConfigKey(keyElement))) == null || !condition.value((Object)configKey)) {
            return false;
        }
        context.put(META_CONFIG_KEY, (Object)configKey);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/config/MetaConfigKeyReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/config/MetaConfigKeyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKeyManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedMetaConfigKey";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAndStoreMetaConfigKeyIfMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Presentation(typeName="Configuration Key")
    private static final class MyNavigationFakeElement
    extends FakePsiElement {
        @NonNls
        static final String CONFIGURATION_KEY = "Configuration Key";
        private final PsiElement myElement;
        private final MetaConfigKeyReference<?> myReference;

        private MyNavigationFakeElement(MetaConfigKeyReference<?> reference) {
            this.myReference = reference;
            this.myElement = reference.getElement();
        }

        public String getName() {
            return this.myReference.getReferenceDisplayText();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                MyNavigationFakeElement.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return MyNavigationFakeElement.getListItemIcon(this.myElement);
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new PresentationData(this.myReference.getReferenceDisplayText(), "(" + SymbolPresentationUtil.getFilePathPresentation((PsiFile)this.myElement.getContainingFile()) + ")", MyNavigationFakeElement.getListItemIcon(this.myElement), null);
        }

        public PsiElement getParent() {
            return this.myElement;
        }

        private static Icon getListItemIcon(PsiElement navigationItem) {
            return navigationItem.getContainingFile().getIcon(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/microservices/config/MetaConfigKeyReference$MyNavigationFakeElement", "getNavigationElement"));
        }
    }
}

