/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.config;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaConfigKeyManager {
    @NonNls
    private static final String GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME = "Gradle: kaptGeneratedClasses";

    public List<? extends MetaConfigKey> getAllMetaConfigKeys(@Nullable PsiElement psiElement) {
        return psiElement == null ? Collections.emptyList() : this.getAllMetaConfigKeys(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
    }

    public abstract List<? extends MetaConfigKey> getAllMetaConfigKeys(@Nullable Module var1);

    @Nullable
    @Contract(value="_, null -> null; null, !null -> null")
    public MetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.doFindApplicationMetaConfigKey(module, configKey, false);
    }

    @Nullable
    public MetaConfigKey findCanonicalApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.doFindApplicationMetaConfigKey(module, configKey, true);
    }

    @Nullable
    private MetaConfigKey doFindApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey, boolean canonicalNotation) {
        if (configKey == null || module == null) {
            return null;
        }
        List<? extends MetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            return null;
        }
        if (canonicalNotation) {
            return (MetaConfigKey)ContainerUtil.find(allKeys, key -> configKey.equals(key.getName()));
        }
        MetaConfigKey exact = (MetaConfigKey)ContainerUtil.find(allKeys, this.createNormalAccessTypeMatchingCondition(configKey));
        if (exact != null) {
            return exact;
        }
        ConfigKeyNameBinder binder = this.getConfigKeyNameBinder(module);
        return (MetaConfigKey)ContainerUtil.find(allKeys, key -> binder.bindsTo((MetaConfigKey)key, configKey));
    }

    @NotNull
    public List<? extends MetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(0);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends MetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        List exact = ContainerUtil.findAll(allKeys, this.createNormalAccessTypeMatchingCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                MetaConfigKeyManager.$$$reportNull$$$0(3);
            }
            return list;
        }
        ConfigKeyNameBinder binder = this.getConfigKeyNameBinder(module);
        List list = ContainerUtil.findAll(allKeys, key -> binder.bindsTo((MetaConfigKey)key, configKey));
        if (list == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public abstract ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module var1);

    protected boolean isCaseSensitiveKeys() {
        return true;
    }

    @NotNull
    private Condition<MetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(5);
        }
        Condition condition = key -> key.isAccessType(MetaConfigKey.AccessType.NORMAL) && Comparing.equal((String)key.getName(), (String)configKey, (boolean)this.isCaseSensitiveKeys());
        if (condition == null) {
            MetaConfigKeyManager.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Nullable
    protected static File findLocalMetadataJsonFile(Module module, String relativeFilePath, boolean unitTestMode) {
        if (!unitTestMode) {
            String compilerOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (compilerOutputPath == null) {
                return null;
            }
            File compilerOutputJson = MetaConfigKeyManager.findInOutputPath(compilerOutputPath, relativeFilePath);
            if (compilerOutputJson != null) {
                return compilerOutputJson;
            }
            return MetaConfigKeyManager.findLocalMetadataJsonFileForKapt(module, relativeFilePath);
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/" + relativeFilePath);
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File localJsonFile = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    private static File findLocalMetadataJsonFileForKapt(Module module, String relativeFilePath) {
        LibraryOrderEntry entry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)ModuleRootManager.getInstance((Module)module), (String)GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME);
        if (entry == null) {
            return null;
        }
        for (VirtualFile virtualFile : entry.getRootFiles(OrderRootType.CLASSES)) {
            File file = MetaConfigKeyManager.findInOutputPath(VirtualFileManager.extractPath((String)virtualFile.getUrl()), relativeFilePath);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static File findInOutputPath(String outputPath, String relativeFilePath) {
        String metadataJsonPath = outputPath + "/META-INF/" + relativeFilePath;
        File localJsonFile = new File(metadataJsonPath);
        return localJsonFile.exists() ? localJsonFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/config/MetaConfigKeyManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllApplicationMetaConfigKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/config/MetaConfigKeyManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalAccessTypeMatchingCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNormalAccessTypeMatchingCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ConfigKeyNameBinder {
        public boolean bindsTo(@NotNull MetaConfigKey var1, @NotNull String var2);

        public boolean matchesPrefix(@NotNull MetaConfigKey var1, @NotNull String var2);

        public boolean matchesPart(@NotNull String var1, @NotNull String var2);

        @Nullable
        public String bindsToKeyProperty(@NotNull MetaConfigKey var1, @Nullable String var2, @NotNull String var3);
    }
}

