/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.laf.win10;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public final class WinIntelliJSliderUI
extends BasicSliderUI {
    private static final String HOVER_PROPERTY = "JSlider.mouseHover";
    private static final String PRESSED_PROPERTY = "JSlider.mousePressed";
    private MouseListener mouseListener;
    private Color ticksColor;

    private WinIntelliJSliderUI() {
        super(null);
    }

    public static ComponentUI createUI(JComponent b) {
        return new WinIntelliJSliderUI();
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.setProperty(e, WinIntelliJSliderUI.PRESSED_PROPERTY, Boolean.TRUE);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.setProperty(e, WinIntelliJSliderUI.PRESSED_PROPERTY, Boolean.FALSE);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setProperty(e, WinIntelliJSliderUI.HOVER_PROPERTY, Boolean.TRUE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setProperty(e, WinIntelliJSliderUI.HOVER_PROPERTY, Boolean.FALSE);
            }

            private void setProperty(MouseEvent e, String property, Boolean value) {
                JComponent c = (JComponent)e.getComponent();
                c.putClientProperty(property, value);
                c.repaint();
            }
        };
        slider.addMouseListener(this.mouseListener);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        if (this.mouseListener != null) {
            slider.removeMouseListener(this.mouseListener);
        }
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Rectangle2D.Double scaleRect;
            Rectangle2D.Double coloredTrack;
            int tw = JBUIScale.scale((int)1);
            if (this.slider.getOrientation() == 0) {
                coloredTrack = new Rectangle2D.Double(this.trackRect.x - this.thumbRect.width / 2, this.trackRect.y + this.trackRect.height - JBUIScale.scale((int)10), this.thumbRect.x - this.trackRect.x + this.thumbRect.width, tw);
                scaleRect = new Rectangle2D.Double(this.thumbRect.x + this.thumbRect.width / 2, this.trackRect.y + this.trackRect.height - JBUIScale.scale((int)10), this.trackRect.x + this.trackRect.width - this.thumbRect.x - tw, tw);
            } else {
                coloredTrack = new Rectangle2D.Double(this.trackRect.x + this.thumbRect.width - JBUIScale.scale((int)10), this.trackRect.y - this.thumbRect.height / 2, tw, this.thumbRect.y - this.trackRect.y + this.thumbRect.height);
                scaleRect = new Rectangle2D.Double(this.trackRect.x + this.thumbRect.width - JBUIScale.scale((int)10), this.thumbRect.y + this.thumbRect.height / 2, tw, this.trackRect.y + this.trackRect.height - this.thumbRect.y - tw);
            }
            g2.setColor(this.getSliderColor());
            g2.fill(coloredTrack);
            Color scaleColor = UIManager.getColor(this.slider.isEnabled() ? "Button.intellij.native.borderColor" : "Slider.disabledForeground");
            g2.setColor(scaleColor);
            g2.fill(scaleRect);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.setBounds(this.contentRect.x + this.trackBuffer, this.contentRect.y + (this.contentRect.height - centerSpacing) / 2, this.contentRect.width - this.trackBuffer * 2, this.thumbRect.height);
        } else {
            int centerSpacing = this.thumbRect.width;
            int offset = JBUIScale.scale((int)6);
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                    offset = -offset;
                }
            } else if (this.slider.getPaintLabels()) {
                centerSpacing -= this.getWidthOfWidestLabel();
            }
            this.trackRect.setBounds(this.contentRect.x + (this.contentRect.width - centerSpacing) / 2 + offset, this.contentRect.y + this.trackBuffer, this.thumbRect.width, this.contentRect.height - this.trackBuffer * 2);
        }
    }

    @Override
    protected void calculateTickRect() {
        super.calculateTickRect();
        if (this.slider.getOrientation() == 0) {
            this.tickRect.y -= JBUIScale.scale((int)5);
        } else {
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= JBUIScale.scale((int)5)) : this.trackRect.x + JBUIScale.scale((int)5);
        }
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 1) {
                int distance = JBUIScale.scale((int)11);
                this.labelRect.x = this.labelRect.x + (this.slider.getComponentOrientation().isLeftToRight() ? distance : -distance);
            } else {
                this.labelRect.y += JBUIScale.scale((int)6);
            }
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return this.slider.getOrientation() == 1 ? new JBDimension(22, 8) : new JBDimension(8, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(this.thumbRect.x, this.thumbRect.y);
            Path2D.Float thumb = new Path2D.Float(1);
            if (this.slider.getOrientation() == 1) {
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    ((Path2D)thumb).moveTo(0.0, 0.0);
                    ((Path2D)thumb).lineTo(this.thumbRect.width - JBUIScale.scale((int)4), 0.0);
                    ((Path2D)thumb).lineTo(this.thumbRect.width, this.thumbRect.height / 2);
                    ((Path2D)thumb).lineTo(this.thumbRect.width - JBUIScale.scale((int)4), this.thumbRect.height);
                    ((Path2D)thumb).lineTo(0.0, this.thumbRect.height);
                } else {
                    ((Path2D)thumb).moveTo(this.thumbRect.width, 0.0);
                    ((Path2D)thumb).lineTo(this.thumbRect.width, this.thumbRect.height);
                    ((Path2D)thumb).lineTo(JBUIScale.scale((int)4), this.thumbRect.height);
                    ((Path2D)thumb).lineTo(0.0, this.thumbRect.height / 2);
                    ((Path2D)thumb).lineTo(JBUIScale.scale((int)4), 0.0);
                }
            } else {
                ((Path2D)thumb).moveTo(0.0, 0.0);
                ((Path2D)thumb).lineTo(this.thumbRect.width, 0.0);
                ((Path2D)thumb).lineTo(this.thumbRect.width, this.thumbRect.height - JBUIScale.scale((int)4));
                ((Path2D)thumb).lineTo(this.thumbRect.width / 2, this.thumbRect.height);
                ((Path2D)thumb).lineTo(0.0, this.thumbRect.height - JBUIScale.scale((int)4));
            }
            thumb.closePath();
            g2.setColor(this.getSliderColor());
            g2.fill(thumb);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected int getTickLength() {
        return JBUIScale.scale((int)4);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        Rectangle2D.Double tick = new Rectangle2D.Double((double)x - 0.5, 0.0, JBUIScale.scale((int)1), tickBounds.height);
        this.paintSliderTick(g, tick);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.paintMinorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        Rectangle2D.Double tick = new Rectangle2D.Double(0.0, (double)y - 0.5, tickBounds.width, JBUIScale.scale((int)1));
        this.paintSliderTick(g, tick);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.paintMinorTickForVertSlider(g, tickBounds, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintSliderTick(Graphics g, Rectangle2D shape) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(this.ticksColor);
            g2.fill(shape);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public void paintTicks(Graphics g) {
        this.ticksColor = UIManager.getColor(this.slider.isEnabled() ? "Button.intellij.native.borderColor" : "Slider.disabledForeground");
        super.paintTicks(g);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    private Color getSliderColor() {
        if (this.slider.isEnabled()) {
            if (this.slider.getClientProperty(PRESSED_PROPERTY) == Boolean.TRUE) {
                return UIManager.getColor("Slider.pressedColor");
            }
            if (this.slider.getClientProperty(HOVER_PROPERTY) == Boolean.TRUE || this.slider.hasFocus()) {
                return UIManager.getColor("Slider.focusedColor");
            }
            return UIManager.getColor("Slider.foreground");
        }
        return UIManager.getColor("Slider.disabledForeground");
    }
}

