/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.laf.win10;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxUI;
import com.intellij.laf.win10.WinIconLookup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJCheckBoxUI
extends DarculaCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)13))).asUIResource();

    public static ComponentUI createUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        return new WinIntelliJCheckBoxUI();
    }

    protected Rectangle updateViewRect(AbstractButton b, Rectangle viewRect) {
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)b.getInsets());
        return viewRect;
    }

    protected Dimension computeOurPreferredSize(JComponent c) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            ButtonModel bm = b.getModel();
            String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
            Object op = b.getClientProperty("JComponent.outline");
            boolean focused = op == null && c.hasFocus() || bm.isRollover() || WinIntelliJCheckBoxUI.isCellRollover(b);
            boolean pressed = bm.isPressed() || WinIntelliJCheckBoxUI.isCellPressed(b);
            Icon icon = WinIconLookup.getIcon(iconName, selected || this.isIndeterminate(b), focused, enabled, false, pressed);
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
            if (op != null) {
                DarculaUIUtil.Outline.valueOf((String)op.toString()).setGraphicsColor(g2, b.hasFocus());
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(new Rectangle2D.Float(iconRect.x - JBUIScale.scale((int)1), iconRect.y - JBUIScale.scale((int)1), JBUIScale.scale((int)15), JBUIScale.scale((int)15)), false);
                outline.append(new Rectangle2D.Float(iconRect.x + JBUIScale.scale((int)1), iconRect.y + JBUIScale.scale((int)1), JBUIScale.scale((int)11), JBUIScale.scale((int)11)), false);
                g2.fill(outline);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static boolean isCellRollover(AbstractButton checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.rollOver.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    private static boolean isCellPressed(AbstractButton checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.pressed.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)4);
    }

    protected int getMnemonicIndex(AbstractButton b) {
        return b.getDisplayedMnemonicIndex();
    }
}

