/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ide;

import com.intellij.ide.PasteProvider;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ide.ImagePasteProviderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/ide/ImagePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "imageFilePasted", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEnabledForDataContext", "", "isPasteEnabled", "isPastePossible", "performPaste", "intellij.platform.images"})
public class ImagePasteProvider
implements PasteProvider {
    public final boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return CopyPasteManager.getInstance().areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.imageFlavor}) && dataContext.getData(CommonDataKeys.VIRTUAL_FILE) != null && this.isEnabledForDataContext(dataContext);
    }

    public boolean isEnabledForDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public final void performPaste(@NotNull DataContext dataContext) {
        BufferedImage imageToPaste;
        BufferedImage bufferedImage;
        Object object;
        VirtualFile newFileParent;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dataContext.getData(Comm\u2026taKeys.PROJECT) ?: return");
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"dataContext.getData(Comm\u2026s.VIRTUAL_FILE) ?: return");
        VirtualFile currentFile = virtualFile;
        CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)copyPasteManager, (String)"CopyPasteManager.getInstance()");
        Transferable transferable = copyPasteManager.getContents();
        if (transferable == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)transferable, (String)"CopyPasteManager.getInstance().contents ?: return");
        Transferable pasteContents = transferable;
        if (DumbService.isDumb((Project)project2)) {
            DumbService.getInstance((Project)project2).showDumbModeNotification(LangBundle.message((String)"popup.content.sorry.file.copy.paste.available.during.indexing", (Object[])new Object[0]));
            return;
        }
        VirtualFile virtualFile2 = newFileParent = currentFile.isDirectory() ? currentFile : currentFile.getParent();
        if (newFileParent == null || !newFileParent.isDirectory()) {
            return;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImagePasteProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Logger logger2 = logger;
        try {
            object = pasteContents.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException ioException) {
            logger2.error("Failed to get data from the clipboard. Data is no longer available. Aborting operation.", (Throwable)ioException);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof MultiResolutionImage) {
            List<Image> list = ((MultiResolutionImage)it).getResolutionVariants();
            Intrinsics.checkNotNullExpressionValue(list, (String)"it.resolutionVariants");
            Image image = (Image)CollectionsKt.firstOrNull(list);
            bufferedImage = image != null ? ImagePasteProviderKt.access$toBufferedImage(image) : null;
        } else {
            bufferedImage = object2 instanceof BufferedImage ? (BufferedImage)it : (object2 instanceof Image ? ImagePasteProviderKt.access$toBufferedImage((Image)it) : null);
        }
        if ((imageToPaste = bufferedImage) == null) {
            logger2.error("Failed to get data from the clipboard. Nothing to paste. Aborting operation.");
            return;
        }
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, newFileParent, logger2, imageToPaste, dataContext){
            final /* synthetic */ ImagePasteProvider this$0;
            final /* synthetic */ VirtualFile $newFileParent$inlined;
            final /* synthetic */ Logger $logger$inlined;
            final /* synthetic */ BufferedImage $imageToPaste$inlined;
            final /* synthetic */ DataContext $dataContext$inlined;
            {
                this.this$0 = imagePasteProvider;
                this.$newFileParent$inlined = virtualFile;
                this.$logger$inlined = logger;
                this.$imageToPaste$inlined = bufferedImage;
                this.$dataContext$inlined = dataContext;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                block14: {
                    Object object;
                    boolean bl = false;
                    String string = VfsUtil.getNextAvailableName((VirtualFile)this.$newFileParent$inlined, (String)"img", (String)"png");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.getNextAvailable\u2026FileParent, \"img\", \"png\")");
                    String nextAvailableName = string;
                    try {
                        object = this.$newFileParent$inlined.createChildData((Object)this.this$0, nextAvailableName);
                    }
                    catch (IOException ioException) {
                        this.$logger$inlined.error("Failed to create a pasted image file due to I/O error. Aborting operation.", (Throwable)ioException);
                        object = null;
                    }
                    VirtualFile virtualFile = object;
                    if (virtualFile == null) {
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"try {\n        newFilePar\u2026 ?: return@runWriteAction");
                        VirtualFile imageFile = virtualFile;
                        try {
                            object = imageFile.getOutputStream((Object)this.this$0);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            Throwable throwable = null;
                            try {
                                OutputStream it = (OutputStream)object;
                                boolean bl4 = false;
                                boolean bl5 = ImageIO.write((RenderedImage)this.$imageToPaste$inlined, "png", it);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            }
                        }
                        catch (IOException ioException) {
                            this.$logger$inlined.error("Failed to save a pasted image to a file due to I/O error. Aborting operation", (Throwable)ioException);
                            try {
                                imageFile.delete((Object)this.this$0);
                            }
                            catch (IOException iOException) {}
                            break block14;
                        }
                        this.this$0.imageFilePasted(this.$dataContext$inlined, imageFile);
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public void imageFilePasted(@NotNull DataContext dataContext, @NotNull VirtualFile imageFile) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)imageFile, (String)"imageFile");
    }
}

