/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.ddmlib.ByteBufferUtil;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.perflib.vmtrace.VmClockType;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.primitives.UnsignedInts;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VmTraceParser {
    private static final int TRACE_MAGIC = 1464814675;
    private static final String HEADER_SECTION_VERSION = "*version";
    private static final String HEADER_SECTION_THREADS = "*threads";
    private static final String HEADER_SECTION_METHODS = "*methods";
    private static final String HEADER_END = "*end";
    private static final String KEY_CLOCK = "clock";
    private final File mTraceFile;
    private final VmTraceHandler mTraceDataHandler;
    private int mVersion;
    private VmClockType mVmClockType;
    private static final int PARSE_VERSION = 0;
    private static final int PARSE_METHODS = 1;
    private static final int PARSE_THREADS = 2;
    private static final int PARSE_SUMMARY = 3;
    private static final int PARSE_OPTIONS = 4;

    public VmTraceParser(File traceFile, VmTraceHandler traceHandler) {
        if (!traceFile.exists()) {
            throw new IllegalArgumentException("Trace file " + traceFile.getAbsolutePath() + " does not exist.");
        }
        this.mTraceFile = traceFile;
        this.mTraceDataHandler = traceHandler;
    }

    public void parse() throws IOException {
        ByteBuffer buffer;
        if (VmTraceParser.isStreamingTrace(this.mTraceFile)) {
            StreamingTraceParser streamingTraceParser = new StreamingTraceParser(this.mTraceFile);
            buffer = streamingTraceParser.parse();
        } else {
            long headerLength = this.parseHeader(this.mTraceFile);
            buffer = ByteBufferUtil.mapFile((File)this.mTraceFile, (long)headerLength, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        }
        this.parseData(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStreamingTrace(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.US_ASCII));){
            String firstLine = in.readLine();
            if (firstLine != null && firstLine.startsWith(HEADER_SECTION_VERSION)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long parseHeader(File f) throws IOException {
        long offset = 0L;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charsets.UTF_8));
            int mode = 0;
            while (true) {
                String line;
                if ((line = in.readLine()) == null) {
                    throw new IOException("Key section does not have an *end marker");
                }
                offset += (long)(line.getBytes(Charsets.UTF_8).length + 1);
                if (line.startsWith("*")) {
                    if (line.equals(HEADER_SECTION_VERSION)) {
                        mode = 0;
                        continue;
                    }
                    if (line.equals(HEADER_SECTION_THREADS)) {
                        mode = 2;
                        continue;
                    }
                    if (line.equals(HEADER_SECTION_METHODS)) {
                        mode = 1;
                        continue;
                    }
                    if (line.equals(HEADER_END)) break;
                }
                switch (mode) {
                    case 0: {
                        this.mVersion = Integer.decode(line);
                        this.mTraceDataHandler.setVersion(this.mVersion);
                        mode = 4;
                        break;
                    }
                    case 2: {
                        this.parseThread(line);
                        break;
                    }
                    case 1: {
                        this.parseMethod(line);
                        break;
                    }
                    case 4: {
                        this.parseOption(line);
                    }
                }
            }
            if (in == null) return offset;
        }
        catch (Throwable throwable) {
            if (in == null) throw throwable;
            try {
                Closeables.close(in, (boolean)true);
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            Closeables.close((Closeable)in, (boolean)true);
            return offset;
        }
        catch (IOException iOException) {}
        return offset;
    }

    private void parseOption(String line) {
        String[] tokens = line.split("=");
        if (tokens.length == 2) {
            String key = tokens[0];
            String value = tokens[1];
            this.mTraceDataHandler.setProperty(key, value);
            if (key.equals(KEY_CLOCK)) {
                if (value.equals("thread-cpu")) {
                    this.mVmClockType = VmClockType.THREAD_CPU;
                } else if (value.equals("wall")) {
                    this.mVmClockType = VmClockType.WALL;
                } else if (value.equals("dual")) {
                    this.mVmClockType = VmClockType.DUAL;
                }
            }
        }
    }

    private void parseThread(String line) {
        int index = line.indexOf(9);
        if (index < 0) {
            return;
        }
        try {
            int id = Integer.decode(line.substring(0, index));
            String name = line.substring(index).trim();
            this.mTraceDataHandler.addThread(id, name);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void parseMethod(String line) {
        long id;
        String[] tokens = line.split("\t");
        try {
            id = Long.decode(tokens[0]);
        }
        catch (NumberFormatException e) {
            return;
        }
        String className = tokens[1];
        String methodName = null;
        String signature = null;
        String pathname = null;
        int lineNumber = -1;
        if (tokens.length == 6) {
            methodName = tokens[2];
            signature = tokens[3];
            pathname = tokens[4];
            lineNumber = Integer.decode(tokens[5]);
            pathname = this.constructPathname(className, pathname);
        } else if (tokens.length > 2) {
            if (tokens[3].startsWith("(")) {
                methodName = tokens[2];
                signature = tokens[3];
                if (tokens.length >= 5) {
                    pathname = tokens[4];
                }
            } else {
                pathname = tokens[2];
                lineNumber = Integer.decode(tokens[3]);
            }
        }
        this.mTraceDataHandler.addMethod(id, new MethodInfo(id, className, methodName, signature, pathname, lineNumber));
    }

    private String constructPathname(String className, String pathname) {
        int index = className.lastIndexOf(47);
        if (index > 0 && index < className.length() - 1 && pathname.endsWith(".java")) {
            pathname = className.substring(0, index + 1) + pathname;
        }
        return pathname;
    }

    private void parseData(ByteBuffer buffer) {
        int recordSize = this.readDataFileHeader(buffer);
        this.parseMethodTraceData(buffer, recordSize);
    }

    private void parseMethodTraceData(ByteBuffer buffer, int recordSize) {
        int version = this.mVersion;
        while (buffer.hasRemaining()) {
            TraceAction methodAction;
            int threadTime;
            int globalTime;
            int positionStart = buffer.position();
            short threadId = version == 1 ? buffer.get() : buffer.getShort();
            int methodId = buffer.getInt();
            switch (this.mVmClockType) {
                case WALL: {
                    threadTime = globalTime = buffer.getInt();
                    break;
                }
                case DUAL: {
                    threadTime = buffer.getInt();
                    globalTime = buffer.getInt();
                    break;
                }
                default: {
                    globalTime = threadTime = buffer.getInt();
                }
            }
            int positionEnd = buffer.position();
            int bytesRead = positionEnd - positionStart;
            if (bytesRead < recordSize) {
                buffer.position(positionEnd + (recordSize - bytesRead));
            }
            int action = methodId & 3;
            switch (action) {
                case 0: {
                    methodAction = TraceAction.METHOD_ENTER;
                    break;
                }
                case 1: {
                    methodAction = TraceAction.METHOD_EXIT;
                    break;
                }
                case 2: {
                    methodAction = TraceAction.METHOD_EXIT_UNROLL;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid trace action, expected one of method entry, exit or unroll.");
                }
            }
            this.mTraceDataHandler.addMethodAction(threadId, UnsignedInts.toLong((int)(methodId &= 0xFFFFFFFC)), methodAction, threadTime, globalTime);
        }
    }

    private int readDataFileHeader(ByteBuffer buffer) {
        int recordSize;
        VmTraceParser.validateMagic(buffer.getInt());
        short version = buffer.getShort();
        if (version != this.mVersion) {
            String msg = String.format("Error: version number mismatch; got %d in data header but %d in options\n", version, this.mVersion);
            throw new RuntimeException(msg);
        }
        VmTraceParser.validateTraceVersion(version);
        int offsetToData = buffer.getShort() - 16;
        this.mTraceDataHandler.setStartTimeUs(buffer.getLong());
        switch (version) {
            case 1: {
                recordSize = 9;
                break;
            }
            case 2: {
                recordSize = 10;
                break;
            }
            default: {
                recordSize = buffer.getShort();
                offsetToData -= 2;
            }
        }
        while (offsetToData-- > 0) {
            buffer.get();
        }
        return recordSize;
    }

    private static void validateTraceVersion(int version) {
        if (version < 1 || version > 3) {
            String msg = String.format("Error: unsupported trace version number %d.  Please use a newer version of TraceView to read this file.", version);
            throw new RuntimeException(msg);
        }
    }

    private static void validateMagic(int magic) {
        if (magic != 1464814675) {
            String msg = String.format("Error: magic number mismatch; got 0x%x, expected 0x%x\n", magic, 1464814675);
            throw new RuntimeException(msg);
        }
    }

    private class StreamingTraceParser {
        private static final int STREAMING_TRACE_VERSION_MASK = 240;
        private File mTraceFile;
        private DataInputStream mInputStream;
        private ByteArrayOutputStream mByteOutputStream;

        private StreamingTraceParser(File streamingTraceFile) throws IOException {
            this.mTraceFile = streamingTraceFile;
            this.mInputStream = new DataInputStream(new FileInputStream(this.mTraceFile));
            this.mByteOutputStream = new ByteArrayOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer parse() throws IOException {
            try {
                int recordSize;
                int magic = this.readNumberLE(4);
                VmTraceParser.validateMagic(magic);
                this.writeNumberLE(magic, 4);
                int version = this.readNumberLE(2);
                VmTraceParser.validateTraceVersion(version ^= 0xF0);
                this.writeNumberLE(version, 2);
                VmTraceParser.this.mVersion = version;
                VmTraceParser.this.mTraceDataHandler.setVersion(version);
                int offsetToData = this.readNumberLE(2) - 16;
                this.writeNumberLE(offsetToData + 16, 2);
                this.copyBytes(8);
                switch (version) {
                    case 1: {
                        recordSize = 9;
                        break;
                    }
                    case 2: {
                        recordSize = 10;
                        break;
                    }
                    default: {
                        recordSize = this.readNumberLE(2);
                        this.writeNumberLE(recordSize, 2);
                        offsetToData -= 2;
                    }
                }
                this.copyBytes(offsetToData);
                try {
                    while (true) {
                        int threadId;
                        if ((threadId = this.readNumberLE(2)) == 0) {
                            int code = this.mInputStream.readUnsignedByte();
                            if (code == 1) {
                                int methodLineLength = this.readNumberLE(2);
                                VmTraceParser.this.parseMethod(this.readString(methodLineLength));
                                continue;
                            }
                            if (code == 2) {
                                int tid = this.readNumberLE(2);
                                int threadLineLength = this.readNumberLE(2);
                                String name = this.readString(threadLineLength);
                                VmTraceParser.this.mTraceDataHandler.addThread(tid, name);
                                continue;
                            }
                            if (code == 3) {
                                int summaryLength = this.readNumberLE(4);
                                String summary = this.readString(summaryLength);
                                this.processSummary(summary);
                                break;
                            }
                            throw new RuntimeException("Invalid trace format: got an invalid code.");
                        }
                        this.writeNumberLE(threadId, 2);
                        this.copyBytes(recordSize - 2);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    Closeables.close((Closeable)this.mInputStream, (boolean)true);
                }
                catch (IOException iOException) {}
            }
            return ByteBuffer.wrap(this.mByteOutputStream.toByteArray()).order(ByteOrder.LITTLE_ENDIAN);
        }

        private void processSummary(String summary) {
            int lineIndex;
            String[] summaryLines = summary.split("\n");
            assert (summaryLines.length > lineIndex);
            String line = summaryLines[lineIndex];
            for (lineIndex = 2; lineIndex < summaryLines.length && !line.equals("*threads\n"); ++lineIndex) {
                VmTraceParser.this.parseOption(summaryLines[lineIndex]);
            }
        }

        private void copyBytes(int numBytes) throws IOException {
            byte[] bytesToCopy = new byte[numBytes];
            int bytesRead = this.mInputStream.read(bytesToCopy);
            if (bytesRead != numBytes) {
                String msg = String.format("Invalid trace format: expected %d bytes, but found %d\n", numBytes, bytesRead);
                throw new RuntimeException(msg);
            }
            this.mByteOutputStream.write(bytesToCopy);
        }

        private String readString(int length) throws IOException {
            byte[] buffer = new byte[length];
            for (int i = 0; i < length; ++i) {
                buffer[i] = (byte)this.mInputStream.readUnsignedByte();
            }
            return new String(buffer, Charsets.UTF_8);
        }

        private int readNumberLE(int numBytes) throws IOException {
            int leNumber = 0;
            for (int i = 0; i < numBytes; ++i) {
                leNumber += this.mInputStream.readUnsignedByte() << i * 8;
            }
            return leNumber;
        }

        private void writeNumberLE(int value, int numBytes) throws IOException {
            byte[] intBytes = new byte[numBytes];
            for (int i = 0; i < numBytes; ++i) {
                intBytes[i] = (byte)(value >> i * 8 & 0xFF);
            }
            this.mByteOutputStream.write(intBytes);
        }
    }
}

