/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.ext;

import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.SnapshotPostProcessor;

public class NativeRegistryPostProcessor
implements SnapshotPostProcessor {
    static final String CLEANER_CLASS = "sun.misc.Cleaner";
    static final String CLEANER_THUNK_CLASS = "libcore.util.NativeAllocationRegistry$CleanerThunk";
    static final String NATIVE_REGISTRY_CLASS = "libcore.util.NativeAllocationRegistry";
    private boolean myHasNativeAllocations;

    public boolean getHasNativeAllocations() {
        return this.myHasNativeAllocations;
    }

    @Override
    public void postProcess(Snapshot snapshot) {
        ClassObj cleanerClass = snapshot.findClass(CLEANER_CLASS);
        if (cleanerClass == null) {
            return;
        }
        block0: for (Instance cleanerInst : cleanerClass.getInstancesList()) {
            ClassInstance thunk;
            ClassObj thunkClass;
            ClassInstance cleaner = (ClassInstance)cleanerInst;
            Object referent = NativeRegistryPostProcessor.getField(cleaner, "referent");
            if (!(referent instanceof Instance)) continue;
            Instance inst = (Instance)referent;
            Object thunkValue = NativeRegistryPostProcessor.getField(cleaner, "thunk");
            if (!(thunkValue instanceof ClassInstance) || (thunkClass = (thunk = (ClassInstance)thunkValue).getClassObj()) == null || !CLEANER_THUNK_CLASS.equals(thunkClass.getClassName())) continue;
            for (ClassInstance.FieldValue thunkField : thunk.getValues()) {
                Object sizeValue;
                ClassInstance registry;
                ClassObj registryClass;
                if (!(thunkField.getValue() instanceof ClassInstance) || (registryClass = (registry = (ClassInstance)thunkField.getValue()).getClassObj()) == null || !NATIVE_REGISTRY_CLASS.equals(registryClass.getClassName()) || !((sizeValue = NativeRegistryPostProcessor.getField(registry, "size")) instanceof Long)) continue;
                inst.setNativeSize((Long)sizeValue);
                this.myHasNativeAllocations = true;
                continue block0;
            }
        }
    }

    private static Object getField(ClassInstance cls, String name) {
        for (ClassInstance.FieldValue field : cls.getValues()) {
            if (!name.equals(field.getField().getName())) continue;
            return field.getValue();
        }
        return null;
    }
}

