/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.captures;

import com.android.ddmlib.ByteBufferUtil;
import com.android.tools.perflib.captures.DataBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMappedFileBuffer
implements DataBuffer {
    private static final int DEFAULT_SIZE = 0x40000000;
    private static final int DEFAULT_PADDING = 1024;
    private final int mBufferSize;
    private final int mPadding;
    private final ByteBuffer[] mByteBuffers;
    private final long mLength;
    private long mCurrentPosition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryMappedFileBuffer(File f, int bufferSize, int padding) throws IOException {
        this.mBufferSize = bufferSize;
        this.mPadding = padding;
        this.mLength = f.length();
        int shards = (int)(this.mLength / (long)this.mBufferSize) + 1;
        this.mByteBuffers = new ByteBuffer[shards];
        try (FileInputStream inputStream = new FileInputStream(f);){
            long offset = 0L;
            for (int i = 0; i < shards; ++i) {
                long size = Math.min(this.mLength - offset, (long)(this.mBufferSize + this.mPadding));
                this.mByteBuffers[i] = inputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size);
                this.mByteBuffers[i].order(HPROF_BYTE_ORDER);
                offset += (long)this.mBufferSize;
            }
            this.mCurrentPosition = 0L;
        }
    }

    public MemoryMappedFileBuffer(File f) throws IOException {
        this(f, 0x40000000, 1024);
    }

    @Override
    public void dispose() {
        for (ByteBuffer buffer : this.mByteBuffers) {
            ByteBufferUtil.cleanBuffer((ByteBuffer)buffer);
        }
    }

    @Override
    public byte readByte() {
        byte result = this.mByteBuffers[this.getIndex()].get(this.getOffset());
        ++this.mCurrentPosition;
        return result;
    }

    @Override
    public void append(byte[] data) {
    }

    @Override
    public void read(byte[] b) {
        int index = this.getIndex();
        this.mByteBuffers[index].position(this.getOffset());
        if (b.length <= this.mByteBuffers[index].remaining()) {
            this.mByteBuffers[index].get(b, 0, b.length);
        } else {
            int split = this.mBufferSize - this.mByteBuffers[index].position();
            this.mByteBuffers[index].get(b, 0, split);
            this.mByteBuffers[index + 1].position(0);
            this.mByteBuffers[index + 1].get(b, split, b.length - split);
        }
        this.mCurrentPosition += (long)b.length;
    }

    @Override
    public void readSubSequence(byte[] b, int sourceStart, int length) {
        assert ((long)length < this.mLength);
        this.mCurrentPosition += (long)sourceStart;
        int index = this.getIndex();
        this.mByteBuffers[index].position(this.getOffset());
        if (b.length <= this.mByteBuffers[index].remaining()) {
            this.mByteBuffers[index].get(b, 0, b.length);
        } else {
            int split = this.mBufferSize - this.mByteBuffers[index].position();
            this.mByteBuffers[index].get(b, 0, split);
            int start = split;
            int remainingMaxLength = Math.min(length - start, b.length - start);
            int remainingShardCount = (remainingMaxLength + this.mBufferSize - 1) / this.mBufferSize;
            for (int i = 0; i < remainingShardCount; ++i) {
                int maxToRead = Math.min(remainingMaxLength, this.mBufferSize);
                this.mByteBuffers[index + 1 + i].position(0);
                this.mByteBuffers[index + 1 + i].get(b, start, maxToRead);
                start += maxToRead;
                remainingMaxLength -= maxToRead;
            }
        }
        this.mCurrentPosition += (long)Math.min(b.length, length);
    }

    @Override
    public char readChar() {
        char result = this.mByteBuffers[this.getIndex()].getChar(this.getOffset());
        this.mCurrentPosition += 2L;
        return result;
    }

    @Override
    public short readShort() {
        short result = this.mByteBuffers[this.getIndex()].getShort(this.getOffset());
        this.mCurrentPosition += 2L;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.mByteBuffers[this.getIndex()].getInt(this.getOffset());
        this.mCurrentPosition += 4L;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.mByteBuffers[this.getIndex()].getLong(this.getOffset());
        this.mCurrentPosition += 8L;
        return result;
    }

    @Override
    public float readFloat() {
        float result = this.mByteBuffers[this.getIndex()].getFloat(this.getOffset());
        this.mCurrentPosition += 4L;
        return result;
    }

    @Override
    public double readDouble() {
        double result = this.mByteBuffers[this.getIndex()].getDouble(this.getOffset());
        this.mCurrentPosition += 8L;
        return result;
    }

    @Override
    public void setPosition(long position) {
        this.mCurrentPosition = position;
    }

    @Override
    public long position() {
        return this.mCurrentPosition;
    }

    @Override
    public boolean hasRemaining() {
        return this.mCurrentPosition < this.mLength;
    }

    @Override
    public long remaining() {
        return this.mLength - this.mCurrentPosition;
    }

    private int getIndex() {
        return (int)(this.mCurrentPosition / (long)this.mBufferSize);
    }

    private int getOffset() {
        return (int)(this.mCurrentPosition % (long)this.mBufferSize);
    }
}

