/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020 H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020:H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/SmartStepTargetVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "lines", "Lcom/intellij/util/Range;", "", "consumer", "Lcom/intellij/util/containers/OrderedSet;", "Lcom/intellij/debugger/actions/SmartStepTarget;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/util/Range;Lcom/intellij/util/containers/OrderedSet;)V", "intrinsicMethods", "Lorg/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods;", "append", "", "target", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isIntrinsic", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isInvokeInBuiltinFunction", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "recordFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "recordFunctionCall", "expression", "recordGetter", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitSimpleNameExpression", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "kotlin.jvm-debugger.core"})
public final class SmartStepTargetVisitor
extends KtTreeVisitorVoid {
    private final IntrinsicMethods intrinsicMethods;
    private final KtElement element;
    private final Range<Integer> lines;
    private final OrderedSet<SmartStepTarget> consumer;

    private final void append(SmartStepTarget target) {
        Collection collection = (Collection)this.consumer;
        boolean bl = false;
        collection.add(target);
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
        this.recordFunction((KtFunction)ktFunctionLiteral);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (!this.recordFunction((KtFunction)function)) {
            super.visitNamedFunction(function);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean recordFunction(KtFunction function) {
        Map arguments;
        BindingContext context = ResolutionUtils.analyze$default((KtElement)((KtElement)function), null, (int)1, null);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((Call)CallUtilKt.getParentCall$default((KtElement)((KtElement)function), (BindingContext)context, (boolean)false, (int)2, null), (BindingContext)context);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Map map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"resolvedCall.valueArguments");
        Map map2 = arguments = map;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void param;
            boolean bl2;
            block5: {
                ResolvedValueArgument argument;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl3 = false;
                map2 = (ValueParameterDescriptor)entry2.getKey();
                entry2 = entry;
                bl3 = false;
                ResolvedValueArgument resolvedValueArgument = argument = (ResolvedValueArgument)entry2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedValueArgument, (String)"argument");
                List list = resolvedValueArgument.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"argument.arguments");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValueArgument it = (ValueArgument)element$iv;
                        boolean bl4 = false;
                        ValueArgument valueArgument = it;
                        Intrinsics.checkNotNullExpressionValue((Object)valueArgument, (String)"it");
                        if (!Intrinsics.areEqual((Object)this.getArgumentExpression(valueArgument), (Object)function)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)resultingDescriptor;
            void v7 = param;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"param");
            Name name = v7.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"param.name");
            String label2 = KotlinLambdaSmartStepTarget.Companion.calcLabel(declarationDescriptor, name);
            boolean isInline = InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)resultingDescriptor));
            KotlinType kotlinType = param.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"param.type");
            boolean isSuspend = FunctionTypesKt.isSuspendFunctionType((KotlinType)kotlinType);
            KotlinLambdaSmartStepTarget target = new KotlinLambdaSmartStepTarget(label2, function, this.lines, isInline, isSuspend);
            this.append(target);
            return true;
        }
        return false;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtLambdaExpression ktLambdaExpression;
        KtExpression ktExpression = it.getArgumentExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (ktLambdaExpression = (KtLambdaExpression)ktExpression) != null && (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) != null ? (KtExpression)ktLambdaExpression : it.getArgumentExpression();
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhileExpression(@NotNull KtWhileExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getCondition();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitForExpression(@NotNull KtForExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getLoopRange();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtExpression ktExpression = expression.getSubjectExpression();
            if (ktExpression == null) break block0;
            ktExpression.accept((PsiElementVisitor)this);
        }
    }

    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.recordFunctionCall((KtExpression)expression);
        super.visitArrayAccessExpression(expression);
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        this.recordFunctionCall((KtExpression)ktSimpleNameExpression);
        super.visitUnaryExpression(expression);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
        this.recordFunctionCall((KtExpression)ktOperationReferenceExpression);
        super.visitBinaryExpression(expression);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression calleeExpression = expression.getCalleeExpression();
        if (calleeExpression != null) {
            this.recordFunctionCall(calleeExpression);
        }
        super.visitCallExpression(expression);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.recordGetter(expression);
        super.visitSimpleNameExpression(expression);
    }

    private final void recordGetter(KtSimpleNameExpression expression) {
        BindingContext bindingContext = ResolutionUtils.analyze$default((KtElement)((KtElement)expression), null, (int)1, null);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        if (!(callableDescriptor instanceof PropertyDescriptor)) {
            callableDescriptor = null;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)callableDescriptor;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor2.getGetter();
        if (getterDescriptor == null || getterDescriptor.isDefault()) {
            return;
        }
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        PsiElement psiElement = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)getterDescriptor);
        if (!(psiElement instanceof KtDeclaration)) {
            psiElement = null;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)psiElement;
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration ktDeclaration2 = ktDeclaration;
        ResolvedCall delegatedResolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)getterDescriptor);
        if (delegatedResolvedCall != null) {
            CallableDescriptor callableDescriptor2 = delegatedResolvedCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"delegatedResolvedCall.resultingDescriptor");
            FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)callableDescriptor2;
            String label2 = propertyDescriptor2.getName() + '.' + KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)delegatedPropertyGetterDescriptor);
            this.append(new KotlinMethodSmartStepTarget((CallableMemberDescriptor)delegatedPropertyGetterDescriptor, ktDeclaration2, label2, (PsiElement)expression, this.lines));
        } else if (ktDeclaration2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)ktDeclaration2).hasBody()) {
            String label3 = KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)getterDescriptor);
            this.append(new KotlinMethodSmartStepTarget((CallableMemberDescriptor)getterDescriptor, ktDeclaration2, label3, (PsiElement)expression, this.lines));
        }
    }

    private final void recordFunctionCall(KtExpression expression) {
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expression), null, (int)1, null);
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor descriptor = resolvedCall2.getResultingDescriptor();
        if (!(descriptor instanceof FunctionDescriptor) || this.isIntrinsic((CallableMemberDescriptor)descriptor)) {
            return;
        }
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)descriptor);
        if (SpecialBuiltinMembers.isFromJava((CallableMemberDescriptor)((CallableMemberDescriptor)descriptor))) {
            if (declaration2 instanceof PsiMethod) {
                this.append((SmartStepTarget)new MethodSmartStepTarget((PsiMethod)declaration2, null, (PsiElement)expression, false, this.lines));
            }
        } else {
            KtExpression ktExpression;
            if (declaration2 == null && !this.isInvokeInBuiltinFunction((DeclarationDescriptor)descriptor)) {
                return;
            }
            PsiElement psiElement = declaration2;
            if (!(psiElement != null ? psiElement instanceof KtDeclaration : true)) {
                return;
            }
            if (descriptor instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor).isPrimary() && declaration2 instanceof KtClass && ((KtClass)declaration2).getAnonymousInitializers().isEmpty()) {
                return;
            }
            if (declaration2 instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)declaration2)) {
                return;
            }
            String callLabel = KotlinMethodSmartStepTarget.Companion.calcLabel((DeclarationDescriptor)descriptor);
            CallableDescriptor callableDescriptor = descriptor;
            String label2 = callableDescriptor instanceof FunctionInvokeDescriptor ? ((ktExpression = expression) instanceof KtSimpleNameExpression ? (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(expression){
                final /* synthetic */ KtExpression $expression;

                public final String invoke() {
                    return ((KtSimpleNameExpression)this.$expression).getText();
                }
                {
                    this.$expression = ktExpression;
                    super(0);
                }
            })) + '.' + callLabel : callLabel) : callLabel;
            this.append(new KotlinMethodSmartStepTarget((CallableMemberDescriptor)descriptor, (KtDeclaration)declaration2, label2, (PsiElement)expression, this.lines));
        }
    }

    private final boolean isIntrinsic(CallableMemberDescriptor descriptor) {
        return this.intrinsicMethods.getIntrinsic(descriptor) != null;
    }

    private final boolean isInvokeInBuiltinFunction(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof FunctionInvokeDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((FunctionInvokeDescriptor)descriptor).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        SimpleType simpleType = classDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"classDescriptor.defaultType");
        return FunctionTypesKt.isBuiltinFunctionalType((KotlinType)((KotlinType)simpleType));
    }

    /*
     * WARNING - void declaration
     */
    public SmartStepTargetVisitor(@NotNull KtElement element, @NotNull Range<Integer> lines, @NotNull OrderedSet<SmartStepTarget> consumer) {
        IntrinsicMethods intrinsicMethods;
        JdkPlatform jdkPlatform;
        Object v0;
        block2: {
            void $this$run;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.element = element;
            this.lines = lines;
            this.consumer = consumer;
            SmartStepTargetVisitor smartStepTargetVisitor = this;
            boolean bl = false;
            boolean bl2 = false;
            SmartStepTargetVisitor smartStepTargetVisitor2 = smartStepTargetVisitor;
            SmartStepTargetVisitor smartStepTargetVisitor3 = this;
            boolean bl3 = false;
            Iterable $this$firstIsInstanceOrNull$iv = (Iterable)PlatformKt.getPlatform((KtElement)$this$run.element);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof JdkPlatform)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((jdkPlatform = (JdkPlatform)v0) == null || (jdkPlatform = jdkPlatform.getTargetVersion()) == null) {
            jdkPlatform = JvmTarget.DEFAULT;
        }
        JdkPlatform jvmTarget = jdkPlatform;
        smartStepTargetVisitor3.intrinsicMethods = intrinsicMethods = new IntrinsicMethods((JvmTarget)jvmTarget);
    }
}

