/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinOrdinaryMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepIntoHandler;", "Lcom/intellij/debugger/actions/JvmSmartStepIntoHandler;", "()V", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "stepTarget", "Lcom/intellij/debugger/actions/SmartStepTarget;", "findSmartStepTargets", "", "position", "Lcom/intellij/debugger/SourcePosition;", "isAvailable", "", "kotlin.jvm-debugger.core"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public boolean isAvailable(@Nullable SourcePosition position) {
        SourcePosition sourcePosition2 = position;
        return (sourcePosition2 != null ? sourcePosition2.getFile() : null) instanceof KtFile;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@NotNull SourcePosition position) {
        KtElement ktElement;
        KtElement ktElement2;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        PsiFile psiFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"position.file");
        PsiFile file = psiFile;
        PsiElement psiElement = position.getElementAt();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        PsiElement psiElement2 = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)element, (int)textRange.getStartOffset());
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        if ((ktElement2 = (ktElement = (KtElement)psiElement2)) == null || (ktElement2 = ktElement2.getTextRange()) == null) {
            return CollectionsKt.emptyList();
        }
        KtElement elementTextRange = ktElement2;
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026le) ?: return emptyList()");
        Document document2 = document;
        Range lines = new Range((Comparable)Integer.valueOf(document2.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(document2.getLineNumber(elementTextRange.getEndOffset())));
        return (List)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<OrderedSet<SmartStepTarget>>(ktElement, lines){
            final /* synthetic */ KtElement $ktElement;
            final /* synthetic */ Range $lines;

            @NotNull
            public final OrderedSet<SmartStepTarget> invoke() {
                OrderedSet consumer = new OrderedSet();
                SmartStepTargetVisitor visitor = new SmartStepTargetVisitor(this.$ktElement, (Range<Integer>)this.$lines, (OrderedSet<SmartStepTarget>)consumer);
                this.$ktElement.accept((KtVisitor)visitor, null);
                return consumer;
            }
            {
                this.$ktElement = ktElement;
                this.$lines = range;
                super(0);
            }
        }));
    }

    @Nullable
    protected MethodFilter createMethodFilter(@Nullable SmartStepTarget stepTarget) {
        SmartStepTarget smartStepTarget = stepTarget;
        return smartStepTarget instanceof KotlinMethodSmartStepTarget ? (MethodFilter)new KotlinOrdinaryMethodFilter((KotlinMethodSmartStepTarget)stepTarget) : (smartStepTarget instanceof KotlinLambdaSmartStepTarget ? (MethodFilter)new KotlinLambdaMethodFilter((KotlinLambdaSmartStepTarget)stepTarget) : super.createMethodFilter(stepTarget));
    }
}

