/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0012\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "target", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaSmartStepTarget;", "(Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaSmartStepTarget;)V", "isInline", "", "isSuspend", "lambdaPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "myFirstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "myLastStatementLine", "getBreakpointPosition", "getCallingExpressionLines", "getLastStatementLine", "isLambdaName", "name", "", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "kotlin.jvm-debugger.core"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final SmartPsiElementPointer<KtFunction> lambdaPtr;
    private final Range<Integer> myCallingExpressionLines;
    private final boolean isInline;
    private final boolean isSuspend;
    private final SourcePosition myFirstStatementPosition;
    private final int myLastStatementLine;

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.myFirstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.myLastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        KtFunction ktFunction = (KtFunction)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFunction>(this){
            final /* synthetic */ KotlinLambdaMethodFilter this$0;

            @Nullable
            public final KtFunction invoke() {
                return (KtFunction)KotlinLambdaMethodFilter.access$getLambdaPtr$p(this.this$0).getElement();
            }
            {
                this.this$0 = kotlinLambdaMethodFilter;
                super(0);
            }
        }));
        if (ktFunction == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktFunction, (String)"runReadAction { lambdaPtr.element } ?: return true");
        KtFunction lambda2 = ktFunction;
        if (this.isInline) {
            return DebuggerUtilKt.isInsideInlineArgument(lambda2, location, process);
        }
        Method method = SafeUtilKt.safeMethod((Location)location);
        if (method == null) {
            return true;
        }
        Method method2 = method;
        return this.isLambdaName(method2.name());
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.isInline ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : this.myCallingExpressionLines;
    }

    private final boolean isLambdaName(String name) {
        if (this.isSuspend && name != null) {
            return CoroutineCodegenUtilKt.isResumeImplMethodNameFromAnyLanguageSettings((String)name);
        }
        return Intrinsics.areEqual((Object)name, (Object)OperatorNameConventions.INVOKE.asString());
    }

    public KotlinLambdaMethodFilter(@NotNull KotlinLambdaSmartStepTarget target) {
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        this.lambdaPtr = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)target.getLambda()));
        this.myCallingExpressionLines = target.getCallingExpressionLines();
        this.isInline = target.isInline();
        this.isSuspend = target.isSuspend();
        KtFunction lambda2 = target.getLambda();
        KtExpression body = lambda2.getBodyExpression();
        if (body != null && PsiLinesUtilsKt.isMultiLine((PsiElement)((PsiElement)lambda2))) {
            Object object;
            SourcePosition firstStatementPosition = null;
            SourcePosition lastStatementPosition = null;
            KtExpression ktExpression = body;
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object = (KtBlockExpression)ktExpression) == null || (object = object.getStatements()) == null) {
                object = CollectionsKt.listOf((Object)body);
            }
            Object statements = object;
            Collection collection = (Collection)statements;
            boolean bl = false;
            if (!collection.isEmpty() && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)CollectionsKt.first((List)statements)))) != null) {
                KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)statements);
                PsiFile psiFile = firstStatementPosition.getFile();
                KtExpression ktExpression2 = lastStatement;
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"lastStatement");
                TextRange textRange = ktExpression2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"lastStatement.textRange");
                lastStatementPosition = SourcePosition.createFromOffset((PsiFile)psiFile, (int)textRange.getEndOffset());
            }
            this.myFirstStatementPosition = firstStatementPosition;
            SourcePosition sourcePosition2 = lastStatementPosition;
            this.myLastStatementLine = sourcePosition2 != null ? sourcePosition2.getLine() : -1;
        } else {
            SourcePosition sourcePosition3 = this.myFirstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)lambda2));
            Intrinsics.checkNotNull((Object)sourcePosition3);
            this.myLastStatementLine = sourcePosition3.getLine();
        }
    }

    public static final /* synthetic */ SmartPsiElementPointer access$getLambdaPtr$p(KotlinLambdaMethodFilter $this) {
        return $this.lambdaPtr;
    }
}

