/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.filter;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/LocationToken;", "", "lineNumber", "", "inlineVariables", "", "", "(ILjava/util/List;)V", "getInlineVariables", "()Ljava/util/List;", "getLineNumber", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "kotlin.jvm-debugger.core"})
public final class LocationToken {
    private final int lineNumber;
    @NotNull
    private final List<String> inlineVariables;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getLineNumber() {
        return this.lineNumber;
    }

    @NotNull
    public final List<String> getInlineVariables() {
        return this.inlineVariables;
    }

    public LocationToken(int lineNumber2, @NotNull List<String> inlineVariables) {
        Intrinsics.checkNotNullParameter(inlineVariables, (String)"inlineVariables");
        this.lineNumber = lineNumber2;
        this.inlineVariables = inlineVariables;
    }

    public final int component1() {
        return this.lineNumber;
    }

    @NotNull
    public final List<String> component2() {
        return this.inlineVariables;
    }

    @NotNull
    public final LocationToken copy(int lineNumber2, @NotNull List<String> inlineVariables) {
        Intrinsics.checkNotNullParameter(inlineVariables, (String)"inlineVariables");
        return new LocationToken(lineNumber2, inlineVariables);
    }

    public static /* synthetic */ LocationToken copy$default(LocationToken locationToken, int n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = locationToken.lineNumber;
        }
        if ((n2 & 2) != 0) {
            list = locationToken.inlineVariables;
        }
        return locationToken.copy(n, list);
    }

    @NotNull
    public String toString() {
        return "LocationToken(lineNumber=" + this.lineNumber + ", inlineVariables=" + this.inlineVariables + ")";
    }

    public int hashCode() {
        List<String> list = this.inlineVariables;
        return Integer.hashCode(this.lineNumber) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LocationToken)) break block3;
                LocationToken locationToken = (LocationToken)object;
                if (this.lineNumber != locationToken.lineNumber || !Intrinsics.areEqual(this.inlineVariables, locationToken.inlineVariables)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/LocationToken$Companion;", "", "()V", "from", "Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/LocationToken;", "stackFrame", "Lcom/sun/jdi/StackFrame;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        @NotNull
        public final LocationToken from(@NotNull StackFrame stackFrame) {
            Location location;
            Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
            Location location2 = location = stackFrame.location();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location");
            int lineNumber2 = SafeUtilKt.safeLineNumber((Location)location2, (String)"Java");
            ArrayList methodVariables = new ArrayList(0);
            Object object = SafeUtilKt.safeMethod((Location)location);
            if (object == null || (object = SafeUtilKt.safeVariables((Method)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                LocalVariable variable = (LocalVariable)iterator.next();
                String name = variable.name();
                if (!variable.isVisible(stackFrame)) continue;
                String string = name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (!InlineCodegenUtilsKt.isFakeLocalVariableForInline((String)string)) continue;
                Collection collection = methodVariables;
                boolean bl = false;
                collection.add(name);
            }
            return new LocationToken(lineNumber2, methodVariables);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

