/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stackFrame;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.stackFrame.ExistingVariables;
import org.jetbrains.kotlin.idea.debugger.stackFrame.PendingValue;
import org.jetbrains.kotlin.idea.debugger.stackFrame.ThisLabelUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001a\u0010\u0006\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a%\u0010\u000f\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0082\u0010\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"attachCapturedValues", "", "containerValue", "Lcom/sun/jdi/ObjectReference;", "existingVariables", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/ExistingVariables;", "collector", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/descriptors/data/DescriptorData;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "collectPendingValues", "", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/PendingValue;", "container", "Lorg/jetbrains/kotlin/idea/debugger/stackFrame/PendingValue$Container;", "collectValuesBfs", "queue", "Ljava/util/Deque;", "consumer", "", "createPendingValue", "field", "Lcom/sun/jdi/Field;", "kotlin.jvm-debugger.core"})
public final class CapturedValuesSearcherKt {
    public static final void attachCapturedValues(@NotNull ObjectReference containerValue, @NotNull ExistingVariables existingVariables, @NotNull Function1<? super DescriptorData<? extends ValueDescriptorImpl>, Unit> collector) {
        Intrinsics.checkNotNullParameter((Object)containerValue, (String)"containerValue");
        Intrinsics.checkNotNullParameter((Object)existingVariables, (String)"existingVariables");
        Intrinsics.checkNotNullParameter(collector, (String)"collector");
        List<PendingValue> values = CapturedValuesSearcherKt.collectPendingValues(new PendingValue.Container(containerValue));
        for (PendingValue value : values) {
            DescriptorData<? extends ValueDescriptorImpl> descriptorData;
            if (value.addTo(existingVariables) == null) {
                continue;
            }
            collector.invoke(descriptorData);
        }
    }

    private static final List<PendingValue> collectPendingValues(PendingValue.Container container) {
        ArrayDeque<PendingValue.Container> queue = new ArrayDeque<PendingValue.Container>();
        queue.offer(container);
        boolean bl = false;
        List values = new ArrayList();
        CapturedValuesSearcherKt.collectValuesBfs((Deque<PendingValue>)queue, values);
        return values;
    }

    private static final void collectValuesBfs(Deque<PendingValue> queue, List<PendingValue> consumer) {
        while (true) {
            boolean bl;
            Collection collection;
            ArrayDeque deeperValues = new ArrayDeque();
            while (true) {
                PendingValue value;
                collection = queue;
                bl = false;
                if (!(!collection.isEmpty())) break;
                if (queue.removeFirst() == null) {
                    break;
                }
                if (value instanceof PendingValue.Container) {
                    List<PendingValue> children = ((PendingValue.Container)value).getChildren();
                    deeperValues.addAll(children);
                    continue;
                }
                Collection collection2 = consumer;
                boolean bl2 = false;
                collection2.add(value);
            }
            collection = deeperValues;
            bl = false;
            if (!(!collection.isEmpty())) break;
            queue = deeperValues;
        }
    }

    private static final PendingValue createPendingValue(PendingValue.Container container, Field field) {
        String name = field.name();
        if (Intrinsics.areEqual((Object)name, (Object)"this$0")) {
            Value value = container.getValue().getValue(field);
            if (!(value instanceof ObjectReference)) {
                value = null;
            }
            ObjectReference objectReference = (ObjectReference)value;
            if (objectReference == null) {
                return null;
            }
            ObjectReference value2 = objectReference;
            String label2 = ThisLabelUtilsKt.getThisValueLabel(value2);
            return label2 == null ? (PendingValue)new PendingValue.Container(value2) : (PendingValue)new PendingValue.This(label2, value2);
        }
        String string = name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (StringsKt.startsWith$default((String)string, (String)"$this_", (boolean)false, (int)2, null)) {
            Value value = container.getValue().getValue(field);
            String string2 = StringsKt.drop((String)name, (int)"$this_".length());
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string3 = charSequence.length() > 0 ? string2 : null;
            if (string3 == null) {
                return null;
            }
            String label3 = string3;
            return new PendingValue.This(label3, value);
        }
        boolean value = StringsKt.startsWith$default((String)name, (String)"$", (boolean)false, (int)2, null);
        boolean bl = false;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !value) {
            boolean bl6 = false;
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        String string5 = StringsKt.drop((String)name, (int)1);
        bl5 = false;
        boolean bl7 = false;
        String it = string5;
        boolean bl8 = false;
        CharSequence charSequence = it;
        boolean bl9 = false;
        String string6 = charSequence.length() > 0 ? string5 : null;
        if (string6 == null) {
            return null;
        }
        String capturedValueName = string6;
        return new PendingValue.Ordinary(capturedValueName, field, container);
    }

    public static final /* synthetic */ PendingValue access$createPendingValue(PendingValue.Container container, Field field) {
        return CapturedValuesSearcherKt.createPendingValue(container, field);
    }
}

