/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.DelegateSourcePosition;
import org.jetbrains.kotlin.idea.debugger.HopelessExceptionUtilKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.idea.decompiler.classFile.KtClsFile;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b*\u0001\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001QB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020 H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010,2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020*0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u00107\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u00109\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010\u0016\u001a\u00020\u0013J \u0010;\u001a\u00020<*\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0=2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J0\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001e0\n*\u00020\u001e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001e0\n2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020 H\u0002J\u001a\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010=*\u00020DH\u0002J$\u0010E\u001a\u0004\u0018\u0001HF\"\u0006\b\u0000\u0010F\u0018\u0001*\u00020G2\u0006\u0010H\u001a\u00020 H\u0082\b\u00a2\u0006\u0002\u0010IJ&\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0=0\n*\u00020A2\u0006\u0010B\u001a\u00020 H\u0002J4\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010=*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0=0\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010L\u001a\u00020<*\u00020\u001e2\u0006\u0010M\u001a\u00020,H\u0002J\u0014\u0010N\u001a\u00020<*\u00020D2\u0006\u0010O\u001a\u00020 H\u0002J\u001c\u0010P\u001a\u00020<*\u00020\u001e2\u0006\u0010M\u001a\u00020,2\u0006\u0010B\u001a\u00020 H\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager;", "Lcom/intellij/debugger/MultiRequestPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerEx;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "allKotlinFilesScope", "org/jetbrains/kotlin/idea/debugger/KotlinPositionManager$allKotlinFilesScope$1", "Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager$allKotlinFilesScope$1;", "sourceSearchScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "stackFrameInterceptor", "Lorg/jetbrains/kotlin/idea/debugger/StackFrameInterceptor;", "createPrepareRequest", "Lcom/sun/jdi/request/ClassPrepareRequest;", "classPrepareRequestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "createPrepareRequests", "requestor", "position", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "defaultInternalName", "", "evaluateCondition", "Lcom/intellij/util/ThreeState;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "expression", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getAlternativeSource", "Lcom/intellij/psi/PsiFile;", "getElementForDeclarationLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "lineNumber", "", "getLambdaOrFunIfInside", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getPsiFileByLocation", "getReferenceTypesForPositionInKtFile", "getSourcePosition", "locationsOfLine", "type", "originalClassNamesForPosition", "contains", "", "Lkotlin/Pair;", "findLocationsInSameInlinedFunction", "locations", "method", "Lcom/sun/jdi/Method;", "sourceFileName", "getBorders", "Lcom/sun/jdi/LocalVariable;", "getFieldValue", "T", "", "fieldName", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "getInlineFunctionBorders", "getLeastEnclosingBorders", "hasFinallyBlockInParent", "psiFile", "isInlineFunctionLocalVariable", "methodName", "shouldBeTreatedAsReentrantSourcePosition", "KotlinReentrantSourcePosition", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManager
extends PositionManagerEx
implements MultiRequestPositionManager {
    private final StackFrameInterceptor stackFrameInterceptor;
    private final allKotlinFilesScope.1 allKotlinFilesScope;
    private final List<GlobalSearchScope> sourceSearchScopes;
    private final DebugProcess myDebugProcess;

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        Set set = KotlinFileTypeFactoryUtils.KOTLIN_FILE_TYPES_SET;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"KotlinFileTypeFactoryUtils.KOTLIN_FILE_TYPES_SET");
        return set;
    }

    @NotNull
    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return ThreeState.UNSURE;
    }

    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
        XStackFrame xStackFrame;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (DebuggerUtilKt.isInKotlinSources(location)) {
            xStackFrame = this.stackFrameInterceptor.createStackFrame(frame, debugProcess, location);
            if (xStackFrame == null) {
                xStackFrame = (XStackFrame)new KotlinStackFrame(frame);
            }
        } else {
            xStackFrame = null;
        }
        return xStackFrame;
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location) {
        PsiFile psiFile;
        if (location == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        String string = SafeUtilKt.safeSourceName((Location)location);
        if (string == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        String fileName = string;
        int lineNumber2 = SafeUtilKt.safeLineNumber((Location)location);
        if (lineNumber2 < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!DebuggerUtils.INSTANCE.isKotlinSourceFile(fileName)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        PsiFile psiFile2 = this.getAlternativeSource(location);
        if (psiFile2 == null) {
            psiFile2 = psiFile = this.getPsiFileByLocation(location);
        }
        if (psiFile == null) {
            ReferenceType referenceType = location.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            boolean isKotlinStrataAvailable = DebuggerUtilKt.containsKotlinStrata(referenceType);
            if (isKotlinStrataAvailable) {
                try {
                    Project project;
                    String javaSourceFileName = location.sourceName("Java");
                    JvmClassName jvmClassName = JvmClassName.byInternalName((String)this.defaultInternalName(location));
                    Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026ltInternalName(location))");
                    JvmClassName javaClassName = jvmClassName;
                    Project project2 = project = this.myDebugProcess.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    String string2 = javaSourceFileName;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaSourceFileName");
                    KtFile defaultPsiFile = DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, javaClassName, string2, location);
                    if (defaultPsiFile != null) {
                        return SourcePosition.createFromLine((PsiFile)((PsiFile)defaultPsiFile), (int)0);
                    }
                }
                catch (AbsentInformationException javaSourceFileName) {
                    // empty catch block
                }
            }
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        if (!(psiFile instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        int sourceLineNumber = SafeUtilKt.safeLineNumber((Location)location) - 1;
        if (sourceLineNumber < 0) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        KtFunction lambdaOrFunIfInside = this.getLambdaOrFunIfInside(location, (KtFile)psiFile, sourceLineNumber);
        if (lambdaOrFunIfInside != null) {
            KtExpression ktExpression = lambdaOrFunIfInside.getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            return SourcePosition.createFromElement((PsiElement)((PsiElement)ktExpression));
        }
        KtElement elementInDeclaration = this.getElementForDeclarationLine(location, (KtFile)psiFile, sourceLineNumber);
        if (elementInDeclaration != null) {
            return SourcePosition.createFromElement((PsiElement)((PsiElement)elementInDeclaration));
        }
        if (this.shouldBeTreatedAsReentrantSourcePosition(location, psiFile, fileName)) {
            SourcePosition sourcePosition2 = SourcePosition.createFromLine((PsiFile)psiFile, (int)sourceLineNumber);
            Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"SourcePosition.createFro\u2026siFile, sourceLineNumber)");
            return new KotlinReentrantSourcePosition(sourcePosition2);
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)sourceLineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldBeTreatedAsReentrantSourcePosition(Location $this$shouldBeTreatedAsReentrantSourcePosition, PsiFile psiFile, String sourceFileName) {
        Collection collection;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Method method = SafeUtilKt.safeMethod((Location)$this$shouldBeTreatedAsReentrantSourcePosition);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Iterable iterable = SafeUtilKt.safeAllLineLocations((Method)method2);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)it), (Object)sourceFileName) && it.lineNumber() == $this$shouldBeTreatedAsReentrantSourcePosition.lineNumber())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sameLineLocations = (List)destination$iv$iv;
        if (sameLineLocations.size() < 2 || this.hasFinallyBlockInParent($this$shouldBeTreatedAsReentrantSourcePosition, psiFile)) {
            return false;
        }
        List<Location> locationsInSameInlinedFunction = this.findLocationsInSameInlinedFunction($this$shouldBeTreatedAsReentrantSourcePosition, sameLineLocations, method2, sourceFileName);
        Collection collection2 = locationsInSameInlinedFunction;
        boolean bl = false;
        if (collection2.isEmpty()) {
            boolean bl2 = false;
            collection = sameLineLocations;
        } else {
            collection = collection2;
        }
        return ((List)collection).indexOf($this$shouldBeTreatedAsReentrantSourcePosition) > 0;
    }

    private final boolean hasFinallyBlockInParent(Location $this$hasFinallyBlockInParent, PsiFile psiFile) {
        KtFinallySection ktFinallySection;
        PsiElement elementAt;
        PsiElement psiElement;
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)psiFile, (int)$this$hasFinallyBlockInParent.lineNumber());
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            psiElement = psiFile.findElementAt(it);
        } else {
            psiElement = null;
        }
        PsiElement psiElement2 = elementAt = psiElement;
        if (psiElement2 != null) {
            PsiElement $this$parentOfType$iv = psiElement2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktFinallySection = (KtFinallySection)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFinallySection.class, (boolean)true);
        } else {
            ktFinallySection = null;
        }
        return ktFinallySection != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> findLocationsInSameInlinedFunction(Location $this$findLocationsInSameInlinedFunction, List<? extends Location> locations, Method method, String sourceFileName) {
        void $this$filterTo$iv$iv;
        Pair<Location, Location> pair = this.getLeastEnclosingBorders(this.getInlineFunctionBorders(method, sourceFileName), $this$findLocationsInSameInlinedFunction);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<Location, Location> leastEnclosingBorders = pair;
        Iterable $this$filter$iv = locations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location it = (Location)element$iv$iv;
            boolean bl = false;
            if (!this.contains(leastEnclosingBorders, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Pair<Location, Location> getLeastEnclosingBorders(List<? extends Pair<? extends Location, ? extends Location>> $this$getLeastEnclosingBorders, Location location) {
        Pair<? extends Location, ? extends Location> result2 = null;
        for (Pair<? extends Location, ? extends Location> pair : $this$getLeastEnclosingBorders) {
            if (!this.contains(pair, location) || result2 != null && ((Location)pair.getFirst()).compareTo(result2.getFirst()) <= 0) continue;
            result2 = pair;
        }
        return result2;
    }

    private final boolean contains(Pair<? extends Location, ? extends Location> $this$contains, Location location) {
        Comparable comparable = location;
        return comparable.compareTo((Comparable)$this$contains.getFirst()) >= 0 && comparable.compareTo((Comparable)$this$contains.getSecond()) <= 0;
    }

    private final List<Pair<Location, Location>> getInlineFunctionBorders(Method $this$getInlineFunctionBorders, String sourceFileName) {
        List list = SafeUtilKt.safeVariables((Method)$this$getInlineFunctionBorders);
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List localVariables = list;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), (Function1)((Function1)new Function1<LocalVariable, Boolean>(this, $this$getInlineFunctionBorders){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ Method $this_getInlineFunctionBorders;

            public final boolean invoke(@NotNull LocalVariable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$this_getInlineFunctionBorders.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
                return KotlinPositionManager.access$isInlineFunctionLocalVariable(this.this$0, it, string);
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$this_getInlineFunctionBorders = method;
                super(1);
            }
        })), (Function1)((Function1)new Function1<LocalVariable, Pair<? extends Location, ? extends Location>>(this){
            final /* synthetic */ KotlinPositionManager this$0;

            @Nullable
            public final Pair<Location, Location> invoke(@NotNull LocalVariable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinPositionManager.access$getBorders(this.this$0, it);
            }
            {
                this.this$0 = kotlinPositionManager;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Location, ? extends Location>, Boolean>(sourceFileName){
            final /* synthetic */ String $sourceFileName;

            public final boolean invoke(@NotNull Pair<? extends Location, ? extends Location> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName((Location)((Location)it.getFirst())), (Object)this.$sourceFileName);
            }
            {
                this.$sourceFileName = string;
                super(1);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInlineFunctionLocalVariable(LocalVariable $this$isInlineFunctionLocalVariable, String methodName) {
        String string = $this$isInlineFunctionLocalVariable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
        if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isInlineFunctionLocalVariable.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
        if (!(Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)string2, (String)"$i$f$", null, (int)2, null), (Object)methodName) ^ true)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Location, Location> getBorders(LocalVariable $this$getBorders) {
        Location location;
        Location location2;
        int n;
        KotlinPositionManager $this$getFieldValue$iv;
        LocalVariable localVariable = $this$getBorders;
        KotlinPositionManager kotlinPositionManager = this;
        Object fieldName$iv = "scopeStart";
        boolean $i$f$getFieldValue = false;
        try {
            Field field;
            block14: {
                Field[] fieldArray = ((Object)((Object)$this$getFieldValue$iv)).getClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"javaClass.declaredFields");
                Field[] $this$firstOrNull$iv$iv = fieldArray;
                boolean $i$f$firstOrNull = false;
                Field[] fieldArray2 = $this$firstOrNull$iv$iv;
                int n2 = fieldArray2.length;
                for (n = 0; n < n2; ++n) {
                    Field element$iv$iv;
                    Field it$iv = element$iv$iv = fieldArray2[n];
                    boolean bl = false;
                    Field field2 = it$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"it");
                    if (!Intrinsics.areEqual((Object)field2.getName(), (Object)fieldName$iv)) continue;
                    field = element$iv$iv;
                    break block14;
                }
                field = null;
            }
            if (field == null) {
                location2 = null;
            } else {
                Field field$iv = field;
                field$iv.setAccessible(true);
                Object object = field$iv.get((Object)$this$getFieldValue$iv);
                if (!(object instanceof Location)) {
                    object = null;
                }
                location2 = (Location)object;
            }
        }
        catch (Exception ex$iv) {
            location2 = null;
        }
        if (location2 == null) {
            return null;
        }
        Location scopeStart = location2;
        fieldName$iv = $this$getBorders;
        $this$getFieldValue$iv = this;
        String fieldName$iv2 = "scopeEnd";
        boolean $i$f$getFieldValue2 = false;
        try {
            Field field;
            void $this$getFieldValue$iv2;
            block15: {
                Field[] fieldArray = $this$getFieldValue$iv2.getClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"javaClass.declaredFields");
                Field[] $this$firstOrNull$iv$iv = fieldArray;
                boolean $i$f$firstOrNull = false;
                Field[] fieldArray3 = $this$firstOrNull$iv$iv;
                n = fieldArray3.length;
                for (int i = 0; i < n; ++i) {
                    Field element$iv$iv;
                    Field it$iv = element$iv$iv = fieldArray3[i];
                    boolean bl = false;
                    Field field3 = it$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"it");
                    if (!Intrinsics.areEqual((Object)field3.getName(), (Object)fieldName$iv2)) continue;
                    field = element$iv$iv;
                    break block15;
                }
                field = null;
            }
            if (field == null) {
                location = null;
            } else {
                Field field$iv = field;
                field$iv.setAccessible(true);
                Object object = field$iv.get($this$getFieldValue$iv2);
                if (!(object instanceof Location)) {
                    object = null;
                }
                location = (Location)object;
            }
        }
        catch (Exception ex$iv) {
            location = null;
        }
        if (location == null) {
            return null;
        }
        Location scopeEnd = location;
        return new Pair(scopeStart, scopeEnd);
    }

    private final /* synthetic */ <T> T getFieldValue(Object $this$getFieldValue, String fieldName) {
        int $i$f$getFieldValue = 0;
        try {
            Field field;
            block4: {
                Field[] fieldArray = $this$getFieldValue.getClass().getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"javaClass.declaredFields");
                Field[] $this$firstOrNull$iv = fieldArray;
                boolean $i$f$firstOrNull = false;
                Field[] fieldArray2 = $this$firstOrNull$iv;
                int n = fieldArray2.length;
                for (int i = 0; i < n; ++i) {
                    Field element$iv;
                    Field it = element$iv = fieldArray2[i];
                    boolean bl = false;
                    Field field2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"it");
                    if (!Intrinsics.areEqual((Object)field2.getName(), (Object)fieldName)) continue;
                    field = element$iv;
                    break block4;
                }
                field = null;
            }
            Field field3 = field;
            if (field3 == null) {
                return null;
            }
            Field field4 = field3;
            field4.setAccessible(true);
            Object object = field4.get($this$getFieldValue);
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)object;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private final PsiFile getAlternativeSource(Location location) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myDebugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(myDebugProcess.project)");
        PsiManager manager = psiManager;
        String qName = location.declaringType().name();
        String string = DebuggerUtilsEx.getAlternativeSourceUrl((String)qName, (Project)this.myDebugProcess.getProject());
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DebuggerUtilsEx.getAlter\u2026s.project) ?: return null");
        String alternativeFileUrl = string;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(alternativeFileUrl);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VirtualFileManager.getIn\u2026veFileUrl) ?: return null");
        VirtualFile alternativePsiFile = virtualFile2;
        return manager.findFile(alternativePsiFile);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final KtElement getElementForDeclarationLine(Location location, KtFile file, int lineNumber) {
        block8: {
            block7: {
                block6: {
                    v0 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)((PsiFile)file), (int)lineNumber);
                    if (v0 == null) {
                        return null;
                    }
                    lineStartOffset = v0;
                    elementAt = file.findElementAt(lineStartOffset);
                    contextElement = CodeFragmentContextUtilsKt.getContextElement((PsiElement)elementAt);
                    if (!(contextElement instanceof KtClass)) {
                        return null;
                    }
                    methodName = location.method().name();
                    v1 = methodName;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"methodName");
                    if (!JvmAbi.isGetterName((String)v1)) break block7;
                    v2 /* !! */  = ((KtClass)contextElement).getPrimaryConstructor();
                    if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getValueParameters()) == null) {
                        v2 /* !! */  = CollectionsKt.emptyList();
                    }
                    valueParameters /* !! */  = v2 /* !! */ ;
                    var9_9 = (Iterable)valueParameters /* !! */ ;
                    var10_10 = false;
                    var11_11 = var9_9;
                    var12_12 = false;
                    for (T var14_14 : var11_11) {
                        it = (KtParameter)var14_14;
                        $i$a$-find-KotlinPositionManager$getElementForDeclarationLine$1 = false;
                        if (!it.hasValOrVar()) ** GOTO lbl-1000
                        v3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                        if (v3.getName() == null) ** GOTO lbl-1000
                        v4 = it.getName();
                        Intrinsics.checkNotNull((Object)v4);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.name!!");
                        if (Intrinsics.areEqual((Object)JvmAbi.getterName((String)v4), (Object)methodName)) {
                            v5 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v5 = false;
                        }
                        if (!v5) continue;
                        v6 = var14_14;
                        break block6;
                    }
                    v6 = null;
                }
                v7 = v6;
                break block8;
            }
            v7 = Intrinsics.areEqual((Object)methodName, (Object)"<init>") != false ? (KtElement)((KtClass)contextElement).getPrimaryConstructor() : null;
        }
        return v7;
    }

    private final KtFunction getLambdaOrFunIfInside(Location location, KtFile file, int lineNumber2) {
        String string = location.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        Integer start = CodeInsightUtils.getStartLineOffset((PsiFile)((PsiFile)file), (int)lineNumber2);
        Integer end = CodeInsightUtils.getEndLineOffset((PsiFile)((PsiFile)file), (int)lineNumber2);
        if (start == null || end == null) {
            return null;
        }
        List<KtFunction> literalsOrFunctions = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file, lineNumber2);
        if (literalsOrFunctions.isEmpty()) {
            return null;
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byFqNameWit\u2026e(currentLocationFqName))");
        String string2 = jvmClassName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JvmClassName.byFqNameWit\u2026tionFqName)).internalName");
        String currentLocationClassName = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        for (KtFunction literal : literalsOrFunctions) {
            boolean bl;
            block9: {
                if (InlineUtil.isInlinedArgument((KtFunction)literal, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)literal), (BodyResolveMode)BodyResolveMode.PARTIAL), (boolean)true)) {
                    DebugProcess debugProcess = this.myDebugProcess;
                    if (debugProcess == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.debugger.engine.DebugProcessImpl");
                    }
                    if (!DebuggerUtilKt.isInsideInlineArgument(literal, location, (DebugProcessImpl)debugProcess)) continue;
                    return literal;
                }
                Project project = this.myDebugProcess.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
                GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                List internalClassNames = new DebuggerClassNameProvider(project, globalSearchScope, false, false, 4, null).getOuterClassNamesForElement(literal.getFirstChild(), SetsKt.emptySet()).getClassNames();
                Iterable $this$any$iv = internalClassNames;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)currentLocationClassName)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return literal;
        }
        return null;
    }

    private final PsiFile getPsiFileByLocation(Location location) {
        Project project;
        String string;
        String string2 = SafeUtilKt.safeSourceName((Location)location);
        if (string2 == null) {
            return null;
        }
        String sourceName = string2;
        try {
            String string3;
            ReferenceType referenceType = location.declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"location.declaringType()");
            if (DebuggerUtilKt.containsKotlinStrata(referenceType)) {
                String string4 = location.sourcePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"location.sourcePath()");
                string3 = StringsKt.replace$default((String)string4, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            } else {
                string3 = this.defaultInternalName(location);
            }
            string = string3;
        }
        catch (AbsentInformationException e) {
            string = this.defaultInternalName(location);
        }
        String referenceInternalName = string;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)referenceInternalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(referenceInternalName)");
        JvmClassName className = jvmClassName;
        Project project2 = project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return (PsiFile)DebuggerUtils.INSTANCE.findSourceFileForClass(project2, this.sourceSearchScopes, className, sourceName, location);
    }

    private final String defaultInternalName(Location location) {
        String referenceFqName;
        String string = referenceFqName = location.declaringType().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referenceFqName");
        return StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"sourcePosition.file");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 instanceof KtFile) {
            List list;
            List list2;
            if (!ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)((PsiElement)psiFile2), (boolean)false, (int)2, null)) {
                return CollectionsKt.emptyList();
            }
            boolean $i$f$hopelessAware = false;
            try {
                boolean bl = false;
                list2 = this.getReferenceTypesForPositionInKtFile(sourcePosition2);
            }
            catch (Exception e$iv) {
                HopelessExceptionUtilKt.handleHopelessException((Exception)e$iv);
                list2 = null;
            }
            if ((list = list2) == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        if (psiFile2 instanceof ClsFileImpl) {
            PsiFile $this$readAction$iv = psiFile2;
            boolean $i$f$readAction = false;
            PsiFile decompiledPsiFile = (PsiFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>((Object)$this$readAction$iv){
                final /* synthetic */ Object $this_readAction;
                {
                    this.$this_readAction = object;
                    super(0);
                }

                public final PsiFile invoke() {
                    ClsFileImpl it = (ClsFileImpl)this.$this_readAction;
                    boolean bl = false;
                    return it.getDecompiledPsiFile();
                }
            }));
            if (decompiledPsiFile instanceof KtClsFile && ((Number)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Integer>(sourcePosition2){
                final /* synthetic */ SourcePosition $sourcePosition;

                public final int invoke() {
                    return this.$sourcePosition.getLine();
                }
                {
                    this.$sourcePosition = sourcePosition2;
                    super(0);
                }
            }))).intValue() == -1) {
                String className = JvmFileClassUtil.getFileClassInternalName((KtFile)((KtFile)decompiledPsiFile));
                List list = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"myDebugProcess.virtualMa\u2026.classesByName(className)");
                return list;
            }
        }
        NoDataException noDataException = NoDataException.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
        throw (Throwable)noDataException;
    }

    private final List<ReferenceType> getReferenceTypesForPositionInKtFile(SourcePosition sourcePosition2) {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        DebuggerClassNameProvider debuggerClassNameProvider = new DebuggerClassNameProvider(project, globalSearchScope, false, false, 12, null);
        int lineNumber2 = ((Number)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Integer>(sourcePosition2){
            final /* synthetic */ SourcePosition $sourcePosition;

            public final int invoke() {
                return this.$sourcePosition.getLine();
            }
            {
                this.$sourcePosition = sourcePosition2;
                super(0);
            }
        }))).intValue();
        Set<String> classes = debuggerClassNameProvider.getClassesForPosition(sourcePosition2);
        Iterable $this$flatMap$iv = classes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String className = (String)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            ReferenceType referenceType2 = referenceType;
            Intrinsics.checkNotNullExpressionValue((Object)referenceType2, (String)"referenceType");
            list$iv$iv = KotlinPositionManagerKt.access$findTargetClasses(this.myDebugProcess, referenceType2, lineNumber2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> originalClassNamesForPosition(@NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        DebuggerClassNameProvider debuggerClassNameProvider = new DebuggerClassNameProvider(project, globalSearchScope, false, false, 8, null);
        return debuggerClassNameProvider.getOuterClassNamesForPosition(position);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        try {
            void $this$filterTo$iv$iv;
            int line;
            List locations;
            if (NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)this.myDebugProcess)) {
                List inlineLocations2 = (List)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<List<? extends Location>>(this, type, position){
                    final /* synthetic */ KotlinPositionManager this$0;
                    final /* synthetic */ ReferenceType $type;
                    final /* synthetic */ SourcePosition $position;

                    @NotNull
                    public final List<Location> invoke() {
                        GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope();
                        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                        return NoStrataPositionManagerHelperKt.getLocationsOfInlinedLine((ReferenceType)this.$type, (SourcePosition)this.$position, (GlobalSearchScope)globalSearchScope);
                    }
                    {
                        this.this$0 = kotlinPositionManager;
                        this.$type = referenceType;
                        this.$position = sourcePosition2;
                        super(0);
                    }
                }));
                Collection collection = inlineLocations2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return inlineLocations2;
                }
            }
            if ((locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (String)"Kotlin", null, (int)(line = position.getLine() + 1))) == null || locations.isEmpty()) {
                NoDataException noDataException = NoDataException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
                throw (Throwable)noDataException;
            }
            Iterable $this$filter$iv = locations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Location it = (Location)element$iv$iv;
                boolean bl = false;
                String string = it.sourceName("Kotlin");
                PsiFile psiFile = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"position.file");
                if (!Intrinsics.areEqual((Object)string, (Object)psiFile.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (AbsentInformationException e) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
    }

    @Deprecated(message="Since Idea 14.0.3 use createPrepareRequests fun", replaceWith=@ReplaceWith(imports={}, expression="createPrepareRequests(classPrepareRequestor, sourcePosition).firstOrNull()"))
    @Nullable
    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)classPrepareRequestor, (String)"classPrepareRequestor");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return (ClassPrepareRequest)CollectionsKt.firstOrNull(this.createPrepareRequests(classPrepareRequestor, sourcePosition2));
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position.getFile() instanceof KtFile)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"NoDataException.INSTANCE");
            throw (Throwable)noDataException;
        }
        Object object = DumbService.getInstance((Project)this.myDebugProcess.getProject()).runReadActionInSmartMode(new Computable(this, position, requestor){
            final /* synthetic */ KotlinPositionManager this$0;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ ClassPrepareRequestor $requestor;

            /*
             * WARNING - void declaration
             */
            public final List<ClassPrepareRequest> compute() {
                void $this$flatMapTo$iv$iv;
                Project project = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
                GlobalSearchScope globalSearchScope = KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
                List<String> classNames = new DebuggerClassNameProvider(project, globalSearchScope, false, false, 12, null).getOuterClassNamesForPosition(this.$position);
                Iterable $this$flatMap$iv = classNames;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String name = (String)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])new ClassPrepareRequest[]{KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getRequestsManager().createClassPrepareRequest(this.$requestor, name), KotlinPositionManager.access$getMyDebugProcess$p(this.this$0).getRequestsManager().createClassPrepareRequest(this.$requestor, name + "$*")});
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = kotlinPositionManager;
                this.$position = sourcePosition2;
                this.$requestor = classPrepareRequestor;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DumbService.getInstance(\u2026\n            }\n        })");
        return (List)object;
    }

    public KotlinPositionManager(@NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
        ComponentManager $this$getServiceSafe$iv = (ComponentManager)project;
        boolean $i$f$getServiceSafe = false;
        Object object = $this$getServiceSafe$iv.getService(StackFrameInterceptor.class);
        if (object == null) {
            String string = "Unable to locate service " + StackFrameInterceptor.class.getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.stackFrameInterceptor = (StackFrameInterceptor)object;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myDebugProcess.project)");
        Project project2 = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myDebugProcess.project");
        this.allKotlinFilesScope = new DelegatingGlobalSearchScope(this, KotlinSourceFilterScope.Companion.projectAndLibrariesSources(globalSearchScope, project2)){
            private final ProjectFileIndex projectIndex;
            private final Comparator<VirtualFile> scopeComparator;
            final /* synthetic */ KotlinPositionManager this$0;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return this.scopeComparator.compare(file1, file2);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)KotlinPositionManager.access$getMyDebugProcess$p(this$0).getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getIn\u2026e(myDebugProcess.project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026rocess.project).fileIndex");
                this.projectIndex = projectFileIndex;
                this.scopeComparator = Comparator.comparing(new Function(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final Boolean apply(VirtualFile it) {
                        return allKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInSourceContent(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).thenComparing(new Function(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final Boolean apply(VirtualFile it) {
                        return allKotlinFilesScope.1.access$getProjectIndex$p(this.this$0).isInLibrarySource(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).thenComparing(new Comparator(this){
                    final /* synthetic */ allKotlinFilesScope.1 this$0;

                    public final int compare(VirtualFile file1, VirtualFile file2) {
                        return allKotlinFilesScope.1.access$compare$s-1623866647(this.this$0, file1, file2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            public static final /* synthetic */ ProjectFileIndex access$getProjectIndex$p(allKotlinFilesScope.1 $this) {
                return $this.projectIndex;
            }

            public static final /* synthetic */ int access$compare$s-1623866647(allKotlinFilesScope.1 $this, VirtualFile p0, VirtualFile p1) {
                return super.compare(p0, p1);
            }
        };
        Object[] objectArray = new GlobalSearchScope[2];
        GlobalSearchScope globalSearchScope2 = this.myDebugProcess.getSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"myDebugProcess.searchScope");
        objectArray[0] = globalSearchScope2;
        objectArray[1] = (GlobalSearchScope)this.allKotlinFilesScope;
        this.sourceSearchScopes = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ boolean access$isInlineFunctionLocalVariable(KotlinPositionManager $this, LocalVariable $this$access_u24isInlineFunctionLocalVariable, String methodName) {
        return $this.isInlineFunctionLocalVariable($this$access_u24isInlineFunctionLocalVariable, methodName);
    }

    public static final /* synthetic */ Pair access$getBorders(KotlinPositionManager $this, LocalVariable $this$access_u24getBorders) {
        return $this.getBorders($this$access_u24getBorders);
    }

    public static final /* synthetic */ DebugProcess access$getMyDebugProcess$p(KotlinPositionManager $this) {
        return $this.myDebugProcess;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinPositionManager$KotlinReentrantSourcePosition;", "Lorg/jetbrains/kotlin/idea/debugger/DelegateSourcePosition;", "delegate", "Lcom/intellij/debugger/SourcePosition;", "(Lcom/intellij/debugger/SourcePosition;)V", "kotlin.jvm-debugger.core"})
    public static final class KotlinReentrantSourcePosition
    extends DelegateSourcePosition {
        public KotlinReentrantSourcePosition(@NotNull SourcePosition delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
        }
    }
}

