/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.util.containers.Stack;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u000200H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/ClassNameCalculatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "allNames", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "", "getAllNames", "()Ljava/util/Map;", "anonymousIndices", "Lcom/intellij/util/containers/Stack;", "", "collectedNames", "Ljava/util/WeakHashMap;", "names", "getTopLevelName", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "nextAnonymousName", "pop", "", "push", "element", "name", "recordName", "", "saveName", "visitCallableReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitClassOrObject", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "kotlin.jvm-debugger.core"})
final class ClassNameCalculatorVisitor
extends KtTreeVisitorVoid {
    private final Stack<String> names = new Stack();
    private final Stack<Integer> anonymousIndices = new Stack();
    private WeakHashMap<KtElement, String> collectedNames = new WeakHashMap();

    @NotNull
    public final Map<KtElement, String> getAllNames() {
        return this.collectedNames;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtElement ktElement = (KtElement)file;
        String string = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file).getFileClassFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JvmFileClassUtil.getFile\u2026ileClassFqName.asString()");
        this.saveName(ktElement, string);
        super.visitKtFile(file);
    }

    public void visitScript(@NotNull KtScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)script, script.getFqName().asString(), false, 4, null);
        super.visitScript(script);
        this.pop();
    }

    public void visitClassOrObject(@NotNull KtClassOrObject klass) {
        String string;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.getName() == null) {
            super.visitClassOrObject(klass);
            return;
        }
        KtElement ktElement = (KtElement)klass;
        if (klass.isTopLevel()) {
            FqName fqName = klass.getFqName();
            string = fqName != null ? fqName.asString() : null;
        } else {
            string = klass.getName();
        }
        ClassNameCalculatorVisitor.push$default(this, ktElement, string, false, 4, null);
        super.visitClassOrObject(klass);
        this.pop();
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitObjectLiteralExpression(expression);
        this.pop();
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitLambdaExpression(expression);
        this.pop();
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ClassNameCalculatorVisitor.push$default(this, (KtElement)expression, this.nextAnonymousName(), false, 4, null);
        super.visitCallableReferenceExpression(expression);
        this.pop();
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.push((KtElement)property, property.isTopLevel() ? this.getTopLevelName((KtDeclaration)property) : property.getName(), false);
        if (property.hasDelegate()) {
            this.nextAnonymousName();
        }
        super.visitProperty(property);
        this.pop();
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        boolean isLocal = function.isLocal();
        String name = isLocal ? this.nextAnonymousName() : (function.isTopLevel() ? this.getTopLevelName((KtDeclaration)function) : function.getName());
        this.push((KtElement)function, name, isLocal);
        if (function.hasModifier(KtTokens.SUSPEND_KEYWORD) && !isLocal) {
            this.nextAnonymousName();
        }
        super.visitNamedFunction(function);
        this.pop();
    }

    private final String getTopLevelName(KtDeclaration declaration2) {
        String string = declaration2.getName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name ?: return null");
        String selfName = string;
        KtFile ktFile = declaration2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"declaration.containingKtFile");
        JvmFileClassInfo info = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)ktFile);
        return info.getFacadeClassFqName().asString() + "$" + selfName;
    }

    private final void push(KtElement element, String name, boolean recordName) {
        this.names.push((Object)name);
        this.anonymousIndices.push((Object)0);
        if (recordName) {
            this.saveName(element, CollectionsKt.joinToString$default((Iterable)((Iterable)this.names), (CharSequence)"$", null, null, (int)0, null, null, (int)62, null));
        }
    }

    static /* synthetic */ void push$default(ClassNameCalculatorVisitor classNameCalculatorVisitor, KtElement ktElement, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        classNameCalculatorVisitor.push(ktElement, string, bl);
    }

    private final void saveName(KtElement element, String name) {
        ((Map)this.collectedNames).put(element, name);
    }

    private final void pop() {
        this.names.pop();
        this.anonymousIndices.pop();
    }

    private final String nextAnonymousName() {
        int index = ((Number)this.anonymousIndices.pop()).intValue() + 1;
        this.anonymousIndices.push((Object)index);
        return String.valueOf(index);
    }
}

