/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.ClassNameCalculatorVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/ClassNameCalculator;", "", "()V", "getClassName", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getClassNames", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm-debugger.core"})
public final class ClassNameCalculator {
    @NotNull
    public static final ClassNameCalculator INSTANCE;

    @NotNull
    public final Map<KtElement, String> getClassNames(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), (CachedValueProvider)new CachedValueProvider(file){
            final /* synthetic */ KtFile $file;

            @Nullable
            public final CachedValueProvider.Result<Map<KtElement, String>> compute() {
                ClassNameCalculatorVisitor visitor = new ClassNameCalculatorVisitor();
                this.$file.accept((PsiElementVisitor)visitor);
                return new CachedValueProvider.Result(visitor.getAllNames(), new Object[]{this.$file});
            }
            {
                this.$file = ktFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getC\u2026allNames, file)\n        }");
        return (Map)object;
    }

    @Nullable
    public final String getClassName(@NotNull KtElement element) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtElement ktElement2 = element;
        if (ktElement2 instanceof KtFunctionLiteral) {
            KtLambdaExpression ktLambdaExpression;
            PsiElement psiElement = ((KtFunctionLiteral)element).getParent();
            if (!(psiElement instanceof KtLambdaExpression)) {
                psiElement = null;
            }
            if ((ktLambdaExpression = (KtLambdaExpression)psiElement) == null) {
                ktLambdaExpression = element;
            }
            ktElement = (KtElement)ktLambdaExpression;
        } else {
            ktElement = element;
        }
        KtElement target = ktElement;
        KtFile ktFile = element.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        return this.getClassNames(ktFile).get(target);
    }

    private ClassNameCalculator() {
    }

    static {
        ClassNameCalculator classNameCalculator;
        INSTANCE = classNameCalculator = new ClassNameCalculator();
    }
}

