/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.renderer;

import com.intellij.icons.AllIcons;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFacesNodeCellRenderer
extends AbstractColoredNodeCellRenderer
implements Disposable {
    private final FacesConfig myFacesConfig;
    private final GraphBuilder<String, NavigationCase> myGraphBuilder;
    private final Graph2D myGraph;

    public BasicFacesNodeCellRenderer(FacesConfig facesConfig, GraphBuilder<String, NavigationCase> graphBuilder) {
        super((ModificationTracker)facesConfig.getManager());
        this.myFacesConfig = facesConfig;
        this.myGraphBuilder = graphBuilder;
        this.myGraph = graphBuilder.getGraph();
        VirtualFileListener myListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                BasicFacesNodeCellRenderer.this.clearCache();
                BasicFacesNodeCellRenderer.this.myGraph.updateViews();
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                BasicFacesNodeCellRenderer.this.clearCache();
                BasicFacesNodeCellRenderer.this.myGraph.updateViews();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/jsf/yfilesGraph/renderer/BasicFacesNodeCellRenderer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(myListener, (Disposable)this);
    }

    public void tuneNode(NodeRealizer nodeRealizer, JPanel wrapper) {
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setIcon(this.getIconLabel(nodeRealizer));
        String nodeName = this.getNodeName(nodeRealizer.getNode());
        label.append("EMPTY_NODE".equals(nodeName) ? BasicFacesNodeCellRenderer.getEmptyNodeText() : this.getNodeName(nodeRealizer.getNode()));
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setBorder(JBUI.Borders.empty((int)3));
        wrapper.add((Component)label, "Center");
    }

    @Nls
    private static String getEmptyNodeText() {
        return FacesBundle.message("faces.graph.empty.node.text", new Object[0]);
    }

    private Icon getIconLabel(NodeRealizer nodeRealizer) {
        VirtualFile virtualFile = this.getFileForNode(nodeRealizer);
        if (virtualFile != null) {
            if (virtualFile.isDirectory()) {
                return PlatformIcons.FOLDER_ICON;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myFacesConfig.getManager().getProject()).findFile(virtualFile);
            if (psiFile != null) {
                return psiFile.getIcon(0);
            }
        }
        return AllIcons.FileTypes.Unknown;
    }

    @Nullable
    private VirtualFile getFileForNode(NodeRealizer nodeRealizer) {
        String name = this.getNodeName(nodeRealizer.getNode());
        boolean isEmptyNode = "EMPTY_NODE".equals(name);
        name = isEmptyNode ? "*" : name;
        return JsfCommonUtils.getFileByRelativePath(this.myFacesConfig, name);
    }

    @NotNull
    @NlsSafe
    private String getNodeName(Node node) {
        String nodeName = this.myGraphBuilder.getNodeName((Object)((String)this.myGraphBuilder.getNodeObject(node)));
        String string = nodeName == null ? "" : nodeName;
        if (string == null) {
            BasicFacesNodeCellRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/BasicFacesNodeCellRenderer", "getNodeName"));
    }
}

