/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import java.util.ArrayList;
import java.util.HashSet;

public class GraphNavigationProvider
extends DomElementNavigationProvider {
    private final GraphBuilderImpl myBuilder;

    public GraphNavigationProvider(GraphBuilderImpl builder) {
        this.myBuilder = builder;
    }

    public String getProviderName() {
        return GraphNavigationProvider.class.getName();
    }

    public void navigate(DomElement domElement, boolean requestFocus) {
        if (domElement == null) {
            return;
        }
        ArrayList<NavigationCase> toBeSelected = new ArrayList<NavigationCase>();
        NavigationCase selectedNavigationCase = (NavigationCase)domElement.getParentOfType(NavigationCase.class, false);
        if (selectedNavigationCase != null) {
            toBeSelected.add(selectedNavigationCase);
        } else {
            NavigationRule navigationRule = (NavigationRule)domElement.getParentOfType(NavigationRule.class, false);
            if (navigationRule != null) {
                toBeSelected.addAll(navigationRule.getNavigationCases());
            }
        }
        if (toBeSelected.size() == 0) {
            return;
        }
        HashSet<Node> selectNodes = new HashSet<Node>();
        ArrayList<Edge> selectEdges = new ArrayList<Edge>();
        for (Edge edge : this.myBuilder.getGraph().getEdgeArray()) {
            Object object = this.myBuilder.getEdgeObject(edge);
            if (!(object instanceof NavigationCase)) continue;
            for (NavigationCase aCase : toBeSelected) {
                if (!aCase.equals(object)) continue;
                selectNodes.add(edge.source());
                selectEdges.add(edge);
            }
        }
        Graph2D graph = this.myBuilder.getGraph();
        for (Edge edge : graph.getEdgeArray()) {
            graph.getRealizer(edge).setSelected(selectEdges.contains(edge));
        }
        for (Edge edge : graph.getNodeArray()) {
            graph.getRealizer((Node)edge).setSelected(selectNodes.contains(edge));
        }
    }

    public boolean canNavigate(DomElement domElement) {
        return domElement.getParentOfType(NavigationCase.class, false) != null || domElement.getParentOfType(NavigationRule.class, false) != null;
    }
}

