/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.yfilesGraph.FacesBuildersFactory;
import com.intellij.jsf.yfilesGraph.GraphNavigationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesNavigationGraphComponent
extends JPanel
implements Disposable {
    private final GraphBuilderImpl<String, NavigationCase> myBuilder;
    private final GraphNavigationProvider myNavigationProvider;

    public FacesNavigationGraphComponent(@NotNull FacesConfig facesConfig) {
        if (facesConfig == null) {
            FacesNavigationGraphComponent.$$$reportNull$$$0(0);
        }
        this.myBuilder = FacesBuildersFactory.createNavigationBuilder(facesConfig, GraphManager.getGraphManager().createGraph2D(), GraphManager.getGraphManager().createGraph2DView());
        Disposer.register((Disposable)this, this.myBuilder);
        this.myNavigationProvider = new GraphNavigationProvider(this.myBuilder);
        this.setLayout(new BorderLayout());
        JComponent graphComponent = this.myBuilder.getView().getJComponent();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)GraphViewUtil.getCommonToolbarActions(), true);
        toolbar.setTargetComponent(graphComponent);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)graphComponent, "Center");
        this.myBuilder.initialize();
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener(event -> {
            if (this.isShowing()) {
                this.myBuilder.queueUpdate();
            }
        }, (Disposable)this);
        GraphViewUtil.addDataProvider((Graph2DView)this.myBuilder.getView(), dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "jsf.navigation";
            }
            return null;
        });
    }

    public GraphBuilderImpl getBuilder() {
        return this.myBuilder;
    }

    public void dispose() {
    }

    public void setSelectedDomElement(DomElement domElement) {
        this.myNavigationProvider.navigate(domElement, true);
    }

    @Nullable
    public DomElement getSelectedDomElement() {
        NodeCursor cursor = this.myBuilder.getGraph().selectedNodes();
        while (cursor.ok()) {
            NavigationCase aCase;
            Node node = cursor.node();
            EdgeCursor ec = node.outEdges();
            if (ec.ok() && (aCase = (NavigationCase)this.myBuilder.getEdgeObject(ec.edge())) != null) {
                return ((NavigationRule)aCase.getParentOfType(NavigationRule.class, true)).getFromViewId();
            }
            ec = node.inEdges();
            if (ec.ok() && (aCase = (NavigationCase)this.myBuilder.getEdgeObject(ec.edge())) != null) {
                return aCase.getToViewId();
            }
            cursor.next();
        }
        cursor = this.myBuilder.getGraph().selectedEdges();
        while (cursor.ok()) {
            NavigationRule parent;
            NavigationCase aCase = (NavigationCase)this.myBuilder.getEdgeObject(cursor.edge());
            if (aCase != null && (parent = (NavigationRule)aCase.getParentOfType(NavigationRule.class, true)) != null) {
                parent.getFromViewId();
            }
            cursor.next();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facesConfig", "com/intellij/jsf/yfilesGraph/FacesNavigationGraphComponent", "<init>"));
    }
}

