/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.jsf.yfilesGraph.renderer.BasicFacesNodeCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFacesGraphPresentationModel
extends SelectionDependenciesPresentationModel<String, NavigationCase> {
    private final FacesConfig myFacesConfig;
    @NonNls
    private static final String BASIC_GRAPH_CONFIGURATION = "BASIC_GRAPH_CONFIGURATION";
    private BasicFacesNodeCellRenderer myCellRenderer;

    public AbstractFacesGraphPresentationModel(FacesConfig facesConfig, Graph2D graph) {
        super((Graph)graph);
        this.myFacesConfig = facesConfig;
    }

    public BasicFacesNodeCellRenderer getCellRenderer() {
        if (this.myCellRenderer == null) {
            this.myCellRenderer = new BasicFacesNodeCellRenderer(this.getFacesConfig(), (GraphBuilder<String, NavigationCase>)this.getGraphBuilder());
            Disposer.register((Disposable)this, (Disposable)this.myCellRenderer);
        }
        return this.myCellRenderer;
    }

    @Nullable
    public String getNodeTooltip(String s) {
        return this.getNodeTip(this.getGraphBuilder().getNode((Object)s));
    }

    @Nullable
    public String getEdgeTooltip(NavigationCase navigationCase) {
        return this.getEdgeTip(navigationCase);
    }

    public boolean editNode(String s) {
        return this.startNodeEditing(s);
    }

    public boolean editEdge(NavigationCase navigationCase) {
        VirtualFile file;
        XmlTag tag = navigationCase.getXmlTag();
        if (tag != null && tag.getContainingFile() != null && (file = tag.getContainingFile().getVirtualFile()) != null) {
            int offset = tag.getTextOffset();
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)tag.getProject());
            editorManager.openTextEditor(new OpenFileDescriptor(tag.getProject(), file, offset), true);
            return true;
        }
        return false;
    }

    private boolean startNodeEditing(String node) {
        if (!this.doNodeEditing(node)) {
            return false;
        }
        if (node != null) {
            JsfCommonUtils.navigate(this.myFacesConfig, node);
        }
        return true;
    }

    protected boolean doNodeEditing(String node) {
        return true;
    }

    @Nullable
    @NonNls
    protected String getEdgeTip(NavigationCase nc) {
        if (nc == null) {
            return null;
        }
        Edge edge = this.getGraphBuilder().getEdge((Object)nc);
        return edge != null ? "<html><table><tr><td>from:</td><td>\"" + this.getNodeName(edge.source()) + "\"" + this.getNodeName(edge.target()) + "\"</td></tr></table></html>" : "";
    }

    @NotNull
    @NonNls
    protected String getNodeTip(Node node) {
        @NonNls String tip = "<html><b>\"" + this.getNodeName(node) + "\"</b><table>";
        EdgeCursor toCursor = node.inEdges();
        tip = tip + "<tr><td valign=\"top\"> from (" + toCursor.size() + "): </td><td><table>";
        while (toCursor.ok()) {
            tip = tip + "<tr><td> -&nbsp;" + this.getNodeName(toCursor.edge().opposite(node)) + "</td></tr>";
            toCursor.next();
        }
        tip = tip;
        EdgeCursor outCursor = node.outEdges();
        tip = tip + "<tr><td valign=\"top\"> to (" + outCursor.size() + "): </td><td><table>";
        while (outCursor.ok()) {
            tip = tip + "<tr><td> -&nbsp;" + this.getNodeName(outCursor.edge().opposite(node)) + "</td></tr>";
            outCursor.next();
        }
        tip = tip;
        String string = tip = tip + "</table>";
        if (string == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable String o) {
        DefaultActionGroup defaultActionGroup = this.getNodeActions();
        if (defaultActionGroup == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(1);
        }
        return defaultActionGroup;
    }

    @NotNull
    public DefaultActionGroup getEdgeActionGroup(@Nullable NavigationCase n) {
        DefaultActionGroup defaultActionGroup = this.getPaperPopupActions();
        if (defaultActionGroup == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    public DefaultActionGroup getPaperActionGroup() {
        DefaultActionGroup defaultActionGroup = this.getPaperPopupActions();
        if (defaultActionGroup == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private DefaultActionGroup getPaperPopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("Graph.Faces.DefaultGraphPopup"));
        return group;
    }

    private DefaultActionGroup getNodeActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("Graph.Faces.DefaultGraphPopup"));
        return group;
    }

    private String getNodeName(Node node) {
        GraphBuilder builder = this.getGraphBuilder();
        if (builder == null) {
            return "";
        }
        String nodeName = builder.getNodeName((Object)((String)builder.getNodeObject(node)));
        if ("EMPTY_NODE".equals(nodeName)) {
            nodeName = "*";
        }
        return nodeName;
    }

    public FacesConfig getFacesConfig() {
        return this.myFacesConfig;
    }

    protected NodeRealizer getDefaultFacesRealizer() {
        return GraphViewUtil.createNodeRealizer((String)BASIC_GRAPH_CONFIGURATION, (NodeCellRenderer)this.getCellRenderer());
    }

    public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
        if (view == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(4);
        }
        if (editMode == null) {
            AbstractFacesGraphPresentationModel.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public EdgeCreationPolicy<String> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<String>(){

            public boolean acceptSource(@NotNull String source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            public boolean acceptTarget(@NotNull String target) {
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !"EMPTY_NODE".equals(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptTarget";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void dispose() {
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTip";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeActionGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaperActionGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

