/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.jsf.references.ActionAttributeValueReference;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.jsp.highlighter.JspxFileType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfActionXmlAttributeReferencesProvider
extends JsfXmlAttributeReferencesProvider {
    @NonNls
    private static final String JSF_ACTION_ATTR_NAME = "action";
    private static final String[] myParamVariants = new String[]{"faces-redirect=true", "faces-redirect=false"};

    @Override
    public String[] getAttributeNames() {
        return new String[]{JSF_ACTION_ATTR_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue element, ProcessingContext context) {
        String value;
        if (element == null) {
            JsfActionXmlAttributeReferencesProvider.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)(value = element.getValue()))) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (value.trim().startsWith("/")) {
            return PathReferenceManager.getInstance().createCustomReferences((PsiElement)element, true, new PathReferenceProvider[]{new CustomReferneceProvider(), new RedirectParamPathReferenceProvider()});
        }
        ActionAttributeValueReference simpleAttributeValueReference = new ActionAttributeValueReference((PsiElement)element);
        PsiReference redirectParamPathReference = JsfActionXmlAttributeReferencesProvider.createRedirectParamPathReference((PsiElement)element);
        if (redirectParamPathReference != null) {
            return new PsiReference[]{simpleAttributeValueReference, redirectParamPathReference};
        }
        return new PsiReference[]{simpleAttributeValueReference};
    }

    @Nullable
    private static String getValue(PsiElement psiElement) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator != null) {
            return manipulator.getRangeInElement(psiElement).substring(psiElement.getText());
        }
        return null;
    }

    @Nullable
    public static PsiReference createRedirectParamPathReference(final @NotNull PsiElement psiElement) {
        String value;
        if (psiElement == null) {
            JsfActionXmlAttributeReferencesProvider.$$$reportNull$$$0(1);
        }
        if ((value = JsfActionXmlAttributeReferencesProvider.getValue(psiElement)) != null && value.contains("?")) {
            String paramValue = value.substring(value.indexOf("?"));
            return new PsiReferenceBase<PsiElement>(psiElement, TextRange.from((int)(psiElement.getText().indexOf("?") + 1), (int)(paramValue.length() - 1)), false){

                public PsiElement resolve() {
                    return psiElement;
                }

                @NotNull
                public Object[] getVariants() {
                    if (myParamVariants == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myParamVariants;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$1", "getVariants"));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRedirectParamPathReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomReferneceProvider
    implements PathReferenceProvider {
        private CustomReferneceProvider() {
        }

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                CustomReferneceProvider.$$$reportNull$$$0(0);
            }
            if (references == null) {
                CustomReferneceProvider.$$$reportNull$$$0(1);
            }
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)psiElement);
            int offset = range.getStartOffset();
            String text = range.substring(psiElement.getText());
            String trimedUrl = WebUtil.trimURL((String)text);
            FileReferenceSet set = new FileReferenceSet(trimedUrl, psiElement, offset, null, true, true){

                protected boolean isSoft() {
                    return true;
                }

                public FileReference createFileReference(TextRange range, int index, String text) {
                    return new ActionAttrFileReference(range, index, text, this);
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return element -> element instanceof WebDirectoryElement || element instanceof PsiFile && ((PsiFile)element).getFileType() instanceof JspxFileType;
                }
            };
            Collections.addAll(references, set.getAllReferences());
            return false;
        }

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                CustomReferneceProvider.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CustomReferneceProvider.$$$reportNull$$$0(3);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createReferences";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class ActionAttrFileReference
        extends FileReference {
            public ActionAttrFileReference(TextRange range, int index, String text, FileReferenceSet set) {
                super(set, range, index, text);
            }

            public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> result, boolean caseSensitive) {
                if (text == null) {
                    ActionAttrFileReference.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    ActionAttrFileReference.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    ActionAttrFileReference.$$$reportNull$$$0(2);
                }
                super.innerResolveInContext((String)(this.isLast() ? text + ".xhtml" : text), context, result, caseSensitive);
            }

            protected Object createLookupItem(PsiElement candidate) {
                if (candidate instanceof PsiFile) {
                    PsiFile file = (PsiFile)candidate;
                    String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)file.getName());
                    return LookupElementBuilder.create((String)nameWithoutExtension).withIcon(file.getIcon(0)).withTypeText(file.getName());
                }
                return super.createLookupItem(candidate);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    ActionAttrFileReference.$$$reportNull$$$0(3);
                }
                if (newElementName.contains(".")) {
                    newElementName = newElementName.substring(0, newElementName.indexOf("."));
                }
                return super.handleElementRename(newElementName);
            }

            protected PsiElement rename(String newName) throws IncorrectOperationException {
                if (newName.contains(".")) {
                    newName = newName.substring(0, newName.indexOf("."));
                }
                return super.rename(newName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider$ActionAttrFileReference";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "innerResolveInContext";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleElementRename";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class RedirectParamPathReferenceProvider
    implements PathReferenceProvider {
        private RedirectParamPathReferenceProvider() {
        }

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            PsiReference pathReference;
            if (psiElement == null) {
                RedirectParamPathReferenceProvider.$$$reportNull$$$0(0);
            }
            if (references == null) {
                RedirectParamPathReferenceProvider.$$$reportNull$$$0(1);
            }
            if ((pathReference = JsfActionXmlAttributeReferencesProvider.createRedirectParamPathReference(psiElement)) != null) {
                references.add(pathReference);
            }
            return false;
        }

        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                RedirectParamPathReferenceProvider.$$$reportNull$$$0(2);
            }
            if (element == null) {
                RedirectParamPathReferenceProvider.$$$reportNull$$$0(3);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$RedirectParamPathReferenceProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createReferences";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

