/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.impl.converters;

import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.javaee.web.psi.jsp.WebDirectoryUtil;
import com.intellij.jsf.converters.model.AsteriskPathReferenceConverter;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.xml.ConvertContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsteriskPathReferenceConverterImpl
extends AsteriskPathReferenceConverter {
    private final PathReferenceProvider myAsteriskProvider = new PathReferenceProvider(){

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            WebApp webApp;
            WebFacet webFacet;
            String value;
            if (psiElement == null) {
                6.$$$reportNull$$$0(0);
            }
            if (references == null) {
                6.$$$reportNull$$$0(1);
            }
            if ((value = AsteriskPathReferenceConverterImpl.getValue(psiElement)) == null) {
                return false;
            }
            String path = WebUtil.trimURL((String)value);
            if (path.contains("*") && path.lastIndexOf("\\") < path.lastIndexOf("*") && (webFacet = WebUtil.getWebFacet((PsiElement)psiElement)) != null && (webApp = webFacet.getRoot()) != null) {
                PsiReferenceBase base;
                Object object = base = path.equals("*") ? AsteriskPathReferenceConverterImpl.createSimpleAsteriskReference(webFacet, psiElement, soft) : AsteriskPathReferenceConverterImpl.createAsteriskReference(path, psiElement, webFacet, soft);
                if (base != null) {
                    references.add((PsiReference)base);
                }
            }
            return false;
        }

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                6.$$$reportNull$$$0(2);
            }
            if (element == null) {
                6.$$$reportNull$$$0(3);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsf/impl/converters/AsteriskPathReferenceConverterImpl$6";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createReferences";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public PathReference fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        XmlElement element = context.getReferenceXmlElement();
        if (element == null) {
            return null;
        }
        WebFacet webFacet = (WebFacet)JavaeeFacetUtil.getInstance().getJavaeeFacet(context, WebFacet.ID);
        if (webFacet != null) {
            if (s.trim().equals("*")) {
                return AsteriskPathReferenceConverterImpl.createSimpleAsteriskWebPath(s, webFacet);
            }
            if (s.trim().endsWith("*")) {
                return AsteriskPathReferenceConverterImpl.createAsteriskWebPath(s, webFacet);
            }
        }
        return PathReferenceManager.getInstance().getPathReference(s, (PsiElement)element, new PathReferenceProvider[0]);
    }

    private static PathReference createAsteriskWebPath(final String path, final WebFacet webFacet) {
        return new PathReference(path, (Function)PathReference.NULL_ICON){

            public PsiElement resolve() {
                Project project = webFacet.getModule().getProject();
                VirtualFile file = WebDirectoryUtil.getWebDirectoryUtil((Project)project).findVirtualFileByPath(path.substring(0, path.length() - 1), webFacet);
                return file == null ? null : PsiManager.getInstance((Project)project).findDirectory(file);
            }
        };
    }

    private static PathReference createSimpleAsteriskWebPath(String s, final WebFacet webFacet) {
        return new PathReference(s, (Function)PathReference.NULL_ICON){

            @Nullable
            public PsiElement resolve() {
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    PsiDirectory psiFile;
                    VirtualFile virtualFile = webRoot.getFile();
                    if (virtualFile == null || (psiFile = PsiManager.getInstance((Project)webFacet.getModule().getProject()).findDirectory(virtualFile)) == null) continue;
                    return psiFile;
                }
                return null;
            }
        };
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            AsteriskPathReferenceConverterImpl.$$$reportNull$$$0(0);
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(psiElement, soft, new PathReferenceProvider[]{this.myAsteriskProvider});
        if (psiReferenceArray == null) {
            AsteriskPathReferenceConverterImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static PsiReferenceBase createSimpleAsteriskReference(WebFacet webFacet, PsiElement psiElement, boolean soft) {
        List list = webFacet.getWebRoots();
        for (WebRoot webRoot : list) {
            PsiDirectory psiFile;
            VirtualFile virtualFile = webRoot.getFile();
            if (virtualFile == null || (psiFile = psiElement.getManager().findDirectory(virtualFile)) == null) continue;
            return new PsiReferenceBase<PsiElement>(psiElement, soft){

                public PsiElement resolve() {
                    return psiFile;
                }
            };
        }
        return null;
    }

    @Nullable
    private static PsiReference createAsteriskReference(String path, final PsiElement psiElement, final WebFacet webFacet, boolean soft) {
        String text = psiElement.getText();
        int slashIndex = path.lastIndexOf("/");
        if (slashIndex < 0) {
            return null;
        }
        final String parentDirectory = path.substring(0, slashIndex);
        final String asteriskText = path.substring(slashIndex + 1);
        int i = text.indexOf(asteriskText);
        TextRange textRange = new TextRange(i, i + asteriskText.length());
        return asteriskText.replaceAll("\n", "").trim().equals("*") ? new PsiReferenceBase<PsiElement>(psiElement, textRange, soft){

            public PsiElement resolve() {
                return WebDirectoryUtil.getWebDirectoryUtil((Project)psiElement.getProject()).findFileByPath(parentDirectory, webFacet);
            }
        } : new PsiPolyVariantReferenceBase<PsiElement>(psiElement, textRange, true){

            @NotNull
            public ResolveResult[] multiResolve(boolean incompleteCode) {
                VirtualFile element = WebDirectoryUtil.getWebDirectoryUtil((Project)psiElement.getProject()).findVirtualFileByPath(parentDirectory, webFacet);
                if (element != null && element.isDirectory()) {
                    ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
                    Pattern pattern = Pattern.compile(asteriskText.replaceAll("([\\[\\]\\^\\(\\)\\{\\}\\-])", "\\\\$1").replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.\\*"));
                    for (VirtualFile file : element.getChildren()) {
                        PsiFile psiFile;
                        if (!pattern.matcher(file.getName()).matches() || (psiFile = psiElement.getManager().findFile(file)) == null) continue;
                        result.add(new PsiElementResolveResult((PsiElement)psiFile));
                    }
                    ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
                    if (resolveResultArray == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return resolveResultArray;
                }
                if (ResolveResult.EMPTY_ARRAY == null) {
                    5.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/impl/converters/AsteriskPathReferenceConverterImpl$5", "multiResolve"));
            }
        };
    }

    @Nullable
    private static String getValue(PsiElement psiElement) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator != null) {
            return manipulator.getRangeInElement(psiElement).substring(psiElement.getText());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/impl/converters/AsteriskPathReferenceConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/impl/converters/AsteriskPathReferenceConverterImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

